/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.Main;
import annotator.find.Criteria;
import annotator.find.Criterion;
import annotator.find.IsSigMethodCriterion;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import javax.lang.model.element.Modifier;

final class InMethodCriterion
implements Criterion {
    public final String name;
    private final IsSigMethodCriterion sigMethodCriterion;

    InMethodCriterion(String name) {
        this.name = name;
        this.sigMethodCriterion = new IsSigMethodCriterion(name);
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.IN_METHOD;
    }

    @Override
    public boolean isSatisfiedBy(TreePath path, Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path) {
        Criteria.dbug.debug("InMethodCriterion.isSatisfiedBy(%s); this=%s%n", Main.leafString(path), this.toString());
        boolean inDecl = false;
        boolean staticDecl = false;
        do {
            if (path.getLeaf().getKind() == Tree.Kind.METHOD) {
                boolean b = this.sigMethodCriterion.isSatisfiedBy(path);
                Criteria.dbug.debug("%s%n", "InMethodCriterion.isSatisfiedBy => b");
                return b;
            }
            if (path.getLeaf().getKind() != Tree.Kind.VARIABLE) continue;
            ModifiersTree mods = ((VariableTree)path.getLeaf()).getModifiers();
            inDecl = true;
            staticDecl = mods.getFlags().contains((Object)Modifier.STATIC);
        } while ((path = path.getParentPath()) != null && path.getLeaf() != null);
        boolean result2 = inDecl && (staticDecl ? "<clinit>()V" : "<init>()V").equals(this.name);
        Criteria.dbug.debug("InMethodCriterion.isSatisfiedBy => %s%n", result2);
        return result2;
    }

    public String toString() {
        return "in method '" + this.name + "'";
    }
}

