/*
 * Decompiled with CFR 0.152.
 */
package annotator.scanner;

import annotator.scanner.CommonScanner;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LambdaScanner
extends CommonScanner {
    private int index = -1;
    private boolean done = false;
    private final Tree tree;
    private static Map<String, List<Integer>> methodNameToLambdaExpressionOffsets = new HashMap<String, List<Integer>>();

    public static int indexOfLambdaExpressionTree(TreePath origpath, Tree tree) {
        TreePath path = LambdaScanner.findCountingContext(origpath);
        if (path == null) {
            return -1;
        }
        LambdaScanner ls = new LambdaScanner(tree);
        ls.scan(path, null);
        return ls.index;
    }

    private LambdaScanner(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Void visitLambdaExpression(LambdaExpressionTree node, Void p) {
        if (!this.done) {
            ++this.index;
        }
        if (this.tree == node) {
            this.done = true;
        }
        return (Void)super.visitLambdaExpression(node, p);
    }

    public static void addLambdaExpressionToMethod(String methodName, Integer offset) {
        List<Integer> offsetList = methodNameToLambdaExpressionOffsets.get(methodName);
        if (offsetList == null) {
            offsetList = new ArrayList<Integer>();
            methodNameToLambdaExpressionOffsets.put(methodName, offsetList);
        }
        offsetList.add(offset);
    }

    public static Integer getMethodLambdaExpressionIndex(String methodName, Integer offset) {
        List<Integer> offsetList = methodNameToLambdaExpressionOffsets.get(methodName);
        if (offsetList == null) {
            return -1;
        }
        return offsetList.indexOf(offset);
    }
}

