/*
 * Decompiled with CFR 0.152.
 */
package annotator.specification;

import annotator.Main;
import annotator.find.AnnotationInsertion;
import annotator.find.CastInsertion;
import annotator.find.CloseParenthesisInsertion;
import annotator.find.ConstructorInsertion;
import annotator.find.Criteria;
import annotator.find.GenericArrayLocationCriterion;
import annotator.find.Insertion;
import annotator.find.IntersectionTypeLocationCriterion;
import annotator.find.NewInsertion;
import annotator.find.ReceiverInsertion;
import annotator.scanner.MethodOffsetClassVisitor;
import annotator.specification.CriterionList;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.com.google.common.collect.LinkedHashMultimap;
import org.checkerframework.com.google.common.collect.Multimap;
import org.checkerframework.org.objectweb.asm.ClassReader;
import org.checkerframework.org.plumelib.util.FileIOException;
import org.checkerframework.org.plumelib.util.Pair;
import scenelib.annotations.Annotation;
import scenelib.annotations.el.ABlock;
import scenelib.annotations.el.AClass;
import scenelib.annotations.el.AElement;
import scenelib.annotations.el.AExpression;
import scenelib.annotations.el.AField;
import scenelib.annotations.el.AMethod;
import scenelib.annotations.el.AScene;
import scenelib.annotations.el.ATypeElement;
import scenelib.annotations.el.ATypeElementWithType;
import scenelib.annotations.el.AnnotationDef;
import scenelib.annotations.el.BoundLocation;
import scenelib.annotations.el.InnerTypeLocation;
import scenelib.annotations.el.LocalLocation;
import scenelib.annotations.el.RelativeLocation;
import scenelib.annotations.el.TypeIndexLocation;
import scenelib.annotations.field.AnnotationFieldType;
import scenelib.annotations.io.ASTPath;
import scenelib.annotations.io.IndexFileParser;
import scenelib.annotations.util.coll.VivifyingMap;
import scenelib.type.DeclaredType;
import scenelib.type.Type;

public class IndexFileSpecification {
    private final Multimap<Insertion, Annotation> insertionSources = LinkedHashMultimap.create();
    private final List<Insertion> insertions = new ArrayList<Insertion>();
    private ConstructorInsertion constructorInsertion = null;
    private final AScene scene;
    private final String indexFileName;
    public static boolean noAsm = false;
    private static boolean debug = false;

    public IndexFileSpecification(String indexFileName) {
        this.indexFileName = indexFileName;
        this.scene = new AScene();
    }

    public List<Insertion> parse() throws FileIOException {
        try {
            Map<String, AnnotationDef> annotationDefs = IndexFileParser.parseFile(this.indexFileName, this.scene);
            Set<String> defKeys = annotationDefs.keySet();
            LinkedHashSet<String> ambiguous = new LinkedHashSet<String>();
            for (String key : defKeys) {
                String name;
                int ix = Math.max(key.lastIndexOf("."), key.lastIndexOf("$"));
                if (ix < 0 || annotationDefs.get(name = key.substring(ix + 1)) != null) continue;
                ambiguous.add(name);
            }
            Insertion.setAlwaysQualify(ambiguous);
        }
        catch (FileIOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while parsing index file", e);
        }
        if (debug) {
            System.out.printf("Scene parsed from %s:%n", this.indexFileName);
            System.out.println(this.scene.unparse());
        }
        this.parseScene();
        return this.insertions;
    }

    public Map<String, Set<String>> annotationImports() {
        return this.scene.imports;
    }

    public Multimap<Insertion, Annotation> insertionSources() {
        return this.insertionSources;
    }

    private void addInsertionSource(Insertion ins, Annotation anno) {
        this.insertionSources.put(ins, anno);
    }

    private static void debug(String s2) {
        if (debug) {
            System.out.println(s2);
        }
    }

    public AScene getScene() {
        return this.scene;
    }

    private void parseScene() {
        IndexFileSpecification.debug("parseScene()");
        CriterionList clist = new CriterionList();
        VivifyingMap<String, AElement> packages2 = this.scene.packages;
        for (Map.Entry entry : packages2.entrySet()) {
            this.parsePackage(clist, (String)entry.getKey(), (AElement)entry.getValue());
        }
        VivifyingMap<String, AClass> classes = this.scene.classes;
        for (Map.Entry entry : classes.entrySet()) {
            String key = (String)entry.getKey();
            AClass clazz = (AClass)entry.getValue();
            if (key.endsWith(".package-info")) {
                this.parsePackage(clist, key.substring(0, key.length() - 13), clazz);
                continue;
            }
            this.parseClass(clist, key, clazz);
        }
    }

    private void parsePackage(CriterionList clist, String packageName, AElement element) {
        CriterionList packageClist = clist.add(Criteria.packageDecl(packageName));
        this.parseElement(packageClist, element);
    }

    private void parseClass(CriterionList clist, String className, AClass clazz) {
        this.constructorInsertion = null;
        if (!noAsm) {
            IndexFileSpecification.debug("parseClass(" + className + ")");
            try {
                ClassReader classReader = new ClassReader(className);
                MethodOffsetClassVisitor cv = new MethodOffsetClassVisitor(classReader);
                classReader.accept(cv, false);
                IndexFileSpecification.debug("Done reading " + className + ".class");
            }
            catch (IOException e) {
                System.out.println("Warning: IndexFileSpecification did not find classfile for: " + className);
            }
            catch (RuntimeException e) {
                System.err.println("IndexFileSpecification had a problem reading class: " + className);
                throw e;
            }
            catch (Error e) {
                System.err.println("IndexFileSpecification had a problem reading class: " + className);
                throw e;
            }
        }
        CriterionList clistSansClass = clist;
        clist = clist.add(Criteria.inClass(className, true));
        CriterionList classClist = clistSansClass.add(Criteria.is(Tree.Kind.CLASS, className));
        this.parseElement(classClist, clazz);
        VivifyingMap<BoundLocation, ATypeElement> bounds = clazz.bounds;
        for (Map.Entry entry : bounds.entrySet()) {
            BoundLocation boundLoc = (BoundLocation)entry.getKey();
            ATypeElement bound = (ATypeElement)entry.getValue();
            CriterionList boundList = clist.add(Criteria.classBound(className, boundLoc));
            for (Map.Entry innerEntry : bound.innerTypes.entrySet()) {
                InnerTypeLocation innerLoc = (InnerTypeLocation)innerEntry.getKey();
                AElement ae = (AElement)innerEntry.getValue();
                CriterionList innerBoundList = boundList.add(Criteria.atLocation(innerLoc));
                this.parseElement(innerBoundList, ae);
            }
            CriterionList outerClist = boundList.add(Criteria.atLocation());
            this.parseElement(outerClist, bound);
        }
        clist = clist.add(Criteria.inClass(className, false));
        VivifyingMap<TypeIndexLocation, ATypeElement> extimpl = clazz.extendsImplements;
        for (Map.Entry entry : extimpl.entrySet()) {
            TypeIndexLocation eiLoc = (TypeIndexLocation)entry.getKey();
            ATypeElement ei = (ATypeElement)entry.getValue();
            CriterionList eiList = clist.add(Criteria.atExtImplsLocation(className, eiLoc));
            for (Map.Entry innerEntry : ei.innerTypes.entrySet()) {
                InnerTypeLocation innerLoc = (InnerTypeLocation)innerEntry.getKey();
                AElement ae = (AElement)innerEntry.getValue();
                CriterionList innerBoundList = eiList.add(Criteria.atLocation(innerLoc));
                this.parseElement(innerBoundList, ae);
            }
            this.parseElement(eiList, ei);
        }
        this.parseASTInsertions(clist, clazz.insertAnnotations, clazz.insertTypecasts);
        for (Map.Entry entry : clazz.fields.entrySet()) {
            this.parseField(clist, (String)entry.getKey(), (AField)entry.getValue());
        }
        for (Map.Entry entry : clazz.methods.entrySet()) {
            this.parseMethod(clist, className, (String)entry.getKey(), (AMethod)entry.getValue());
        }
        for (Map.Entry entry : clazz.staticInits.entrySet()) {
            this.parseStaticInit(clist, className, (Integer)entry.getKey(), (ABlock)entry.getValue());
        }
        for (Map.Entry entry : clazz.instanceInits.entrySet()) {
            this.parseInstanceInit(clist, className, (Integer)entry.getKey(), (ABlock)entry.getValue());
        }
        for (Map.Entry entry : clazz.fieldInits.entrySet()) {
            this.parseFieldInit(clist, className, (String)entry.getKey(), (AExpression)entry.getValue());
        }
        IndexFileSpecification.debug("parseClass(" + className + "):  done");
    }

    private void parseField(CriterionList clist, String fieldName, AField field2) {
        this.parseElement(clist.add(Criteria.field(fieldName, true)), field2);
        clist = clist.add(Criteria.field(fieldName, false));
        this.parseInnerAndOuterElements(clist, field2.type);
        this.parseASTInsertions(clist, field2.insertAnnotations, field2.insertTypecasts);
    }

    private void parseStaticInit(CriterionList clist, String className, int blockID, ABlock block) {
        clist = clist.add(Criteria.inStaticInit(blockID));
        this.parseBlock(clist, className, "static init number " + blockID + "()", block);
    }

    private void parseInstanceInit(CriterionList clist, String className, int blockID, ABlock block) {
        clist = clist.add(Criteria.inInstanceInit(blockID));
        this.parseBlock(clist, className, "instance init number " + blockID + "()", block);
    }

    private void parseFieldInit(CriterionList clist, String className, String fieldName, AExpression exp) {
        clist = clist.add(Criteria.inFieldInit(fieldName));
        this.parseExpression(clist, className, "init for field " + fieldName + "()", exp);
    }

    private List<Insertion> parseElement(CriterionList clist, AElement element) {
        return this.parseElement(clist, element, new ArrayList<Insertion>(), false);
    }

    private List<Insertion> parseElement(CriterionList clist, AElement element, boolean isCastInsertion) {
        return this.parseElement(clist, element, new ArrayList<Insertion>(), isCastInsertion);
    }

    private List<Insertion> parseElement(CriterionList clist, AElement element, List<Insertion> innerTypeInsertions) {
        return this.parseElement(clist, element, innerTypeInsertions, false);
    }

    private List<Insertion> parseElement(CriterionList clist, AElement element, List<Insertion> innerTypeInsertions, boolean isCastInsertion) {
        ReceiverInsertion receiver = null;
        NewInsertion neu = null;
        CastInsertion cast = null;
        CloseParenthesisInsertion closeParen = null;
        ArrayList<Insertion> annotationInsertions = new ArrayList<Insertion>();
        Set<Pair<String, Annotation>> elementAnnotations = this.getElementAnnotations(element);
        if (elementAnnotations.isEmpty()) {
            Criteria criteria = clist.criteria();
            if (element instanceof ATypeElementWithType) {
                Pair<CastInsertion, CloseParenthesisInsertion> pair = this.createCastInsertion(((ATypeElementWithType)element).getType(), null, innerTypeInsertions, criteria);
                cast = (CastInsertion)pair.a;
                closeParen = (CloseParenthesisInsertion)pair.b;
            } else if (!innerTypeInsertions.isEmpty()) {
                if (IndexFileSpecification.isOnReceiver(criteria)) {
                    receiver = new ReceiverInsertion(new DeclaredType(), criteria, innerTypeInsertions);
                } else if (IndexFileSpecification.isOnNew(criteria)) {
                    neu = new NewInsertion(new DeclaredType(), criteria, innerTypeInsertions);
                }
            }
        }
        for (Pair<String, Annotation> p : elementAnnotations) {
            DeclaredType type;
            ArrayList<Insertion> elementInsertions = new ArrayList<Insertion>();
            String annotationString = (String)p.a;
            Annotation annotation = (Annotation)p.b;
            Criteria criteria = clist.criteria();
            Boolean isDeclarationAnnotation = !annotation.def.isTypeAnnotation() || criteria.isOnFieldDeclaration();
            if (this.noTypePath(criteria) && IndexFileSpecification.isOnReceiver(criteria)) {
                if (receiver == null) {
                    type = new DeclaredType();
                    type.addAnnotation(annotationString);
                    receiver = new ReceiverInsertion(type, criteria, innerTypeInsertions);
                    elementInsertions.add(receiver);
                } else {
                    receiver.getType().addAnnotation(annotationString);
                }
                this.addInsertionSource(receiver, annotation);
            } else if (this.noTypePath(criteria) && IndexFileSpecification.isOnNew(criteria)) {
                if (neu == null) {
                    type = new DeclaredType();
                    type.addAnnotation(annotationString);
                    neu = new NewInsertion(type, criteria, innerTypeInsertions);
                    elementInsertions.add(neu);
                } else {
                    neu.getType().addAnnotation(annotationString);
                }
                this.addInsertionSource(neu, annotation);
            } else if (element instanceof ATypeElementWithType) {
                if (cast == null) {
                    Pair<CastInsertion, CloseParenthesisInsertion> insertions = this.createCastInsertion(((ATypeElementWithType)element).getType(), annotationString, innerTypeInsertions, criteria);
                    cast = (CastInsertion)insertions.a;
                    closeParen = (CloseParenthesisInsertion)insertions.b;
                    elementInsertions.add(cast);
                    elementInsertions.add(closeParen);
                } else {
                    cast.getType().addAnnotation(annotationString);
                }
                this.addInsertionSource(cast, annotation);
            } else {
                RelativeLocation loc = criteria.getCastRelativeLocation();
                if (loc != null && loc.type_index > 0) {
                    criteria.add(new IntersectionTypeLocationCriterion(loc));
                }
                AnnotationInsertion ins = new AnnotationInsertion(annotationString, criteria, isDeclarationAnnotation);
                IndexFileSpecification.debug("parsed: " + ins);
                if (!isCastInsertion) {
                    elementInsertions.add(ins);
                }
                annotationInsertions.add(ins);
                this.addInsertionSource(ins, annotation);
            }
            this.insertions.addAll(elementInsertions);
            if (this.noTypePath(criteria) && IndexFileSpecification.isOnNullaryConstructor(criteria)) {
                if (this.constructorInsertion == null) {
                    type = new DeclaredType(criteria.getClassName());
                    this.constructorInsertion = new ConstructorInsertion(type, criteria, new ArrayList<Insertion>());
                    this.insertions.add(this.constructorInsertion);
                } else if (Main.temporaryDebug) {
                    System.out.printf("Ignoring criteria=%s because constructorInsertion=%s%n", criteria, this.constructorInsertion);
                }
                for (Insertion i : elementInsertions) {
                    if (i.getKind() == Insertion.Kind.RECEIVER) {
                        this.constructorInsertion.addReceiverInsertion((ReceiverInsertion)i);
                        continue;
                    }
                    if (criteria.isOnReturnType()) {
                        ((DeclaredType)this.constructorInsertion.getType()).addAnnotation(annotationString);
                        continue;
                    }
                    if (isDeclarationAnnotation.booleanValue()) {
                        this.constructorInsertion.addDeclarationInsertion(i);
                        continue;
                    }
                    annotationInsertions.add(i);
                }
            }
            elementInsertions.clear();
        }
        if (receiver != null) {
            this.insertions.add(receiver);
        }
        if (neu != null) {
            this.insertions.add(neu);
        }
        if (cast != null) {
            this.insertions.add(cast);
            this.insertions.add(closeParen);
        }
        if (this.constructorInsertion != null) {
            this.constructorInsertion.setInserted(false);
        }
        return annotationInsertions;
    }

    private boolean noTypePath(Criteria criteria) {
        GenericArrayLocationCriterion galc = criteria.getGenericArrayLocation();
        return galc == null || galc.getLocation().isEmpty();
    }

    public static boolean isOnReceiver(Criteria criteria) {
        ASTPath astPath = criteria.getASTPath();
        if (astPath == null) {
            return criteria.isOnReceiver();
        }
        if (astPath.isEmpty()) {
            return false;
        }
        ASTPath.ASTEntry entry = astPath.getLast();
        return entry.childSelectorIs("parameter") && entry.getArgument() < 0;
    }

    public static boolean isOnNew(Criteria criteria) {
        ASTPath astPath = criteria.getASTPath();
        if (astPath == null || astPath.isEmpty()) {
            return criteria.isOnNew();
        }
        ASTPath.ASTEntry entry = astPath.getLast();
        Tree.Kind kind = entry.getTreeKind();
        return kind == Tree.Kind.NEW_ARRAY && entry.childSelectorIs("type") && entry.getArgument() == 0 || kind == Tree.Kind.NEW_CLASS && entry.childSelectorIs("identifier");
    }

    private static boolean isOnNullaryConstructor(Criteria criteria) {
        if (criteria.isOnMethod("<init>()V")) {
            ASTPath astPath = criteria.getASTPath();
            if (astPath == null || astPath.isEmpty()) {
                return !criteria.isOnNew();
            }
            ASTPath.ASTEntry entry = (ASTPath.ASTEntry)astPath.get(0);
            return entry.getTreeKind() == Tree.Kind.METHOD && (entry.childSelectorIs("type") || IndexFileSpecification.isOnReceiver(criteria));
        }
        return false;
    }

    private Pair<CastInsertion, CloseParenthesisInsertion> createCastInsertion(Type type, String annotationString, List<Insertion> innerTypeInsertions, Criteria criteria) {
        if (annotationString != null) {
            type.addAnnotation(annotationString);
        }
        Insertion.decorateType(innerTypeInsertions, type, criteria.getASTPath());
        CastInsertion cast = new CastInsertion(criteria, type);
        CloseParenthesisInsertion closeParen = new CloseParenthesisInsertion(criteria, cast.isSeparateLine());
        return new Pair<CastInsertion, CloseParenthesisInsertion>(cast, closeParen);
    }

    private void parseInnerAndOuterElements(CriterionList clist, ATypeElement typeElement) {
        this.parseInnerAndOuterElements(clist, typeElement, false);
    }

    private void parseInnerAndOuterElements(CriterionList clist, ATypeElement typeElement, boolean isCastInsertion) {
        ArrayList<Insertion> innerInsertions = new ArrayList<Insertion>();
        for (Map.Entry innerEntry : typeElement.innerTypes.entrySet()) {
            InnerTypeLocation innerLoc = (InnerTypeLocation)innerEntry.getKey();
            AElement innerElement = (AElement)innerEntry.getValue();
            CriterionList innerClist = clist.add(Criteria.atLocation(innerLoc));
            innerInsertions.addAll(this.parseElement(innerClist, innerElement, isCastInsertion));
        }
        CriterionList outerClist = clist;
        if (!isCastInsertion) {
            outerClist = clist.add(Criteria.atLocation());
        }
        this.parseElement(outerClist, (AElement)typeElement, innerInsertions);
    }

    private Set<Pair<String, Annotation>> getElementAnnotations(AElement element) {
        LinkedHashSet<Pair<String, Annotation>> result2 = new LinkedHashSet<Pair<String, Annotation>>(element.tlAnnotationsHere.size());
        for (Annotation a : element.tlAnnotationsHere) {
            AnnotationDef adef = a.def;
            String annotationString = "@" + adef.name;
            if (a.fieldValues.size() == 1 && a.fieldValues.containsKey("value")) {
                annotationString = annotationString + "(" + this.formatFieldValue(a, "value") + ")";
            } else if (a.fieldValues.size() > 0) {
                annotationString = annotationString + "(";
                boolean first2 = true;
                for (String field2 : a.fieldValues.keySet()) {
                    if (!first2) {
                        annotationString = annotationString + ", ";
                    }
                    annotationString = annotationString + field2 + "=" + this.formatFieldValue(a, field2);
                    first2 = false;
                }
                annotationString = annotationString + ")";
            }
            result2.add(new Pair<String, Annotation>(annotationString, a));
        }
        return result2;
    }

    private String formatFieldValue(Annotation a, String field2) {
        AnnotationFieldType fieldType = a.def.fieldTypes.get(field2);
        assert (fieldType != null);
        return fieldType.format(a.fieldValues.get(field2));
    }

    private void parseMethod(CriterionList clist, String className, String methodName, AMethod method) {
        clist = clist.add(Criteria.inMethod(methodName));
        this.parseElement(clist, method);
        CriterionList receiverClist = clist.add(Criteria.receiver(methodName));
        this.parseInnerAndOuterElements(receiverClist, method.receiver.type);
        CriterionList returnClist = clist.add(Criteria.returnType(className, methodName));
        this.parseInnerAndOuterElements(returnClist, method.returnType);
        for (Map.Entry entry : method.bounds.entrySet()) {
            BoundLocation boundLoc = (BoundLocation)entry.getKey();
            ATypeElement bound = (ATypeElement)entry.getValue();
            CriterionList boundClist = clist.add(Criteria.methodBound(methodName, boundLoc));
            this.parseInnerAndOuterElements(boundClist, bound);
        }
        for (Map.Entry entry : method.parameters.entrySet()) {
            Integer index = (Integer)entry.getKey();
            AField param2 = (AField)entry.getValue();
            CriterionList paramClist = clist.add(Criteria.param(methodName, index));
            this.parseInnerAndOuterElements(paramClist, param2.type);
        }
        this.parseASTInsertions(clist, method.insertAnnotations, method.insertTypecasts);
        this.parseBlock(clist, className, methodName, method.body);
    }

    private void parseBlock(CriterionList clist, String className, String methodName, ABlock block) {
        for (Map.Entry entry : block.locals.entrySet()) {
            LocalLocation loc = (LocalLocation)entry.getKey();
            AElement var = (AElement)entry.getValue();
            CriterionList varClist = clist.add(Criteria.local(methodName, loc));
            this.parseElement(varClist, var);
            this.parseInnerAndOuterElements(varClist, var.type);
        }
        this.parseExpression(clist, className, methodName, block);
    }

    private void parseExpression(CriterionList clist, String className, String methodName, AExpression exp) {
        CriterionList instanceOfClist;
        RelativeLocation loc;
        for (Map.Entry entry : exp.typecasts.entrySet()) {
            loc = (RelativeLocation)entry.getKey();
            ATypeElement cast = (ATypeElement)entry.getValue();
            CriterionList castClist = clist.add(Criteria.cast(methodName, loc));
            this.parseInnerAndOuterElements(castClist, cast);
        }
        for (Map.Entry entry : exp.news.entrySet()) {
            loc = (RelativeLocation)entry.getKey();
            ATypeElement newObject = (ATypeElement)entry.getValue();
            CriterionList newClist = clist.add(Criteria.newObject(methodName, loc));
            this.parseInnerAndOuterElements(newClist, newObject);
        }
        for (Map.Entry entry : exp.instanceofs.entrySet()) {
            loc = (RelativeLocation)entry.getKey();
            ATypeElement instanceOf = (ATypeElement)entry.getValue();
            instanceOfClist = clist.add(Criteria.instanceOf(methodName, loc));
            this.parseInnerAndOuterElements(instanceOfClist, instanceOf);
        }
        for (Map.Entry entry : exp.refs.entrySet()) {
            loc = (RelativeLocation)entry.getKey();
            ATypeElement ref = (ATypeElement)entry.getValue();
            instanceOfClist = clist.add(Criteria.memberReference(methodName, loc));
            this.parseInnerAndOuterElements(instanceOfClist, ref);
        }
        for (Map.Entry entry : exp.calls.entrySet()) {
            loc = (RelativeLocation)entry.getKey();
            ATypeElement call = (ATypeElement)entry.getValue();
            instanceOfClist = clist.add(Criteria.methodCall(methodName, loc));
            this.parseInnerAndOuterElements(instanceOfClist, call);
        }
        for (Map.Entry entry : exp.funs.entrySet()) {
            loc = (RelativeLocation)entry.getKey();
            AMethod lambda = (AMethod)entry.getValue();
            CriterionList lambdaClist = clist.add(Criteria.lambda(methodName, loc));
            this.parseLambdaExpression(className, methodName, lambda, lambdaClist);
        }
    }

    private void parseLambdaExpression(String className, String methodName, AMethod lambda, CriterionList clist) {
        for (Map.Entry entry : lambda.parameters.entrySet()) {
            Integer index = (Integer)entry.getKey();
            AField param2 = (AField)entry.getValue();
            CriterionList paramClist = clist.add(Criteria.param("(anonymous)", index));
            this.parseInnerAndOuterElements(paramClist, param2.type);
            this.parseASTInsertions(paramClist, param2.insertAnnotations, param2.insertTypecasts);
        }
        this.parseBlock(clist, className, methodName, lambda.body);
    }

    private void parseASTInsertions(CriterionList clist, VivifyingMap<ASTPath, ATypeElement> insertAnnotations, VivifyingMap<ASTPath, ATypeElementWithType> insertTypecasts) {
        ASTPath astPath;
        for (Map.Entry entry : insertAnnotations.entrySet()) {
            astPath = (ASTPath)entry.getKey();
            ATypeElement insertAnnotation = (ATypeElement)entry.getValue();
            CriterionList insertAnnotationClist = clist.add(Criteria.astPath(astPath));
            this.parseInnerAndOuterElements(insertAnnotationClist, insertAnnotation, true);
        }
        for (Map.Entry entry : insertTypecasts.entrySet()) {
            astPath = (ASTPath)entry.getKey();
            ATypeElementWithType insertTypecast = (ATypeElementWithType)entry.getValue();
            CriterionList insertTypecastClist = clist.add(Criteria.astPath(astPath));
            this.parseInnerAndOuterElements(insertTypecastClist, insertTypecast, true);
        }
    }
}

