/*
 * Decompiled with CFR 0.152.
 */
package com.daml.assistant.config;

import com.daml.assistant.config.ConfigLoadError;
import com.daml.assistant.config.ConfigLoadingError;
import com.daml.assistant.config.ConfigMissing;
import com.daml.assistant.config.ConfigParseError;
import com.daml.assistant.config.ProjectConfig;
import io.circe.Json;
import io.circe.ParsingFailure;
import io.circe.yaml.parser.package$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Try$;

public final class ProjectConfig$
implements Serializable {
    public static final ProjectConfig$ MODULE$ = new ProjectConfig$();
    private static final String envVarProjectPath = "DAML_PROJECT";
    private static final String projectConfigName = "daml.yaml";

    public String envVarProjectPath() {
        return envVarProjectPath;
    }

    public String projectConfigName() {
        return projectConfigName;
    }

    public Either<ConfigLoadingError, String> projectPath() {
        return scala.sys.package$.MODULE$.env().get(this.envVarProjectPath()).toRight((Function0<ConfigMissing> & Serializable)() -> new ConfigMissing(new StringBuilder(31).append("Environment variable ").append(MODULE$.envVarProjectPath()).append(" not found").toString()));
    }

    public Either<ConfigLoadingError, File> projectConfigPath() {
        return this.projectPath().flatMap((Function1<String, Either> & Serializable)path -> Try$.MODULE$.apply((Function0<File> & Serializable)() -> new File((String)path, MODULE$.projectConfigName())).toEither().left().map((Function1<Throwable, ConfigMissing> & Serializable)t -> new ConfigMissing(t.getMessage())));
    }

    public Either<ConfigLoadingError, ProjectConfig> loadFromString(Path projectPath, String content) {
        return package$.MODULE$.parse(content).left().map((Function1<ParsingFailure, ConfigParseError> & Serializable)e -> new ConfigParseError(e.getMessage())).map((Function1<Json, ProjectConfig> & Serializable)json -> new ProjectConfig((Json)json, projectPath));
    }

    public Either<ConfigLoadingError, ProjectConfig> loadFromFile(File file) {
        return scala.package$.MODULE$.Either().cond(Files.exists(file.toPath(), new LinkOption[0]), () -> true, (Function0<ConfigMissing> & Serializable)() -> new ConfigMissing(new StringBuilder(27).append("Config file ").append(file.toPath()).append(" does not exist").toString())).flatMap((Function1<Object, Either> & Serializable)x$1 -> ProjectConfig$.$anonfun$loadFromFile$3(file, BoxesRunTime.unboxToBoolean(x$1)));
    }

    public Either<ConfigLoadingError, ProjectConfig> loadFromEnv() {
        return this.projectConfigPath().flatMap((Function1<File, Either> & Serializable)path -> MODULE$.loadFromFile((File)path).map((Function1<ProjectConfig, ProjectConfig> & Serializable)result2 -> result2));
    }

    public ProjectConfig apply(Json content, Path projectPath) {
        return new ProjectConfig(content, projectPath);
    }

    public Option<Tuple2<Json, Path>> unapply(ProjectConfig x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple2<Json, Path>>(new Tuple2<Json, Path>(x$0.content(), x$0.projectPath()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ProjectConfig$.class);
    }

    public static final /* synthetic */ Either $anonfun$loadFromFile$3(File file$1, boolean x$1) {
        boolean bl = x$1;
        Either either2 = Try$.MODULE$.apply((Function0<BufferedSource> & Serializable)() -> Source$.MODULE$.fromFile(file$1, "UTF-8")).toEither().left().map((Function1<Throwable, ConfigLoadError> & Serializable)e -> new ConfigLoadError(e.getMessage())).flatMap((Function1<BufferedSource, Either> & Serializable)source -> Try$.MODULE$.apply((Function0<String> & Serializable)() -> {
            String string2;
            try {
                string2 = source.mkString();
            }
            finally {
                source.close();
            }
            return string2;
        }).toEither().left().map((Function1<Throwable, ConfigLoadError> & Serializable)e -> new ConfigLoadError(e.getMessage())).flatMap((Function1<String, Either> & Serializable)content -> MODULE$.loadFromString(file$1.getParentFile().toPath(), (String)content).map((Function1<ProjectConfig, ProjectConfig> & Serializable)result2 -> result2)));
        return either2;
    }

    private ProjectConfig$() {
    }
}

