/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.CommandCompletionServiceOuterClass;
import com.daml.ledger.api.v1.CompletionOuterClass;
import com.daml.ledger.javaapi.data.Checkpoint;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CompletionStreamResponse {
    private final Optional<Checkpoint> checkpoint;
    private final List<CompletionOuterClass.Completion> completions;

    public CompletionStreamResponse(@NonNull Optional<Checkpoint> checkpoint, @NonNull List< @NonNull CompletionOuterClass.Completion> completions) {
        this.checkpoint = checkpoint;
        this.completions = completions;
    }

    public static CompletionStreamResponse fromProto(CommandCompletionServiceOuterClass.CompletionStreamResponse response) {
        if (response.hasCheckpoint()) {
            Checkpoint checkpoint = Checkpoint.fromProto(response.getCheckpoint());
            return new CompletionStreamResponse(Optional.of(checkpoint), response.getCompletionsList());
        }
        return new CompletionStreamResponse(Optional.empty(), response.getCompletionsList());
    }

    public CommandCompletionServiceOuterClass.CompletionStreamResponse toProto() {
        CommandCompletionServiceOuterClass.CompletionStreamResponse.Builder builder = CommandCompletionServiceOuterClass.CompletionStreamResponse.newBuilder();
        this.checkpoint.ifPresent(c -> builder.setCheckpoint(c.toProto()));
        builder.addAllCompletions(this.completions);
        return builder.build();
    }

    public @NonNull Optional<Checkpoint> getCheckpoint() {
        return this.checkpoint;
    }

    public @NonNull List< @NonNull CompletionOuterClass.Completion> getCompletions() {
        return this.completions;
    }

    public String toString() {
        return "CompletionStreamResponse{checkpoint=" + this.checkpoint + ", completions=" + this.completions + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompletionStreamResponse that = (CompletionStreamResponse)o;
        return Objects.equals(this.checkpoint, that.checkpoint) && Objects.equals(this.completions, that.completions);
    }

    public int hashCode() {
        return Objects.hash(this.checkpoint, this.completions);
    }
}

