/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.CommandsOuterClass;
import com.daml.ledger.javaapi.data.Command;
import com.daml.ledger.javaapi.data.DamlRecord;
import com.daml.ledger.javaapi.data.Identifier;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CreateCommand
extends Command {
    private final Identifier templateId;
    private final DamlRecord createArguments;

    public CreateCommand(@NonNull Identifier templateId, @NonNull DamlRecord createArguments) {
        this.templateId = templateId;
        this.createArguments = createArguments;
    }

    public String toString() {
        return "CreateCommand{templateId=" + this.templateId + ", createArguments=" + this.createArguments + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateCommand that = (CreateCommand)o;
        return Objects.equals(this.templateId, that.templateId) && Objects.equals(this.createArguments, that.createArguments);
    }

    public int hashCode() {
        return Objects.hash(this.templateId, this.createArguments);
    }

    @Override
    public @NonNull Identifier getTemplateId() {
        return this.templateId;
    }

    public @NonNull DamlRecord getCreateArguments() {
        return this.createArguments;
    }

    public static CreateCommand fromProto(CommandsOuterClass.CreateCommand create2) {
        DamlRecord createArgument = DamlRecord.fromProto(create2.getCreateArguments());
        Identifier templateId = Identifier.fromProto(create2.getTemplateId());
        return new CreateCommand(templateId, createArgument);
    }

    public CommandsOuterClass.CreateCommand toProto() {
        return CommandsOuterClass.CreateCommand.newBuilder().setTemplateId(this.templateId.toProto()).setCreateArguments(this.createArguments.toProtoRecord()).build();
    }
}

