/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.admin.UserManagementServiceOuterClass;
import com.daml.ledger.javaapi.data.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class CreateUserRequest {
    private final User user;
    private final List<User.Right> rights;

    public CreateUserRequest(User user, User.Right right, User.Right ... rights) {
        this.user = user;
        this.rights = new ArrayList<User.Right>(rights.length + 1);
        this.rights.add(right);
        this.rights.addAll(Arrays.asList(rights));
    }

    public CreateUserRequest(@NonNull String id2, @NonNull String primaryParty) {
        this(new User(id2, primaryParty), new User.Right.CanActAs(primaryParty), new User.Right[0]);
    }

    public User getUser() {
        return this.user;
    }

    public List<User.Right> getRights() {
        return new ArrayList<User.Right>(this.rights);
    }

    public UserManagementServiceOuterClass.CreateUserRequest toProto() {
        return UserManagementServiceOuterClass.CreateUserRequest.newBuilder().setUser(this.user.toProto()).addAllRights(this.rights.stream().map(User.Right::toProto).collect(Collectors.toList())).build();
    }

    public String toString() {
        return "CreateUserRequest{user=" + this.user + ", rights=" + this.rights + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateUserRequest that = (CreateUserRequest)o;
        return this.user.equals(that.user) && this.rights.equals(that.rights);
    }

    public int hashCode() {
        return Objects.hash(this.user, this.rights);
    }
}

