/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.ValueOuterClass;
import com.daml.ledger.javaapi.data.DamlCollectors;
import com.daml.ledger.javaapi.data.Value;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class DamlGenMap
extends Value {
    private final Map<Value, Value> map;
    private static @NonNull DamlGenMap EMPTY = DamlGenMap.fromPrivateMap(Collections.EMPTY_MAP);

    private DamlGenMap(@NonNull Map<@NonNull Value, @NonNull Value> map2) {
        this.map = map2;
    }

    static @NonNull DamlGenMap fromPrivateMap(@NonNull Map<@NonNull Value, @NonNull Value> map2) {
        return new DamlGenMap(Collections.unmodifiableMap(map2));
    }

    public static DamlGenMap of(@NonNull Map<@NonNull Value, @NonNull Value> map2) {
        return DamlGenMap.fromPrivateMap(new LinkedHashMap<Value, Value>(map2));
    }

    public Stream<Map.Entry<Value, Value>> stream() {
        return this.map.entrySet().stream();
    }

    public <K, V> @NonNull Map<@NonNull K, @NonNull V> toMap(@NonNull Function<@NonNull Value, @NonNull K> keyMapper, @NonNull Function<@NonNull Value, @NonNull V> valueMapper) {
        return this.stream().collect(Collectors.toMap(e -> keyMapper.apply((Value)e.getKey()), e -> valueMapper.apply((Value)e.getValue()), (left, right) -> right, LinkedHashMap::new));
    }

    public <V> @NonNull Map<@NonNull V, @NonNull V> toMap(@NonNull Function<@NonNull Value, @NonNull V> valueMapper) {
        return this.toMap(valueMapper, valueMapper);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DamlGenMap other = (DamlGenMap)o;
        return Objects.equals(this.map, other.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public @NonNull String toString() {
        StringJoiner sj = new StringJoiner(", ", "GenMap{", "}");
        this.map.forEach((key, value) -> sj.add(key.toString() + " -> " + value.toString()));
        return sj.toString();
    }

    @Override
    public ValueOuterClass.Value toProto() {
        ValueOuterClass.GenMap.Builder mb = ValueOuterClass.GenMap.newBuilder();
        this.map.forEach((key, value) -> mb.addEntries(ValueOuterClass.GenMap.Entry.newBuilder().setKey(key.toProto()).setValue(value.toProto())));
        return ValueOuterClass.Value.newBuilder().setGenMap(mb).build();
    }

    public static @NonNull DamlGenMap fromProto(ValueOuterClass.GenMap map2) {
        return map2.getEntriesList().stream().collect(DamlCollectors.toDamlGenMap(entry -> DamlGenMap.fromProto(entry.getKey()), entry -> DamlGenMap.fromProto(entry.getValue())));
    }
}

