/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.ValueOuterClass;
import com.daml.ledger.javaapi.data.DamlCollectors;
import com.daml.ledger.javaapi.data.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class DamlList
extends Value {
    private List<Value> values;
    private static DamlList EMPTY = DamlList.fromPrivateList(Collections.EMPTY_LIST);

    private DamlList() {
    }

    static @NonNull DamlList fromPrivateList(@NonNull List<@NonNull Value> values2) {
        DamlList damlList = new DamlList();
        damlList.values = Collections.unmodifiableList(values2);
        return damlList;
    }

    public static DamlList of(@NonNull List<@NonNull Value> values2) {
        return DamlList.fromPrivateList(new ArrayList<Value>(values2));
    }

    @SafeVarargs
    public static DamlList of(Value ... values2) {
        return DamlList.fromPrivateList(Arrays.asList(values2));
    }

    @Deprecated
    public DamlList(@NonNull List<@NonNull Value> values2) {
        this.values = values2;
    }

    @Deprecated
    @SafeVarargs
    public DamlList(Value ... values2) {
        this(Arrays.asList(values2));
    }

    @Deprecated
    public @NonNull List<@NonNull Value> getValues() {
        return this.toList(Function.identity());
    }

    public @NonNull Stream<Value> stream() {
        return this.values.stream();
    }

    public <T> @NonNull List<T> toList(Function<Value, T> valueMapper) {
        return this.stream().map(valueMapper).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DamlList list2 = (DamlList)o;
        return Objects.equals(this.values, list2.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public String toString() {
        return "DamlList{values=" + this.values + "}";
    }

    @Override
    public ValueOuterClass.Value toProto() {
        ValueOuterClass.List.Builder builder = ValueOuterClass.List.newBuilder();
        for (Value value : this.values) {
            builder.addElements(value.toProto());
        }
        return ValueOuterClass.Value.newBuilder().setList(builder.build()).build();
    }

    public static @NonNull DamlList fromProto(ValueOuterClass.List list2) {
        return list2.getElementsList().stream().collect(DamlCollectors.toDamlList(Value::fromProto));
    }
}

