/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.EventOuterClass;
import com.daml.ledger.javaapi.data.Identifier;
import com.daml.ledger.javaapi.data.TreeEvent;
import com.daml.ledger.javaapi.data.Value;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ExercisedEvent
implements TreeEvent {
    private final List<String> witnessParties;
    private final String eventId;
    private final Identifier templateId;
    private final Identifier interfaceId;
    private final String contractId;
    private final String choice;
    private final Value choiceArgument;
    private final List<String> actingParties;
    private final boolean consuming;
    private final List<String> childEventIds;
    private final Value exerciseResult;

    public ExercisedEvent(@NonNull List<@NonNull String> witnessParties, @NonNull String eventId, @NonNull Identifier templateId, Identifier interfaceId, @NonNull String contractId, @NonNull String choice2, @NonNull Value choiceArgument, @NonNull List<@NonNull String> actingParties, boolean consuming, @NonNull List<@NonNull String> childEventIds, @NonNull Value exerciseResult) {
        this.witnessParties = witnessParties;
        this.eventId = eventId;
        this.templateId = templateId;
        this.interfaceId = interfaceId;
        this.contractId = contractId;
        this.choice = choice2;
        this.choiceArgument = choiceArgument;
        this.actingParties = actingParties;
        this.consuming = consuming;
        this.childEventIds = childEventIds;
        this.exerciseResult = exerciseResult;
    }

    @Override
    public @NonNull List<@NonNull String> getWitnessParties() {
        return this.witnessParties;
    }

    @Override
    public @NonNull String getEventId() {
        return this.eventId;
    }

    @Override
    public @NonNull Identifier getTemplateId() {
        return this.templateId;
    }

    public boolean hasInterfaceId() {
        return this.interfaceId != null;
    }

    public Identifier getInterfaceId() {
        return this.interfaceId;
    }

    @Override
    public @NonNull String getContractId() {
        return this.contractId;
    }

    public @NonNull String getChoice() {
        return this.choice;
    }

    public @NonNull List<@NonNull String> getChildEventIds() {
        return this.childEventIds;
    }

    public @NonNull Value getChoiceArgument() {
        return this.choiceArgument;
    }

    public @NonNull List<@NonNull String> getActingParties() {
        return this.actingParties;
    }

    public boolean isConsuming() {
        return this.consuming;
    }

    public @NonNull Value getExerciseResult() {
        return this.exerciseResult;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExercisedEvent that = (ExercisedEvent)o;
        return this.consuming == that.consuming && Objects.equals(this.witnessParties, that.witnessParties) && Objects.equals(this.eventId, that.eventId) && Objects.equals(this.templateId, that.templateId) && Objects.equals(this.contractId, that.contractId) && Objects.equals(this.choice, that.choice) && Objects.equals(this.choiceArgument, that.choiceArgument) && Objects.equals(this.actingParties, that.actingParties) && Objects.equals(this.exerciseResult, that.exerciseResult);
    }

    public int hashCode() {
        return Objects.hash(this.witnessParties, this.eventId, this.templateId, this.contractId, this.choice, this.choiceArgument, this.actingParties, this.consuming, this.exerciseResult);
    }

    public String toString() {
        return "ExercisedEvent{witnessParties=" + this.witnessParties + ", eventId='" + this.eventId + "', templateId=" + this.templateId + ", contractId='" + this.contractId + "', choice='" + this.choice + "', choiceArgument=" + this.choiceArgument + ", actingParties=" + this.actingParties + ", consuming=" + this.consuming + ", childEventIds=" + this.childEventIds + ", exerciseResult=" + this.exerciseResult + "}";
    }

    public  @NonNull EventOuterClass.ExercisedEvent toProto() {
        EventOuterClass.ExercisedEvent.Builder builder = EventOuterClass.ExercisedEvent.newBuilder();
        builder.setEventId(this.getEventId());
        builder.setChoice(this.getChoice());
        builder.setChoiceArgument(this.getChoiceArgument().toProto());
        builder.setConsuming(this.isConsuming());
        builder.setContractId(this.getContractId());
        builder.setTemplateId(this.getTemplateId().toProto());
        if (this.hasInterfaceId()) {
            builder.setInterfaceId(this.getInterfaceId().toProto());
        }
        builder.addAllActingParties(this.getActingParties());
        builder.addAllWitnessParties(this.getWitnessParties());
        builder.addAllChildEventIds(this.getChildEventIds());
        builder.setExerciseResult(this.getExerciseResult().toProto());
        return builder.build();
    }

    public static ExercisedEvent fromProto(EventOuterClass.ExercisedEvent exercisedEvent) {
        return new ExercisedEvent(exercisedEvent.getWitnessPartiesList(), exercisedEvent.getEventId(), Identifier.fromProto(exercisedEvent.getTemplateId()), exercisedEvent.hasInterfaceId() ? Identifier.fromProto(exercisedEvent.getInterfaceId()) : null, exercisedEvent.getContractId(), exercisedEvent.getChoice(), Value.fromProto(exercisedEvent.getChoiceArgument()), exercisedEvent.getActingPartiesList(), exercisedEvent.getConsuming(), exercisedEvent.getChildEventIdsList(), Value.fromProto(exercisedEvent.getExerciseResult()));
    }
}

