/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.TransactionOuterClass;
import com.daml.ledger.api.v1.TransactionServiceOuterClass;
import com.daml.ledger.javaapi.data.Transaction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class GetTransactionsResponse {
    private final List<Transaction> transactions;

    public GetTransactionsResponse(@NonNull List<@NonNull Transaction> transactions) {
        this.transactions = transactions;
    }

    public static GetTransactionsResponse fromProto(TransactionServiceOuterClass.GetTransactionsResponse response) {
        ArrayList<Transaction> transactions = new ArrayList<Transaction>(response.getTransactionsCount());
        for (TransactionOuterClass.Transaction transaction : response.getTransactionsList()) {
            transactions.add(Transaction.fromProto(transaction));
        }
        return new GetTransactionsResponse(transactions);
    }

    public TransactionServiceOuterClass.GetTransactionsResponse toProto() {
        ArrayList<TransactionOuterClass.Transaction> transactions = new ArrayList<TransactionOuterClass.Transaction>(this.transactions.size());
        for (Transaction transaction : this.transactions) {
            transactions.add(transaction.toProto());
        }
        return TransactionServiceOuterClass.GetTransactionsResponse.newBuilder().addAllTransactions(transactions).build();
    }

    public @NonNull List<@NonNull Transaction> getTransactions() {
        return this.transactions;
    }

    public String toString() {
        return "GetTransactionsResponse{transactions=" + this.transactions + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTransactionsResponse that = (GetTransactionsResponse)o;
        return Objects.equals(this.transactions, that.transactions);
    }

    public int hashCode() {
        return Objects.hash(this.transactions);
    }
}

