/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.ValueOuterClass;
import com.daml.ledger.javaapi.data.Value;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Timestamp
extends Value {
    private final long value;

    public static @NonNull Timestamp fromMillis(long millis) {
        return new Timestamp(millis * 1000L);
    }

    public static @NonNull Timestamp fromInstant(@NonNull Instant instant) {
        return new Timestamp(instant.getEpochSecond() * 1000000L + (long)instant.getNano() / 1000L);
    }

    public Timestamp(long value) {
        this.value = value;
    }

    public @NonNull Instant getValue() {
        return this.toInstant();
    }

    public @NonNull long getMicroseconds() {
        return this.value;
    }

    public Instant toInstant() {
        return Instant.ofEpochSecond(TimeUnit.MICROSECONDS.toSeconds(this.value), this.value % 1000000L * 1000L);
    }

    @Override
    public ValueOuterClass.Value toProto() {
        return ValueOuterClass.Value.newBuilder().setTimestamp(this.value).build();
    }

    public String toString() {
        return "Timestamp{value=" + this.value + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Timestamp timestamp = (Timestamp)o;
        return this.value == timestamp.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

