/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.codegen.backend.java.inner;

import com.daml.ledger.javaapi.data.Contract;
import com.daml.ledger.javaapi.data.CreatedEvent;
import com.daml.ledger.javaapi.data.Identifier;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import javax.lang.model.element.Modifier;
import scala.Function1;
import scala.collection.Iterable;

public final class DecoderClass$ {
    public static final DecoderClass$ MODULE$ = new DecoderClass$();
    private static final ClassName contractType = ClassName.get(Contract.class);
    private static final ParameterizedTypeName decoderFunctionType = ParameterizedTypeName.get(ClassName.get(Function.class), ClassName.get(CreatedEvent.class), ClassName.get(Contract.class));
    private static final ParameterizedTypeName decodersMapType = ParameterizedTypeName.get(ClassName.get(HashMap.class), ClassName.get(Identifier.class), MODULE$.decoderFunctionType());
    private static final MethodSpec fromCreatedEvent = MethodSpec.methodBuilder("fromCreatedEvent").addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(MODULE$.contractType()).addParameter(ClassName.get(CreatedEvent.class), "event", new Modifier[0]).addException((Type)((Object)IllegalArgumentException.class)).addCode(CodeBlock.builder().addStatement("Identifier templateId = event.getTemplateId()", new Object[0]).addStatement("$T decoderFunc = getDecoder(templateId).orElseThrow(() -> new IllegalArgumentException(\"No template found for identifier \" + templateId))", MODULE$.decoderFunctionType()).addStatement("return decoderFunc.apply(event)", new Object[0]).build()).build();
    private static final MethodSpec getDecoder = MethodSpec.methodBuilder("getDecoder").addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(ParameterizedTypeName.get(ClassName.get(Optional.class), MODULE$.decoderFunctionType())).addParameter(ClassName.get(Identifier.class), "templateId", new Modifier[0]).addStatement(CodeBlock.of("return Optional.ofNullable(decoders.get(templateId))", new Object[0])).build();
    private static final FieldSpec decodersField = FieldSpec.builder(MODULE$.decodersMapType(), "decoders", new Modifier[0]).addModifiers(Modifier.PRIVATE, Modifier.STATIC).build();

    public TypeSpec generateCode(String simpleClassName, Iterable<ClassName> templateNames) {
        return TypeSpec.classBuilder(simpleClassName).addModifiers(Modifier.PUBLIC).addField(this.decodersField()).addMethod(this.fromCreatedEvent()).addMethod(this.getDecoder()).addStaticBlock(this.generateStaticInitializer(templateNames)).build();
    }

    private ClassName contractType() {
        return contractType;
    }

    private ParameterizedTypeName decoderFunctionType() {
        return decoderFunctionType;
    }

    private ParameterizedTypeName decodersMapType() {
        return decodersMapType;
    }

    private MethodSpec fromCreatedEvent() {
        return fromCreatedEvent;
    }

    private MethodSpec getDecoder() {
        return getDecoder;
    }

    private FieldSpec decodersField() {
        return decodersField;
    }

    public CodeBlock generateStaticInitializer(Iterable<ClassName> templateNames) {
        CodeBlock.Builder b = CodeBlock.builder();
        b.addStatement("$N = new $T()", this.decodersField(), this.decodersMapType());
        templateNames.foreach((Function1<ClassName, CodeBlock.Builder> & Serializable)template -> b.addStatement("$N.put($T.TEMPLATE_ID, $T.Contract::fromCreatedEvent)", MODULE$.decodersField(), template, template));
        return b.build();
    }

    private DecoderClass$() {
    }
}

