/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.codegen.backend.java.inner;

import com.daml.ledger.javaapi.data.DamlRecord;
import com.daml.ledger.javaapi.data.Value;
import com.daml.ledger.javaapi.data.Variant;
import com.daml.lf.codegen.backend.java.JavaEscaper$;
import com.daml.lf.codegen.backend.java.inner.FieldInfo;
import com.daml.lf.codegen.backend.java.inner.FromValueExtractorParameters$;
import com.daml.lf.codegen.backend.java.inner.package$;
import com.daml.lf.data.ImmArray;
import com.daml.lf.data.ImmArray$ImmArraySeq$;
import com.daml.lf.iface.PrimType;
import com.daml.lf.iface.PrimTypeBool$;
import com.daml.lf.iface.PrimTypeContractId$;
import com.daml.lf.iface.PrimTypeDate$;
import com.daml.lf.iface.PrimTypeGenMap$;
import com.daml.lf.iface.PrimTypeInt64$;
import com.daml.lf.iface.PrimTypeList$;
import com.daml.lf.iface.PrimTypeOptional$;
import com.daml.lf.iface.PrimTypeParty$;
import com.daml.lf.iface.PrimTypeText$;
import com.daml.lf.iface.PrimTypeTextMap$;
import com.daml.lf.iface.PrimTypeTimestamp$;
import com.daml.lf.iface.PrimTypeUnit$;
import com.daml.lf.iface.TypeCon;
import com.daml.lf.iface.TypeNumeric;
import com.daml.lf.iface.TypePrim;
import com.daml.lf.iface.TypeVar;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.List;
import javax.lang.model.element.Modifier;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqFactory$UnapplySeqWrapper$;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class FromValueGenerator$
implements StrictLogging {
    public static final FromValueGenerator$ MODULE$ = new FromValueGenerator$();
    private static final Map<PrimType, Tuple2<String, Option<String>>> extractors;
    private static Logger logger;

    static {
        StrictLogging.$init$(MODULE$);
        extractors = (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2<PrimTypeBool$, Tuple2<String, Some<String>>>(PrimTypeBool$.MODULE$, new Tuple2<String, Some<String>>("asBool", new Some<String>(".getValue()"))), new Tuple2<PrimTypeInt64$, Tuple2<String, Some<String>>>(PrimTypeInt64$.MODULE$, new Tuple2<String, Some<String>>("asInt64", new Some<String>(".getValue()"))), new Tuple2<PrimTypeText$, Tuple2<String, Some<String>>>(PrimTypeText$.MODULE$, new Tuple2<String, Some<String>>("asText", new Some<String>(".getValue()"))), new Tuple2<PrimTypeTimestamp$, Tuple2<String, Some<String>>>(PrimTypeTimestamp$.MODULE$, new Tuple2<String, Some<String>>("asTimestamp", new Some<String>(".getValue()"))), new Tuple2<PrimTypeParty$, Tuple2<String, Some<String>>>(PrimTypeParty$.MODULE$, new Tuple2<String, Some<String>>("asParty", new Some<String>(".getValue()"))), new Tuple2<PrimTypeUnit$, Tuple2<String, None$>>(PrimTypeUnit$.MODULE$, new Tuple2<String, None$>("asUnit", None$.MODULE$)), new Tuple2<PrimTypeDate$, Tuple2<String, Some<String>>>(PrimTypeDate$.MODULE$, new Tuple2<String, Some<String>>("asDate", new Some<String>(".getValue()")))}));
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public MethodSpec generateFromValueForRecordLike(IndexedSeq<FieldInfo> fields, TypeName className, IndexedSeq<String> typeParameters, Function2<String, String, CodeBlock> recordValueExtractor, Map<String, String> packagePrefixes) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Generating fromValue method");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        IndexedSeq<ParameterSpec> converterParams = FromValueExtractorParameters$.MODULE$.generate(typeParameters).parameterSpecs();
        MethodSpec.Builder method = MethodSpec.methodBuilder("fromValue").addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(className).addTypeVariables(package$.MODULE$.TypeNameExtensions(className).typeParameters()).addParameter(TypeName.get(Value.class), "value$", new Modifier[0]).addParameters(CollectionConverters$.MODULE$.SeqHasAsJava(converterParams).asJava()).addException((Type)((Object)IllegalArgumentException.class)).addCode(recordValueExtractor.apply("value$", "recordValue$")).addStatement("$T record$$ = recordValue$$.asRecord().orElseThrow(() -> new IllegalArgumentException($S))", DamlRecord.class, "Contracts must be constructed from Records").addStatement("$T fields$$ = record$$.getFields()", ParameterizedTypeName.get(List.class, new Type[]{DamlRecord.Field.class})).addStatement("int numberOfFields = fields$$.size()", new Object[0]).beginControlFlow(new StringBuilder(23).append("if (numberOfFields != ").append(fields.size()).append(")").toString(), new Object[0]).addStatement("throw new $T($S + numberOfFields)", IllegalArgumentException.class, new StringBuilder(25).append("Expected ").append(fields.size()).append(" arguments, got ").toString()).endControlFlow();
        fields.iterator().zip(this.accessors()).foreach((Function1<Tuple2, MethodSpec.Builder> & Serializable)x0$1 -> {
            CodeBlock accessor;
            FieldInfo fieldInfo;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    fieldInfo = (FieldInfo)tuple2._1();
                    accessor = (CodeBlock)tuple2._2();
                    if (fieldInfo != null) break block3;
                }
                throw new MatchError(tuple2);
            }
            com.daml.lf.iface.Type damlType = fieldInfo.damlType();
            String javaName = fieldInfo.javaName();
            MethodSpec.Builder builder = method.addStatement(MODULE$.generateFieldExtractor(damlType, javaName, accessor, packagePrefixes));
            return builder;
        });
        return method.addStatement("return new $L($L)", className, package$.MODULE$.generateArgumentList((IndexedSeq)fields.map((Function1<FieldInfo, String> & Serializable)x$1 -> x$1.javaName()))).build();
    }

    private Iterator<CodeBlock> accessors() {
        return scala.package$.MODULE$.Iterator().from(0).map((Function1<Object, CodeBlock> & Serializable)i -> FromValueGenerator$.$anonfun$accessors$1(BoxesRunTime.unboxToInt(i)));
    }

    public CodeBlock variantCheck(String constructorName, String inputVar, String outputVar) {
        return CodeBlock.builder().addStatement("$T variant$$ = $L.asVariant().orElseThrow(() -> new IllegalArgumentException($S + $L.getClass().getName()))", Variant.class, inputVar, "Expected: Variant. Actual: ", inputVar).addStatement("if (!$S.equals(variant$$.getConstructor())) throw new $T($S + variant$$.getConstructor())", constructorName, IllegalArgumentException.class, new StringBuilder(41).append("Invalid constructor. Expected: ").append(constructorName).append(". Actual: ").toString()).addStatement("$T $L = variant$$.getValue()", Value.class, outputVar).build();
    }

    public CodeBlock generateFieldExtractor(com.daml.lf.iface.Type fieldType, String field2, CodeBlock accessor, Map<String, String> packagePrefixes) {
        return CodeBlock.of("$T $L = $L", package$.MODULE$.toJavaTypeName(fieldType, packagePrefixes), field2, this.extractor(fieldType, field2, accessor, package$.MODULE$.newNameGenerator(), packagePrefixes));
    }

    private Option<CodeBlock> primitive(PrimType damlType, TypeName apiType, String field2, CodeBlock accessor) {
        return extractors.get(damlType).map((Function1<Tuple2, CodeBlock> & Serializable)x0$1 -> {
            Option converter;
            String extractor;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                BoxedUnit boxedUnit;
                extractor = (String)tuple2._1();
                converter = (Option)tuple2._2();
                if (MODULE$.logger().underlying().isDebugEnabled()) {
                    MODULE$.logger().underlying().debug("Generating primitive extractor for {} of type {}", new Object[]{field2, apiType});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError(tuple2);
            }
            CodeBlock codeBlock = CodeBlock.of("$L.$L()$L$L", accessor, extractor, MODULE$.orElseThrow(apiType, field2), converter.getOrElse((Function0<String> & Serializable)() -> ""));
            return codeBlock;
        });
    }

    private CodeBlock orElseThrow(TypeName typeName, String field2) {
        return CodeBlock.of(".orElseThrow(() -> new IllegalArgumentException($S))", new StringBuilder(24).append("Expected ").append(field2).append(" to be of type ").append(typeName).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CodeBlock extractor(com.daml.lf.iface.Type damlType, String field2, CodeBlock accessor, Iterator<String> args, Map<String, String> packagePrefixes) {
        PrimType primType;
        BoxedUnit boxedUnit;
        LazyRef apiType$lzy = new LazyRef();
        LazyRef javaType$lzy = new LazyRef();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Generating composite extractor for {} of type {}", new Object[]{field2, FromValueGenerator$.javaType$1(javaType$lzy, damlType, packagePrefixes)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boolean bl = false;
        TypePrim typePrim = null;
        boolean bl2 = false;
        TypeCon typeCon = null;
        com.daml.lf.iface.Type type = damlType;
        if (type instanceof TypeVar) {
            TypeVar typeVar = (TypeVar)type;
            String tvName = typeVar.name();
            return CodeBlock.of("fromValue$L.apply($L)", JavaEscaper$.MODULE$.escapeString(tvName), accessor);
        }
        if (type instanceof TypePrim) {
            SeqOps seqOps;
            bl = true;
            typePrim = (TypePrim)type;
            PrimType primType2 = typePrim.typ();
            ImmArray.ImmArraySeq<com.daml.lf.iface.Type> immArraySeq = typePrim.typArgs();
            if (PrimTypeList$.MODULE$.equals(primType2) && immArraySeq != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = ImmArray$ImmArraySeq$.MODULE$.unapplySeq(immArraySeq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
                com.daml.lf.iface.Type param2 = (com.daml.lf.iface.Type)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                String optMapArg = args.next();
                String listMapArg = args.next();
                return CodeBlock.of(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("$L.asList()\n            |    .map($L -> $L.toList($L ->\n            |        $L\n            |    ))\n            |    $L\n            |")), accessor, optMapArg, optMapArg, listMapArg, this.extractor(param2, listMapArg, CodeBlock.of("$L", listMapArg), args, packagePrefixes), this.orElseThrow(FromValueGenerator$.apiType$2(apiType$lzy, damlType), field2));
            }
        }
        if (bl) {
            SeqOps seqOps;
            PrimType primType3 = typePrim.typ();
            ImmArray.ImmArraySeq<com.daml.lf.iface.Type> immArraySeq = typePrim.typArgs();
            if (PrimTypeOptional$.MODULE$.equals(primType3) && immArraySeq != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = ImmArray$ImmArraySeq$.MODULE$.unapplySeq(immArraySeq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
                com.daml.lf.iface.Type param3 = (com.daml.lf.iface.Type)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                String optOptArg = args.next();
                String valArg = args.next();
                return CodeBlock.of(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("$L.asOptional()\n            |    .map($L -> $L.toOptional($L ->\n            |        $L\n            |    ))\n            |    $L\n          ")), accessor, optOptArg, optOptArg, valArg, this.extractor(param3, valArg, CodeBlock.of("$L", valArg), args, packagePrefixes), this.orElseThrow(FromValueGenerator$.apiType$2(apiType$lzy, damlType), field2));
            }
        }
        if (bl && PrimTypeContractId$.MODULE$.equals(primType = typePrim.typ())) {
            return CodeBlock.of("new $T($L.asContractId()$L.getValue())", FromValueGenerator$.javaType$1(javaType$lzy, damlType, packagePrefixes), accessor, this.orElseThrow(FromValueGenerator$.apiType$2(apiType$lzy, damlType), field2));
        }
        if (bl) {
            SeqOps seqOps;
            PrimType primType4 = typePrim.typ();
            ImmArray.ImmArraySeq<com.daml.lf.iface.Type> immArraySeq = typePrim.typArgs();
            if (PrimTypeTextMap$.MODULE$.equals(primType4) && immArraySeq != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = ImmArray$ImmArraySeq$.MODULE$.unapplySeq(immArraySeq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
                com.daml.lf.iface.Type param4 = (com.daml.lf.iface.Type)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                String optMapArg = args.next();
                String entryArg = args.next();
                return CodeBlock.of(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("$L.asTextMap()\n            |    .map($L -> $L.toMap($L ->\n            |        $L\n            |    ))\n            |    $L\n          ")), accessor, optMapArg, optMapArg, entryArg, this.extractor(param4, entryArg, CodeBlock.of("$L", entryArg), args, packagePrefixes), this.orElseThrow(FromValueGenerator$.apiType$2(apiType$lzy, damlType), field2));
            }
        }
        if (bl) {
            SeqOps seqOps;
            PrimType primType5 = typePrim.typ();
            ImmArray.ImmArraySeq<com.daml.lf.iface.Type> immArraySeq = typePrim.typArgs();
            if (PrimTypeGenMap$.MODULE$.equals(primType5) && immArraySeq != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = ImmArray$ImmArraySeq$.MODULE$.unapplySeq(immArraySeq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                com.daml.lf.iface.Type keyType = (com.daml.lf.iface.Type)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                com.daml.lf.iface.Type valueType = (com.daml.lf.iface.Type)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                String optMapArg = args.next();
                String entryArg = args.next();
                return CodeBlock.of(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("$L.asGenMap()\n              |    .map($L -> $L.toMap(\n              |        $L -> $L,\n              |        $L -> $L\n              |    ))\n              |    $L\n          ")), accessor, optMapArg, optMapArg, entryArg, this.extractor(keyType, entryArg, CodeBlock.of("$L", entryArg), args, packagePrefixes), entryArg, this.extractor(valueType, entryArg, CodeBlock.of("$L", entryArg), args, packagePrefixes), this.orElseThrow(FromValueGenerator$.apiType$2(apiType$lzy, damlType), field2));
            }
        }
        if (type instanceof TypeNumeric) {
            return CodeBlock.of("$L.asNumeric()$L.getValue()", accessor, this.orElseThrow(FromValueGenerator$.apiType$2(apiType$lzy, damlType), field2));
        }
        if (bl) {
            PrimType prim = typePrim.typ();
            return (CodeBlock)this.primitive(prim, FromValueGenerator$.apiType$2(apiType$lzy, damlType), field2, accessor).getOrElse((Function0<Nothing$> & Serializable)() -> scala.sys.package$.MODULE$.error(new StringBuilder(25).append("Unhandled primitive type ").append(prim).toString()));
        }
        if (type instanceof TypeCon) {
            SeqOps seqOps;
            bl2 = true;
            typeCon = (TypeCon)type;
            ImmArray.ImmArraySeq<com.daml.lf.iface.Type> immArraySeq = typeCon.typArgs();
            if (immArraySeq != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = ImmArray$ImmArraySeq$.MODULE$.unapplySeq(immArraySeq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0) == 0) {
                return CodeBlock.of("$T.fromValue($L)", FromValueGenerator$.javaType$1(javaType$lzy, damlType, packagePrefixes), accessor);
            }
        }
        if (!bl2) throw new MatchError(type);
        ImmArray.ImmArraySeq<com.daml.lf.iface.Type> typeParameters = typeCon.typArgs();
        Tuple2 tuple2 = ((StrictOptimizedIterableOps)typeParameters.map((Function1<com.daml.lf.iface.Type, Tuple2> & Serializable)targ -> {
            String innerArg = (String)args.next();
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(package$.MODULE$.toJavaTypeName((com.daml.lf.iface.Type)targ, packagePrefixes)), CodeBlock.of("$L -> $L", innerArg, MODULE$.extractor((com.daml.lf.iface.Type)targ, field2, CodeBlock.of("$L", innerArg), args, packagePrefixes)));
        })).unzip(Predef$.MODULE$.$conforms());
        if (tuple2 == null) throw new MatchError(tuple2);
        ImmArray.ImmArraySeq targs = (ImmArray.ImmArraySeq)tuple2._1();
        ImmArray.ImmArraySeq extractors = (ImmArray.ImmArraySeq)tuple2._2();
        Tuple2<ImmArray.ImmArraySeq, ImmArray.ImmArraySeq> tuple22 = new Tuple2<ImmArray.ImmArraySeq, ImmArray.ImmArraySeq>(targs, extractors);
        Tuple2<ImmArray.ImmArraySeq, ImmArray.ImmArraySeq> tuple23 = tuple22;
        ImmArray.ImmArraySeq targs2 = tuple23._1();
        ImmArray.ImmArraySeq extractors2 = tuple23._2();
        CodeBlock targsCode = CodeBlock.join(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)targs2.map((Function1<TypeName, CodeBlock> & Serializable)x$3 -> CodeBlock.of("$L", x$3))).asJava(), ", ");
        return CodeBlock.builder().add(CodeBlock.of("$T.<$L>fromValue($L, ", package$.MODULE$.TypeNameExtensions(FromValueGenerator$.javaType$1(javaType$lzy, damlType, packagePrefixes)).rawType(), targsCode, accessor)).add(CodeBlock.join(CollectionConverters$.MODULE$.SeqHasAsJava(extractors2).asJava(), ", ")).add(")", new Object[0]).build();
    }

    public static final /* synthetic */ CodeBlock $anonfun$accessors$1(int i) {
        return CodeBlock.of("fields$$.get($L).getValue()", i);
    }

    private static final /* synthetic */ TypeName apiType$lzycompute$1(LazyRef apiType$lzy$1, com.daml.lf.iface.Type damlType$1) {
        TypeName typeName;
        LazyRef lazyRef = apiType$lzy$1;
        synchronized (lazyRef) {
            typeName = apiType$lzy$1.initialized() ? (TypeName)apiType$lzy$1.value() : apiType$lzy$1.initialize(package$.MODULE$.toAPITypeName(damlType$1));
        }
        return typeName;
    }

    private static final TypeName apiType$2(LazyRef apiType$lzy$1, com.daml.lf.iface.Type damlType$1) {
        return apiType$lzy$1.initialized() ? (TypeName)apiType$lzy$1.value() : FromValueGenerator$.apiType$lzycompute$1(apiType$lzy$1, damlType$1);
    }

    private static final /* synthetic */ TypeName javaType$lzycompute$1(LazyRef javaType$lzy$1, com.daml.lf.iface.Type damlType$1, Map packagePrefixes$2) {
        TypeName typeName;
        LazyRef lazyRef = javaType$lzy$1;
        synchronized (lazyRef) {
            typeName = javaType$lzy$1.initialized() ? (TypeName)javaType$lzy$1.value() : javaType$lzy$1.initialize(package$.MODULE$.toJavaTypeName(damlType$1, packagePrefixes$2));
        }
        return typeName;
    }

    private static final TypeName javaType$1(LazyRef javaType$lzy$1, com.daml.lf.iface.Type damlType$1, Map packagePrefixes$2) {
        return javaType$lzy$1.initialized() ? (TypeName)javaType$lzy$1.value() : FromValueGenerator$.javaType$lzycompute$1(javaType$lzy$1, damlType$1, packagePrefixes$2);
    }

    private FromValueGenerator$() {
    }
}

