/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.codegen.backend.java.inner;

import com.daml.ledger.javaapi.data.Value;
import com.daml.ledger.javaapi.data.Variant;
import com.daml.lf.codegen.TypeWithContext;
import com.daml.lf.codegen.backend.java.JavaEscaper$;
import com.daml.lf.codegen.backend.java.inner.FieldInfo;
import com.daml.lf.codegen.backend.java.inner.FromValueExtractorParameters;
import com.daml.lf.codegen.backend.java.inner.FromValueExtractorParameters$;
import com.daml.lf.codegen.backend.java.inner.ToValueExtractorParameters$;
import com.daml.lf.codegen.backend.java.inner.TrackLineage$;
import com.daml.lf.codegen.backend.java.inner.VariantConstructorClass$;
import com.daml.lf.codegen.backend.java.inner.VariantRecordClass$;
import com.daml.lf.codegen.backend.java.inner.package$;
import com.daml.lf.data.ImmArray;
import com.daml.lf.data.Ref;
import com.daml.lf.iface.DataType;
import com.daml.lf.iface.DefDataType;
import com.daml.lf.iface.Enum;
import com.daml.lf.iface.InterfaceType;
import com.daml.lf.iface.Record;
import com.daml.lf.iface.TypeCon;
import com.daml.lf.iface.TypeConName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.lang.reflect.Type;
import javax.lang.model.element.Modifier;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashSet;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class VariantClass$
implements StrictLogging {
    public static final VariantClass$ MODULE$ = new VariantClass$();
    private static Logger logger;

    static {
        StrictLogging.$init$(MODULE$);
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public Tuple2<TypeSpec, List<TypeSpec>> generate(ClassName variantClassName, String subPackage, IndexedSeq<String> typeArguments, com.daml.lf.iface.Variant<com.daml.lf.iface.Type> variant, TypeWithContext typeWithContext, Map<String, String> packagePrefixes) {
        return (Tuple2)TrackLineage$.MODULE$.of("variant", typeWithContext.name(), (Function0<Tuple2> & Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("Start");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            IndexedSeq<FieldInfo> constructorInfo = package$.MODULE$.getFieldsWithTypes(variant.fields(), packagePrefixes);
            TypeSpec variantType = TypeSpec.classBuilder(variantClassName).addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).addTypeVariables(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)typeArguments.map((Function1<String, TypeVariableName> & Serializable)x$1 -> TypeVariableName.get(x$1))).asJava()).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).build()).addMethod(MODULE$.generateAbstractToValueSpec(typeArguments)).addMethod(MODULE$.generateFromValue(typeArguments, constructorInfo, variantClassName, subPackage)).addField(package$.MODULE$.createPackageIdField(typeWithContext.interface().packageId())).build();
            List<TypeSpec> constructors2 = MODULE$.generateConstructorClasses(typeArguments, variant, typeWithContext, packagePrefixes, variantClassName);
            if (MODULE$.logger().underlying().isDebugEnabled()) {
                MODULE$.logger().underlying().debug("End");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new Tuple2<TypeSpec, List<TypeSpec>>(variantType, constructors2);
        });
    }

    private boolean isRecord(InterfaceType interfaceType) {
        boolean bl;
        DataType<com.daml.lf.iface.Type, com.daml.lf.iface.Type> dataType = interfaceType.type().dataType();
        if (dataType instanceof Record) {
            bl = true;
        } else {
            boolean bl2 = dataType instanceof com.daml.lf.iface.Variant ? true : dataType instanceof Enum;
            if (bl2) {
                bl = false;
            } else {
                throw new MatchError(dataType);
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isVariantRecord(TypeWithContext typeWithContext, String constructor, Ref.Identifier identifier) {
        if (!typeWithContext.interface().typeDecls().get(identifier.qualifiedName()).exists((Function1<InterfaceType, Object> & Serializable)interfaceType -> BoxesRunTime.boxToBoolean(VariantClass$.MODULE$.isRecord(interfaceType)))) return false;
        Ref.DottedName dottedName = typeWithContext.identifier().qualifiedName().module();
        Ref.DottedName dottedName2 = identifier.qualifiedName().module();
        if (dottedName == null) {
            if (dottedName2 != null) {
                return false;
            }
        } else if (!((Object)dottedName).equals(dottedName2)) return false;
        ImmArray<String> immArray = typeWithContext.identifier().qualifiedName().name().segments();
        ImmArray<String> immArray2 = identifier.qualifiedName().name().segments().init();
        if (immArray == null) {
            if (immArray2 != null) {
                return false;
            }
        } else if (!((Object)immArray).equals(immArray2)) return false;
        String string2 = constructor;
        String string3 = identifier.qualifiedName().name().segments().last();
        if (string2 == null) {
            if (string3 == null) return true;
            return false;
        } else {
            if (!string2.equals(string3)) return false;
            return true;
        }
    }

    private MethodSpec generateAbstractToValueSpec(IndexedSeq<String> typeArgs) {
        return MethodSpec.methodBuilder("toValue").addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).addParameters(CollectionConverters$.MODULE$.SeqHasAsJava(ToValueExtractorParameters$.MODULE$.generate(typeArgs)).asJava()).returns((Type)((Object)Value.class)).build();
    }

    private MethodSpec.Builder initFromValueBuilder(TypeName t) {
        return MethodSpec.methodBuilder("fromValue").addModifiers(Modifier.STATIC, Modifier.PUBLIC).returns(t).addParameter((Type)((Object)Value.class), "value$", new Modifier[0]);
    }

    private CodeBlock variantExtractor(TypeName t) {
        return CodeBlock.of("$T variant$$ = value$$.asVariant().orElseThrow(() -> new IllegalArgumentException($S))", Variant.class, new StringBuilder(53).append("Expected Variant to build an instance of the Variant ").append(t).toString());
    }

    private MethodSpec.Builder switchOnConstructor(MethodSpec.Builder builder, IndexedSeq<FieldInfo> constructors2, ClassName variant, String subPackage, Function1<String, CodeBlock> useConstructor) {
        BoxedUnit boxedUnit;
        String constructorsAsString = ((IterableOnceOps)constructors2.map((Function1<FieldInfo, String> & Serializable)x$1 -> x$1.damlName())).mkString("[", ", ", "]");
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Generating switch on constructors {} for {}", new Object[]{constructorsAsString, variant});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        constructors2.foreach((Function1<FieldInfo, MethodSpec.Builder> & Serializable)constructorInfo -> builder.beginControlFlow("if ($S.equals(variant$$.getConstructor()))", constructorInfo.damlName()).addStatement((CodeBlock)useConstructor.apply(((IterableOnceOps)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{subPackage, constructorInfo.javaName()}))).mkString("."))).endControlFlow());
        return builder.addStatement("throw new IllegalArgumentException($S)", new StringBuilder(82).append("Found unknown constructor variant$.getConstructor() for variant ").append(variant).append(", expected one of ").append(constructorsAsString).toString());
    }

    private MethodSpec generateParameterizedFromValue(ParameterizedTypeName variant, IndexedSeq<FieldInfo> constructors2, String subPackage) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Generating fromValue static method for {}", (Object)variant);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.require(CollectionConverters$.MODULE$.ListHasAsScala(variant.typeArguments).asScala().forall((Function1<TypeName, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(VariantClass$.$anonfun$generateParameterizedFromValue$1(x$2))), (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(38).append("All type arguments of ").append(variant$2.rawType).append(" must be generic").toString());
        MethodSpec.Builder builder = this.initFromValueBuilder(variant);
        FromValueExtractorParameters typeVariablesExtractorParameters = FromValueExtractorParameters$.MODULE$.generate(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(variant.typeArguments).asScala().map((Function1<TypeName, String> & Serializable)x$3 -> x$3.toString())).toIndexedSeq());
        builder.addTypeVariables(CollectionConverters$.MODULE$.SeqHasAsJava(typeVariablesExtractorParameters.typeVariables()).asJava());
        builder.addParameters(CollectionConverters$.MODULE$.SeqHasAsJava(typeVariablesExtractorParameters.parameterSpecs()).asJava());
        builder.addStatement("$L", this.variantExtractor(variant.rawType));
        CodeBlock extractors = CodeBlock.join(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(variant.typeArguments).asScala().map((Function1<TypeName, CodeBlock> & Serializable)t -> CodeBlock.of("$L", new StringBuilder(9).append("fromValue").append(t).toString()))).asJava(), ", ");
        this.switchOnConstructor(builder, constructors2, variant.rawType, subPackage, (Function1<String, CodeBlock> & Serializable)constructor -> CodeBlock.of("return $L.fromValue(variant$$, $L)", constructor, extractors));
        return builder.build();
    }

    private MethodSpec generateConcreteFromValue(ClassName t, IndexedSeq<FieldInfo> constructors2, String subPackage) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Generating fromValue static method for {}", (Object)t);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        MethodSpec.Builder builder = this.initFromValueBuilder(t).addStatement("$L", this.variantExtractor(t));
        this.switchOnConstructor(builder, constructors2, t, subPackage, (Function1<String, CodeBlock> & Serializable)c -> CodeBlock.of("return $L.fromValue(variant$$)", c));
        return builder.build();
    }

    private MethodSpec generateFromValue(IndexedSeq<String> typeArguments, IndexedSeq<FieldInfo> constructorInfo, ClassName variantClassName, String subPackage) {
        MethodSpec methodSpec;
        TypeName typeName = package$.MODULE$.ClassNameExtensions(variantClassName).parameterized(typeArguments);
        if (typeName instanceof ClassName) {
            ClassName className = (ClassName)typeName;
            methodSpec = this.generateConcreteFromValue(className, constructorInfo, subPackage);
        } else if (typeName instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
            methodSpec = this.generateParameterizedFromValue(parameterizedTypeName, constructorInfo, subPackage);
        } else {
            throw new IllegalArgumentException("Required either ClassName or ParameterizedTypeName");
        }
        return methodSpec;
    }

    private List<TypeSpec> generateConstructorClasses(IndexedSeq<String> typeArgs, com.daml.lf.iface.Variant<com.daml.lf.iface.Type> variant, TypeWithContext typeWithContext, Map<String, String> packagePrefixes, ClassName variantClassName) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Generating inner classes");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ArrayBuffer innerClasses = new ArrayBuffer();
        HashSet variantRecords = new HashSet();
        TypeName fullVariantClassName = package$.MODULE$.ClassNameExtensions(variantClassName).parameterized(typeArgs);
        package$.MODULE$.getFieldsWithTypes(variant.fields(), packagePrefixes).foreach((Function1<FieldInfo, Object> & Serializable)fieldInfo -> {
            Object object;
            Ref.Identifier id2;
            TypeCon typeCon;
            TypeConName typeConName;
            FieldInfo fieldInfo2 = fieldInfo;
            if (fieldInfo2 == null) {
                throw new MatchError(fieldInfo2);
            }
            String damlName = fieldInfo2.damlName();
            com.daml.lf.iface.Type damlType = fieldInfo2.damlType();
            String javaName = fieldInfo2.javaName();
            Tuple3<String, com.daml.lf.iface.Type, String> tuple3 = new Tuple3<String, com.daml.lf.iface.Type, String>(damlName, damlType, javaName);
            Tuple3<String, com.daml.lf.iface.Type, String> tuple32 = tuple3;
            String damlName2 = tuple32._1();
            com.daml.lf.iface.Type damlType2 = tuple32._2();
            String javaName2 = tuple32._3();
            com.daml.lf.iface.Type type = damlType2;
            if (type instanceof TypeCon && (typeConName = (typeCon = (TypeCon)type).name()) != null && MODULE$.isVariantRecord(typeWithContext, damlName2, id2 = typeConName.identifier())) {
                object = BoxesRunTime.boxToBoolean(variantRecords.add(damlName2));
            } else {
                BoxedUnit boxedUnit;
                if (MODULE$.logger().underlying().isDebugEnabled()) {
                    MODULE$.logger().underlying().debug("{} is trivial", (Object)damlName2);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                object = innerClasses.$plus$eq(VariantConstructorClass$.MODULE$.generate(typeWithContext.interface().packageId(), fullVariantClassName, typeArgs, damlName2, javaName2, damlType2, packagePrefixes));
            }
            return object;
        });
        typeWithContext.typesLineages().map((Function1<TypeWithContext, Object> & Serializable)child -> {
            Serializable serializable;
            block10: {
                block7: {
                    DataType<com.daml.lf.iface.Type, com.daml.lf.iface.Type> record;
                    ImmArray.ImmArraySeq<String> typeVars;
                    block9: {
                        Option<InterfaceType> option2;
                        block8: {
                            InterfaceType.Normal normal;
                            DefDataType<com.daml.lf.iface.Type, com.daml.lf.iface.Type> defDataType;
                            Some some;
                            InterfaceType interfaceType;
                            BoxedUnit boxedUnit;
                            if (!variantRecords.contains(child.name())) break block7;
                            if (MODULE$.logger().underlying().isDebugEnabled()) {
                                MODULE$.logger().underlying().debug("{} is a variant record", (Object)child.name());
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            option2 = child.type().typ();
                            if (!(option2 instanceof Some) || !((interfaceType = (InterfaceType)(some = (Some)option2).value()) instanceof InterfaceType.Normal) || (defDataType = (normal = (InterfaceType.Normal)interfaceType).type()) == null) break block8;
                            typeVars = defDataType.typeVars();
                            record = defDataType.dataType();
                            if (record instanceof Record) break block9;
                        }
                        String c = new StringBuilder(1).append(typeWithContext.name()).append(".").append(child.name()).toString();
                        throw new IllegalArgumentException(new StringBuilder(55).append("Underlying type of constructor ").append(c).append(" is not Record (found: ").append(option2).append(")").toString());
                    }
                    Record record2 = (Record)record;
                    ArrayBuffer arrayBuffer = (ArrayBuffer)innerClasses.$plus$eq(VariantRecordClass$.MODULE$.generate(typeWithContext.interface().packageId(), (IndexedSeq)typeVars.map((Function1<String, String> & Serializable)s2 -> JavaEscaper$.MODULE$.escapeString((String)s2)), package$.MODULE$.getFieldsWithTypes(record2.fields(), packagePrefixes), child.name(), fullVariantClassName, packagePrefixes));
                    serializable = arrayBuffer;
                    break block10;
                }
                if (MODULE$.logger().underlying().isDebugEnabled()) {
                    MODULE$.logger().underlying().debug("{} is an unrelated inner type", (Object)child.name());
                    serializable = BoxedUnit.UNIT;
                } else {
                    serializable = BoxedUnit.UNIT;
                }
            }
            return serializable;
        });
        return innerClasses.toList();
    }

    public static final /* synthetic */ boolean $anonfun$generateParameterizedFromValue$1(TypeName x$2) {
        return x$2 instanceof TypeVariableName;
    }

    private VariantClass$() {
    }
}

