/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index;

import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.index.IndexRefinementInfo;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.GreaterThanNode;
import org.checkerframework.dataflow.cfg.node.GreaterThanOrEqualNode;
import org.checkerframework.dataflow.cfg.node.LessThanNode;
import org.checkerframework.dataflow.cfg.node.LessThanOrEqualNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.flow.CFAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFTransfer;
import org.checkerframework.framework.flow.CFValue;

public abstract class IndexAbstractTransfer
extends CFTransfer {
    protected IndexAbstractTransfer(CFAnalysis analysis) {
        super(analysis);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitGreaterThan(GreaterThanNode node, TransferInput<CFValue, CFStore> in) {
        TransferResult result2 = (TransferResult)super.visitGreaterThan(node, in);
        IndexRefinementInfo rfi = new IndexRefinementInfo(result2, this.analysis, node);
        if (rfi.leftAnno == null || rfi.rightAnno == null) {
            return result2;
        }
        this.refineGT(rfi.left, rfi.leftAnno, rfi.right, rfi.rightAnno, rfi.thenStore, in);
        this.refineGTE(rfi.right, rfi.rightAnno, rfi.left, rfi.leftAnno, rfi.elseStore, in);
        return rfi.newResult;
    }

    @Override
    public TransferResult<CFValue, CFStore> visitGreaterThanOrEqual(GreaterThanOrEqualNode node, TransferInput<CFValue, CFStore> in) {
        TransferResult result2 = (TransferResult)super.visitGreaterThanOrEqual(node, in);
        IndexRefinementInfo rfi = new IndexRefinementInfo(result2, this.analysis, node);
        if (rfi.leftAnno == null || rfi.rightAnno == null) {
            return result2;
        }
        this.refineGTE(rfi.left, rfi.leftAnno, rfi.right, rfi.rightAnno, rfi.thenStore, in);
        this.refineGT(rfi.right, rfi.rightAnno, rfi.left, rfi.leftAnno, rfi.elseStore, in);
        return rfi.newResult;
    }

    @Override
    public TransferResult<CFValue, CFStore> visitLessThanOrEqual(LessThanOrEqualNode node, TransferInput<CFValue, CFStore> in) {
        TransferResult result2 = (TransferResult)super.visitLessThanOrEqual(node, in);
        IndexRefinementInfo rfi = new IndexRefinementInfo(result2, this.analysis, node);
        if (rfi.leftAnno == null || rfi.rightAnno == null) {
            return result2;
        }
        this.refineGTE(rfi.right, rfi.rightAnno, rfi.left, rfi.leftAnno, rfi.thenStore, in);
        this.refineGT(rfi.left, rfi.leftAnno, rfi.right, rfi.rightAnno, rfi.elseStore, in);
        return rfi.newResult;
    }

    @Override
    public TransferResult<CFValue, CFStore> visitLessThan(LessThanNode node, TransferInput<CFValue, CFStore> in) {
        TransferResult result2 = (TransferResult)super.visitLessThan(node, in);
        IndexRefinementInfo rfi = new IndexRefinementInfo(result2, this.analysis, node);
        if (rfi.leftAnno == null || rfi.rightAnno == null) {
            return result2;
        }
        this.refineGT(rfi.right, rfi.rightAnno, rfi.left, rfi.leftAnno, rfi.thenStore, in);
        this.refineGTE(rfi.left, rfi.leftAnno, rfi.right, rfi.rightAnno, rfi.elseStore, in);
        return rfi.newResult;
    }

    protected abstract void refineGT(Node var1, AnnotationMirror var2, Node var3, AnnotationMirror var4, CFStore var5, TransferInput<CFValue, CFStore> var6);

    protected abstract void refineGTE(Node var1, AnnotationMirror var2, Node var3, AnnotationMirror var4, CFStore var5, TransferInput<CFValue, CFStore> var6);
}

