/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.upperbound;

import java.util.AbstractList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.checkerframework.checker.index.inequality.LessThanChecker;
import org.checkerframework.checker.index.lowerbound.LowerBoundChecker;
import org.checkerframework.checker.index.samelen.SameLenChecker;
import org.checkerframework.checker.index.searchindex.SearchIndexChecker;
import org.checkerframework.checker.index.substringindex.SubstringIndexChecker;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.value.ValueChecker;
import org.checkerframework.framework.source.SuppressWarningsKeys;

@SuppressWarningsKeys(value={"index", "upperbound"})
public class UpperBoundChecker
extends BaseTypeChecker {
    private HashSet<String> collectionBaseTypeNames;

    public UpperBoundChecker() {
        Class[] collectionBaseClasses = new Class[]{List.class, AbstractList.class};
        this.collectionBaseTypeNames = new HashSet(collectionBaseClasses.length);
        for (Class collectionBaseClass : collectionBaseClasses) {
            this.collectionBaseTypeNames.add(collectionBaseClass.getName());
        }
    }

    @Override
    public boolean shouldSkipUses(String typeName) {
        if (this.collectionBaseTypeNames.contains(typeName)) {
            return true;
        }
        return super.shouldSkipUses(typeName);
    }

    @Override
    protected LinkedHashSet<Class<? extends BaseTypeChecker>> getImmediateSubcheckerClasses() {
        LinkedHashSet<Class<? extends BaseTypeChecker>> checkers = super.getImmediateSubcheckerClasses();
        checkers.add(SubstringIndexChecker.class);
        checkers.add(SearchIndexChecker.class);
        checkers.add(SameLenChecker.class);
        checkers.add(LowerBoundChecker.class);
        checkers.add(ValueChecker.class);
        checkers.add(LessThanChecker.class);
        return checkers;
    }
}

