/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.initialization;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import org.checkerframework.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.checker.initialization.InitializationAnnotatedTypeFactory;
import org.checkerframework.checker.initialization.InitializationStore;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.framework.flow.CFAbstractStore;
import org.checkerframework.framework.flow.CFAbstractValue;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.AnnotationFormatter;
import org.checkerframework.framework.util.DefaultAnnotationFormatter;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;

public class InitializationVisitor<Factory extends InitializationAnnotatedTypeFactory<Value, Store, ?, ?>, Value extends CFAbstractValue<Value>, Store extends InitializationStore<Value, Store>>
extends BaseTypeVisitor<Factory> {
    protected final AnnotationFormatter annoFormatter = new DefaultAnnotationFormatter();
    private static final @CompilerMessageKey String COMMITMENT_INVALID_CAST = "initialization.invalid.cast";
    private static final @CompilerMessageKey String COMMITMENT_FIELDS_UNINITIALIZED = "initialization.fields.uninitialized";
    private static final @CompilerMessageKey String COMMITMENT_INVALID_FIELD_TYPE = "initialization.invalid.field.type";
    private static final @CompilerMessageKey String COMMITMENT_INVALID_CONSTRUCTOR_RETURN_TYPE = "initialization.invalid.constructor.return.type";
    private static final @CompilerMessageKey String COMMITMENT_INVALID_FIELD_WRITE_UNCLASSIFIED = "initialization.invalid.field.write.unknown";
    private static final @CompilerMessageKey String COMMITMENT_INVALID_FIELD_WRITE_COMMITTED = "initialization.invalid.field.write.initialized";
    protected final List<VariableTree> initializedFields = new ArrayList<VariableTree>();

    public InitializationVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    @Override
    public void setRoot(CompilationUnitTree root) {
        this.initializedFields.clear();
        super.setRoot(root);
    }

    @Override
    protected boolean checkConstructorInvocation(AnnotatedTypeMirror.AnnotatedDeclaredType dt, AnnotatedTypeMirror.AnnotatedExecutableType constructor, NewClassTree src) {
        return true;
    }

    @Override
    protected void commonAssignmentCheck(Tree varTree, ExpressionTree valueExp, @CompilerMessageKey String errorKey) {
        if (TreeUtils.isFieldAccess(varTree)) {
            ExpressionTree lhs = (ExpressionTree)varTree;
            ExpressionTree y = valueExp;
            Element el = TreeUtils.elementFromUse(lhs);
            AnnotatedTypeMirror xType = ((InitializationAnnotatedTypeFactory)this.atypeFactory).getReceiverType(lhs);
            AnnotatedTypeMirror yType = ((InitializationAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(y);
            Set<AnnotationMirror> fieldAnnotations = ((InitializationAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(TreeUtils.elementFromUse(lhs)).getAnnotations();
            if (!(AnnotationUtils.containsSameIgnoringValues(fieldAnnotations, ((InitializationAnnotatedTypeFactory)this.atypeFactory).UNCLASSIFIED) || ElementUtils.isStatic(el) || ((InitializationAnnotatedTypeFactory)this.atypeFactory).isCommitted(yType) || ((InitializationAnnotatedTypeFactory)this.atypeFactory).isFree(xType) || ((InitializationAnnotatedTypeFactory)this.atypeFactory).isFbcBottom(yType))) {
                String err = ((InitializationAnnotatedTypeFactory)this.atypeFactory).isCommitted(xType) ? COMMITMENT_INVALID_FIELD_WRITE_COMMITTED : COMMITMENT_INVALID_FIELD_WRITE_UNCLASSIFIED;
                this.checker.report(Result.failure(err, varTree), varTree);
                return;
            }
        }
        super.commonAssignmentCheck(varTree, valueExp, errorKey);
    }

    @Override
    public Void visitVariable(VariableTree node, Void p) {
        if (TreeUtils.elementFromDeclaration(node).getKind().isField()) {
            Set<AnnotationMirror> annotationMirrors = ((InitializationAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node).getExplicitAnnotations();
            block0: for (Class<Annotation> c : ((InitializationAnnotatedTypeFactory)this.atypeFactory).getInitializationAnnotations()) {
                for (AnnotationMirror a : annotationMirrors) {
                    if (((InitializationAnnotatedTypeFactory)this.atypeFactory).isUnclassified(a) || !AnnotationUtils.areSameByClass(a, c)) continue;
                    this.checker.report(Result.failure(COMMITMENT_INVALID_FIELD_TYPE, node), node);
                    continue block0;
                }
            }
        }
        return super.visitVariable(node, p);
    }

    @Override
    protected boolean checkContract(FlowExpressions.Receiver expr, AnnotationMirror necessaryAnnotation, AnnotationMirror inferredAnnotation, CFAbstractStore<?, ?> store) {
        AnnotationMirror invariantAnno = ((InitializationAnnotatedTypeFactory)this.atypeFactory).getFieldInvariantAnnotation();
        if (!((InitializationAnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().isSubtype(invariantAnno, necessaryAnnotation) || !(expr instanceof FlowExpressions.FieldAccess)) {
            return super.checkContract(expr, necessaryAnnotation, inferredAnnotation, store);
        }
        FlowExpressions.FieldAccess fa = (FlowExpressions.FieldAccess)expr;
        if (fa.getReceiver() instanceof FlowExpressions.ThisReference || fa.getReceiver() instanceof FlowExpressions.ClassName) {
            AnnotatedTypeMirror fieldType;
            InitializationStore s2 = (InitializationStore)store;
            if (s2.isFieldInitialized(fa.getField()) && AnnotationUtils.containsSame((fieldType = ((InitializationAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(fa.getField())).getAnnotations(), invariantAnno)) {
                return true;
            }
        } else {
            Set<AnnotationMirror> recvAnnoSet;
            Object value = store.getValue(fa.getReceiver());
            if (value != null) {
                recvAnnoSet = ((CFAbstractValue)value).getAnnotations();
            } else if (fa.getReceiver() instanceof FlowExpressions.LocalVariable) {
                Element elem = ((FlowExpressions.LocalVariable)fa.getReceiver()).getElement();
                AnnotatedTypeMirror recvType = ((InitializationAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(elem);
                recvAnnoSet = recvType.getAnnotations();
            } else {
                return false;
            }
            boolean isRecvCommitted = false;
            for (AnnotationMirror anno : recvAnnoSet) {
                if (!((InitializationAnnotatedTypeFactory)this.atypeFactory).isCommitted(anno)) continue;
                isRecvCommitted = true;
            }
            AnnotatedTypeMirror fieldType = ((InitializationAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(fa.getField());
            if (isRecvCommitted && AnnotationUtils.containsSame(fieldType.getAnnotations(), invariantAnno)) {
                return true;
            }
        }
        return super.checkContract(expr, necessaryAnnotation, inferredAnnotation, store);
    }

    @Override
    public Void visitTypeCast(TypeCastTree node, Void p) {
        boolean isSubtype;
        AnnotatedTypeMirror exprType = ((InitializationAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node.getExpression());
        AnnotatedTypeMirror castType = ((InitializationAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node);
        AnnotationMirror exprAnno = null;
        AnnotationMirror castAnno = null;
        for (Class<Annotation> a : ((InitializationAnnotatedTypeFactory)this.atypeFactory).getInitializationAnnotations()) {
            if (castType.hasAnnotation(a)) {
                assert (castAnno == null);
                castAnno = castType.getAnnotation(a);
            }
            if (!exprType.hasAnnotation(a)) continue;
            assert (exprAnno == null);
            exprAnno = exprType.getAnnotation(a);
        }
        if (exprAnno == null || castAnno == null) {
            isSubtype = true;
        } else {
            assert (exprAnno != null && castAnno != null);
            isSubtype = ((InitializationAnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().isSubtype(exprAnno, castAnno);
        }
        if (!isSubtype) {
            this.checker.report(Result.failure(COMMITMENT_INVALID_CAST, this.annoFormatter.formatAnnotationMirror(exprAnno), this.annoFormatter.formatAnnotationMirror(castAnno)), node);
            return p;
        }
        return super.visitTypeCast(node, p);
    }

    @Override
    public void processClassTree(ClassTree node) {
        for (Tree tree : node.getMembers()) {
            if (tree.getKind() != Tree.Kind.BLOCK || ((BlockTree)tree).isStatic()) continue;
            BlockTree block = (BlockTree)tree;
            InitializationStore initializationStore = (InitializationStore)((InitializationAnnotatedTypeFactory)this.atypeFactory).getRegularExitStore(block);
            for (Pair t : initializationStore.getAnalysis().getFieldValues()) {
                initializationStore.addInitializedField((VariableElement)t.first);
            }
            List<VariableTree> init = ((InitializationAnnotatedTypeFactory)this.atypeFactory).getInitializedInvariantFields(initializationStore, this.getCurrentPath());
            this.initializedFields.addAll(init);
        }
        super.processClassTree(node);
        if (node.getKind() == Tree.Kind.CLASS) {
            boolean isStatic = true;
            InitializationStore initializationStore = (InitializationStore)((InitializationAnnotatedTypeFactory)this.atypeFactory).getRegularExitStore(node);
            for (Pair pair : initializationStore.getAnalysis().getFieldValues()) {
                initializationStore.addInitializedField((VariableElement)pair.first);
            }
            List receiverAnnotations = Collections.emptyList();
            this.checkFieldsInitialized(node, isStatic, initializationStore, receiverAnnotations);
        }
    }

    @Override
    public Void visitMethod(MethodTree node, Void p) {
        if (TreeUtils.isConstructor(node)) {
            Set<AnnotationMirror> returnTypeAnnotations = AnnotationUtils.getExplicitAnnotationsOnConstructorResult(node);
            block0: for (Class<Annotation> c : ((InitializationAnnotatedTypeFactory)this.atypeFactory).getInvalidConstructorReturnTypeAnnotations()) {
                for (AnnotationMirror a : returnTypeAnnotations) {
                    if (!AnnotationUtils.areSameByClass(a, c)) continue;
                    this.checker.report(Result.failure(COMMITMENT_INVALID_CONSTRUCTOR_RETURN_TYPE, node), node);
                    continue block0;
                }
            }
            boolean isStatic = false;
            InitializationStore store = (InitializationStore)((InitializationAnnotatedTypeFactory)this.atypeFactory).getRegularExitStore(node);
            List<AnnotationMirror> receiverAnnotations = this.getAllReceiverAnnotations(node);
            this.checkFieldsInitialized(node, isStatic, store, receiverAnnotations);
        }
        return super.visitMethod(node, p);
    }

    private List<? extends AnnotationMirror> getAllReceiverAnnotations(MethodTree node) {
        Symbol meth;
        List<Attribute.TypeCompound> rcvannos = null;
        if (TreeUtils.isConstructor(node) && (rcvannos = (meth = (Symbol)((Object)TreeUtils.elementFromDeclaration(node))).getRawTypeAttributes()) == null) {
            rcvannos = Collections.emptyList();
        }
        return rcvannos;
    }

    protected void checkFieldsInitialized(Tree blockNode, boolean staticFields, Store store, List<? extends AnnotationMirror> receiverAnnotations) {
        if (store == null) {
            return;
        }
        List<VariableTree> violatingFields = ((InitializationAnnotatedTypeFactory)this.atypeFactory).getUninitializedInvariantFields(store, this.getCurrentPath(), staticFields, receiverAnnotations);
        if (!staticFields) {
            violatingFields.removeAll(this.initializedFields);
        }
        Iterator<VariableTree> itor = violatingFields.iterator();
        while (itor.hasNext()) {
            VariableTree f = itor.next();
            Element e = TreeUtils.elementFromTree(f);
            if (!this.checker.shouldSuppressWarnings(e, COMMITMENT_FIELDS_UNINITIALIZED)) continue;
            itor.remove();
        }
        if (!violatingFields.isEmpty()) {
            StringBuilder fieldsString = new StringBuilder();
            boolean first2 = true;
            for (VariableTree f : violatingFields) {
                if (!first2) {
                    fieldsString.append(", ");
                }
                first2 = false;
                fieldsString.append(f.getName());
            }
            this.checker.report(Result.failure(COMMITMENT_FIELDS_UNINITIALIZED, fieldsString), blockNode);
        }
    }
}

