/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.lock;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import java.util.List;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.lock.LockAnalysis;
import org.checkerframework.checker.lock.LockAnnotatedTypeFactory;
import org.checkerframework.checker.lock.LockChecker;
import org.checkerframework.checker.lock.LockStore;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.UnderlyingAST;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.SynchronizedNode;
import org.checkerframework.framework.flow.CFAbstractTransfer;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.TreeUtils;

public class LockTransfer
extends CFAbstractTransfer<CFValue, LockStore, LockTransfer> {
    private final LockAnnotatedTypeFactory atypeFactory;

    public LockTransfer(LockAnalysis analysis, LockChecker checker) {
        super(analysis, true);
        this.atypeFactory = (LockAnnotatedTypeFactory)analysis.getTypeFactory();
    }

    protected void makeLockHeld(LockStore store, Node node) {
        FlowExpressions.Receiver internalRepr = FlowExpressions.internalReprOf((AnnotationProvider)this.atypeFactory, node);
        store.insertValue(internalRepr, this.atypeFactory.LOCKHELD);
    }

    protected void makeLockPossiblyHeld(LockStore store, Node node) {
        FlowExpressions.Receiver internalRepr = FlowExpressions.internalReprOf((AnnotationProvider)this.atypeFactory, node);
        store.insertLockPossiblyHeld(internalRepr);
    }

    protected void makeLockHeld(TransferResult<CFValue, LockStore> result2, Node node) {
        if (result2.containsTwoStores()) {
            this.makeLockHeld(result2.getThenStore(), node);
            this.makeLockHeld(result2.getElseStore(), node);
        } else {
            this.makeLockHeld(result2.getRegularStore(), node);
        }
    }

    protected void makeLockPossiblyHeld(TransferResult<CFValue, LockStore> result2, Node node) {
        if (result2.containsTwoStores()) {
            this.makeLockPossiblyHeld(result2.getThenStore(), node);
            this.makeLockPossiblyHeld(result2.getElseStore(), node);
        } else {
            this.makeLockPossiblyHeld(result2.getRegularStore(), node);
        }
    }

    @Override
    public LockStore initialStore(UnderlyingAST underlyingAST, List<LocalVariableNode> parameters) {
        LockStore store = (LockStore)super.initialStore(underlyingAST, (List)parameters);
        UnderlyingAST.Kind astKind = underlyingAST.getKind();
        if (astKind == UnderlyingAST.Kind.METHOD) {
            UnderlyingAST.CFGMethod method = (UnderlyingAST.CFGMethod)underlyingAST;
            MethodTree methodTree = method.getMethod();
            ExecutableElement methodElement = TreeUtils.elementFromDeclaration(methodTree);
            if (methodElement.getModifiers().contains((Object)Modifier.SYNCHRONIZED)) {
                ClassTree classTree = method.getClassTree();
                TypeMirror classType = TreeUtils.typeOf(classTree);
                if (methodElement.getModifiers().contains((Object)Modifier.STATIC)) {
                    store.insertValue((FlowExpressions.Receiver)new FlowExpressions.ClassName(classType), this.atypeFactory.LOCKHELD);
                } else {
                    store.insertThisValue(this.atypeFactory.LOCKHELD, classType);
                }
            } else if (methodElement.getKind() == ElementKind.CONSTRUCTOR) {
                store.setInConstructorOrInitializer();
            }
        } else if (astKind == UnderlyingAST.Kind.ARBITRARY_CODE) {
            store.setInConstructorOrInitializer();
        }
        return store;
    }

    @Override
    public TransferResult<CFValue, LockStore> visitSynchronized(SynchronizedNode n, TransferInput<CFValue, LockStore> p) {
        TransferResult result2 = (TransferResult)super.visitSynchronized(n, p);
        if (n.getIsStartOfBlock()) {
            this.makeLockHeld(result2, n.getExpression());
        } else {
            this.makeLockPossiblyHeld(result2, n.getExpression());
        }
        return result2;
    }
}

