/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.nullness;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.KeyForAnalysis;
import org.checkerframework.checker.nullness.KeyForPropagationTreeAnnotator;
import org.checkerframework.checker.nullness.KeyForPropagator;
import org.checkerframework.checker.nullness.KeyForStore;
import org.checkerframework.checker.nullness.KeyForTransfer;
import org.checkerframework.checker.nullness.KeyForValue;
import org.checkerframework.checker.nullness.compatqual.KeyForDecl;
import org.checkerframework.checker.nullness.compatqual.KeyForType;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.PolyKeyFor;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.framework.qual.PolyAll;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.DefaultTypeHierarchy;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.TypeHierarchy;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.util.GraphQualifierHierarchy;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TypesUtils;

public class KeyForAnnotatedTypeFactory
extends GenericAnnotatedTypeFactory<KeyForValue, KeyForStore, KeyForTransfer, KeyForAnalysis> {
    protected final AnnotationMirror UNKNOWNKEYFOR;
    protected final AnnotationMirror KEYFOR;
    protected final AnnotationMirror KEYFORBOTTOM;
    private final KeyForPropagator keyForPropagator;
    private final TypeMirror erasedMapType;

    public KeyForAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker, true);
        this.KEYFOR = AnnotationBuilder.fromClass(this.elements, KeyFor.class);
        this.UNKNOWNKEYFOR = AnnotationBuilder.fromClass(this.elements, UnknownKeyFor.class);
        this.KEYFORBOTTOM = AnnotationBuilder.fromClass(this.elements, KeyForBottom.class);
        this.keyForPropagator = new KeyForPropagator(this.UNKNOWNKEYFOR);
        this.addAliasedAnnotation(KeyForDecl.class, this.KEYFOR);
        this.addAliasedAnnotation(KeyForType.class, this.KEYFOR);
        TypeMirror mapType = TypesUtils.typeFromClass(Map.class, this.types, this.elements);
        this.erasedMapType = this.types.erasure(mapType);
        this.postInit();
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return new LinkedHashSet<Class<? extends Annotation>>(Arrays.asList(KeyFor.class, UnknownKeyFor.class, KeyForBottom.class, PolyKeyFor.class, PolyAll.class));
    }

    @Override
    public Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> constructorFromUse(NewClassTree tree) {
        Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> result2 = super.constructorFromUse(tree);
        this.keyForPropagator.propagateNewClassTree(tree, ((AnnotatedTypeMirror.AnnotatedExecutableType)result2.first).getReturnType(), this);
        return result2;
    }

    @Override
    protected TypeHierarchy createTypeHierarchy() {
        return new KeyForTypeHierarchy(this.checker, this.getQualifierHierarchy(), this.checker.getBooleanOption("ignoreRawTypeArguments", true), this.checker.hasOption("invariantArrays"));
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(super.createTreeAnnotator(), new KeyForPropagationTreeAnnotator(this, this.keyForPropagator));
    }

    public AnnotationMirror createKeyForAnnotationMirrorWithValue(LinkedHashSet<String> values2) {
        AnnotationBuilder builder = new AnnotationBuilder(this.getProcessingEnv(), KeyFor.class);
        builder.setValue((CharSequence)"value", values2.toArray());
        return builder.build();
    }

    public AnnotationMirror createKeyForAnnotationMirrorWithValue(String value) {
        LinkedHashSet<String> values2 = new LinkedHashSet<String>();
        values2.add(value);
        return this.createKeyForAnnotationMirrorWithValue(values2);
    }

    public boolean isKeyForMap(String mapExpression, ExpressionTree tree) {
        Collection<String> maps = null;
        AnnotatedTypeMirror type = this.getAnnotatedType(tree);
        AnnotationMirror keyForAnno = type.getAnnotation(KeyFor.class);
        if (keyForAnno != null) {
            maps = AnnotationUtils.getElementValueArray(keyForAnno, "value", String.class, false);
        } else {
            KeyForValue value = (KeyForValue)this.getInferredValueFor(tree);
            if (value != null) {
                maps = value.getKeyForMaps();
            }
        }
        return maps != null && maps.contains(mapExpression);
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new KeyForQualifierHierarchy(factory);
    }

    protected boolean isInvocationOfMapMethod(MethodInvocationNode n, String methodName) {
        TypeMirror receiverType;
        String invokedMethod = this.getMethodName(n);
        return invokedMethod.equals(methodName) && this.types.isSubtype(receiverType = this.types.erasure(n.getTarget().getReceiver().getType()), this.erasedMapType);
    }

    protected String getMethodName(MethodInvocationNode n) {
        String invokedMethod = n.getTarget().getMethod().toString();
        int index = invokedMethod.indexOf("(");
        assert (index != -1) : this.getClass() + ": expected method name to contain (";
        invokedMethod = invokedMethod.substring(0, index);
        return invokedMethod;
    }

    private final class KeyForQualifierHierarchy
    extends GraphQualifierHierarchy {
        public KeyForQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
            super(factory, KeyForAnnotatedTypeFactory.this.KEYFORBOTTOM);
        }

        private List<String> extractValues(AnnotationMirror anno) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> valMap = anno.getElementValues();
            List<String> res = valMap.isEmpty() ? new ArrayList<String>() : AnnotationUtils.getElementValueArray(anno, "value", String.class, true);
            return res;
        }

        @Override
        public boolean isSubtype(AnnotationMirror subAnno, AnnotationMirror superAnno) {
            if (AnnotationUtils.areSameIgnoringValues(superAnno, KeyForAnnotatedTypeFactory.this.KEYFOR) && AnnotationUtils.areSameIgnoringValues(subAnno, KeyForAnnotatedTypeFactory.this.KEYFOR)) {
                List<String> lhsValues = this.extractValues(superAnno);
                List<String> rhsValues = this.extractValues(subAnno);
                return rhsValues.containsAll(lhsValues);
            }
            if (AnnotationUtils.areSameIgnoringValues(superAnno, KeyForAnnotatedTypeFactory.this.KEYFOR)) {
                superAnno = KeyForAnnotatedTypeFactory.this.KEYFOR;
            }
            if (AnnotationUtils.areSameIgnoringValues(subAnno, KeyForAnnotatedTypeFactory.this.KEYFOR)) {
                subAnno = KeyForAnnotatedTypeFactory.this.KEYFOR;
            }
            return super.isSubtype(subAnno, superAnno);
        }
    }

    protected static class KeyForTypeHierarchy
    extends DefaultTypeHierarchy {
        public KeyForTypeHierarchy(BaseTypeChecker checker, QualifierHierarchy qualifierHierarchy, boolean ignoreRawTypes, boolean invariantArrayComponents) {
            super(checker, qualifierHierarchy, ignoreRawTypes, invariantArrayComponents);
        }

        @Override
        protected boolean isSubtype(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype, AnnotationMirror top) {
            if (supertype.getKind() == TypeKind.TYPEVAR && subtype.getKind() == TypeKind.TYPEVAR && supertype.getAnnotations().isEmpty()) {
                return true;
            }
            if (subtype.hasAnnotation(KeyForBottom.class)) {
                return true;
            }
            return super.isSubtype(subtype, supertype, top);
        }
    }
}

