/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.com.github.javaparser.ast.body;

import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Consumer;
import org.checkerframework.com.github.javaparser.TokenRange;
import org.checkerframework.com.github.javaparser.ast.AllFieldsConstructor;
import org.checkerframework.com.github.javaparser.ast.Modifier;
import org.checkerframework.com.github.javaparser.ast.Node;
import org.checkerframework.com.github.javaparser.ast.NodeList;
import org.checkerframework.com.github.javaparser.ast.body.BodyDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.EnumDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.MethodDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.Parameter;
import org.checkerframework.com.github.javaparser.ast.body.VariableDeclarator;
import org.checkerframework.com.github.javaparser.ast.expr.AnnotationExpr;
import org.checkerframework.com.github.javaparser.ast.expr.AssignExpr;
import org.checkerframework.com.github.javaparser.ast.expr.NameExpr;
import org.checkerframework.com.github.javaparser.ast.nodeTypes.NodeWithJavadoc;
import org.checkerframework.com.github.javaparser.ast.nodeTypes.NodeWithVariables;
import org.checkerframework.com.github.javaparser.ast.nodeTypes.modifiers.NodeWithAccessModifiers;
import org.checkerframework.com.github.javaparser.ast.nodeTypes.modifiers.NodeWithFinalModifier;
import org.checkerframework.com.github.javaparser.ast.nodeTypes.modifiers.NodeWithStaticModifier;
import org.checkerframework.com.github.javaparser.ast.observer.ObservableProperty;
import org.checkerframework.com.github.javaparser.ast.stmt.BlockStmt;
import org.checkerframework.com.github.javaparser.ast.stmt.ReturnStmt;
import org.checkerframework.com.github.javaparser.ast.type.Type;
import org.checkerframework.com.github.javaparser.ast.type.VoidType;
import org.checkerframework.com.github.javaparser.ast.visitor.CloneVisitor;
import org.checkerframework.com.github.javaparser.ast.visitor.GenericVisitor;
import org.checkerframework.com.github.javaparser.ast.visitor.VoidVisitor;
import org.checkerframework.com.github.javaparser.metamodel.FieldDeclarationMetaModel;
import org.checkerframework.com.github.javaparser.metamodel.JavaParserMetaModel;
import org.checkerframework.com.github.javaparser.metamodel.NonEmptyProperty;
import org.checkerframework.com.github.javaparser.resolution.Resolvable;
import org.checkerframework.com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import org.checkerframework.com.github.javaparser.utils.Utils;

public final class FieldDeclaration
extends BodyDeclaration<FieldDeclaration>
implements NodeWithJavadoc<FieldDeclaration>,
NodeWithVariables<FieldDeclaration>,
NodeWithAccessModifiers<FieldDeclaration>,
NodeWithStaticModifier<FieldDeclaration>,
NodeWithFinalModifier<FieldDeclaration>,
Resolvable<ResolvedFieldDeclaration> {
    private EnumSet<Modifier> modifiers;
    @NonEmptyProperty
    private NodeList<VariableDeclarator> variables;

    public FieldDeclaration() {
        this(null, EnumSet.noneOf(Modifier.class), new NodeList<AnnotationExpr>(), new NodeList<VariableDeclarator>());
    }

    public FieldDeclaration(EnumSet<Modifier> modifiers, VariableDeclarator variable) {
        this(null, modifiers, new NodeList<AnnotationExpr>(), NodeList.nodeList((Node[])new VariableDeclarator[]{variable}));
    }

    public FieldDeclaration(EnumSet<Modifier> modifiers, NodeList<VariableDeclarator> variables) {
        this(null, modifiers, new NodeList<AnnotationExpr>(), variables);
    }

    @AllFieldsConstructor
    public FieldDeclaration(EnumSet<Modifier> modifiers, NodeList<AnnotationExpr> annotations, NodeList<VariableDeclarator> variables) {
        this(null, modifiers, annotations, variables);
    }

    public FieldDeclaration(TokenRange tokenRange, EnumSet<Modifier> modifiers, NodeList<AnnotationExpr> annotations, NodeList<VariableDeclarator> variables) {
        super(tokenRange, annotations);
        this.setModifiers((EnumSet)modifiers);
        this.setVariables((NodeList)variables);
        this.customInitialization();
    }

    public FieldDeclaration(EnumSet<Modifier> modifiers, Type type, String name) {
        this(Utils.assertNotNull(modifiers), new VariableDeclarator(type, Utils.assertNotNull(name)));
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public EnumSet<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public NodeList<VariableDeclarator> getVariables() {
        return this.variables;
    }

    @Override
    public FieldDeclaration setModifiers(EnumSet<Modifier> modifiers) {
        Utils.assertNotNull(modifiers);
        if (modifiers == this.modifiers) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.MODIFIERS, this.modifiers, modifiers);
        this.modifiers = modifiers;
        return this;
    }

    @Override
    public FieldDeclaration setVariables(NodeList<VariableDeclarator> variables) {
        Utils.assertNotNull(variables);
        if (variables == this.variables) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.VARIABLES, this.variables, variables);
        if (this.variables != null) {
            this.variables.setParentNode(null);
        }
        this.variables = variables;
        this.setAsParentNodeOf(variables);
        return this;
    }

    public MethodDeclaration createGetter() {
        if (this.getVariables().size() != 1) {
            throw new IllegalStateException("You can use this only when the field declares only 1 variable name");
        }
        Optional<ClassOrInterfaceDeclaration> parentClass = this.getAncestorOfType(ClassOrInterfaceDeclaration.class);
        Optional<EnumDeclaration> parentEnum = this.getAncestorOfType(EnumDeclaration.class);
        if (!parentClass.isPresent() && !parentEnum.isPresent() || parentClass.isPresent() && parentClass.get().isInterface()) {
            throw new IllegalStateException("You can use this only when the field is attached to a class or an enum");
        }
        VariableDeclarator variable = this.getVariable(0);
        String fieldName = variable.getNameAsString();
        String fieldNameUpper = fieldName.toUpperCase().substring(0, 1) + fieldName.substring(1, fieldName.length());
        MethodDeclaration getter2 = parentClass.map(clazz -> clazz.addMethod("get" + fieldNameUpper, Modifier.PUBLIC)).orElseGet(() -> ((EnumDeclaration)parentEnum.get()).addMethod("get" + fieldNameUpper, Modifier.PUBLIC));
        getter2.setType(variable.getType());
        BlockStmt blockStmt = new BlockStmt();
        getter2.setBody(blockStmt);
        blockStmt.addStatement(new ReturnStmt(fieldName));
        return getter2;
    }

    public MethodDeclaration createSetter() {
        if (this.getVariables().size() != 1) {
            throw new IllegalStateException("You can use this only when the field declares only 1 variable name");
        }
        Optional<ClassOrInterfaceDeclaration> parentClass = this.getAncestorOfType(ClassOrInterfaceDeclaration.class);
        Optional<EnumDeclaration> parentEnum = this.getAncestorOfType(EnumDeclaration.class);
        if (!parentClass.isPresent() && !parentEnum.isPresent() || parentClass.isPresent() && parentClass.get().isInterface()) {
            throw new IllegalStateException("You can use this only when the field is attached to a class or an enum");
        }
        VariableDeclarator variable = this.getVariable(0);
        String fieldName = variable.getNameAsString();
        String fieldNameUpper = fieldName.toUpperCase().substring(0, 1) + fieldName.substring(1, fieldName.length());
        MethodDeclaration setter2 = parentClass.map(clazz -> clazz.addMethod("set" + fieldNameUpper, Modifier.PUBLIC)).orElseGet(() -> ((EnumDeclaration)parentEnum.get()).addMethod("set" + fieldNameUpper, Modifier.PUBLIC));
        setter2.setType(new VoidType());
        setter2.getParameters().add(new Parameter(variable.getType(), fieldName));
        BlockStmt blockStmt2 = new BlockStmt();
        setter2.setBody(blockStmt2);
        blockStmt2.addStatement(new AssignExpr(new NameExpr("this." + fieldName), new NameExpr(fieldName), AssignExpr.Operator.ASSIGN));
        return setter2;
    }

    public boolean isTransient() {
        return this.getModifiers().contains((Object)Modifier.TRANSIENT);
    }

    public boolean isVolatile() {
        return this.getModifiers().contains((Object)Modifier.VOLATILE);
    }

    public FieldDeclaration setTransient(boolean set2) {
        return (FieldDeclaration)this.setModifier(Modifier.TRANSIENT, set2);
    }

    public FieldDeclaration setVolatile(boolean set2) {
        return (FieldDeclaration)this.setModifier(Modifier.VOLATILE, set2);
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < this.variables.size(); ++i) {
            if (this.variables.get(i) != node) continue;
            this.variables.remove(i);
            return true;
        }
        return super.remove(node);
    }

    @Override
    public FieldDeclaration clone() {
        return (FieldDeclaration)this.accept(new CloneVisitor(), null);
    }

    @Override
    public FieldDeclarationMetaModel getMetaModel() {
        return JavaParserMetaModel.fieldDeclarationMetaModel;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < this.variables.size(); ++i) {
            if (this.variables.get(i) != node) continue;
            this.variables.set(i, (VariableDeclarator)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public boolean isFieldDeclaration() {
        return true;
    }

    @Override
    public FieldDeclaration asFieldDeclaration() {
        return this;
    }

    @Override
    public void ifFieldDeclaration(Consumer<FieldDeclaration> action) {
        action.accept(this);
    }

    @Override
    public ResolvedFieldDeclaration resolve() {
        return this.getSymbolResolver().resolveDeclaration(this, ResolvedFieldDeclaration.class);
    }

    @Override
    public Optional<FieldDeclaration> toFieldDeclaration() {
        return Optional.of(this);
    }
}

