/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.com.google.common.escape;

import java.util.Collections;
import java.util.Map;
import org.checkerframework.com.google.common.annotations.Beta;
import org.checkerframework.com.google.common.annotations.GwtCompatible;
import org.checkerframework.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.com.google.common.base.Preconditions;

@Beta
@GwtCompatible
public final class ArrayBasedEscaperMap {
    private final char[][] replacementArray;
    private static final char[][] EMPTY_REPLACEMENT_ARRAY = new char[0][0];

    public static ArrayBasedEscaperMap create(Map<Character, String> replacements) {
        return new ArrayBasedEscaperMap(ArrayBasedEscaperMap.createReplacementArray(replacements));
    }

    private ArrayBasedEscaperMap(char[][] replacementArray) {
        this.replacementArray = replacementArray;
    }

    char[][] getReplacementArray() {
        return this.replacementArray;
    }

    @VisibleForTesting
    static char[][] createReplacementArray(Map<Character, String> map2) {
        Preconditions.checkNotNull(map2);
        if (map2.isEmpty()) {
            return EMPTY_REPLACEMENT_ARRAY;
        }
        char max = Collections.max(map2.keySet()).charValue();
        char[][] replacements = new char[max + '\u0001'][];
        for (char c : map2.keySet()) {
            replacements[c] = map2.get(Character.valueOf(c)).toCharArray();
        }
        return replacements;
    }
}

