/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.Collections;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Types;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.util.HashCodeUtils;

public class SynchronizedNode
extends Node {
    protected final @Nullable Tree tree;
    protected final Node expression;
    protected final boolean startOfBlock;

    public SynchronizedNode(@Nullable Tree tree, Node expression, boolean startOfBlock, Types types) {
        super(types.getNoType(TypeKind.NONE));
        this.tree = tree;
        this.expression = expression;
        this.startOfBlock = startOfBlock;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    public Node getExpression() {
        return this.expression;
    }

    public boolean getIsStartOfBlock() {
        return this.startOfBlock;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitSynchronized(this, p);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("synchronized (");
        sb.append(this.expression);
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SynchronizedNode)) {
            return false;
        }
        SynchronizedNode other = (SynchronizedNode)obj;
        if (this.tree == null && other.getTree() != null) {
            return false;
        }
        return this.getTree().equals(other.getTree()) && this.getExpression().equals(other.getExpression()) && this.startOfBlock == other.startOfBlock;
    }

    public int hashCode() {
        int hash2 = 0;
        if (this.tree != null) {
            hash2 = HashCodeUtils.hash((Object)this.tree);
        }
        hash2 = HashCodeUtils.hash(this.startOfBlock);
        return HashCodeUtils.hash(hash2, (Object)this.getExpression());
    }

    @Override
    public Collection<Node> getOperands() {
        return Collections.emptyList();
    }
}

