/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.element.ClassTypeParamApplier;
import org.checkerframework.framework.util.element.MethodApplier;
import org.checkerframework.framework.util.element.MethodTypeParamApplier;
import org.checkerframework.framework.util.element.ParamApplier;
import org.checkerframework.framework.util.element.SuperTypeApplier;
import org.checkerframework.framework.util.element.TypeDeclarationApplier;
import org.checkerframework.framework.util.element.TypeVarUseApplier;
import org.checkerframework.framework.util.element.VariableApplier;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.Pair;

public class ElementAnnotationApplier {
    public static void apply(AnnotatedTypeMirror type, Element element, AnnotatedTypeFactory typeFactory) {
        if (element == null) {
            ErrorReporter.errorAbort("ElementAnnotationUtil.apply: element cannot be null");
        } else if (TypeVarUseApplier.accepts(type, element)) {
            TypeVarUseApplier.apply(type, element, typeFactory);
        } else if (VariableApplier.accepts(type, element)) {
            VariableApplier.apply(type, element);
        } else if (MethodApplier.accepts(type, element)) {
            MethodApplier.apply(type, element, typeFactory);
        } else if (TypeDeclarationApplier.accepts(type, element)) {
            TypeDeclarationApplier.apply(type, element, typeFactory);
        } else if (ClassTypeParamApplier.accepts(type, element)) {
            ClassTypeParamApplier.apply((AnnotatedTypeMirror.AnnotatedTypeVariable)type, element, typeFactory);
        } else if (MethodTypeParamApplier.accepts(type, element)) {
            MethodTypeParamApplier.apply((AnnotatedTypeMirror.AnnotatedTypeVariable)type, element, typeFactory);
        } else if (ParamApplier.accepts(type, element)) {
            ParamApplier.apply(type, element, typeFactory);
        } else if (!ElementAnnotationApplier.isCaptureConvertedTypeVar(element)) {
            ErrorReporter.errorAbort("ElementAnnotationUtil.apply: illegal argument: " + element + " [" + (Object)((Object)element.getKind()) + "] with type " + type);
        }
    }

    public static void annotateSupers(List<AnnotatedTypeMirror.AnnotatedDeclaredType> supertypes, TypeElement subtypeElement) {
        SuperTypeApplier.annotateSupers(supertypes, subtypeElement);
    }

    public static Pair<VariableTree, LambdaExpressionTree> getParamAndLambdaTree(VariableElement varEle, AnnotatedTypeFactory typeFactory) {
        Tree parentTree;
        VariableTree paramDecl = (VariableTree)typeFactory.declarationFromElement(varEle);
        if (paramDecl != null && (parentTree = typeFactory.getPath(paramDecl).getParentPath().getLeaf()) != null && parentTree.getKind() == Tree.Kind.LAMBDA_EXPRESSION) {
            return Pair.of(paramDecl, (LambdaExpressionTree)parentTree);
        }
        return null;
    }

    private static boolean isCaptureConvertedTypeVar(Element element) {
        Element enclosure = element.getEnclosingElement();
        return ((Symbol)enclosure).kind == false;
    }
}

