/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.ElementFilter;
import org.checkerframework.framework.qual.ConditionalPostconditionAnnotation;
import org.checkerframework.framework.qual.EnsuresQualifier;
import org.checkerframework.framework.qual.EnsuresQualifierIf;
import org.checkerframework.framework.qual.EnsuresQualifiers;
import org.checkerframework.framework.qual.EnsuresQualifiersIf;
import org.checkerframework.framework.qual.PostconditionAnnotation;
import org.checkerframework.framework.qual.PreconditionAnnotation;
import org.checkerframework.framework.qual.QualifierArgument;
import org.checkerframework.framework.qual.RequiresQualifier;
import org.checkerframework.framework.qual.RequiresQualifiers;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.Pair;

public class ContractsUtils {
    protected static ContractsUtils instance;
    protected GenericAnnotatedTypeFactory<?, ?, ?, ?> factory;

    public static ContractsUtils getInstance(GenericAnnotatedTypeFactory<?, ?, ?, ?> factory) {
        if (instance == null || ContractsUtils.instance.factory != factory) {
            instance = new ContractsUtils(factory);
        }
        return instance;
    }

    public List<Contract> getContracts(ExecutableElement element) {
        ArrayList<Contract> contracts = new ArrayList<Contract>();
        contracts.addAll(this.getPreconditions(element));
        contracts.addAll(this.getPostconditions(element));
        contracts.addAll(this.getConditionalPostconditions(element));
        return contracts;
    }

    public Set<Precondition> getPreconditions(Element element) {
        LinkedHashSet<Precondition> result2 = new LinkedHashSet<Precondition>();
        AnnotationMirror requiresAnnotation = this.factory.getDeclAnnotation(element, RequiresQualifier.class);
        result2.addAll(this.getPrecondition(requiresAnnotation));
        AnnotationMirror requiresAnnotations = this.factory.getDeclAnnotation(element, RequiresQualifiers.class);
        if (requiresAnnotations != null) {
            List<AnnotationMirror> annotations = AnnotationUtils.getElementValueArray(requiresAnnotations, "value", AnnotationMirror.class, false);
            for (AnnotationMirror a : annotations) {
                result2.addAll(this.getPrecondition(a));
            }
        }
        Class<PreconditionAnnotation> metaAnnotation = PreconditionAnnotation.class;
        List<Pair<AnnotationMirror, AnnotationMirror>> declAnnotations = this.factory.getDeclAnnotationWithMetaAnnotation(element, metaAnnotation);
        for (Pair<AnnotationMirror, AnnotationMirror> r : declAnnotations) {
            AnnotationMirror anno = (AnnotationMirror)r.first;
            AnnotationMirror metaAnno = (AnnotationMirror)r.second;
            List<String> expressions = AnnotationUtils.getElementValueArray(anno, "value", String.class, false);
            AnnotationMirror precondtionAnno = this.getAnnotationMirrorOfMetaAnnotation(metaAnno, anno);
            if (precondtionAnno == null) continue;
            for (String expr : expressions) {
                result2.add(new Precondition(expr, precondtionAnno));
            }
        }
        return result2;
    }

    private AnnotationMirror getAnnotationMirrorOfQualifier(AnnotationMirror qualifierAnno, AnnotationMirror argumentAnno, Map<String, String> argumentRenaming) {
        AnnotationMirror anno;
        Class<?> c = AnnotationUtils.getElementValueClass(qualifierAnno, "qualifier", false);
        if (argumentAnno == null || argumentRenaming.isEmpty()) {
            anno = AnnotationBuilder.fromClass(this.factory.getElementUtils(), c);
        } else {
            AnnotationBuilder builder = new AnnotationBuilder(this.factory.getProcessingEnv(), c);
            builder.copyRenameElementValuesFromAnnotation(argumentAnno, argumentRenaming);
            anno = builder.build();
        }
        if (this.factory.isSupportedQualifier(anno)) {
            return anno;
        }
        AnnotationMirror aliasedAnno = this.factory.aliasedAnnotation(anno);
        if (this.factory.isSupportedQualifier(aliasedAnno)) {
            return aliasedAnno;
        }
        return null;
    }

    private AnnotationMirror getAnnotationMirrorOfContractAnnotation(AnnotationMirror contractAnno) {
        return this.getAnnotationMirrorOfQualifier(contractAnno, null, null);
    }

    private Map<String, String> makeArgumentMap(Element contractAnnoElement) {
        HashMap<String, String> argumentMap = new HashMap<String, String>();
        for (ExecutableElement meth : ElementFilter.methodsIn(contractAnnoElement.getEnclosedElements())) {
            AnnotationMirror argumentAnnotation = this.factory.getDeclAnnotationNoAliases(meth, QualifierArgument.class);
            if (argumentAnnotation == null) continue;
            String sourceName = meth.getSimpleName().toString();
            String targetName = AnnotationUtils.getElementValue(argumentAnnotation, "value", String.class, false);
            if (targetName == null || targetName.isEmpty()) {
                targetName = sourceName;
            }
            argumentMap.put(sourceName, targetName);
        }
        return argumentMap;
    }

    private AnnotationMirror getAnnotationMirrorOfMetaAnnotation(AnnotationMirror metaAnno, AnnotationMirror argumentAnno) {
        Map<String, String> argumentMap = this.makeArgumentMap(argumentAnno.getAnnotationType().asElement());
        return this.getAnnotationMirrorOfQualifier(metaAnno, argumentAnno, argumentMap);
    }

    private Set<Precondition> getPrecondition(AnnotationMirror requiresAnnotation) {
        if (requiresAnnotation == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<Precondition> result2 = new LinkedHashSet<Precondition>();
        List<String> expressions = AnnotationUtils.getElementValueArray(requiresAnnotation, "expression", String.class, false);
        AnnotationMirror postcondAnno = this.getAnnotationMirrorOfContractAnnotation(requiresAnnotation);
        if (postcondAnno == null) {
            return result2;
        }
        for (String expr : expressions) {
            result2.add(new Precondition(expr, postcondAnno));
        }
        return result2;
    }

    public Set<Postcondition> getPostconditions(ExecutableElement methodElement) {
        LinkedHashSet<Postcondition> result2 = new LinkedHashSet<Postcondition>();
        AnnotationMirror ensuresAnnotation = this.factory.getDeclAnnotation(methodElement, EnsuresQualifier.class);
        result2.addAll(this.getPostcondition(ensuresAnnotation));
        AnnotationMirror ensuresAnnotations = this.factory.getDeclAnnotation(methodElement, EnsuresQualifiers.class);
        if (ensuresAnnotations != null) {
            List<AnnotationMirror> annotations = AnnotationUtils.getElementValueArray(ensuresAnnotations, "value", AnnotationMirror.class, false);
            for (AnnotationMirror a : annotations) {
                result2.addAll(this.getPostcondition(a));
            }
        }
        Class<PostconditionAnnotation> metaAnnotation = PostconditionAnnotation.class;
        List<Pair<AnnotationMirror, AnnotationMirror>> declAnnotations = this.factory.getDeclAnnotationWithMetaAnnotation(methodElement, metaAnnotation);
        for (Pair<AnnotationMirror, AnnotationMirror> r : declAnnotations) {
            AnnotationMirror anno = (AnnotationMirror)r.first;
            AnnotationMirror metaAnno = (AnnotationMirror)r.second;
            List<String> expressions = AnnotationUtils.getElementValueArray(anno, "value", String.class, false);
            AnnotationMirror postcondAnno = this.getAnnotationMirrorOfMetaAnnotation(metaAnno, anno);
            if (postcondAnno == null) continue;
            for (String expr : expressions) {
                result2.add(new Postcondition(expr, postcondAnno));
            }
        }
        return result2;
    }

    private Set<Postcondition> getPostcondition(AnnotationMirror ensuresAnnotation) {
        if (ensuresAnnotation == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<Postcondition> result2 = new LinkedHashSet<Postcondition>();
        List<String> expressions = AnnotationUtils.getElementValueArray(ensuresAnnotation, "expression", String.class, false);
        AnnotationMirror postcondAnno = this.getAnnotationMirrorOfContractAnnotation(ensuresAnnotation);
        if (postcondAnno == null) {
            return result2;
        }
        for (String expr : expressions) {
            result2.add(new Postcondition(expr, postcondAnno));
        }
        return result2;
    }

    public Set<ConditionalPostcondition> getConditionalPostconditions(ExecutableElement methodElement) {
        LinkedHashSet<ConditionalPostcondition> result2 = new LinkedHashSet<ConditionalPostcondition>();
        AnnotationMirror ensuresQualifierIf = this.factory.getDeclAnnotation(methodElement, EnsuresQualifierIf.class);
        result2.addAll(this.getConditionalPostcondition(ensuresQualifierIf));
        AnnotationMirror ensuresAnnotationsIf = this.factory.getDeclAnnotation(methodElement, EnsuresQualifiersIf.class);
        if (ensuresAnnotationsIf != null) {
            List<AnnotationMirror> annotations = AnnotationUtils.getElementValueArray(ensuresAnnotationsIf, "value", AnnotationMirror.class, false);
            for (AnnotationMirror a : annotations) {
                result2.addAll(this.getConditionalPostcondition(a));
            }
        }
        Class<ConditionalPostconditionAnnotation> metaAnnotation = ConditionalPostconditionAnnotation.class;
        List<Pair<AnnotationMirror, AnnotationMirror>> declAnnotations = this.factory.getDeclAnnotationWithMetaAnnotation(methodElement, metaAnnotation);
        for (Pair<AnnotationMirror, AnnotationMirror> r : declAnnotations) {
            AnnotationMirror anno = (AnnotationMirror)r.first;
            AnnotationMirror metaAnno = (AnnotationMirror)r.second;
            List<String> expressions = AnnotationUtils.getElementValueArray(anno, "expression", String.class, false);
            AnnotationMirror postcondAnno = this.getAnnotationMirrorOfMetaAnnotation(metaAnno, anno);
            if (postcondAnno == null) continue;
            boolean annoResult = AnnotationUtils.getElementValue(anno, "result", Boolean.class, false);
            for (String expr : expressions) {
                result2.add(new ConditionalPostcondition(expr, annoResult, postcondAnno));
            }
        }
        return result2;
    }

    private Set<ConditionalPostcondition> getConditionalPostcondition(AnnotationMirror ensuresQualifierIf) {
        if (ensuresQualifierIf == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<ConditionalPostcondition> result2 = new LinkedHashSet<ConditionalPostcondition>();
        List<String> expressions = AnnotationUtils.getElementValueArray(ensuresQualifierIf, "expression", String.class, false);
        AnnotationMirror postcondAnno = this.getAnnotationMirrorOfContractAnnotation(ensuresQualifierIf);
        if (postcondAnno == null) {
            return result2;
        }
        boolean annoResult = AnnotationUtils.getElementValue(ensuresQualifierIf, "result", Boolean.class, false);
        for (String expr : expressions) {
            result2.add(new ConditionalPostcondition(expr, annoResult, postcondAnno));
        }
        return result2;
    }

    private ContractsUtils(GenericAnnotatedTypeFactory<?, ?, ?, ?> factory) {
        this.factory = factory;
    }

    public static class ConditionalPostcondition
    extends Contract {
        public final boolean annoResult;

        public ConditionalPostcondition(String expression, boolean annoResult, AnnotationMirror annotation) {
            super(expression, annotation, Contract.Kind.CONDITIONALPOSTCONDTION);
            this.annoResult = annoResult;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ConditionalPostcondition that = (ConditionalPostcondition)o;
            return this.annoResult == that.annoResult;
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + (this.annoResult ? 1 : 0);
            return result2;
        }
    }

    public static class Postcondition
    extends Contract {
        public Postcondition(String expression, AnnotationMirror annotation) {
            super(expression, annotation, Contract.Kind.POSTCONDTION);
        }
    }

    public static class Precondition
    extends Contract {
        public Precondition(String expression, AnnotationMirror annotation) {
            super(expression, annotation, Contract.Kind.PRECONDITION);
        }
    }

    public static abstract class Contract {
        public final String expression;
        public final AnnotationMirror annotation;
        public final Kind kind;

        public Contract(String expression, AnnotationMirror annotation, Kind kind) {
            this.expression = expression;
            this.annotation = annotation;
            this.kind = kind;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Contract contract = (Contract)o;
            if (this.expression != null ? !this.expression.equals(contract.expression) : contract.expression != null) {
                return false;
            }
            if (this.annotation != null ? !this.annotation.equals(contract.annotation) : contract.annotation != null) {
                return false;
            }
            return this.kind == contract.kind;
        }

        public int hashCode() {
            int result2 = this.expression != null ? this.expression.hashCode() : 0;
            result2 = 31 * result2 + (this.annotation != null ? this.annotation.hashCode() : 0);
            result2 = 31 * result2 + (this.kind != null ? this.kind.hashCode() : 0);
            return result2;
        }

        public static enum Kind {
            PRECONDITION("precondition"),
            POSTCONDTION("postcondition"),
            CONDITIONALPOSTCONDTION("conditional.postcondition");

            public final String errorKey;

            private Kind(String errorKey) {
                this.errorKey = errorKey;
            }
        }
    }
}

