/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.QualifierHierarchy;

public class FieldInvariants {
    private final List<String> fields;
    private final List<AnnotationMirror> qualifiers;

    public FieldInvariants(List<String> fields, List<AnnotationMirror> qualifiers) {
        this(null, fields, qualifiers);
    }

    public FieldInvariants(FieldInvariants other, List<String> fields, List<AnnotationMirror> qualifiers) {
        if (fields.size() > qualifiers.size() && qualifiers.size() == 1) {
            int difference = fields.size() - qualifiers.size();
            for (int i = 0; i < difference; ++i) {
                qualifiers.add(qualifiers.get(0));
            }
        }
        if (other != null) {
            fields.addAll(other.fields);
            qualifiers.addAll(other.qualifiers);
        }
        this.fields = Collections.unmodifiableList(fields);
        this.qualifiers = qualifiers;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public List<AnnotationMirror> getQualifiersFor(CharSequence field2) {
        String fieldString = field2.toString();
        if (this.isWellFormed()) {
            int index = this.fields.indexOf(fieldString);
            if (index == -1) {
                return Collections.emptyList();
            }
            ArrayList<AnnotationMirror> list2 = new ArrayList<AnnotationMirror>();
            for (int i = 0; i < this.fields.size(); ++i) {
                if (!this.fields.get(i).equals(fieldString)) continue;
                list2.add(this.qualifiers.get(i));
            }
            return list2;
        }
        return Collections.emptyList();
    }

    public boolean isWellFormed() {
        return this.qualifiers.size() == this.fields.size();
    }

    public Result isSuperInvariant(FieldInvariants superInvar, AnnotatedTypeFactory factory) {
        QualifierHierarchy qualifierHierarchy = factory.getQualifierHierarchy();
        if (!this.fields.containsAll(superInvar.fields)) {
            ArrayList<String> missingFields = new ArrayList<String>(superInvar.fields);
            missingFields.removeAll(this.fields);
            return Result.failure("field.invariant.not.found.superclass", String.join((CharSequence)", ", missingFields));
        }
        for (String field2 : superInvar.fields) {
            List<AnnotationMirror> superQualifiers = superInvar.getQualifiersFor(field2);
            List<AnnotationMirror> subQualifiers = this.getQualifiersFor(field2);
            for (AnnotationMirror superA : superQualifiers) {
                AnnotationMirror sub = qualifierHierarchy.findAnnotationInSameHierarchy(subQualifiers, superA);
                if (sub != null && qualifierHierarchy.isSubtype(sub, superA)) continue;
                return Result.failure("field.invariant.not.subtype.superclass", field2, sub, superA);
            }
        }
        return null;
    }
}

