/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.typeinference.constraint;

import java.util.Set;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.typeinference.constraint.A2F;
import org.checkerframework.framework.util.typeinference.constraint.AFConstraint;
import org.checkerframework.framework.util.typeinference.constraint.AFReducer;
import org.checkerframework.framework.util.typeinference.constraint.AFReducingVisitor;
import org.checkerframework.framework.util.typeinference.constraint.F2A;
import org.checkerframework.framework.util.typeinference.constraint.FIsA;

public class A2FReducer
implements AFReducer {
    protected final A2FReducingVisitor visitor;

    public A2FReducer(AnnotatedTypeFactory typeFactory) {
        this.visitor = new A2FReducingVisitor(typeFactory);
    }

    @Override
    public boolean reduce(AFConstraint constraint, Set<AFConstraint> newConstraints) {
        if (constraint instanceof A2F) {
            A2F a2f = (A2F)constraint;
            this.visitor.visit(a2f.argument, a2f.formalParameter, newConstraints);
            return true;
        }
        return false;
    }

    private static class A2FReducingVisitor
    extends AFReducingVisitor {
        public A2FReducingVisitor(AnnotatedTypeFactory typeFactory) {
            super(A2F.class, typeFactory);
        }

        @Override
        public AFConstraint makeConstraint(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype) {
            return new A2F(subtype, supertype);
        }

        @Override
        public AFConstraint makeInverseConstraint(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype) {
            return new F2A(subtype, supertype);
        }

        @Override
        public AFConstraint makeEqualityConstraint(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype) {
            return new FIsA(supertype, subtype);
        }
    }
}

