/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.javacutil;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.CollectionUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class AnnotationUtils {
    private static final int ANNOTATION_CACHE_SIZE = 500;
    private static final Map<Class<? extends Annotation>, String> annotationClassNames = Collections.synchronizedMap(CollectionUtils.createLRUCache(500));
    private static final Comparator<AnnotationMirror> ANNOTATION_ORDERING = new Comparator<AnnotationMirror>(){

        @Override
        public int compare(AnnotationMirror a1, AnnotationMirror a2) {
            if (AnnotationUtils.areSame(a1, a2)) {
                return 0;
            }
            String n1 = a1.toString();
            String n2 = a2.toString();
            return n1.compareTo(n2);
        }
    };

    private AnnotationUtils() {
        throw new AssertionError((Object)"Class AnnotationUtils cannot be instantiated.");
    }

    public static void clear() {
        AnnotationBuilder.clear();
        annotationClassNames.clear();
    }

    public static final String annotationName(AnnotationMirror annotation) {
        if (annotation instanceof AnnotationBuilder.CheckerFrameworkAnnotationMirror) {
            return ((AnnotationBuilder.CheckerFrameworkAnnotationMirror)annotation).annotationName;
        }
        DeclaredType annoType = annotation.getAnnotationType();
        TypeElement elm = (TypeElement)annoType.asElement();
        String name = elm.getQualifiedName().toString();
        return name;
    }

    public static boolean areSame(@Nullable AnnotationMirror a1, @Nullable AnnotationMirror a2) {
        if (a1 == a2) {
            return true;
        }
        if (!AnnotationUtils.areSameIgnoringValues(a1, a2)) {
            return false;
        }
        return AnnotationUtils.sameElementValues(a1, a2);
    }

    public static boolean areSameIgnoringValues(@Nullable AnnotationMirror a1, @Nullable AnnotationMirror a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        return AnnotationUtils.annotationName(a1).equals(AnnotationUtils.annotationName(a2));
    }

    public static boolean areSameByName(AnnotationMirror am, String aname) {
        return aname.equals(AnnotationUtils.annotationName(am));
    }

    public static boolean areSameByClass(AnnotationMirror am, Class<? extends Annotation> annoClass) {
        String canonicalName = annotationClassNames.get(annoClass);
        if (canonicalName == null) {
            canonicalName = annoClass.getCanonicalName();
            annotationClassNames.put(annoClass, canonicalName);
        }
        return AnnotationUtils.areSameByName(am, canonicalName);
    }

    public static boolean areSame(Collection<? extends AnnotationMirror> c1, Collection<? extends AnnotationMirror> c2) {
        if (c1.size() != c2.size()) {
            return false;
        }
        if (c1.size() == 1) {
            return AnnotationUtils.areSame(c1.iterator().next(), c2.iterator().next());
        }
        Set<AnnotationMirror> s1 = AnnotationUtils.createAnnotationSet();
        Set<AnnotationMirror> s2 = AnnotationUtils.createAnnotationSet();
        s1.addAll(c1);
        s2.addAll(c2);
        Iterator<AnnotationMirror> iter1 = s1.iterator();
        Iterator<AnnotationMirror> iter2 = s2.iterator();
        while (iter1.hasNext()) {
            AnnotationMirror anno2;
            AnnotationMirror anno1 = iter1.next();
            if (AnnotationUtils.areSame(anno1, anno2 = iter2.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsSame(Collection<? extends AnnotationMirror> c, AnnotationMirror anno) {
        return AnnotationUtils.getSame(c, anno) != null;
    }

    public static AnnotationMirror getSame(Collection<? extends AnnotationMirror> c, AnnotationMirror anno) {
        for (AnnotationMirror annotationMirror : c) {
            if (!AnnotationUtils.areSame(annotationMirror, anno)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean containsSameByClass(Collection<? extends AnnotationMirror> c, Class<? extends Annotation> anno) {
        return AnnotationUtils.getAnnotationByClass(c, anno) != null;
    }

    public static AnnotationMirror getAnnotationByClass(Collection<? extends AnnotationMirror> c, Class<? extends Annotation> anno) {
        for (AnnotationMirror annotationMirror : c) {
            if (!AnnotationUtils.areSameByClass(annotationMirror, anno)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean containsSameByName(Collection<? extends AnnotationMirror> c, String anno) {
        return AnnotationUtils.getAnnotationByName(c, anno) != null;
    }

    public static AnnotationMirror getAnnotationByName(Collection<? extends AnnotationMirror> c, String anno) {
        for (AnnotationMirror annotationMirror : c) {
            if (!AnnotationUtils.areSameByName(annotationMirror, anno)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean containsSameIgnoringValues(Collection<? extends AnnotationMirror> c, AnnotationMirror anno) {
        return AnnotationUtils.getSameIgnoringValues(c, anno) != null;
    }

    public static AnnotationMirror getSameIgnoringValues(Collection<? extends AnnotationMirror> c, AnnotationMirror anno) {
        for (AnnotationMirror annotationMirror : c) {
            if (!AnnotationUtils.areSameIgnoringValues(annotationMirror, anno)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static Comparator<AnnotationMirror> annotationOrdering() {
        return ANNOTATION_ORDERING;
    }

    public static <V> Map<AnnotationMirror, V> createAnnotationMap() {
        return new TreeMap(AnnotationUtils.annotationOrdering());
    }

    public static Set<AnnotationMirror> createAnnotationSet() {
        return new TreeSet<AnnotationMirror>(AnnotationUtils.annotationOrdering());
    }

    public static boolean hasInheritedMeta(AnnotationMirror anno) {
        return anno.getAnnotationType().asElement().getAnnotation(Inherited.class) != null;
    }

    public static EnumSet<ElementKind> getElementKindsForTarget(@Nullable Target target) {
        if (target == null) {
            return EnumSet.allOf(ElementKind.class);
        }
        EnumSet<ElementKind> eleKinds = EnumSet.noneOf(ElementKind.class);
        for (ElementType elementType : target.value()) {
            eleKinds.addAll(AnnotationUtils.getElementKindsForElementType(elementType));
        }
        return eleKinds;
    }

    public static EnumSet<ElementKind> getElementKindsForElementType(ElementType elementType) {
        switch (elementType) {
            case TYPE: {
                return EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE, ElementKind.ENUM);
            }
            case FIELD: {
                return EnumSet.of(ElementKind.FIELD, ElementKind.ENUM_CONSTANT);
            }
            case METHOD: {
                return EnumSet.of(ElementKind.METHOD);
            }
            case PARAMETER: {
                return EnumSet.of(ElementKind.PARAMETER);
            }
            case CONSTRUCTOR: {
                return EnumSet.of(ElementKind.CONSTRUCTOR);
            }
            case LOCAL_VARIABLE: {
                return EnumSet.of(ElementKind.LOCAL_VARIABLE, ElementKind.RESOURCE_VARIABLE, ElementKind.EXCEPTION_PARAMETER);
            }
            case ANNOTATION_TYPE: {
                return EnumSet.of(ElementKind.ANNOTATION_TYPE);
            }
            case PACKAGE: {
                return EnumSet.of(ElementKind.PACKAGE);
            }
            case TYPE_PARAMETER: {
                return EnumSet.of(ElementKind.TYPE_PARAMETER);
            }
            case TYPE_USE: {
                return EnumSet.noneOf(ElementKind.class);
            }
        }
        ErrorReporter.errorAbort("New ElementType: %s", new Object[]{elementType});
        return EnumSet.noneOf(ElementKind.class);
    }

    public static Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror ad) {
        HashMap<? extends ExecutableElement, ? extends AnnotationValue> valMap = new HashMap<ExecutableElement, AnnotationValue>();
        if (ad.getElementValues() != null) {
            valMap.putAll(ad.getElementValues());
        }
        for (ExecutableElement meth : ElementFilter.methodsIn(ad.getAnnotationType().asElement().getEnclosedElements())) {
            AnnotationValue defaultValue2 = meth.getDefaultValue();
            if (defaultValue2 == null || valMap.containsKey(meth)) continue;
            valMap.put(meth, defaultValue2);
        }
        return valMap;
    }

    public static boolean sameElementValues(AnnotationMirror am1, AnnotationMirror am2) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> vals1 = am1.getElementValues();
        Map<? extends ExecutableElement, ? extends AnnotationValue> vals2 = am2.getElementValues();
        for (ExecutableElement meth : ElementFilter.methodsIn(am1.getAnnotationType().asElement().getEnclosedElements())) {
            AnnotationValue aval1 = vals1.get(meth);
            AnnotationValue aval2 = vals2.get(meth);
            if (aval1 == null) {
                aval1 = meth.getDefaultValue();
            }
            if (aval2 == null) {
                aval2 = meth.getDefaultValue();
            }
            if (AnnotationUtils.sameAnnotationValue(aval1, aval2)) continue;
            return false;
        }
        return true;
    }

    public static boolean sameAnnotationValue(AnnotationValue av1, AnnotationValue av2) {
        if (av1 == av2) {
            return true;
        }
        if (av1 == null || av2 == null) {
            return false;
        }
        return AnnotationUtils.sameAnnotationValueValue(av1.getValue(), av2.getValue());
    }

    private static boolean sameAnnotationValueValue(Object val1, Object val2) {
        if (val1 == val2) {
            return true;
        }
        if (val1 instanceof List && val2 instanceof List) {
            List list1 = (List)val1;
            List list2 = (List)val2;
            if (list1.size() != list2.size()) {
                return false;
            }
            for (int i = 0; i < list1.size(); ++i) {
                if (AnnotationUtils.sameAnnotationValueValue(list1.get(i), list2.get(i))) continue;
                return false;
            }
            return true;
        }
        if (val1 instanceof AnnotationMirror && val2 instanceof AnnotationMirror) {
            return AnnotationUtils.areSame((AnnotationMirror)val1, (AnnotationMirror)val2);
        }
        if (val1 instanceof AnnotationValue && val2 instanceof AnnotationValue) {
            return AnnotationUtils.sameAnnotationValue((AnnotationValue)val1, (AnnotationValue)val2);
        }
        if (val1 instanceof Type.ClassType && val2 instanceof Type.ClassType) {
            return TypesUtils.areSameDeclaredTypes((Type.ClassType)val1, (Type.ClassType)val2);
        }
        return Objects.equals(val1, val2);
    }

    public static <T> boolean hasElementValue(AnnotationMirror anno, CharSequence name) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> valmap = anno.getElementValues();
        for (ExecutableElement executableElement : valmap.keySet()) {
            if (!executableElement.getSimpleName().contentEquals(name)) continue;
            return true;
        }
        return false;
    }

    public static <T> T getElementValue(AnnotationMirror anno, CharSequence name, Class<T> expectedType, boolean useDefaults) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> valmap = useDefaults ? AnnotationUtils.getElementValuesWithDefaults(anno) : anno.getElementValues();
        for (ExecutableElement executableElement : valmap.keySet()) {
            if (!executableElement.getSimpleName().contentEquals(name)) continue;
            AnnotationValue val = valmap.get(executableElement);
            return expectedType.cast(val.getValue());
        }
        ErrorReporter.errorAbort("No element with name '" + name + "' in annotation " + anno);
        return null;
    }

    public static <T extends Enum<T>> T getElementValueEnum(AnnotationMirror anno, CharSequence name, Class<T> t, boolean useDefaults) {
        Symbol.VarSymbol vs = AnnotationUtils.getElementValue(anno, name, Symbol.VarSymbol.class, useDefaults);
        T value = Enum.valueOf(t, ((Name)vs.getSimpleName()).toString());
        return value;
    }

    public static <T> List<T> getElementValueArray(AnnotationMirror anno, CharSequence name, Class<T> expectedType, boolean useDefaults) {
        List la = AnnotationUtils.getElementValue(anno, name, List.class, useDefaults);
        ArrayList<T> result2 = new ArrayList<T>(la.size());
        for (AnnotationValue a : la) {
            result2.add(expectedType.cast(a.getValue()));
        }
        return result2;
    }

    public static <T extends Enum<T>> List<T> getElementValueEnumArray(AnnotationMirror anno, CharSequence name, Class<T> t, boolean useDefaults) {
        List la = AnnotationUtils.getElementValue(anno, name, List.class, useDefaults);
        ArrayList<T> result2 = new ArrayList<T>(la.size());
        for (AnnotationValue a : la) {
            T value = Enum.valueOf(t, a.getValue().toString());
            result2.add(value);
        }
        return result2;
    }

    public static javax.lang.model.element.Name getElementValueClassName(AnnotationMirror anno, CharSequence name, boolean useDefaults) {
        Type.ClassType ct = AnnotationUtils.getElementValue(anno, name, Type.ClassType.class, useDefaults);
        return ((Symbol)ct.asElement()).getQualifiedName();
    }

    public static List<javax.lang.model.element.Name> getElementValueClassNames(AnnotationMirror anno, CharSequence name, boolean useDefaults) {
        List<Type.ClassType> la = AnnotationUtils.getElementValueArray(anno, name, Type.ClassType.class, useDefaults);
        ArrayList<javax.lang.model.element.Name> names = new ArrayList<javax.lang.model.element.Name>();
        for (Type.ClassType classType : la) {
            names.add(((Symbol)classType.asElement()).getQualifiedName());
        }
        return names;
    }

    public static Class<?> getElementValueClass(AnnotationMirror anno, CharSequence name, boolean useDefaults) {
        javax.lang.model.element.Name cn = AnnotationUtils.getElementValueClassName(anno, name, useDefaults);
        try {
            ClassLoader classLoader = InternalUtils.getClassLoaderForClass(AnnotationUtils.class);
            Class<?> cls = Class.forName(cn.toString(), true, classLoader);
            return cls;
        }
        catch (ClassNotFoundException e) {
            String msg = String.format("Could not load class '%s' for field '%s' in annotation %s", cn, name, anno);
            ErrorReporter.errorAbort(msg, e);
            return null;
        }
    }

    public static <T> void updateMappingToImmutableSet(Map<T, Set<AnnotationMirror>> map2, T key, Set<AnnotationMirror> newQual) {
        Set<AnnotationMirror> result2 = AnnotationUtils.createAnnotationSet();
        if (!map2.containsKey(key)) {
            result2.addAll(newQual);
        } else {
            result2.addAll((Collection<AnnotationMirror>)map2.get(key));
            result2.addAll(newQual);
        }
        map2.put(key, Collections.unmodifiableSet(result2));
    }

    public static Set<AnnotationMirror> getExplicitAnnotationsOnConstructorResult(MethodTree constructorDeclaration) {
        Set<AnnotationMirror> annotationSet = AnnotationUtils.createAnnotationSet();
        ModifiersTree modifiersTree = constructorDeclaration.getModifiers();
        if (modifiersTree != null) {
            List<? extends AnnotationTree> annotationTrees = modifiersTree.getAnnotations();
            annotationSet.addAll(TreeUtils.annotationsFromTypeAnnotationTrees(annotationTrees));
        }
        return annotationSet;
    }
}

