/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.javacutil;

import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacScope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.javacutil.ErrorReporter;

public class Resolver {
    private final Resolve resolve;
    private final Names names;
    private final Trees trees;
    private final Log log;
    private static final Method FIND_METHOD;
    private static final Method FIND_VAR;
    private static final Method FIND_IDENT;
    private static final Method FIND_IDENT_IN_TYPE;
    private static final Method FIND_IDENT_IN_PACKAGE;
    private static final Method FIND_TYPE;
    private static final Class<?> ACCESSERROR;
    private static final Method ACCESSERROR_ACCESS;

    public Resolver(ProcessingEnvironment env) {
        Context context = ((JavacProcessingEnvironment)env).getContext();
        this.resolve = Resolve.instance(context);
        this.names = Names.instance(context);
        this.trees = Trees.instance(env);
        this.log = Log.instance(context);
    }

    public Env<AttrContext> getEnvForPath(TreePath path) {
        TreePath iter = path;
        JavacScope scope = null;
        while (scope == null && iter != null) {
            try {
                scope = (JavacScope)this.trees.getScope(iter);
            }
            catch (Throwable t) {
                iter = iter.getParentPath();
            }
        }
        if (scope != null) {
            return scope.getEnv();
        }
        ErrorReporter.errorAbort("Could not determine any possible scope for path: " + path.getLeaf());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Symbol.PackageSymbol findPackage(String name, TreePath path) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            Env<AttrContext> env = this.getEnvForPath(path);
            Symbol res = this.wrapInvocationOnResolveInstance(FIND_IDENT, env, this.names.fromString(name), 1);
            if (res.getKind() == ElementKind.PACKAGE) {
                Symbol.PackageSymbol ps = (Symbol.PackageSymbol)res;
                Symbol.PackageSymbol packageSymbol = ps.exists() ? ps : null;
                return packageSymbol;
            }
            Symbol.PackageSymbol packageSymbol = null;
            return packageSymbol;
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariableElement findField(String name, TypeMirror type, TreePath path) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            Env<AttrContext> env = this.getEnvForPath(path);
            Symbol res = this.wrapInvocationOnResolveInstance(FIND_IDENT_IN_TYPE, env, type, this.names.fromString(name), 4);
            if (res.getKind() == ElementKind.FIELD) {
                VariableElement variableElement = (VariableElement)((Object)res);
                return variableElement;
            }
            if (res.getKind() == ElementKind.OTHER && ACCESSERROR.isInstance(res)) {
                VariableElement variableElement = (VariableElement)((Object)this.wrapInvocation(res, ACCESSERROR_ACCESS, null, null));
                return variableElement;
            }
            VariableElement variableElement = null;
            return variableElement;
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariableElement findLocalVariableOrParameterOrField(String name, TreePath path) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            Env<AttrContext> env = this.getEnvForPath(path);
            Symbol res = this.wrapInvocationOnResolveInstance(FIND_VAR, env, this.names.fromString(name));
            if (res.getKind() == ElementKind.LOCAL_VARIABLE || res.getKind() == ElementKind.PARAMETER || res.getKind() == ElementKind.FIELD) {
                VariableElement variableElement = (VariableElement)((Object)res);
                return variableElement;
            }
            VariableElement variableElement = null;
            return variableElement;
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element findClass(String name, TreePath path) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            Env<AttrContext> env = this.getEnvForPath(path);
            Symbol symbol = this.wrapInvocationOnResolveInstance(FIND_TYPE, env, this.names.fromString(name));
            return symbol;
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Symbol.ClassSymbol findClassInPackage(String name, Symbol.PackageSymbol pck, TreePath path) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            Env<AttrContext> env = this.getEnvForPath(path);
            Symbol res = this.wrapInvocationOnResolveInstance(FIND_IDENT_IN_PACKAGE, env, pck, this.names.fromString(name), 2);
            if (res.getKind() == ElementKind.CLASS) {
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)res;
                return classSymbol;
            }
            Symbol.ClassSymbol classSymbol = null;
            return classSymbol;
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    public Element findMethod(String methodName, TypeMirror receiverType, TreePath path, java.util.List<TypeMirror> argumentTypes) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            Env<AttrContext> env = this.getEnvForPath(path);
            Type site = (Type)receiverType;
            Name name = this.names.fromString(methodName);
            List<Type> argtypes = List.nil();
            for (TypeMirror a : argumentTypes) {
                argtypes = argtypes.append((Type)a);
            }
            List typeargtypes = List.nil();
            boolean allowBoxing = true;
            boolean useVarargs = false;
            boolean operator = true;
            try {
                Object methodContext = this.buildMethodContext();
                Object oldContext = this.getField(this.resolve, "currentResolutionContext");
                this.setField(this.resolve, "currentResolutionContext", methodContext);
                Symbol result2 = this.wrapInvocationOnResolveInstance(FIND_METHOD, env, site, name, argtypes, typeargtypes, allowBoxing, useVarargs, operator);
                this.setField(this.resolve, "currentResolutionContext", oldContext);
                Symbol symbol = result2;
                return symbol;
            }
            catch (Throwable t) {
                AssertionError err = new AssertionError((Object)"Unexpected Reflection error");
                ((Throwable)((Object)err)).initCause(t);
                throw err;
            }
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    protected Object buildMethodContext() throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        Class<?> methCtxClss = Class.forName("com.sun.tools.javac.comp.Resolve$MethodResolutionContext");
        Constructor<?> constructor = methCtxClss.getDeclaredConstructors()[0];
        constructor.setAccessible(true);
        Object methodContext = constructor.newInstance(this.resolve);
        this.setField(methodContext, "attrMode", (Object)DeferredAttr.AttrMode.CHECK);
        List phases = (List)this.getField(this.resolve, "methodResolutionSteps");
        this.setField(methodContext, "step", phases.get(1));
        return methodContext;
    }

    private void setField(Object receiver, String fieldName, Object value) throws NoSuchFieldException, IllegalAccessException {
        Field f = receiver.getClass().getDeclaredField(fieldName);
        f.setAccessible(true);
        f.set(receiver, value);
    }

    private Object getField(Object receiver, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field f = receiver.getClass().getDeclaredField(fieldName);
        f.setAccessible(true);
        return f.get(receiver);
    }

    private Symbol wrapInvocationOnResolveInstance(Method method, Object ... args) {
        return this.wrapInvocation(this.resolve, method, args);
    }

    private Symbol wrapInvocation(Object receiver, Method method, Object ... args) {
        try {
            return (Symbol)method.invoke(receiver, args);
        }
        catch (IllegalAccessException e) {
            AssertionError err = new AssertionError((Object)"Unexpected Reflection error");
            ((Throwable)((Object)err)).initCause(e);
            throw err;
        }
        catch (IllegalArgumentException e) {
            AssertionError err = new AssertionError((Object)"Unexpected Reflection error");
            ((Throwable)((Object)err)).initCause(e);
            throw err;
        }
        catch (InvocationTargetException e) {
            AssertionError err = new AssertionError((Object)"Unexpected Reflection error");
            ((Throwable)((Object)err)).initCause(e);
            throw err;
        }
    }

    static {
        try {
            FIND_METHOD = Resolve.class.getDeclaredMethod("findMethod", Env.class, Type.class, Name.class, List.class, List.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
            FIND_METHOD.setAccessible(true);
            FIND_VAR = Resolve.class.getDeclaredMethod("findVar", Env.class, Name.class);
            FIND_VAR.setAccessible(true);
            FIND_IDENT = Resolve.class.getDeclaredMethod("findIdent", Env.class, Name.class, Integer.TYPE);
            FIND_IDENT.setAccessible(true);
            FIND_IDENT_IN_TYPE = Resolve.class.getDeclaredMethod("findIdentInType", Env.class, Type.class, Name.class, Integer.TYPE);
            FIND_IDENT_IN_TYPE.setAccessible(true);
            FIND_IDENT_IN_PACKAGE = Resolve.class.getDeclaredMethod("findIdentInPackage", Env.class, Symbol.TypeSymbol.class, Name.class, Integer.TYPE);
            FIND_IDENT_IN_PACKAGE.setAccessible(true);
            FIND_TYPE = Resolve.class.getDeclaredMethod("findType", Env.class, Name.class);
            FIND_TYPE.setAccessible(true);
        }
        catch (Exception e) {
            AssertionError err = new AssertionError((Object)"Compiler 'Resolve' class doesn't contain required 'find' method");
            ((Throwable)((Object)err)).initCause(e);
            throw err;
        }
        try {
            ACCESSERROR = Class.forName("com.sun.tools.javac.comp.Resolve$AccessError");
            ACCESSERROR_ACCESS = ACCESSERROR.getMethod("access", Name.class, Symbol.TypeSymbol.class);
            ACCESSERROR_ACCESS.setAccessible(true);
        }
        catch (ClassNotFoundException e) {
            ErrorReporter.errorAbort("Compiler 'Resolve$AccessError' class could not be retrieved.", e);
            throw new AssertionError();
        }
        catch (NoSuchMethodException e) {
            ErrorReporter.errorAbort("Compiler 'Resolve$AccessError' class doesn't contain required 'access' method", e);
            throw new AssertionError();
        }
    }
}

