/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.objectweb.asm.tree.analysis;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.checkerframework.org.objectweb.asm.Opcodes;
import org.checkerframework.org.objectweb.asm.Type;
import org.checkerframework.org.objectweb.asm.tree.AbstractInsnNode;
import org.checkerframework.org.objectweb.asm.tree.FieldInsnNode;
import org.checkerframework.org.objectweb.asm.tree.LdcInsnNode;
import org.checkerframework.org.objectweb.asm.tree.MethodInsnNode;
import org.checkerframework.org.objectweb.asm.tree.analysis.DataflowValue;
import org.checkerframework.org.objectweb.asm.tree.analysis.Interpreter;
import org.checkerframework.org.objectweb.asm.tree.analysis.SmallSet;
import org.checkerframework.org.objectweb.asm.tree.analysis.Value;

public class DataflowInterpreter
implements Opcodes,
Interpreter {
    @Override
    public Value newValue(Type type) {
        return new DataflowValue(type == null ? 1 : type.getSize());
    }

    @Override
    public Value newOperation(AbstractInsnNode insn) {
        int size;
        switch (insn.getOpcode()) {
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                size = 2;
                break;
            }
            case 18: {
                Object cst = ((LdcInsnNode)insn).cst;
                size = cst instanceof Long || cst instanceof Double ? 2 : 1;
                break;
            }
            case 178: {
                size = Type.getType(((FieldInsnNode)insn).desc).getSize();
                break;
            }
            default: {
                size = 1;
            }
        }
        return new DataflowValue(size, insn);
    }

    @Override
    public Value copyOperation(AbstractInsnNode insn, Value value) {
        return new DataflowValue(value.getSize(), insn);
    }

    @Override
    public Value unaryOperation(AbstractInsnNode insn, Value value) {
        int size;
        switch (insn.getOpcode()) {
            case 117: 
            case 119: 
            case 133: 
            case 135: 
            case 138: 
            case 140: 
            case 141: 
            case 143: {
                size = 2;
                break;
            }
            case 180: {
                size = Type.getType(((FieldInsnNode)insn).desc).getSize();
                break;
            }
            default: {
                size = 1;
            }
        }
        return new DataflowValue(size, insn);
    }

    @Override
    public Value binaryOperation(AbstractInsnNode insn, Value value1, Value value2) {
        int size;
        switch (insn.getOpcode()) {
            case 47: 
            case 49: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                size = 2;
                break;
            }
            default: {
                size = 1;
            }
        }
        return new DataflowValue(size, insn);
    }

    @Override
    public Value ternaryOperation(AbstractInsnNode insn, Value value1, Value value2, Value value3) {
        return new DataflowValue(1, insn);
    }

    @Override
    public Value naryOperation(AbstractInsnNode insn, List values2) {
        int size = insn.getOpcode() == 197 ? 1 : Type.getReturnType(((MethodInsnNode)insn).desc).getSize();
        return new DataflowValue(size, insn);
    }

    @Override
    public Value merge(Value v, Value w) {
        DataflowValue dv = (DataflowValue)v;
        DataflowValue dw = (DataflowValue)w;
        if (dv.insns instanceof SmallSet && dw.insns instanceof SmallSet) {
            Set s2 = ((SmallSet)dv.insns).union((SmallSet)dw.insns);
            if (s2 == dv.insns && dv.size == dw.size) {
                return v;
            }
            return new DataflowValue(Math.min(dv.size, dw.size), s2);
        }
        if (dv.size != dw.size || !dv.insns.containsAll(dw.insns)) {
            HashSet s3 = new HashSet();
            s3.addAll(dv.insns);
            s3.addAll(dw.insns);
            return new DataflowValue(Math.min(dv.size, dw.size), s3);
        }
        return v;
    }
}

