/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.objectweb.asm.util;

import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import org.checkerframework.org.objectweb.asm.TypeAnnotationVisitor;
import org.checkerframework.org.objectweb.asm.util.TraceAnnotationVisitor;

public class TraceTypeAnnotationVisitor
extends TraceAnnotationVisitor
implements TypeAnnotationVisitor {
    protected TypeAnnotationVisitor xav;
    protected String doubleTab;
    private int xtarget_type;
    private int xoffset;
    private int xlocation_length;
    private TypeAnnotationPosition.TypePathEntry[] xlocations;
    private int xlocations_index;
    private int xstart_pc;
    private int xlength;
    private int xindex;
    private int xparam_index;
    private int xbound_index;
    private int xexception_index;
    private int xtype_index;

    public TraceTypeAnnotationVisitor() {
        this.doubleTab = this.tab + this.tab;
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        this.finishExtendedPart();
    }

    @Override
    protected TraceTypeAnnotationVisitor createTraceTypeAnnotationVisitor() {
        return new TraceTypeAnnotationVisitor();
    }

    private void finishExtendedPart() {
        this.buf.setLength(0);
        this.buf.append("\n  extended annotation: \n");
        this.buf.append(this.doubleTab).append("target_type: ").append(this.xtarget_type).append("\n");
        TargetType tt = TargetType.fromTargetTypeValue(this.xtarget_type);
        switch (tt) {
            case INSTANCEOF: 
            case NEW: 
            case CONSTRUCTOR_REFERENCE: 
            case METHOD_REFERENCE: {
                this.buf.append(this.doubleTab).append("offset: ").append(this.xoffset).append("\n");
                break;
            }
            case METHOD_RECEIVER: {
                break;
            }
            case LOCAL_VARIABLE: 
            case RESOURCE_VARIABLE: {
                this.buf.append(this.doubleTab).append("start_pc: ").append(this.xstart_pc).append("\n");
                this.buf.append(this.doubleTab).append("length: ").append(this.xlength).append("\n");
                this.buf.append(this.doubleTab).append("index: ").append(this.xindex).append("\n");
                break;
            }
            case METHOD_RETURN: {
                break;
            }
            case METHOD_FORMAL_PARAMETER: {
                this.buf.append(this.doubleTab).append("index: ").append("FIXME").append("\n");
                break;
            }
            case FIELD: {
                break;
            }
            case CLASS_TYPE_PARAMETER_BOUND: 
            case METHOD_TYPE_PARAMETER_BOUND: {
                this.buf.append(this.doubleTab).append("param_index: ").append(this.xparam_index).append("\n");
                this.buf.append(this.doubleTab).append("bound_index: ").append(this.xbound_index).append("\n");
                break;
            }
            case CLASS_EXTENDS: 
            case THROWS: {
                this.buf.append(this.doubleTab).append("type_index: ").append(this.xtype_index).append("\n");
                break;
            }
            case CAST: 
            case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: 
            case METHOD_INVOCATION_TYPE_ARGUMENT: 
            case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: 
            case METHOD_REFERENCE_TYPE_ARGUMENT: {
                this.buf.append(this.doubleTab).append("offset: ").append(this.xoffset).append("\n");
                this.buf.append(this.doubleTab).append("type_index: ").append(this.xtype_index).append("\n");
                break;
            }
            case METHOD_TYPE_PARAMETER: {
                this.buf.append(this.doubleTab).append("param_index: ").append(this.xparam_index).append("\n");
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized target type: + " + this.xtarget_type);
            }
        }
        if (this.xlocation_length != 0) {
            this.buf.append(this.doubleTab).append("location_length: " + this.xlocation_length).append("\n");
            this.buf.append(this.doubleTab).append("locations: ");
            boolean first2 = true;
            for (int i = 0; i < this.xlocations.length; ++i) {
                if (!first2) {
                    this.buf.append(", ");
                }
                first2 = false;
                this.buf.append(this.xlocations[i]);
            }
            this.buf.append("\n");
        }
        this.text.add(this.buf.toString());
    }

    @Override
    public void visitXTargetType(int target_type) {
        this.xtarget_type = target_type;
        if (this.xav != null) {
            this.xav.visitXTargetType(target_type);
        }
    }

    @Override
    public void visitXOffset(int offset) {
        this.xoffset = offset;
        if (this.xav != null) {
            this.xav.visitXOffset(offset);
        }
    }

    @Override
    public void visitXLocationLength(int location_length) {
        this.xlocation_length = location_length;
        this.xlocations = new TypeAnnotationPosition.TypePathEntry[this.xlocation_length];
        this.xlocations_index = 0;
        if (this.xav != null) {
            this.xav.visitXLocationLength(location_length);
        }
    }

    @Override
    public void visitXLocation(TypeAnnotationPosition.TypePathEntry location) {
        this.xlocations[this.xlocations_index] = location;
        ++this.xlocations_index;
        if (this.xav != null) {
            this.xav.visitXLocation(location);
        }
    }

    @Override
    public void visitXNumEntries(int num_entries) {
        if (this.xav != null) {
            this.xav.visitXNumEntries(num_entries);
        }
    }

    @Override
    public void visitXStartPc(int start_pc) {
        this.xstart_pc = start_pc;
        if (this.xav != null) {
            this.xav.visitXStartPc(start_pc);
        }
    }

    @Override
    public void visitXLength(int length) {
        this.xlength = length;
        if (this.xav != null) {
            this.xav.visitXLength(length);
        }
    }

    @Override
    public void visitXIndex(int index) {
        this.xindex = index;
        if (this.xav != null) {
            this.xav.visitXIndex(index);
        }
    }

    @Override
    public void visitXParamIndex(int param_index) {
        this.xparam_index = param_index;
        if (this.xav != null) {
            this.xav.visitXParamIndex(param_index);
        }
    }

    @Override
    public void visitXBoundIndex(int bound_index) {
        this.xbound_index = bound_index;
        if (this.xav != null) {
            this.xav.visitXBoundIndex(bound_index);
        }
    }

    @Override
    public void visitXTypeIndex(int type_index) {
        this.xtype_index = type_index;
        if (this.xav != null) {
            this.xav.visitXTypeIndex(type_index);
        }
    }

    @Override
    public void visitXExceptionIndex(int exception_index) {
        this.xexception_index = exception_index;
        if (this.xav != null) {
            this.xav.visitXExceptionIndex(exception_index);
        }
    }

    @Override
    public void visitXNameAndArgsSize() {
    }
}

