/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.objectweb.asm.xml;

import org.checkerframework.org.objectweb.asm.AnnotationVisitor;
import org.checkerframework.org.objectweb.asm.Type;
import org.checkerframework.org.objectweb.asm.xml.SAXAdapter;
import org.checkerframework.org.objectweb.asm.xml.SAXClassAdapter;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class SAXAnnotationAdapter
extends SAXAdapter
implements AnnotationVisitor {
    private final String elementName;

    public SAXAnnotationAdapter(ContentHandler h2, String elementName, int visible, String name, String desc) {
        this(h2, elementName, visible, desc, name, -1);
    }

    public SAXAnnotationAdapter(ContentHandler h2, String elementName, int visible, int parameter, String desc) {
        this(h2, elementName, visible, desc, null, parameter);
    }

    private SAXAnnotationAdapter(ContentHandler h2, String elementName, int visible, String desc, String name, int parameter) {
        super(h2);
        this.elementName = elementName;
        AttributesImpl att = new AttributesImpl();
        if (name != null) {
            att.addAttribute("", "name", "name", "", name);
        }
        if (visible != 0) {
            att.addAttribute("", "visible", "visible", "", visible > 0 ? "true" : "false");
        }
        if (parameter != -1) {
            att.addAttribute("", "parameter", "parameter", "", Integer.toString(parameter));
        }
        if (desc != null) {
            att.addAttribute("", "desc", "desc", "", desc);
        }
        this.addStart(elementName, att);
    }

    @Override
    public void visit(String name, Object value) {
        Class<?> c = value.getClass();
        if (c.isArray()) {
            AnnotationVisitor av = this.visitArray(name);
            if (value instanceof byte[]) {
                byte[] b = (byte[])value;
                for (int i = 0; i < b.length; ++i) {
                    av.visit(null, new Byte(b[i]));
                }
            } else if (value instanceof char[]) {
                char[] b = (char[])value;
                for (int i = 0; i < b.length; ++i) {
                    av.visit(null, new Character(b[i]));
                }
            } else if (value instanceof boolean[]) {
                boolean[] b = (boolean[])value;
                for (int i = 0; i < b.length; ++i) {
                    av.visit(null, b[i]);
                }
            } else if (value instanceof int[]) {
                int[] b = (int[])value;
                for (int i = 0; i < b.length; ++i) {
                    av.visit(null, new Integer(b[i]));
                }
            } else if (value instanceof long[]) {
                long[] b = (long[])value;
                for (int i = 0; i < b.length; ++i) {
                    av.visit(null, new Long(b[i]));
                }
            } else if (value instanceof float[]) {
                float[] b = (float[])value;
                for (int i = 0; i < b.length; ++i) {
                    av.visit(null, new Float(b[i]));
                }
            } else if (value instanceof double[]) {
                double[] b = (double[])value;
                for (int i = 0; i < b.length; ++i) {
                    av.visit(null, new Double(b[i]));
                }
            }
            av.visitEnd();
        } else {
            this.addValueElement("annotationValue", name, Type.getDescriptor(c), value.toString());
        }
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        this.addValueElement("annotationValueEnum", name, desc, value);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String desc) {
        return new SAXAnnotationAdapter(this.getContentHandler(), "annotationValueAnnotation", 0, name, desc);
    }

    @Override
    public AnnotationVisitor visitArray(String name) {
        return new SAXAnnotationAdapter(this.getContentHandler(), "annotationValueArray", 0, name, null);
    }

    @Override
    public void visitEnd() {
        this.addEnd(this.elementName);
    }

    private void addValueElement(String element, String name, String desc, String value) {
        AttributesImpl att = new AttributesImpl();
        if (name != null) {
            att.addAttribute("", "name", "name", "", name);
        }
        if (desc != null) {
            att.addAttribute("", "desc", "desc", "", desc);
        }
        if (value != null) {
            att.addAttribute("", "value", "value", "", SAXClassAdapter.encode(value));
        }
        this.addElement(element, att);
    }
}

