/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.plumelib.util;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.formatter.qual.FormatBottom;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.index.qual.IndexOrHigh;
import org.checkerframework.checker.index.qual.LTEqLengthOf;
import org.checkerframework.checker.index.qual.LessThanBottom;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundBottom;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.index.qual.SameLen;
import org.checkerframework.checker.index.qual.SameLenBottom;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexBottom;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundBottom;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.InternedDistinct;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.lock.qual.GuardSatisfied;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.GuardedByBottom;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.NonRaw;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.regex.qual.RegexBottom;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.checker.signature.qual.SignatureBottom;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.common.value.qual.ArrayLenRange;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.MinLen;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.org.plumelib.util.ArraysPlume;

public class LimitedSizeSet<@SubstringIndexBottom T>
implements Serializable,
Cloneable {
    static final @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown long serialVersionUID = 20031021L;
    protected @Nullable T @Nullable @ArrayLenRange(from=1, to=0x7FFFFFFF) @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @Initialized @NonRaw @MinLen(value=1) @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown [] values;
    @LessThanUnknown @LTEqLengthOf(value={"this.values"}) @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @IndexOrHigh(value={"values"}) @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @NonNegative @UnknownRegex @SignatureUnknown int num_values;
    private static @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown boolean assertsEnabled = false;

    public LimitedSizeSet(@LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @Positive @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int max_values) {
        if (assertsEnabled && max_values <= 0) {
            throw new IllegalArgumentException("max_values should be positive, is " + max_values);
        }
        @Nullable Object @MinLen(value=1) [] new_values_array = new Object[max_values];
        this.values = new_values_array;
        this.num_values = 0;
    }

    public void add(T elt) {
        if (this.repNulled()) {
            return;
        }
        if (this.contains(elt)) {
            return;
        }
        if (this.num_values == this.values.length) {
            this.nullRep();
            return;
        }
        this.values[this.num_values] = elt;
        ++this.num_values;
    }

    public void addAll(@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown LimitedSizeSet<@SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @InternedDistinct @LockPossiblyHeld @GuardedByBottom @KeyForBottom @NonNull @Initialized @NonRaw @FormatBottom @BottomVal @RegexBottom @SignatureBottom ? extends T> s2) {
        boolean sameObject;
        boolean bl = sameObject = this == s2;
        if (sameObject) {
            return;
        }
        if (this.repNulled()) {
            return;
        }
        if (s2.repNulled()) {
            if (s2.size() > this.values.length) {
                this.nullRep();
                return;
            }
            throw new Error("Arg is rep-nulled, so we don't know its values and can't add them to this.");
        }
        @Nullable T @SameLen(value={"s.values"}) [] svalues = s2.values;
        for (int i = 0; i < s2.size(); ++i) {
            assert (svalues[i] != null) : "@AssumeAssertion(nullness): used portion of array";
            this.add(svalues[i]);
            if (!this.repNulled()) continue;
            return;
        }
    }

    @Pure
    public @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown boolean contains(T elt) {
        if (this.repNulled()) {
            throw new UnsupportedOperationException();
        }
        for (int i = 0; i < this.num_values; ++i) {
            if (!Objects.equals(this.values[i], elt)) continue;
            return true;
        }
        return false;
    }

    @Pure
    public @LessThanUnknown @LTEqLengthOf(value={"this.values"}) @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @IndexOrHigh(value={"this.values"}) @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @NonNegative @UnknownRegex @SignatureUnknown int size(@GuardSatisfied LimitedSizeSet<T> this) {
        return this.num_values;
    }

    public @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @Positive @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int max_size() {
        if (this.repNulled()) {
            return this.num_values;
        }
        return this.values.length + 1;
    }

    @EnsuresNonNullIf(result=false, expression={"values"})
    @Pure
    public @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown boolean repNulled(@GuardSatisfied LimitedSizeSet<T> this) {
        return this.values == null;
    }

    private void nullRep() {
        if (this.repNulled()) {
            return;
        }
        this.num_values = this.values.length + 1;
        this.values = null;
    }

    @SideEffectFree
    public @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown LimitedSizeSet<T> clone(@GuardSatisfied LimitedSizeSet<T> this) {
        LimitedSizeSet result2;
        try {
            LimitedSizeSet result_as_lss;
            result2 = result_as_lss = (LimitedSizeSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error();
        }
        if (this.values != null) {
            result2.values = (Object[])this.values.clone();
        }
        return result2;
    }

    public static <T> @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown LimitedSizeSet<T> merge(@LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @Positive @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int max_values, @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown List<@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown LimitedSizeSet<@SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @InternedDistinct @LockPossiblyHeld @GuardedByBottom @KeyForBottom @NonNull @Initialized @NonRaw @FormatBottom @BottomVal @RegexBottom @SignatureBottom ? extends T>> slist) {
        LimitedSizeSet<T> result2 = new LimitedSizeSet<T>(max_values);
        for (LimitedSizeSet<T> limitedSizeSet : slist) {
            result2.addAll(limitedSizeSet);
        }
        return result2;
    }

    @SideEffectFree
    public @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown String toString(@GuardSatisfied LimitedSizeSet<T> this) {
        return "[size=" + this.size() + "; " + (this.repNulled() ? "null" : ArraysPlume.toString(this.values)) + "]";
    }

    static {
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
    }
}

