/*
 * Decompiled with CFR 0.152.
 */
package scenelib.annotations.util;

import com.sun.tools.javac.util.Pair;
import java.util.Map;
import java.util.Set;
import scenelib.annotations.el.ABlock;
import scenelib.annotations.el.AClass;
import scenelib.annotations.el.ADeclaration;
import scenelib.annotations.el.AElement;
import scenelib.annotations.el.AExpression;
import scenelib.annotations.el.AField;
import scenelib.annotations.el.AMethod;
import scenelib.annotations.el.AScene;
import scenelib.annotations.el.ATypeElement;
import scenelib.annotations.el.ATypeElementWithType;
import scenelib.annotations.el.AnnotationDef;
import scenelib.annotations.el.ElementVisitor;
import scenelib.annotations.util.coll.VivifyingMap;

class DiffVisitor
implements ElementVisitor<Void, Pair<AElement, AElement>> {
    DiffVisitor() {
    }

    public void visitScene(AScene minuend, AScene subtrahend, AScene difference) {
        this.visitElements(minuend.packages, subtrahend.packages, difference.packages);
        DiffVisitor.diff(minuend.imports, subtrahend.imports, difference.imports);
        this.visitElements(minuend.classes, subtrahend.classes, difference.classes);
    }

    @Override
    public Void visitAnnotationDef(AnnotationDef minuend, Pair<AElement, AElement> eltPair) {
        throw new IllegalStateException("BUG: DiffVisitor.visitAnnotationDef invoked");
    }

    @Override
    public Void visitBlock(ABlock minuend, Pair<AElement, AElement> eltPair) {
        ABlock subtrahend = (ABlock)eltPair.fst;
        ABlock difference = (ABlock)eltPair.snd;
        this.visitElements(minuend.locals, subtrahend.locals, difference.locals);
        return this.visitExpression((AExpression)minuend, eltPair);
    }

    @Override
    public Void visitClass(AClass minuend, Pair<AElement, AElement> eltPair) {
        AClass subtrahend = (AClass)eltPair.fst;
        AClass difference = (AClass)eltPair.snd;
        this.visitElements(minuend.bounds, subtrahend.bounds, difference.bounds);
        this.visitElements(minuend.extendsImplements, subtrahend.extendsImplements, difference.extendsImplements);
        this.visitElements(minuend.methods, subtrahend.methods, difference.methods);
        this.visitElements(minuend.staticInits, subtrahend.staticInits, difference.staticInits);
        this.visitElements(minuend.instanceInits, subtrahend.instanceInits, difference.instanceInits);
        this.visitElements(minuend.fields, subtrahend.fields, difference.fields);
        this.visitElements(minuend.fieldInits, subtrahend.fieldInits, difference.fieldInits);
        return this.visitDeclaration((ADeclaration)minuend, eltPair);
    }

    @Override
    public Void visitDeclaration(ADeclaration minuend, Pair<AElement, AElement> eltPair) {
        ADeclaration subtrahend = (ADeclaration)eltPair.fst;
        ADeclaration difference = (ADeclaration)eltPair.snd;
        this.visitElements(minuend.insertAnnotations, subtrahend.insertAnnotations, difference.insertAnnotations);
        this.visitElements(minuend.insertTypecasts, subtrahend.insertTypecasts, difference.insertTypecasts);
        return this.visitElement((AElement)minuend, eltPair);
    }

    @Override
    public Void visitExpression(AExpression minuend, Pair<AElement, AElement> eltPair) {
        AExpression subtrahend = (AExpression)eltPair.fst;
        AExpression difference = (AExpression)eltPair.snd;
        this.visitElements(minuend.typecasts, subtrahend.typecasts, difference.typecasts);
        this.visitElements(minuend.instanceofs, subtrahend.instanceofs, difference.instanceofs);
        this.visitElements(minuend.news, subtrahend.news, difference.news);
        this.visitElements(minuend.calls, subtrahend.calls, difference.calls);
        this.visitElements(minuend.refs, subtrahend.refs, difference.refs);
        this.visitElements(minuend.funs, subtrahend.funs, difference.funs);
        return this.visitElement((AElement)minuend, eltPair);
    }

    @Override
    public Void visitField(AField minuend, Pair<AElement, AElement> eltPair) {
        return this.visitDeclaration((ADeclaration)minuend, eltPair);
    }

    @Override
    public Void visitMethod(AMethod minuend, Pair<AElement, AElement> eltPair) {
        AMethod subtrahend = (AMethod)eltPair.fst;
        AMethod difference = (AMethod)eltPair.snd;
        this.visitElements(minuend.bounds, subtrahend.bounds, difference.bounds);
        this.visitElements(minuend.parameters, subtrahend.parameters, difference.parameters);
        this.visitElements(minuend.throwsException, subtrahend.throwsException, difference.throwsException);
        this.visitElements(minuend.parameters, subtrahend.parameters, difference.parameters);
        this.visitBlock(minuend.body, this.elemPair(subtrahend.body, difference.body));
        if (minuend.returnType != null) {
            minuend.returnType.accept(this, this.elemPair(subtrahend.returnType, difference.returnType));
        }
        if (minuend.receiver != null) {
            minuend.receiver.accept(this, this.elemPair(subtrahend.receiver, difference.receiver));
        }
        return this.visitDeclaration((ADeclaration)minuend, eltPair);
    }

    @Override
    public Void visitTypeElement(ATypeElement minuend, Pair<AElement, AElement> eltPair) {
        ATypeElement subtrahend = (ATypeElement)eltPair.fst;
        ATypeElement difference = (ATypeElement)eltPair.snd;
        this.visitElements(minuend.innerTypes, subtrahend.innerTypes, difference.innerTypes);
        return this.visitElement((AElement)minuend, eltPair);
    }

    @Override
    public Void visitTypeElementWithType(ATypeElementWithType minuend, Pair<AElement, AElement> eltPair) {
        return this.visitTypeElement((ATypeElement)minuend, eltPair);
    }

    @Override
    public Void visitElement(AElement minuend, Pair<AElement, AElement> eltPair) {
        AElement subtrahend = (AElement)eltPair.fst;
        AElement difference = (AElement)eltPair.snd;
        DiffVisitor.diff(minuend.tlAnnotationsHere, subtrahend.tlAnnotationsHere, difference.tlAnnotationsHere);
        if (minuend.type != null) {
            ATypeElement stype = subtrahend.type;
            ATypeElement dtype = difference.type;
            minuend.type.accept(this, this.elemPair(stype, dtype));
        }
        return null;
    }

    private <K, V extends AElement> void visitElements(VivifyingMap<K, V> minuend, VivifyingMap<K, V> subtrahend, VivifyingMap<K, V> difference) {
        if (minuend != null) {
            for (Map.Entry e : minuend.entrySet()) {
                Object key = e.getKey();
                AElement mval = (AElement)e.getValue();
                AElement sval = (AElement)subtrahend.get(key);
                if (sval == null) {
                    difference.put(key, mval);
                    continue;
                }
                mval.accept(this, this.elemPair(sval, (AElement)difference.vivify(key)));
            }
        }
    }

    private static <T> void diff(Set<T> minuend, Set<T> subtrahend, Set<T> difference) {
        if (minuend != null) {
            for (T t : minuend) {
                if (subtrahend.contains(t)) continue;
                difference.add(t);
            }
        }
    }

    private static <K, V> void diff(Map<K, Set<V>> minuend, Map<K, Set<V>> subtrahend, Map<K, Set<V>> difference) {
        if (minuend != null) {
            for (K key : minuend.keySet()) {
                Set<V> mval = minuend.get(key);
                Set<V> sval = subtrahend.get(key);
                if (sval == null) {
                    difference.put(key, mval);
                    continue;
                }
                if (sval.equals(mval)) continue;
                try {
                    Set set2 = (Set)sval.getClass().newInstance();
                    DiffVisitor.diff(mval, sval, set2);
                    if (set2.isEmpty()) continue;
                    difference.put(key, set2);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
        }
    }

    private Pair<AElement, AElement> elemPair(AElement stype, AElement dtype) {
        return Pair.of(stype, dtype);
    }
}

