/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.archive;

import com.daml.crypto.MessageDigestPrototype$;
import com.daml.daml_lf_dev.DamlLf;
import com.daml.lf.archive.ArchivePayload;
import com.daml.lf.archive.Error;
import com.daml.lf.archive.Error$Parsing$;
import com.daml.lf.archive.package$;
import com.daml.lf.data.Ref$;
import com.daml.lf.language.LanguageMajorVersion;
import com.daml.lf.language.LanguageMajorVersion$V1$;
import com.daml.lf.language.LanguageVersion;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class Reader$ {
    public static final Reader$ MODULE$ = new Reader$();

    public Either<Error, ArchivePayload> readArchive(DamlLf.Archive lf) throws Error.Parsing {
        DamlLf.HashFunction hashFunction = lf.getHashFunction();
        if (DamlLf.HashFunction.SHA256.equals(hashFunction)) {
            return Ref$.MODULE$.PackageId().fromString(lf.getHash()).left().map((Function1<String, Error.Parsing> & Serializable)err -> new Error.Parsing(new StringBuilder(14).append("Invalid hash: ").append((String)err).toString())).map((Function1<String, Tuple2> & Serializable)theirHash -> {
                String ourHash = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(MessageDigestPrototype$.MODULE$.Sha256().newDigest().digest(lf.getPayload().toByteArray())), (Function1<Object, String> & Serializable)x$1 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02x"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToByte(BoxesRunTime.unboxToByte(x$1))})), ClassTag$.MODULE$.apply(String.class))).mkString();
                return new Tuple2<String, String>((String)theirHash, ourHash);
            }).flatMap((Function1<Tuple2, Either> & Serializable)x$3 -> {
                Tuple2 tuple2 = x$3;
                if (tuple2 != null) {
                    String theirHash = (String)tuple2._1();
                    String ourHash = (String)tuple2._2();
                    String string2 = theirHash;
                    String string3 = ourHash;
                    return scala.package$.MODULE$.Either().cond(!(string2 != null ? !string2.equals(string3) : string3 != null), () -> {}, (Function0<Error.Parsing> & Serializable)() -> new Error.Parsing(new StringBuilder(38).append("Mismatching hashes! Expected ").append(ourHash).append(" but got ").append(theirHash).toString())).flatMap((Function1<BoxedUnit, Either> & Serializable)x$2 -> {
                        BoxedUnit boxedUnit = x$2;
                        return package$.MODULE$.ArchivePayloadParser().fromByteString(lf.getPayload()).flatMap((Function1<DamlLf.ArchivePayload, Either> & Serializable)proto -> MODULE$.readArchivePayload(theirHash, (DamlLf.ArchivePayload)proto).map((Function1<ArchivePayload, ArchivePayload> & Serializable)payload -> payload));
                    });
                }
                throw new MatchError(tuple2);
            });
        }
        if (DamlLf.HashFunction.UNRECOGNIZED.equals(hashFunction)) {
            return scala.package$.MODULE$.Left().apply(new Error.Parsing("Unrecognized hash function"));
        }
        throw new MatchError(hashFunction);
    }

    private Either<Error, LanguageMajorVersion> readArchiveVersion(DamlLf.ArchivePayload lf) throws Error.Parsing {
        DamlLf.ArchivePayload.SumCase sumCase = lf.getSumCase();
        if (DamlLf.ArchivePayload.SumCase.DAML_LF_1.equals(sumCase)) {
            return scala.package$.MODULE$.Right().apply(LanguageMajorVersion$V1$.MODULE$);
        }
        if (DamlLf.ArchivePayload.SumCase.SUM_NOT_SET.equals(sumCase)) {
            return scala.package$.MODULE$.Left().apply(new Error.Parsing("Unrecognized LF version"));
        }
        throw new MatchError(sumCase);
    }

    public Either<Error, ArchivePayload> readArchivePayload(String hash2, DamlLf.ArchivePayload lf) throws Error.Parsing {
        return this.readArchiveVersion(lf).flatMap((Function1<LanguageMajorVersion, Either> & Serializable)majorVersion -> majorVersion.toVersion(lf.getMinor()).left().map(Error$Parsing$.MODULE$).map((Function1<LanguageVersion, ArchivePayload> & Serializable)version -> new ArchivePayload(hash2, lf, (LanguageVersion)version)));
    }

    private Reader$() {
    }
}

