/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
final class Serialization {
    private Serialization() {
    }

    static int readCount(ObjectInputStream stream2) throws IOException {
        return stream2.readInt();
    }

    static <K, V> void writeMap(Map<K, V> map2, ObjectOutputStream stream2) throws IOException {
        stream2.writeInt(map2.size());
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            stream2.writeObject(entry.getKey());
            stream2.writeObject(entry.getValue());
        }
    }

    static <K, V> void populateMap(Map<K, V> map2, ObjectInputStream stream2) throws IOException, ClassNotFoundException {
        int size = stream2.readInt();
        Serialization.populateMap(map2, stream2, size);
    }

    static <K, V> void populateMap(Map<K, V> map2, ObjectInputStream stream2, int size) throws IOException, ClassNotFoundException {
        for (int i = 0; i < size; ++i) {
            Object key = stream2.readObject();
            Object value = stream2.readObject();
            map2.put(key, value);
        }
    }

    static <E> void writeMultiset(Multiset<E> multiset, ObjectOutputStream stream2) throws IOException {
        int entryCount = multiset.entrySet().size();
        stream2.writeInt(entryCount);
        for (Multiset.Entry<E> entry : multiset.entrySet()) {
            stream2.writeObject(entry.getElement());
            stream2.writeInt(entry.getCount());
        }
    }

    static <E> void populateMultiset(Multiset<E> multiset, ObjectInputStream stream2) throws IOException, ClassNotFoundException {
        int distinctElements = stream2.readInt();
        Serialization.populateMultiset(multiset, stream2, distinctElements);
    }

    static <E> void populateMultiset(Multiset<E> multiset, ObjectInputStream stream2, int distinctElements) throws IOException, ClassNotFoundException {
        for (int i = 0; i < distinctElements; ++i) {
            Object element = stream2.readObject();
            int count = stream2.readInt();
            multiset.add(element, count);
        }
    }

    static <K, V> void writeMultimap(Multimap<K, V> multimap, ObjectOutputStream stream2) throws IOException {
        stream2.writeInt(multimap.asMap().size());
        for (Map.Entry<K, Collection<V>> entry : multimap.asMap().entrySet()) {
            stream2.writeObject(entry.getKey());
            stream2.writeInt(entry.getValue().size());
            for (V value : entry.getValue()) {
                stream2.writeObject(value);
            }
        }
    }

    static <K, V> void populateMultimap(Multimap<K, V> multimap, ObjectInputStream stream2) throws IOException, ClassNotFoundException {
        int distinctKeys = stream2.readInt();
        Serialization.populateMultimap(multimap, stream2, distinctKeys);
    }

    static <K, V> void populateMultimap(Multimap<K, V> multimap, ObjectInputStream stream2, int distinctKeys) throws IOException, ClassNotFoundException {
        for (int i = 0; i < distinctKeys; ++i) {
            Object key = stream2.readObject();
            Collection<V> values2 = multimap.get(key);
            int valueCount = stream2.readInt();
            for (int j = 0; j < valueCount; ++j) {
                Object value = stream2.readObject();
                values2.add(value);
            }
        }
    }

    static <T> FieldSetter<T> getFieldSetter(Class<T> clazz, String fieldName) {
        try {
            Field field2 = clazz.getDeclaredField(fieldName);
            return new FieldSetter(field2);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    static final class FieldSetter<T> {
        private final Field field;

        private FieldSetter(Field field2) {
            this.field = field2;
            field2.setAccessible(true);
        }

        void set(T instance, Object value) {
            try {
                this.field.set(instance, value);
            }
            catch (IllegalAccessException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        void set(T instance, int value) {
            try {
                this.field.set(instance, value);
            }
            catch (IllegalAccessException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }
    }
}

