/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.archive.testing;

import com.daml.SafeProto$;
import com.daml.crypto.MessageDigestPrototype$;
import com.daml.daml_lf_dev.DamlLf;
import com.daml.lf.archive.testing.Encode;
import com.daml.lf.archive.testing.EncodeV1;
import com.daml.lf.data.Ref$;
import com.daml.lf.language.Ast;
import com.daml.lf.language.LanguageMajorVersion;
import com.daml.lf.language.LanguageMinorVersion;
import com.daml.lf.language.LanguageVersion;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;

public final class Encode$ {
    public static final Encode$ MODULE$ = new Encode$();

    private DamlLf.ArchivePayload encodePayloadOfVersion(Tuple2<String, Ast.GenPackage<Ast.Expr>> idAndPkg, LanguageVersion version) {
        Tuple2<String, Ast.GenPackage<Ast.Expr>> tuple2 = idAndPkg;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String pkgId = (String)tuple2._1();
        Ast.GenPackage pkg = (Ast.GenPackage)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)pkgId, (Object)pkg);
        String pkgId2 = (String)tuple22._1();
        Ast.GenPackage pkg2 = (Ast.GenPackage)tuple22._2();
        LanguageVersion languageVersion = version;
        if (languageVersion == null) {
            throw new MatchError((Object)languageVersion);
        }
        LanguageMajorVersion major = languageVersion.major();
        LanguageMinorVersion minor = languageVersion.minor();
        Tuple2 tuple23 = new Tuple2((Object)major, (Object)minor);
        LanguageMajorVersion major2 = (LanguageMajorVersion)tuple23._1();
        LanguageMinorVersion minor2 = (LanguageMinorVersion)tuple23._2();
        LanguageMajorVersion languageMajorVersion = major2;
        if (LanguageMajorVersion.V1$.MODULE$.equals(languageMajorVersion)) {
            return DamlLf.ArchivePayload.newBuilder().setMinor(minor2.toProtoIdentifier()).setDamlLf1(new EncodeV1(minor2).encodePackage(pkgId2, (Ast.GenPackage<Ast.Expr>)pkg2)).build();
        }
        throw package$.MODULE$.error(new StringBuilder(14).append(version).append(" not supported").toString());
    }

    public final DamlLf.Archive encodeArchive(Tuple2<String, Ast.GenPackage<Ast.Expr>> pkg, LanguageVersion version) {
        ByteString payload = (ByteString)com.daml.lf.data.package$.MODULE$.assertRight(SafeProto$.MODULE$.toByteString((AbstractMessageLite)this.encodePayloadOfVersion(pkg, version)));
        String hash = (String)Ref$.MODULE$.PackageId().assertFromString(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(MessageDigestPrototype$.MODULE$.Sha256().newDigest().digest(payload.toByteArray())), (Function1 & Serializable)x$3 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)x$3))})), ClassTag$.MODULE$.apply(String.class))).mkString());
        return DamlLf.Archive.newBuilder().setHashFunction(DamlLf.HashFunction.SHA256).setPayload(payload).setHash(hash).build();
    }

    public void unexpectedError() {
        throw new Encode.EncodeError("unexpected error");
    }

    public void expect(boolean b) {
        if (!b) {
            this.unexpectedError();
            return;
        }
    }

    private Encode$() {
    }
}

