/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.speedy;

import com.daml.lf.data.FrontStack;
import com.daml.lf.data.ImmArray;
import com.daml.lf.data.Ref;
import com.daml.lf.data.SortedLookupList;
import com.daml.lf.data.Time;
import com.daml.lf.data.package$;
import com.daml.lf.interpretation.Error;
import com.daml.lf.ledger.EventId;
import com.daml.lf.ledger.FailedAuthorization;
import com.daml.lf.scenario.ScenarioLedger;
import com.daml.lf.speedy.SError;
import com.daml.lf.transaction.GlobalKey;
import com.daml.lf.transaction.Node;
import com.daml.lf.transaction.NodeId;
import com.daml.lf.transaction.TransactionVersion;
import com.daml.lf.transaction.Versioned;
import com.daml.lf.value.Value;
import java.io.Serializable;
import java.math.BigDecimal;
import org.typelevel.paiges.Doc;
import org.typelevel.paiges.Doc$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class Pretty$ {
    public static Pretty$ MODULE$;

    static {
        new Pretty$();
    }

    public Doc prettyError(SError.SError err) {
        Doc doc;
        Doc doc2 = Doc$.MODULE$.text("Error:");
        SError.SError sError = err;
        if (sError instanceof SError.SErrorDamlException) {
            SError.SErrorDamlException sErrorDamlException = (SError.SErrorDamlException)sError;
            doc = this.prettyDamlException(sErrorDamlException.error());
        } else if (sError instanceof SError.SErrorCrash) {
            SError.SErrorCrash sErrorCrash = (SError.SErrorCrash)sError;
            String where = sErrorCrash.location();
            String reason = sErrorCrash.reason();
            doc = Doc$.MODULE$.text(new StringBuilder(11).append("CRASH in ").append(where).append(": ").append(reason).toString());
        } else {
            throw new MatchError((Object)sError);
        }
        return doc2.$amp(doc);
    }

    public Doc prettyParty(String p) {
        return Doc$.MODULE$.char('\'').$plus(Doc$.MODULE$.text(p)).$plus(Doc$.MODULE$.char('\''));
    }

    public Doc prettyDamlException(Error error) {
        Doc doc;
        Error error2 = error;
        if (error2 instanceof Error.FailedAuthorization) {
            Error.FailedAuthorization failedAuthorization = (Error.FailedAuthorization)error2;
            NodeId nid = failedAuthorization.nid();
            FailedAuthorization fa = failedAuthorization.fa();
            doc = Doc$.MODULE$.text(this.prettyFailedAuthorization(nid, fa));
        } else if (error2 instanceof Error.UnhandledException) {
            Error.UnhandledException unhandledException = (Error.UnhandledException)error2;
            Value value = unhandledException.value();
            doc = Doc$.MODULE$.text("Unhandled exception:").$amp(this.prettyValue(true, value));
        } else if (error2 instanceof Error.UserError) {
            Error.UserError userError = (Error.UserError)error2;
            String message = userError.message();
            doc = Doc$.MODULE$.text(new StringBuilder(12).append("User abort: ").append(message).toString());
        } else if (error2 instanceof Error.TemplatePreconditionViolated) {
            Error.TemplatePreconditionViolated templatePreconditionViolated = (Error.TemplatePreconditionViolated)error2;
            Ref.Identifier templateId = templatePreconditionViolated.templateId();
            Value arg = templatePreconditionViolated.arg();
            doc = Doc$.MODULE$.text("Update failed due to precondition violation when creating").$amp(this.prettyTypeConName(templateId)).$amp(Doc$.MODULE$.text("with")).$amp(this.prettyValue(true, arg));
        } else if (error2 instanceof Error.ContractNotActive) {
            Error.ContractNotActive contractNotActive = (Error.ContractNotActive)error2;
            Value.ContractId coid = contractNotActive.coid();
            Ref.Identifier tid = contractNotActive.templateId();
            NodeId consumedBy = contractNotActive.consumedBy();
            doc = Doc$.MODULE$.text("Update failed due to fetch of an inactive contract").$amp(this.prettyContractId(coid)).$amp(Doc$.MODULE$.char('(').$plus(this.prettyTypeConName(tid)).$plus(Doc$.MODULE$.text(").").$div(Doc$.MODULE$.text(new StringBuilder(52).append("The contract had been consumed in sub-transaction #").append(consumedBy).append(":").toString()))));
        } else if (error2 instanceof Error.ContractKeyNotFound) {
            Error.ContractKeyNotFound contractKeyNotFound = (Error.ContractKeyNotFound)error2;
            GlobalKey gk = contractKeyNotFound.key();
            doc = Doc$.MODULE$.text("Update failed due to fetch-by-key or exercise-by-key which did not find a contract with key").$amp(this.prettyValue(false, gk.key())).$amp(Doc$.MODULE$.char('(').$plus(this.prettyIdentifier(gk.templateId())).$plus(Doc$.MODULE$.char(')')));
        } else if (error2 instanceof Error.LocalContractKeyNotVisible) {
            Error.LocalContractKeyNotVisible localContractKeyNotVisible = (Error.LocalContractKeyNotVisible)error2;
            Value.ContractId coid = localContractKeyNotVisible.coid();
            GlobalKey gk = localContractKeyNotVisible.key();
            Set actAs = localContractKeyNotVisible.actAs();
            Set readAs = localContractKeyNotVisible.readAs();
            Set stakeholders = localContractKeyNotVisible.stakeholders();
            Doc qual$1 = Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), (Iterable)actAs.map((Function1 & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom()));
            Doc x$1 = Doc$.MODULE$.char('{');
            Doc x$2 = Doc$.MODULE$.char('}');
            int x$3 = qual$1.tightBracketBy$default$3();
            Doc qual$2 = Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), (Iterable)readAs.map((Function1 & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom()));
            Doc x$4 = Doc$.MODULE$.char('{');
            Doc x$5 = Doc$.MODULE$.char('}');
            int x$6 = qual$2.tightBracketBy$default$3();
            doc = Doc$.MODULE$.text("Update failed due to a fetch, lookup or exercise by key of contract not visible to the reading parties").$amp(this.prettyContractId(coid)).$amp(Doc$.MODULE$.char('(').$plus(this.prettyIdentifier(gk.templateId())).$plus(Doc$.MODULE$.text(") associated with key ")).$plus(this.prettyValue(false, gk.key()))).$amp(Doc$.MODULE$.text("No reading party is a stakeholder:")).$amp(Doc$.MODULE$.text("actAs:")).$amp(qual$1.tightBracketBy(x$1, x$2, x$3)).$amp(Doc$.MODULE$.text("readAs:")).$amp(qual$2.tightBracketBy(x$4, x$5, x$6).$plus(Doc$.MODULE$.char('.').$div(Doc$.MODULE$.text("Stakeholders:")))).$amp(Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), (Iterable)stakeholders.map((Function1 & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom())).$plus(Doc$.MODULE$.char('.')));
        } else if (error2 instanceof Error.DuplicateContractKey) {
            Error.DuplicateContractKey duplicateContractKey = (Error.DuplicateContractKey)error2;
            GlobalKey key = duplicateContractKey.key();
            doc = Doc$.MODULE$.text("Update failed due to a duplicate contract key").$amp(this.prettyValue(false, key.key()));
        } else if (error2 instanceof Error.WronglyTypedContract) {
            Error.WronglyTypedContract wronglyTypedContract = (Error.WronglyTypedContract)error2;
            Value.ContractId coid = wronglyTypedContract.coid();
            Ref.Identifier expected = wronglyTypedContract.expected();
            Ref.Identifier actual = wronglyTypedContract.actual();
            doc = Doc$.MODULE$.text("Update failed due to wrongly typed contract id").$amp(this.prettyContractId(coid).$div(Doc$.MODULE$.text("Expected contract of type"))).$amp(this.prettyTypeConName(expected)).$amp(Doc$.MODULE$.text("but got")).$amp(this.prettyTypeConName(actual));
        } else if (error2 instanceof Error.CreateEmptyContractKeyMaintainers) {
            Error.CreateEmptyContractKeyMaintainers createEmptyContractKeyMaintainers = (Error.CreateEmptyContractKeyMaintainers)error2;
            Ref.Identifier tid = createEmptyContractKeyMaintainers.templateId();
            Value arg = createEmptyContractKeyMaintainers.arg();
            Value key = createEmptyContractKeyMaintainers.key();
            doc = Doc$.MODULE$.text("Update failed due to a contract key with an empty sey of maintainers when creating").$amp(this.prettyTypeConName(tid)).$amp(Doc$.MODULE$.text("with")).$amp(this.prettyValue(true, arg).$div(Doc$.MODULE$.text("The computed key is"))).$amp(this.prettyValue(true, key));
        } else if (error2 instanceof Error.FetchEmptyContractKeyMaintainers) {
            Error.FetchEmptyContractKeyMaintainers fetchEmptyContractKeyMaintainers = (Error.FetchEmptyContractKeyMaintainers)error2;
            Ref.Identifier tid = fetchEmptyContractKeyMaintainers.templateId();
            Value key = fetchEmptyContractKeyMaintainers.key();
            doc = Doc$.MODULE$.text("Update failed due to a contract key with an empty sey of maintainers when fetching or looking up by key").$amp(this.prettyTypeConName(tid).$div(Doc$.MODULE$.text("The provided key is"))).$amp(this.prettyValue(true, key));
        } else if (error2 instanceof Error.ContractNotFound) {
            Error.ContractNotFound contractNotFound = (Error.ContractNotFound)error2;
            Value.ContractId cid = contractNotFound.cid();
            doc = Doc$.MODULE$.text("Update failed due to a unknown contract").$amp(this.prettyContractId(cid));
        } else if (Error.NonComparableValues$.MODULE$.equals(error2)) {
            doc = Doc$.MODULE$.text("functions are not comparable");
        } else if (error2 instanceof Error.ContractIdComparability) {
            Error.ContractIdComparability contractIdComparability = (Error.ContractIdComparability)error2;
            Value.ContractId$.V1 globalCid = contractIdComparability.globalCid();
            doc = Doc$.MODULE$.text("The global contract ID").$amp(this.prettyContractId((Value.ContractId)globalCid)).$amp(Doc$.MODULE$.text("conflicts with a local contract ID"));
        } else if (error2 instanceof Error.ContractIdInContractKey) {
            Error.ContractIdInContractKey contractIdInContractKey = (Error.ContractIdInContractKey)error2;
            Value key = contractIdInContractKey.key();
            doc = Doc$.MODULE$.text("Contract IDs are not supported in contract keys:").$amp(this.prettyContractId((Value.ContractId)key.cids().head()));
        } else if (Error.ValueExceedsMaxNesting$.MODULE$.equals(error2)) {
            doc = Doc$.MODULE$.text("Value exceeds maximum nesting value of 100");
        } else {
            throw new MatchError((Object)error2);
        }
        return doc;
    }

    public Doc prettyPartialTransactionNode(Node node) {
        Doc doc;
        Node node2 = node;
        if (node2 instanceof Node.Rollback) {
            doc = Doc$.MODULE$.text("rollback");
        } else if (node2 instanceof Node.Create) {
            Node.Create create = (Node.Create)node2;
            String string = "create";
            doc = this.prettyContractInst(create.coinst()).$amp$colon(string);
        } else if (node2 instanceof Node.Fetch) {
            Node.Fetch fetch = (Node.Fetch)node2;
            String string = "fetch";
            doc = this.prettyContractId(fetch.coid()).$amp$colon(string);
        } else if (node2 instanceof Node.Exercise) {
            Node.Exercise exercise = (Node.Exercise)node2;
            doc = Doc$.MODULE$.intercalate(Doc$.MODULE$.text(", "), (Iterable)exercise.actingParties().map((Function1 & Serializable & scala.Serializable)p -> Doc$.MODULE$.text(p), Set$.MODULE$.canBuildFrom())).$amp(Doc$.MODULE$.text("exercises")).$amp(Doc$.MODULE$.text(exercise.choiceId()).$plus(Doc$.MODULE$.char(':')).$plus(this.prettyIdentifier(exercise.templateId()))).$amp(Doc$.MODULE$.text("on")).$amp(this.prettyContractId(exercise.targetCoid()).$div(Doc$.MODULE$.text("with"))).$amp(this.prettyValue(false, exercise.chosenValue()));
        } else if (node2 instanceof Node.LookupByKey) {
            Doc doc2;
            Node.LookupByKey lookupByKey = (Node.LookupByKey)node2;
            Doc doc3 = Doc$.MODULE$.text("lookup by key").$amp(this.prettyIdentifier(lookupByKey.templateId()).$div(Doc$.MODULE$.text("key")));
            Doc doc4 = this.prettyKeyWithMaintainers(lookupByKey.key());
            Option option = lookupByKey.result();
            if (None$.MODULE$.equals(option)) {
                doc2 = Doc$.MODULE$.text("not found");
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Value.ContractId coid = (Value.ContractId)some.value();
                doc2 = Doc$.MODULE$.text("found").$amp(this.prettyContractId(coid));
            } else {
                throw new MatchError((Object)option);
            }
            doc = doc3.$amp(doc4.$div(doc2));
        } else {
            throw new MatchError((Object)node2);
        }
        return doc;
    }

    private String prettyFailedAuthorization(NodeId id, FailedAuthorization failure) {
        String string;
        FailedAuthorization failedAuthorization = failure;
        if (failedAuthorization instanceof FailedAuthorization.NoControllers) {
            FailedAuthorization.NoControllers noControllers = (FailedAuthorization.NoControllers)failedAuthorization;
            string = new StringBuilder(27).append("node ").append(id).append(" (").append(noControllers.templateId()).append(") has no controllers").toString();
        } else if (failedAuthorization instanceof FailedAuthorization.CreateMissingAuthorization) {
            FailedAuthorization.CreateMissingAuthorization createMissingAuthorization = (FailedAuthorization.CreateMissingAuthorization)failedAuthorization;
            string = new StringBuilder(52).append("node ").append(id).append(" (").append(createMissingAuthorization.templateId()).append(") requires authorizers ").append(createMissingAuthorization.requiredParties().mkString(",")).append(", but only ").append(createMissingAuthorization.authorizingParties().mkString(",")).append(" were given").toString();
        } else if (failedAuthorization instanceof FailedAuthorization.FetchMissingAuthorization) {
            FailedAuthorization.FetchMissingAuthorization fetchMissingAuthorization = (FailedAuthorization.FetchMissingAuthorization)failedAuthorization;
            string = new StringBuilder(106).append("node ").append(id).append(" requires one of the stakeholders ").append(fetchMissingAuthorization.stakeholders()).append(" of the fetched contract to be an authorizer, but authorizers were ").append(fetchMissingAuthorization.authorizingParties()).toString();
        } else if (failedAuthorization instanceof FailedAuthorization.ExerciseMissingAuthorization) {
            FailedAuthorization.ExerciseMissingAuthorization exerciseMissingAuthorization = (FailedAuthorization.ExerciseMissingAuthorization)failedAuthorization;
            string = new StringBuilder(52).append("node ").append(id).append(" (").append(exerciseMissingAuthorization.templateId()).append(") requires authorizers ").append(exerciseMissingAuthorization.requiredParties().mkString(",")).append(", but only ").append(exerciseMissingAuthorization.authorizingParties().mkString(",")).append(" were given").toString();
        } else if (failedAuthorization instanceof FailedAuthorization.NoSignatories) {
            FailedAuthorization.NoSignatories noSignatories = (FailedAuthorization.NoSignatories)failedAuthorization;
            string = new StringBuilder(27).append("node ").append(id).append(" (").append(noSignatories.templateId()).append(") has no signatories").toString();
        } else if (failedAuthorization instanceof FailedAuthorization.LookupByKeyMissingAuthorization) {
            FailedAuthorization.LookupByKeyMissingAuthorization lookupByKeyMissingAuthorization = (FailedAuthorization.LookupByKeyMissingAuthorization)failedAuthorization;
            string = new StringBuilder(66).append("node ").append(id).append(" (").append(lookupByKeyMissingAuthorization.templateId()).append(") requires authorizers ").append(lookupByKeyMissingAuthorization.maintainers()).append(" for lookup by key, but it only has ").append(lookupByKeyMissingAuthorization.authorizingParties()).toString();
        } else if (failedAuthorization instanceof FailedAuthorization.MaintainersNotSubsetOfSignatories) {
            FailedAuthorization.MaintainersNotSubsetOfSignatories maintainersNotSubsetOfSignatories = (FailedAuthorization.MaintainersNotSubsetOfSignatories)failedAuthorization;
            string = new StringBuilder(68).append("node ").append(id).append(" (").append(maintainersNotSubsetOfSignatories.templateId()).append(") has maintainers ").append(maintainersNotSubsetOfSignatories.maintainers()).append(" which are not a subset of the signatories ").append(maintainersNotSubsetOfSignatories.signatories()).toString();
        } else {
            throw new MatchError((Object)failedAuthorization);
        }
        return string;
    }

    public Doc prettyValueRef(Ref.Identifier ref) {
        return Doc$.MODULE$.text(new StringBuilder(1).append(ref.qualifiedName().toString()).append("@").append(ref.packageId()).toString());
    }

    public Doc prettyLedger(ScenarioLedger l) {
        return Doc$.MODULE$.text("transactions:").$div(this.prettyTransactions(l)).$div(Doc$.MODULE$.line()).$plus(Doc$.MODULE$.text("active contracts:").$div(this.prettyActiveContracts(l.ledgerData())).nested(3));
    }

    public Doc prettyTransactions(ScenarioLedger l) {
        return Doc$.MODULE$.intercalate(Doc$.MODULE$.line().$plus(Doc$.MODULE$.line()), (Iterable)l.scenarioSteps().values().map((Function1 & Serializable & scala.Serializable)step -> MODULE$.prettyScenarioStep(l, (ScenarioLedger.ScenarioStep)step), Iterable$.MODULE$.canBuildFrom()));
    }

    public Doc prettyLoc(Option<Ref.Location> optLoc) {
        return (Doc)optLoc.map((Function1 & Serializable & scala.Serializable)l -> Doc$.MODULE$.text(new StringBuilder(2).append("[").append(l.module().toString()).append(":").toString()).$plus(Doc$.MODULE$.str((Object)BoxesRunTime.boxToInteger((int)(l.start()._1$mcI$sp() + 1)))).$plus(Doc$.MODULE$.text("]"))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Doc$.MODULE$.text("[unknown source]"));
    }

    public Doc prettyScenarioStep(ScenarioLedger l, ScenarioLedger.ScenarioStep step) {
        Doc doc;
        ScenarioLedger.ScenarioStep scenarioStep = step;
        if (scenarioStep instanceof ScenarioLedger.Commit) {
            ScenarioLedger.Commit commit = (ScenarioLedger.Commit)scenarioStep;
            ScenarioLedger.TransactionId txId = commit.txId();
            ScenarioLedger.RichTransaction rtx = commit.richTransaction();
            Option<Ref.Location> optLoc = commit.optLocation();
            Doc children = Doc$.MODULE$.intercalate(Doc$.MODULE$.line().$plus(Doc$.MODULE$.line()), (Iterable)rtx.transaction().roots().toList().map((Function1 & Serializable & scala.Serializable)nodeId -> MODULE$.prettyEventInfo(l, txId, (NodeId)nodeId), List$.MODULE$.canBuildFrom()));
            doc = Doc$.MODULE$.text("TX").$amp(Doc$.MODULE$.char('#').$plus(Doc$.MODULE$.str((Object)txId.id()))).$amp(Doc$.MODULE$.str((Object)rtx.effectiveAt())).$amp(this.prettyLoc(optLoc)).$amp(Doc$.MODULE$.text("version:")).$amp(Doc$.MODULE$.str((Object)rtx.transaction().version().protoValue()).$div(children));
        } else if (scenarioStep instanceof ScenarioLedger.PassTime) {
            ScenarioLedger.PassTime passTime = (ScenarioLedger.PassTime)scenarioStep;
            long dt = passTime.dtMicros();
            String string = "pass";
            doc = Doc$.MODULE$.str((Object)BoxesRunTime.boxToLong((long)dt)).$amp$colon(string);
        } else if (scenarioStep instanceof ScenarioLedger.AssertMustFail) {
            ScenarioLedger.AssertMustFail assertMustFail = (ScenarioLedger.AssertMustFail)scenarioStep;
            Doc qual$1 = Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), (Iterable)assertMustFail.actAs().map((Function1 & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom()));
            Doc x$1 = Doc$.MODULE$.char('{');
            Doc x$2 = Doc$.MODULE$.char('}');
            int x$3 = qual$1.tightBracketBy$default$3();
            Doc qual$2 = Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), (Iterable)assertMustFail.readAs().map((Function1 & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom()));
            Doc x$4 = Doc$.MODULE$.char('{');
            Doc x$5 = Doc$.MODULE$.char('}');
            int x$6 = qual$2.tightBracketBy$default$3();
            doc = Doc$.MODULE$.text("mustFailAt").$amp(Doc$.MODULE$.text("actAs:")).$amp(qual$1.tightBracketBy(x$1, x$2, x$3)).$amp(Doc$.MODULE$.text("readAs:")).$amp(qual$2.tightBracketBy(x$4, x$5, x$6)).$amp(this.prettyLoc(assertMustFail.optLocation()));
        } else {
            throw new MatchError((Object)scenarioStep);
        }
        return doc;
    }

    public Doc prettyKeyWithMaintainers(Node.KeyWithMaintainers key) {
        return this.prettyValue(false, key.key());
    }

    public Doc prettyVersionedKeyWithMaintainers(Versioned<Node.KeyWithMaintainers> key) {
        return this.prettyKeyWithMaintainers((Node.KeyWithMaintainers)key.unversioned());
    }

    public Doc prettyEventInfo(ScenarioLedger l, ScenarioLedger.TransactionId txId, NodeId nodeId2) {
        Doc doc;
        Doc doc2;
        EventId eventId = new EventId(txId.id(), nodeId2);
        ScenarioLedger.LedgerNodeInfo ni = (ScenarioLedger.LedgerNodeInfo)l.ledgerData().nodeInfos().apply((Object)eventId);
        Node node = ni.node();
        if (node instanceof Node.Rollback) {
            Node.Rollback rollback = (Node.Rollback)node;
            ImmArray children = rollback.children();
            doc2 = Doc$.MODULE$.text("rollback:").$div(Doc$.MODULE$.stack((Iterable)children.toList().map((Function1 & Serializable & scala.Serializable)nodeId -> MODULE$.prettyEventInfo(l, txId, (NodeId)nodeId), List$.MODULE$.canBuildFrom())));
        } else if (node instanceof Node.Create) {
            Doc doc3;
            Node.Create create = (Node.Create)node;
            String string = "create";
            Doc d = this.prettyContractInst(create.coinst()).$amp$colon(string);
            Option option = create.versionedKey();
            if (None$.MODULE$.equals(option)) {
                doc3 = d;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Versioned key = (Versioned)some.value();
                doc3 = d.$div(Doc$.MODULE$.text("key")).$amp(this.prettyVersionedKeyWithMaintainers((Versioned<Node.KeyWithMaintainers>)key));
            } else {
                throw new MatchError((Object)option);
            }
            doc2 = doc3;
        } else if (node instanceof Node.Fetch) {
            Node.Fetch fetch = (Node.Fetch)node;
            String string = "ensure active";
            doc2 = this.prettyContractId(fetch.coid()).$amp$colon(string);
        } else if (node instanceof Node.Exercise) {
            Node.Exercise exercise = (Node.Exercise)node;
            Doc children = exercise.children().nonEmpty() ? Doc$.MODULE$.text("children:").$div(Doc$.MODULE$.stack((Iterable)exercise.children().toList().map((Function1 & Serializable & scala.Serializable)nodeId -> MODULE$.prettyEventInfo(l, txId, (NodeId)nodeId), List$.MODULE$.canBuildFrom()))) : Doc$.MODULE$.text("");
            doc2 = Doc$.MODULE$.intercalate(Doc$.MODULE$.text(", "), (Iterable)exercise.actingParties().map((Function1 & Serializable & scala.Serializable)p -> Doc$.MODULE$.text(p), Set$.MODULE$.canBuildFrom())).$amp(Doc$.MODULE$.text("exercises")).$amp(Doc$.MODULE$.text(exercise.choiceId()).$plus(Doc$.MODULE$.char(':')).$plus(this.prettyIdentifier(exercise.templateId()))).$amp(Doc$.MODULE$.text("on")).$amp(this.prettyContractId(exercise.targetCoid()).$div(Doc$.MODULE$.text("    ").$plus(Doc$.MODULE$.text("with")).$amp(this.prettyValue(false, exercise.chosenValue()).$div(children)).nested(4)));
        } else if (node instanceof Node.LookupByKey) {
            Doc doc4;
            Node.LookupByKey lookupByKey = (Node.LookupByKey)node;
            Doc doc5 = Doc$.MODULE$.text("lookup by key").$amp(this.prettyIdentifier(lookupByKey.templateId()).$div(Doc$.MODULE$.text("key")));
            Doc doc6 = this.prettyVersionedKeyWithMaintainers((Versioned<Node.KeyWithMaintainers>)lookupByKey.versionedKey());
            Option option = lookupByKey.result();
            if (None$.MODULE$.equals(option)) {
                doc4 = Doc$.MODULE$.text("not found");
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Value.ContractId coid = (Value.ContractId)some.value();
                doc4 = Doc$.MODULE$.text("found").$amp(this.prettyContractId(coid));
            } else {
                throw new MatchError((Object)option);
            }
            doc2 = doc5.$amp(doc6.$div(doc4));
        } else {
            throw new MatchError((Object)node);
        }
        Doc ppNode = doc2;
        Doc ppDisclosedTo = ni.disclosures().nonEmpty() ? Pretty$.meta$1(Doc$.MODULE$.text("known to (since):").$amp(Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), (Iterable)((TraversableLike)ni.disclosures().toSeq().sortWith((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)Pretty$.$anonfun$prettyEventInfo$4(x0$1, x1$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String p = (String)tuple2._1();
            ScenarioLedger.Disclosure d = (ScenarioLedger.Disclosure)tuple2._2();
            Doc doc = Doc$.MODULE$.text(p).$amp(Doc$.MODULE$.text("(#").$plus(Doc$.MODULE$.str((Object)d.since().id())).$plus(Doc$.MODULE$.char(')')));
            return doc;
        }, Seq$.MODULE$.canBuildFrom())))) : Doc$.MODULE$.text("");
        Doc ppReferencedBy = ni.referencedBy().nonEmpty() ? Pretty$.meta$1(Doc$.MODULE$.text("referenced by").$amp(Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), (Iterable)ni.referencedBy().toSeq().map((Function1 & Serializable & scala.Serializable)n -> MODULE$.prettyEventId((EventId)n), Seq$.MODULE$.canBuildFrom())))) : Doc$.MODULE$.text("");
        Option<EventId> option = ni.consumedBy();
        if (None$.MODULE$.equals(option)) {
            doc = Doc$.MODULE$.text("");
        } else if (option instanceof Some) {
            Some some = (Some)option;
            EventId nid = (EventId)some.value();
            String string = "archived by";
            doc = Pretty$.meta$1(this.prettyEventId(nid).$amp$colon(string));
        } else {
            throw new MatchError(option);
        }
        Doc ppArchivedBy = doc;
        return this.prettyEventId(eventId).$amp(this.prettyOptVersion((Option<TransactionVersion>)ni.node().optVersion()).$div(Doc$.MODULE$.stack((Iterable)((TraversableLike)new .colon.colon((Object)ppArchivedBy, (List)new .colon.colon((Object)ppReferencedBy, (List)new .colon.colon((Object)ppDisclosedTo, (List)new .colon.colon((Object)Pretty$.arrowRight$1(ppNode), (List)Nil$.MODULE$))))).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.nonEmpty())))));
    }

    public Doc prettyOptVersion(Option<TransactionVersion> opt) {
        Doc doc;
        Option<TransactionVersion> option = opt;
        if (option instanceof Some) {
            Some some = (Some)option;
            TransactionVersion v = (TransactionVersion)some.value();
            doc = Doc$.MODULE$.text("version:").$amp(Doc$.MODULE$.str((Object)v.protoValue()));
        } else if (None$.MODULE$.equals(option)) {
            doc = Doc$.MODULE$.text("no-version");
        } else {
            throw new MatchError(option);
        }
        return doc;
    }

    public Doc prettyEventId(EventId n) {
        return Doc$.MODULE$.text(n.toLedgerString());
    }

    public Doc prettyContractInst(Value.ContractInstance coinst) {
        return this.prettyIdentifier(coinst.template()).$div(Doc$.MODULE$.text("with:")).$amp(this.prettyValue(false, coinst.arg())).nested(4);
    }

    public Doc prettyTypeConName(Ref.Identifier tycon) {
        return Doc$.MODULE$.text(tycon.qualifiedName().toString()).$plus(Doc$.MODULE$.char('@')).$plus(this.prettyPackageId(tycon.packageId()));
    }

    public Doc prettyContractId(Value.ContractId coid) {
        return Doc$.MODULE$.text(coid.coid());
    }

    public Doc prettyActiveContracts(ScenarioLedger.LedgerData c) {
        return Doc$.MODULE$.fill(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), (Iterable)((List)c.activeContracts().toList().sortBy((Function1 & Serializable & scala.Serializable)x$8 -> x$8.toString(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)coid -> MODULE$.prettyContractId((Value.ContractId)coid), List$.MODULE$.canBuildFrom()));
    }

    public Doc prettyPackageId(String pkgId) {
        return Doc$.MODULE$.text((String)new StringOps(Predef$.MODULE$.augmentString(pkgId)).take(8));
    }

    public Doc prettyIdentifier(Ref.Identifier id) {
        return Doc$.MODULE$.text(id.qualifiedName().toString()).$plus(Doc$.MODULE$.char('@')).$plus(this.prettyPackageId(id.packageId()));
    }

    public Doc prettyVersionedValue(boolean verbose, Versioned<Value> v) {
        return this.prettyValue(verbose, (Value)v.unversioned());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Doc prettyValue(boolean verbose, Value v) {
        Option option;
        boolean bl = false;
        Value.ValueOptional valueOptional = null;
        Value value = v;
        if (value instanceof Value.ValueInt64) {
            Value.ValueInt64 valueInt64 = (Value.ValueInt64)value;
            long i = valueInt64.value();
            return Doc$.MODULE$.str((Object)BoxesRunTime.boxToLong((long)i));
        }
        if (value instanceof Value.ValueNumeric) {
            Value.ValueNumeric valueNumeric = (Value.ValueNumeric)value;
            BigDecimal d = valueNumeric.value();
            return Doc$.MODULE$.text(package$.MODULE$.Numeric().toString(d));
        }
        if (value instanceof Value.ValueRecord) {
            Doc doc;
            Value.ValueRecord valueRecord = (Value.ValueRecord)value;
            Option mbId = valueRecord.tycon();
            ImmArray fs = valueRecord.fields();
            Option option2 = mbId;
            if (None$.MODULE$.equals(option2)) {
                doc = Doc$.MODULE$.text("");
                return doc.$plus(Doc$.MODULE$.char('{')).$amp(Doc$.MODULE$.fill(Doc$.MODULE$.text(", "), (Iterable)fs.toList().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Option option = (Option)tuple2._1();
                        Value v = (Value)tuple2._2();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            String k = (String)some.value();
                            return Doc$.MODULE$.text(k).$amp(Doc$.MODULE$.char('=')).$amp(MODULE$.prettyValue(true, v));
                        }
                    }
                    if (tuple2 == null) throw new MatchError((Object)tuple2);
                    Option option = (Option)tuple2._1();
                    Value v = (Value)tuple2._2();
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
                    return Doc$.MODULE$.text("<no-label>").$amp(Doc$.MODULE$.char('=')).$amp(MODULE$.prettyValue(true, v));
                }, List$.MODULE$.canBuildFrom()))).$amp(Doc$.MODULE$.char('}'));
            } else {
                if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
                Some some = (Some)option2;
                Ref.Identifier id = (Ref.Identifier)some.value();
                doc = verbose ? this.prettyIdentifier(id) : Doc$.MODULE$.text("");
            }
            return doc.$plus(Doc$.MODULE$.char('{')).$amp(Doc$.MODULE$.fill(Doc$.MODULE$.text(", "), (Iterable)fs.toList().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Option option = (Option)tuple2._1();
                    Value v = (Value)tuple2._2();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String k = (String)some.value();
                        return Doc$.MODULE$.text(k).$amp(Doc$.MODULE$.char('=')).$amp(MODULE$.prettyValue(true, v));
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Option option = (Option)tuple2._1();
                Value v = (Value)tuple2._2();
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
                return Doc$.MODULE$.text("<no-label>").$amp(Doc$.MODULE$.char('=')).$amp(MODULE$.prettyValue(true, v));
            }, List$.MODULE$.canBuildFrom()))).$amp(Doc$.MODULE$.char('}'));
        }
        if (value instanceof Value.ValueVariant) {
            Doc doc;
            Value.ValueVariant valueVariant = (Value.ValueVariant)value;
            Option mbId = valueVariant.tycon();
            String variant = valueVariant.variant();
            Value value2 = valueVariant.value();
            Option option3 = mbId;
            if (None$.MODULE$.equals(option3)) {
                doc = Doc$.MODULE$.text("");
            } else {
                if (!(option3 instanceof Some)) throw new MatchError((Object)option3);
                Some some = (Some)option3;
                Ref.Identifier id = (Ref.Identifier)some.value();
                doc = verbose ? this.prettyIdentifier(id).$plus(Doc$.MODULE$.char(':')) : Doc$.MODULE$.text("");
            }
            Value value3 = value2;
            Doc doc2 = Value.ValueUnit$.MODULE$.equals(value3) ? Doc$.MODULE$.text(variant) : Doc$.MODULE$.text(variant).$plus(Doc$.MODULE$.char('(')).$plus(this.prettyValue(true, value2)).$plus(Doc$.MODULE$.char(')'));
            return doc.$plus(doc2);
        }
        if (value instanceof Value.ValueEnum) {
            Doc doc;
            Value.ValueEnum valueEnum = (Value.ValueEnum)value;
            Option mbId = valueEnum.tycon();
            String constructor = valueEnum.value();
            Option option4 = mbId;
            if (None$.MODULE$.equals(option4)) {
                doc = Doc$.MODULE$.text("");
                return doc.$plus(Doc$.MODULE$.text(constructor));
            } else {
                if (!(option4 instanceof Some)) throw new MatchError((Object)option4);
                Some some = (Some)option4;
                Ref.Identifier id = (Ref.Identifier)some.value();
                doc = verbose ? this.prettyIdentifier(id).$plus(Doc$.MODULE$.char(':')) : Doc$.MODULE$.text("");
            }
            return doc.$plus(Doc$.MODULE$.text(constructor));
        }
        if (value instanceof Value.ValueText) {
            Value.ValueText valueText = (Value.ValueText)value;
            String t = valueText.value();
            return Doc$.MODULE$.char('\"').$plus(Doc$.MODULE$.text(t)).$plus(Doc$.MODULE$.char('\"'));
        }
        if (value instanceof Value.ValueContractId) {
            Value.ValueContractId valueContractId = (Value.ValueContractId)value;
            Value.ContractId acoid = valueContractId.value();
            return Doc$.MODULE$.text(acoid.coid());
        }
        if (Value.ValueUnit$.MODULE$.equals(value)) {
            return Doc$.MODULE$.text("<unit>");
        }
        if (value instanceof Value.ValueBool) {
            Value.ValueBool valueBool = (Value.ValueBool)value;
            boolean b = valueBool.value();
            return Doc$.MODULE$.str((Object)BoxesRunTime.boxToBoolean((boolean)b));
        }
        if (value instanceof Value.ValueList) {
            Value.ValueList valueList = (Value.ValueList)value;
            FrontStack lst = valueList.values();
            return Doc$.MODULE$.char('[').$plus(Doc$.MODULE$.intercalate(Doc$.MODULE$.text(", "), (Iterable)lst.map((Function1 & Serializable & scala.Serializable)x$9 -> MODULE$.prettyValue(true, (Value)x$9)).toImmArray().toSeq())).$plus(Doc$.MODULE$.char(']'));
        }
        if (value instanceof Value.ValueTimestamp) {
            Value.ValueTimestamp valueTimestamp = (Value.ValueTimestamp)value;
            Time.Timestamp t = valueTimestamp.value();
            return Doc$.MODULE$.str((Object)t);
        }
        if (value instanceof Value.ValueDate) {
            Value.ValueDate valueDate = (Value.ValueDate)value;
            Time.Date days = valueDate.value();
            return Doc$.MODULE$.str((Object)days);
        }
        if (value instanceof Value.ValueParty) {
            Value.ValueParty valueParty = (Value.ValueParty)value;
            String p = valueParty.value();
            return Doc$.MODULE$.char('\'').$plus(Doc$.MODULE$.str((Object)p)).$plus(Doc$.MODULE$.char('\''));
        }
        if (value instanceof Value.ValueOptional) {
            bl = true;
            valueOptional = (Value.ValueOptional)value;
            Option option5 = valueOptional.value();
            if (option5 instanceof Some) {
                Some some = (Some)option5;
                Value v1 = (Value)some.value();
                return Doc$.MODULE$.text("Option(").$plus(this.prettyValue(verbose, v1)).$plus(Doc$.MODULE$.char(')'));
            }
        }
        if (bl && None$.MODULE$.equals(option = valueOptional.value())) {
            return Doc$.MODULE$.text("None");
        }
        if (value instanceof Value.ValueTextMap) {
            Value.ValueTextMap valueTextMap = (Value.ValueTextMap)value;
            SortedLookupList map = valueTextMap.value();
            ImmArray list = map.toImmArray().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                Value v = (Value)tuple2._2();
                Doc doc = Doc$.MODULE$.text(k).$plus(Doc$.MODULE$.text(" -> ")).$plus(MODULE$.prettyValue(verbose, v));
                return doc;
            });
            return Doc$.MODULE$.text("TextMap(").$plus(Doc$.MODULE$.intercalate(Doc$.MODULE$.text(", "), (Iterable)list.toSeq())).$plus(Doc$.MODULE$.text(")"));
        }
        if (!(value instanceof Value.ValueGenMap)) throw new MatchError((Object)value);
        Value.ValueGenMap valueGenMap = (Value.ValueGenMap)value;
        ImmArray entries = valueGenMap.entries();
        ImmArray list = entries.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Value k = (Value)tuple2._1();
            Value v = (Value)tuple2._2();
            Doc doc = MODULE$.prettyValue(verbose, k).$plus(Doc$.MODULE$.text(" -> ")).$plus(MODULE$.prettyValue(verbose, v));
            return doc;
        });
        return Doc$.MODULE$.text("GenMap(").$plus(Doc$.MODULE$.intercalate(Doc$.MODULE$.text(", "), (Iterable)list.toSeq())).$plus(Doc$.MODULE$.text(")"));
    }

    private static final Doc arrowRight$1(Doc d) {
        return Doc$.MODULE$.text("\u2514\u2500>").$amp(d);
    }

    private static final Doc meta$1(Doc d) {
        return Doc$.MODULE$.text("\u2502  ").$amp(d);
    }

    public static final /* synthetic */ boolean $anonfun$prettyEventInfo$4(Tuple2 x0$1, Tuple2 x1$1) {
        ScenarioLedger.Disclosure d1;
        String p1;
        Tuple2 tuple2;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = new Tuple2((Object)x0$1, (Object)x1$1);
                if (tuple22 == null) break block2;
                Tuple2 tuple23 = (Tuple2)tuple22._1();
                tuple2 = (Tuple2)tuple22._2();
                if (tuple23 == null) break block2;
                p1 = (String)tuple23._1();
                d1 = (ScenarioLedger.Disclosure)tuple23._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        String p2 = (String)tuple2._1();
        ScenarioLedger.Disclosure d2 = (ScenarioLedger.Disclosure)tuple2._2();
        boolean bl = d1.since().$less$eq(d2.since()) && new StringOps(Predef$.MODULE$.augmentString(p1)).$less((Object)p2);
        return bl;
    }

    private Pretty$() {
        MODULE$ = this;
    }
}

