/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.speedy;

import com.daml.lf.data.FrontStack;
import com.daml.lf.data.Ref;
import com.daml.lf.data.Ref$;
import com.daml.lf.data.Struct;
import com.daml.lf.data.Struct$;
import com.daml.lf.data.Time;
import com.daml.lf.data.package$;
import com.daml.lf.interpretation.Error;
import com.daml.lf.language.Ast$;
import com.daml.lf.ledger.FailedAuthorization;
import com.daml.lf.speedy.PartialTransaction;
import com.daml.lf.speedy.SBuiltin;
import com.daml.lf.speedy.SError;
import com.daml.lf.speedy.SValue;
import com.daml.lf.speedy.SValue$SBigNumeric$;
import com.daml.lf.speedy.SValue$SToken$;
import com.daml.lf.speedy.SValue$SUnit$;
import com.daml.lf.speedy.Speedy;
import com.daml.lf.transaction.GlobalKey;
import com.daml.lf.transaction.Node;
import com.daml.lf.transaction.NodeId;
import com.daml.lf.transaction.Transaction;
import com.daml.lf.value.Value;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.TreeSet;
import scala.collection.immutable.TreeSet$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class SBuiltin$ {
    public static SBuiltin$ MODULE$;
    private final Some<Object> SomeOne;
    private final Struct<BoxedUnit> keyWithMaintainersStructFields;
    private final int keyIdx;
    private final int maintainerIdx;
    private final Struct<Object> cachedContractStructFields;
    public final SBuiltin.SBStructCon com$daml$lf$speedy$SBuiltin$$cachedContractStruct;
    private final int cachedContractArgIdx;
    private final int cachedContractKeyIdx;
    private final int cachedContractSignatoriesIdx;
    private final int cachedContractObserversIdx;

    static {
        new SBuiltin$();
    }

    public <X> Option<X> com$daml$lf$speedy$SBuiltin$$handleArithmeticException(Function0<X> x) {
        Some some;
        try {
            some = new Some(x.apply());
        }
        catch (ArithmeticException arithmeticException) {
            some = None$.MODULE$;
        }
        return some;
    }

    public Option<Object> com$daml$lf$speedy$SBuiltin$$add(long x, long y) {
        return this.com$daml$lf$speedy$SBuiltin$$handleArithmeticException((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Math.addExact(x, y));
    }

    public Option<Object> com$daml$lf$speedy$SBuiltin$$div(long x, long y) {
        return y == 0L || x == Long.MIN_VALUE && y == -1L ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)(x / y)));
    }

    public Option<Object> com$daml$lf$speedy$SBuiltin$$mult(long x, long y) {
        return this.com$daml$lf$speedy$SBuiltin$$handleArithmeticException((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Math.multiplyExact(x, y));
    }

    public Option<Object> com$daml$lf$speedy$SBuiltin$$sub(long x, long y) {
        return this.com$daml$lf$speedy$SBuiltin$$handleArithmeticException((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Math.subtractExact(x, y));
    }

    public Option<Object> com$daml$lf$speedy$SBuiltin$$mod(long x, long y) {
        return y == 0L ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)(x % y)));
    }

    public Option<Object> com$daml$lf$speedy$SBuiltin$$exp(long base, long exponent) {
        return exponent < 0L ? None$.MODULE$ : (exponent == 0L ? this.SomeOne : this.com$daml$lf$speedy$SBuiltin$$handleArithmeticException((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
            long x = base;
            long y = 1L;
            for (long n = exponent; n > 1L; n >>= 1) {
                if (n % 2L == 1L) {
                    y = Math.multiplyExact(y, x);
                }
                x = Math.multiplyExact(x, x);
            }
            return Math.multiplyExact(x, y);
        }));
    }

    public Option<BigDecimal> com$daml$lf$speedy$SBuiltin$$add(BigDecimal x, BigDecimal y) {
        return package$.MODULE$.Numeric().add(x, y).toOption();
    }

    public Option<BigDecimal> com$daml$lf$speedy$SBuiltin$$subtract(BigDecimal x, BigDecimal y) {
        return package$.MODULE$.Numeric().subtract(x, y).toOption();
    }

    public Option<BigDecimal> com$daml$lf$speedy$SBuiltin$$multiply(int scale, BigDecimal x, BigDecimal y) {
        return package$.MODULE$.Numeric().multiply(scale, x, y).toOption();
    }

    public Option<BigDecimal> com$daml$lf$speedy$SBuiltin$$divide(int scale, BigDecimal x, BigDecimal y) {
        return y.signum() == 0 ? None$.MODULE$ : package$.MODULE$.Numeric().divide(scale, x, y).toOption();
    }

    public String com$daml$lf$speedy$SBuiltin$$litToText(String location, SValue x) {
        SValue.SBigNumeric sBigNumeric;
        Some<BigDecimal> some;
        String string;
        SValue sValue = x;
        if (sValue instanceof SValue.SBool) {
            SValue.SBool sBool = (SValue.SBool)sValue;
            boolean b = sBool.value();
            string = Boolean.toString(b);
        } else if (sValue instanceof SValue.SInt64) {
            SValue.SInt64 sInt64 = (SValue.SInt64)sValue;
            long i = sInt64.value();
            string = Long.toString(i);
        } else if (sValue instanceof SValue.STimestamp) {
            SValue.STimestamp sTimestamp = (SValue.STimestamp)sValue;
            Time.Timestamp t = sTimestamp.value();
            string = t.toString();
        } else if (sValue instanceof SValue.SText) {
            String t;
            SValue.SText sText = (SValue.SText)sValue;
            string = t = sText.value();
        } else if (sValue instanceof SValue.SParty) {
            String p;
            SValue.SParty sParty = (SValue.SParty)sValue;
            string = p = sParty.value();
        } else if (SValue$SUnit$.MODULE$.equals(sValue)) {
            string = "<unit>";
        } else if (sValue instanceof SValue.SDate) {
            SValue.SDate sDate = (SValue.SDate)sValue;
            Time.Date date = sDate.value();
            string = date.toString();
        } else if (sValue instanceof SValue.SBigNumeric && !(some = SValue$SBigNumeric$.MODULE$.unapply(sBigNumeric = (SValue.SBigNumeric)sValue)).isEmpty()) {
            BigDecimal x2 = (BigDecimal)some.get();
            string = package$.MODULE$.Numeric().toUnscaledString(x2);
        } else if (sValue instanceof SValue.SNumeric) {
            SValue.SNumeric sNumeric = (SValue.SNumeric)sValue;
            BigDecimal x3 = sNumeric.value();
            string = package$.MODULE$.Numeric().toUnscaledString(x3);
        } else if (sValue instanceof SValue.STNat) {
            SValue.STNat sTNat = (SValue.STNat)sValue;
            int n = sTNat.n();
            string = new StringBuilder(1).append("@").append(n).toString();
        } else {
            boolean bl = sValue instanceof SValue.SContractId ? true : (SValue$SToken$.MODULE$.equals(sValue) ? true : (sValue instanceof SValue.SAny ? true : (sValue instanceof SValue.SEnum ? true : (sValue instanceof SValue.SList ? true : (sValue instanceof SValue.SMap ? true : (sValue instanceof SValue.SOptional ? true : (sValue instanceof SValue.SPAP ? true : (sValue instanceof SValue.SRecord ? true : (sValue instanceof SValue.SStruct ? true : (sValue instanceof SValue.STypeRep ? true : sValue instanceof SValue.SVariant))))))))));
            if (bl) {
                throw new SError.SErrorCrash(location, new StringBuilder(22).append("litToText: unexpected ").append(x).toString());
            }
            throw new MatchError((Object)sValue);
        }
        return string;
    }

    public void checkAborted(PartialTransaction ptx) {
        Transaction.TransactionError transactionError;
        Transaction.TransactionError transactionError2;
        Transaction.TransactionError transactionError3;
        boolean bl = false;
        Some some = null;
        Option<Transaction.TransactionError> option = ptx.aborted();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Transaction.TransactionError transactionError4 = (Transaction.TransactionError)some.value();
            if (transactionError4 instanceof Transaction.AuthFailureDuringExecution) {
                Transaction.AuthFailureDuringExecution authFailureDuringExecution = (Transaction.AuthFailureDuringExecution)transactionError4;
                NodeId nid = authFailureDuringExecution.nid();
                FailedAuthorization fa = authFailureDuringExecution.fa();
                throw new SError.SErrorDamlException((Error)new Error.FailedAuthorization(nid, fa));
            }
        }
        if (bl && (transactionError3 = (Transaction.TransactionError)some.value()) instanceof Transaction.ContractNotActive) {
            Transaction.ContractNotActive contractNotActive = (Transaction.ContractNotActive)transactionError3;
            Value.ContractId coid = contractNotActive.coid();
            Ref.Identifier tid = contractNotActive.templateId();
            NodeId consumedBy = contractNotActive.consumedBy();
            throw new SError.SErrorDamlException((Error)new Error.ContractNotActive(coid, tid, consumedBy));
        }
        if (bl && (transactionError2 = (Transaction.TransactionError)some.value()) instanceof Transaction.ContractNotFound) {
            Transaction.ContractNotFound contractNotFound = (Transaction.ContractNotFound)transactionError2;
            Value.ContractId coid = contractNotFound.coid();
            throw new SError.SErrorDamlException((Error)new Error.ContractNotFound(coid));
        }
        if (bl && (transactionError = (Transaction.TransactionError)some.value()) instanceof Transaction.DuplicateContractKey) {
            Transaction.DuplicateContractKey duplicateContractKey = (Transaction.DuplicateContractKey)transactionError;
            GlobalKey key = duplicateContractKey.key();
            throw new SError.SErrorDamlException((Error)new Error.DuplicateContractKey(key));
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public TreeSet<String> com$daml$lf$speedy$SBuiltin$$extractParties(String where, SValue v) {
        TreeSet treeSet;
        SValue sValue = v;
        if (sValue instanceof SValue.SList) {
            SValue.SList sList = (SValue.SList)sValue;
            FrontStack<SValue> vs = sList.list();
            treeSet = (TreeSet)TreeSet$.MODULE$.empty(Ref$.MODULE$.Party().ordering()).$plus$plus((GenTraversableOnce)vs.iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                String p;
                SValue sValue = x0$1;
                if (!(sValue instanceof SValue.SParty)) {
                    throw new SError.SErrorCrash(where, new StringBuilder(25).append("non-party value in list: ").append(sValue).toString());
                }
                SValue.SParty sParty = (SValue.SParty)sValue;
                String string = p = sParty.value();
                return string;
            }));
        } else if (sValue instanceof SValue.SParty) {
            SValue.SParty sParty = (SValue.SParty)sValue;
            String p = sParty.value();
            treeSet = (TreeSet)TreeSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{p}), Ref$.MODULE$.Party().ordering());
        } else {
            throw new SError.SErrorCrash(where, new StringBuilder(38).append("value not a list of parties or party: ").append(v).toString());
        }
        return treeSet;
    }

    public Node.KeyWithMaintainers com$daml$lf$speedy$SBuiltin$$extractKeyWithMaintainers(Speedy.OnLedger onLedger, Ref.Identifier templateId, String location, SValue v) {
        SValue sValue = v;
        if (!(sValue instanceof SValue.SStruct)) {
            throw new SError.SErrorCrash(location, new StringBuilder(30).append("Invalid key with maintainers: ").append(v).toString());
        }
        SValue.SStruct sStruct = (SValue.SStruct)sValue;
        ArrayList<SValue> vals = sStruct.values();
        Value key = onLedger.ptx().normValue(templateId, vals.get(this.keyIdx));
        key.foreachCid((Function1 & Serializable & scala.Serializable)x$21 -> {
            throw new SError.SErrorDamlException((Error)new Error.ContractIdInContractKey(key));
        });
        Node.KeyWithMaintainers keyWithMaintainers = new Node.KeyWithMaintainers(key, this.com$daml$lf$speedy$SBuiltin$$extractParties("com.daml.lf.speedy.SBuiltin.extractKeyWithMaintainers", vals.get(this.maintainerIdx)));
        return keyWithMaintainers;
    }

    public Option<Node.KeyWithMaintainers> com$daml$lf$speedy$SBuiltin$$extractOptionalKeyWithMaintainers(Speedy.OnLedger onLedger, Ref.Identifier templateId, String where, SValue optKey) {
        SValue sValue = optKey;
        if (!(sValue instanceof SValue.SOptional)) {
            throw new SError.SErrorCrash(where, new StringBuilder(45).append("Expected optional key with maintainers, got: ").append(sValue).toString());
        }
        SValue.SOptional sOptional = (SValue.SOptional)sValue;
        Option<SValue> mbKey = sOptional.value();
        Option option = mbKey.map((Function1 & Serializable & scala.Serializable)x$22 -> MODULE$.com$daml$lf$speedy$SBuiltin$$extractKeyWithMaintainers(onLedger, templateId, where, (SValue)x$22));
        return option;
    }

    public Speedy.CachedContract extractCachedContract(Speedy.OnLedger onLedger, Ref.Identifier templateId, SValue v) {
        SValue.SStruct sStruct;
        ArrayList<SValue> vals;
        SValue sValue = v;
        if (!(sValue instanceof SValue.SStruct) || (vals = (sStruct = (SValue.SStruct)sValue).values()).size() != this.cachedContractStructFields.size()) {
            throw new SError.SErrorCrash("com.daml.lf.speedy.SBuiltin.extractCachedContract", new StringBuilder(25).append("Invalid cached contract: ").append(v).toString());
        }
        Speedy.CachedContract cachedContract = new Speedy.CachedContract(templateId, vals.get(this.cachedContractArgIdx), (Set<String>)this.com$daml$lf$speedy$SBuiltin$$extractParties("com.daml.lf.speedy.SBuiltin.extractCachedContract", vals.get(this.cachedContractSignatoriesIdx)), (Set<String>)this.com$daml$lf$speedy$SBuiltin$$extractParties("com.daml.lf.speedy.SBuiltin.extractCachedContract", vals.get(this.cachedContractObserversIdx)), this.com$daml$lf$speedy$SBuiltin$$extractOptionalKeyWithMaintainers(onLedger, templateId, "com.daml.lf.speedy.SBuiltin.extractCachedContract", vals.get(this.cachedContractKeyIdx)));
        return cachedContract;
    }

    private SBuiltin$() {
        MODULE$ = this;
        this.SomeOne = new Some((Object)BoxesRunTime.boxToLong((long)1L));
        this.keyWithMaintainersStructFields = Struct$.MODULE$.assertFromNameSeq((Seq)new .colon.colon((Object)Ast$.MODULE$.keyFieldName(), (List)new .colon.colon((Object)Ast$.MODULE$.maintainersFieldName(), (List)Nil$.MODULE$)));
        this.keyIdx = this.keyWithMaintainersStructFields.indexOf(Ast$.MODULE$.keyFieldName());
        this.maintainerIdx = this.keyWithMaintainersStructFields.indexOf(Ast$.MODULE$.maintainersFieldName());
        this.cachedContractStructFields = Struct$.MODULE$.assertFromSeq((Seq)new .colon.colon((Object)Ast$.MODULE$.contractFieldName(), (List)new .colon.colon((Object)Ast$.MODULE$.signatoriesFieldName(), (List)new .colon.colon((Object)Ast$.MODULE$.observersFieldName(), (List)new .colon.colon((Object)Ast$.MODULE$.keyFieldName(), (List)Nil$.MODULE$)))).zipWithIndex(List$.MODULE$.canBuildFrom()));
        this.com$daml$lf$speedy$SBuiltin$$cachedContractStruct = new SBuiltin.SBStructCon(this.cachedContractStructFields);
        this.cachedContractArgIdx = this.cachedContractStructFields.indexOf(Ast$.MODULE$.contractFieldName());
        this.cachedContractKeyIdx = this.cachedContractStructFields.indexOf(Ast$.MODULE$.keyFieldName());
        this.cachedContractSignatoriesIdx = this.cachedContractStructFields.indexOf(Ast$.MODULE$.signatoriesFieldName());
        this.cachedContractObserversIdx = this.cachedContractStructFields.indexOf(Ast$.MODULE$.observersFieldName());
    }
}

