/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.speedy;

import com.daml.lf.data.FrontStack;
import com.daml.lf.data.ImmArray;
import com.daml.lf.data.Ref;
import com.daml.lf.data.SortedLookupList;
import com.daml.lf.data.Time;
import com.daml.lf.ledger.EventId;
import com.daml.lf.ledger.FailedAuthorization;
import com.daml.lf.scenario.ScenarioLedger;
import com.daml.lf.speedy.InitialSeeding$NoSeed$;
import com.daml.lf.speedy.PartialTransaction;
import com.daml.lf.speedy.PartialTransaction$;
import com.daml.lf.speedy.SError;
import com.daml.lf.transaction.GlobalKey;
import com.daml.lf.transaction.Node;
import com.daml.lf.transaction.NodeId;
import com.daml.lf.transaction.TransactionVersion;
import com.daml.lf.transaction.TransactionVersion$;
import com.daml.lf.value.Value;
import java.io.Serializable;
import java.math.BigDecimal;
import org.typelevel.paiges.Doc;
import org.typelevel.paiges.Doc$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class Pretty$ {
    public static Pretty$ MODULE$;

    static {
        new Pretty$();
    }

    public Doc prettyError(SError.SError err, PartialTransaction ptx) {
        Doc doc;
        Doc doc2 = Doc$.MODULE$.text("Error:");
        SError.SError sError = err;
        if (sError instanceof SError.SErrorDamlException) {
            SError.SErrorDamlException sErrorDamlException = (SError.SErrorDamlException)sError;
            doc = this.prettyDamlException(sErrorDamlException, ptx);
        } else if (sError instanceof SError.SErrorCrash) {
            SError.SErrorCrash sErrorCrash = (SError.SErrorCrash)sError;
            String reason = sErrorCrash.reason();
            doc = Doc$.MODULE$.text(new StringBuilder(7).append("CRASH: ").append(reason).toString());
        } else if (sError instanceof SError.SRequiresOnLedger) {
            SError.SRequiresOnLedger sRequiresOnLedger = (SError.SRequiresOnLedger)sError;
            String operation = sRequiresOnLedger.operation();
            doc = Doc$.MODULE$.text(new StringBuilder(39).append("Operation is not supported off-ledger: ").append(operation).toString());
        } else if (sError instanceof SError.SErrorScenario) {
            SError.SErrorScenario sErrorScenario = (SError.SErrorScenario)((Object)sError);
            doc = this.prettyScenarioError(sErrorScenario);
        } else {
            throw new MatchError((Object)sError);
        }
        return doc2.$amp(doc);
    }

    public Doc prettyError(SError.SError err) {
        PartialTransaction ptx = PartialTransaction$.MODULE$.initial((Function1<String, TransactionVersion>)(Function1 & Serializable & scala.Serializable)x$1 -> TransactionVersion$.MODULE$.minVersion(), Time.Timestamp$.MODULE$.MinValue(), InitialSeeding$NoSeed$.MODULE$);
        return this.prettyError(err, ptx);
    }

    public Doc prettyParty(String p) {
        return Doc$.MODULE$.char('\'').$plus(Doc$.MODULE$.text(p)).$plus(Doc$.MODULE$.char('\''));
    }

    public Doc prettyDamlException(SError.SErrorDamlException ex, PartialTransaction ptx) {
        Doc doc;
        SError.SErrorDamlException sErrorDamlException = ex;
        if (sErrorDamlException instanceof SError.DamlEFailedAuthorization) {
            SError.DamlEFailedAuthorization damlEFailedAuthorization = (SError.DamlEFailedAuthorization)sErrorDamlException;
            NodeId nid = damlEFailedAuthorization.nid();
            FailedAuthorization fa = damlEFailedAuthorization.fa();
            doc = Doc$.MODULE$.text(this.prettyFailedAuthorization(nid, fa));
        } else if (sErrorDamlException instanceof SError.DamlEArithmeticError) {
            SError.DamlEArithmeticError damlEArithmeticError = (SError.DamlEArithmeticError)sErrorDamlException;
            String message = damlEArithmeticError.message();
            doc = Doc$.MODULE$.text(message);
        } else if (sErrorDamlException instanceof SError.DamlEUserError) {
            SError.DamlEUserError damlEUserError = (SError.DamlEUserError)sErrorDamlException;
            String message = damlEUserError.message();
            doc = Doc$.MODULE$.text(new StringBuilder(12).append("User abort: ").append(message).toString());
        } else if (sErrorDamlException instanceof SError.DamlETransactionError) {
            SError.DamlETransactionError damlETransactionError = (SError.DamlETransactionError)sErrorDamlException;
            String reason = damlETransactionError.reason();
            doc = Doc$.MODULE$.text(new StringBuilder(19).append("Transaction error: ").append(reason).toString());
        } else if (sErrorDamlException instanceof SError.DamlEMatchError) {
            SError.DamlEMatchError damlEMatchError = (SError.DamlEMatchError)sErrorDamlException;
            String reason = damlEMatchError.reason();
            doc = Doc$.MODULE$.text(reason);
        } else if (sErrorDamlException instanceof SError.DamlETemplatePreconditionViolated) {
            SError.DamlETemplatePreconditionViolated damlETemplatePreconditionViolated = (SError.DamlETemplatePreconditionViolated)sErrorDamlException;
            Ref.Identifier tid = damlETemplatePreconditionViolated.templateId();
            Value<Value.ContractId> arg = damlETemplatePreconditionViolated.arg();
            doc = Doc$.MODULE$.text("Update failed due to precondition violation when creating").$amp(this.prettyTypeConName(tid)).$amp(Doc$.MODULE$.text("with")).$amp(this.prettyValue(true, arg));
        } else if (sErrorDamlException instanceof SError.DamlELocalContractNotActive) {
            Doc doc2;
            SError.DamlELocalContractNotActive damlELocalContractNotActive = (SError.DamlELocalContractNotActive)sErrorDamlException;
            Value.ContractId coid = damlELocalContractNotActive.coid();
            Ref.Identifier tid = damlELocalContractNotActive.templateId();
            NodeId consumedBy = damlELocalContractNotActive.consumedBy();
            Doc doc3 = Doc$.MODULE$.text("Update failed due to fetch of an inactive contract").$amp(this.prettyContractId(coid));
            Doc doc4 = Doc$.MODULE$.char('(').$plus(this.prettyTypeConName(tid)).$plus(Doc$.MODULE$.text(").").$div(Doc$.MODULE$.text(new StringBuilder(52).append("The contract had been consumed in sub-transaction #").append(consumedBy).append(":").toString())));
            Option option = ptx.nodes().get((Object)consumedBy);
            if (None$.MODULE$.equals(option)) {
                doc2 = Doc$.MODULE$.line().$plus(Doc$.MODULE$.text("Recursive exercise of ")).$plus(this.prettyTypeConName(tid)).nested(4);
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Node.GenNode node = (Node.GenNode)some.value();
                doc2 = Doc$.MODULE$.line().$plus(this.prettyPartialTransactionNode((Node.GenNode<NodeId, Value.ContractId>)node)).nested(4);
            } else {
                throw new MatchError((Object)option);
            }
            doc = doc3.$amp(doc4.$plus(doc2));
        } else if (sErrorDamlException instanceof SError.DamlEWronglyTypedContract) {
            SError.DamlEWronglyTypedContract damlEWronglyTypedContract = (SError.DamlEWronglyTypedContract)sErrorDamlException;
            Value.ContractId coid = damlEWronglyTypedContract.coid();
            Ref.Identifier expected = damlEWronglyTypedContract.expected();
            Ref.Identifier actual = damlEWronglyTypedContract.actual();
            doc = Doc$.MODULE$.text("Update failed due to wrongly typed contract id").$amp(this.prettyContractId(coid).$div(Doc$.MODULE$.text("Expected contract of type"))).$amp(this.prettyTypeConName(expected)).$amp(Doc$.MODULE$.text("but got")).$amp(this.prettyTypeConName(actual));
        } else if (sErrorDamlException instanceof SError.DamlECreateEmptyContractKeyMaintainers) {
            SError.DamlECreateEmptyContractKeyMaintainers damlECreateEmptyContractKeyMaintainers = (SError.DamlECreateEmptyContractKeyMaintainers)sErrorDamlException;
            Ref.Identifier tid = damlECreateEmptyContractKeyMaintainers.templateId();
            Value<Value.ContractId> arg = damlECreateEmptyContractKeyMaintainers.arg();
            Value<Nothing$> key = damlECreateEmptyContractKeyMaintainers.key();
            doc = Doc$.MODULE$.text("Update failed due to a contract key with an empty sey of maintainers when creating").$amp(this.prettyTypeConName(tid)).$amp(Doc$.MODULE$.text("with")).$amp(this.prettyValue(true, arg).$div(Doc$.MODULE$.text("The computed key is"))).$amp(this.prettyValue(true, key));
        } else if (sErrorDamlException instanceof SError.DamlEFetchEmptyContractKeyMaintainers) {
            SError.DamlEFetchEmptyContractKeyMaintainers damlEFetchEmptyContractKeyMaintainers = (SError.DamlEFetchEmptyContractKeyMaintainers)sErrorDamlException;
            Ref.Identifier tid = damlEFetchEmptyContractKeyMaintainers.templateId();
            Value<Nothing$> key = damlEFetchEmptyContractKeyMaintainers.key();
            doc = Doc$.MODULE$.text("Update failed due to a contract key with an empty sey of maintainers when fetching or looking up by key").$amp(this.prettyTypeConName(tid).$div(Doc$.MODULE$.text("The provided key is"))).$amp(this.prettyValue(true, key));
        } else {
            throw new MatchError((Object)sErrorDamlException);
        }
        return doc;
    }

    public Doc prettyPartialTransactionNode(Node.GenNode<NodeId, Value.ContractId> node) {
        Doc doc;
        Node.GenNode<NodeId, Value.ContractId> genNode = node;
        if (genNode instanceof Node.NodeCreate) {
            Node.NodeCreate nodeCreate = (Node.NodeCreate)genNode;
            String string = "create";
            doc = this.prettyContractInst((Value.ContractInst<Value<Value.ContractId>>)nodeCreate.coinst()).$amp$colon(string);
        } else if (genNode instanceof Node.NodeFetch) {
            Node.NodeFetch nodeFetch = (Node.NodeFetch)genNode;
            String string = "fetch";
            doc = this.prettyContractId((Value.ContractId)nodeFetch.coid()).$amp$colon(string);
        } else if (genNode instanceof Node.NodeExercises) {
            Node.NodeExercises nodeExercises = (Node.NodeExercises)genNode;
            doc = Doc$.MODULE$.intercalate(Doc$.MODULE$.text(", "), (Iterable)nodeExercises.actingParties().map((Function1 & Serializable & scala.Serializable)p -> Doc$.MODULE$.text(p), Set$.MODULE$.canBuildFrom())).$amp(Doc$.MODULE$.text("exercises")).$amp(Doc$.MODULE$.text(nodeExercises.choiceId()).$plus(Doc$.MODULE$.char(':')).$plus(this.prettyIdentifier(nodeExercises.templateId()))).$amp(Doc$.MODULE$.text("on")).$amp(this.prettyContractId((Value.ContractId)nodeExercises.targetCoid()).$div(Doc$.MODULE$.text("with"))).$amp(this.prettyValue(false, (Value<Value.ContractId>)nodeExercises.chosenValue()));
        } else if (genNode instanceof Node.NodeLookupByKey) {
            Doc doc2;
            Node.NodeLookupByKey nodeLookupByKey = (Node.NodeLookupByKey)genNode;
            Doc doc3 = Doc$.MODULE$.text("lookup by key").$amp(this.prettyIdentifier(nodeLookupByKey.templateId()).$div(Doc$.MODULE$.text("key")));
            Doc doc4 = this.prettyKeyWithMaintainers((Node.KeyWithMaintainers<Value<Value.ContractId>>)nodeLookupByKey.key());
            Option option = nodeLookupByKey.result();
            if (None$.MODULE$.equals(option)) {
                doc2 = Doc$.MODULE$.text("not found");
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Value.ContractId coid = (Value.ContractId)some.value();
                doc2 = Doc$.MODULE$.text("found").$amp(this.prettyContractId(coid));
            } else {
                throw new MatchError((Object)option);
            }
            doc = doc3.$amp(doc4.$div(doc2));
        } else {
            throw new MatchError(genNode);
        }
        return doc;
    }

    public Doc prettyScenarioError(SError.SErrorScenario serr) {
        SError.ScenarioErrorCommitError scenarioErrorCommitError;
        ScenarioLedger.CommitError commitError;
        Doc doc;
        Doc doc2 = Doc$.MODULE$.text("Scenario failed");
        SError.SErrorScenario sErrorScenario = serr;
        if (sErrorScenario instanceof SError.ScenarioErrorContractNotEffective) {
            SError.ScenarioErrorContractNotEffective scenarioErrorContractNotEffective = (SError.ScenarioErrorContractNotEffective)sErrorScenario;
            Value.ContractId coid = scenarioErrorContractNotEffective.coid();
            Ref.Identifier tid = scenarioErrorContractNotEffective.templateId();
            Time.Timestamp effectiveAt = scenarioErrorContractNotEffective.effectiveAt();
            doc = Doc$.MODULE$.text("due to a fetch of an inactive contract").$amp(this.prettyContractId(coid)).$amp(Doc$.MODULE$.char('(').$plus(this.prettyIdentifier(tid)).$plus(Doc$.MODULE$.text(")."))).$amp(Doc$.MODULE$.text(new StringBuilder(26).append("that becomes effective at ").append(effectiveAt).toString()));
        } else if (sErrorScenario instanceof SError.ScenarioErrorContractNotActive) {
            SError.ScenarioErrorContractNotActive scenarioErrorContractNotActive = (SError.ScenarioErrorContractNotActive)sErrorScenario;
            Value.ContractId coid = scenarioErrorContractNotActive.coid();
            Ref.Identifier tid = scenarioErrorContractNotActive.templateId();
            EventId consumedBy = scenarioErrorContractNotActive.consumedBy();
            doc = Doc$.MODULE$.text("due to a fetch of a consumed contract").$amp(this.prettyContractId(coid)).$amp(Doc$.MODULE$.char('(').$plus(this.prettyIdentifier(tid)).$plus(Doc$.MODULE$.text(").").$div(Doc$.MODULE$.text("The contract had been consumed in transaction")))).$amp(this.prettyEventId(consumedBy));
        } else if (sErrorScenario instanceof SError.ScenarioErrorContractNotVisible) {
            SError.ScenarioErrorContractNotVisible scenarioErrorContractNotVisible = (SError.ScenarioErrorContractNotVisible)sErrorScenario;
            Value.ContractId coid = scenarioErrorContractNotVisible.coid();
            Ref.Identifier tid = scenarioErrorContractNotVisible.templateId();
            Set<String> actAs = scenarioErrorContractNotVisible.actAs();
            Set<String> readAs = scenarioErrorContractNotVisible.readAs();
            Set<String> observers = scenarioErrorContractNotVisible.observers();
            Doc qual$1 = Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), (Iterable)actAs.map((Function1 & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom()));
            Doc x$1 = Doc$.MODULE$.char('{');
            Doc x$2 = Doc$.MODULE$.char('}');
            int x$3 = qual$1.tightBracketBy$default$3();
            Doc qual$2 = Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), (Iterable)readAs.map((Function1 & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom()));
            Doc x$4 = Doc$.MODULE$.char('{');
            Doc x$5 = Doc$.MODULE$.char('}');
            int x$6 = qual$2.tightBracketBy$default$3();
            doc = Doc$.MODULE$.text("due to the failure to fetch the contract").$amp(this.prettyContractId(coid)).$amp(Doc$.MODULE$.char('(').$plus(this.prettyIdentifier(tid)).$plus(Doc$.MODULE$.text(").").$div(Doc$.MODULE$.text("The contract had not been disclosed to the reading parties:")))).$amp(Doc$.MODULE$.text("actAs:")).$amp(qual$1.tightBracketBy(x$1, x$2, x$3)).$amp(Doc$.MODULE$.text("readAs:")).$amp(qual$2.tightBracketBy(x$4, x$5, x$6).$plus(Doc$.MODULE$.char('.').$div(Doc$.MODULE$.text("The contract had been disclosed to:")))).$amp(Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), (Iterable)observers.map((Function1 & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom())).$plus(Doc$.MODULE$.char('.')));
        } else if (sErrorScenario instanceof SError.ScenarioErrorContractKeyNotVisible) {
            SError.ScenarioErrorContractKeyNotVisible scenarioErrorContractKeyNotVisible = (SError.ScenarioErrorContractKeyNotVisible)sErrorScenario;
            Value.ContractId coid = scenarioErrorContractKeyNotVisible.coid();
            GlobalKey gk = scenarioErrorContractKeyNotVisible.key();
            Set<String> actAs = scenarioErrorContractKeyNotVisible.actAs();
            Set<String> readAs = scenarioErrorContractKeyNotVisible.readAs();
            Set<String> stakeholders = scenarioErrorContractKeyNotVisible.stakeholders();
            Doc qual$3 = Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), (Iterable)actAs.map((Function1 & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom()));
            Doc x$7 = Doc$.MODULE$.char('{');
            Doc x$8 = Doc$.MODULE$.char('}');
            int x$9 = qual$3.tightBracketBy$default$3();
            Doc qual$4 = Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), (Iterable)readAs.map((Function1 & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom()));
            Doc x$10 = Doc$.MODULE$.char('{');
            Doc x$11 = Doc$.MODULE$.char('}');
            int x$12 = qual$4.tightBracketBy$default$3();
            doc = Doc$.MODULE$.text("due to the failure to fetch the contract").$amp(this.prettyContractId(coid)).$amp(Doc$.MODULE$.char('(').$plus(this.prettyIdentifier(gk.templateId())).$plus(Doc$.MODULE$.text(") associated with key ")).$plus(this.prettyValue(false, (Value<Value.ContractId>)gk.key()))).$amp(Doc$.MODULE$.text("The contract had not been disclosed to the reading parties:")).$amp(Doc$.MODULE$.text("actAs:")).$amp(qual$3.tightBracketBy(x$7, x$8, x$9)).$amp(Doc$.MODULE$.text("readAs:")).$amp(qual$4.tightBracketBy(x$10, x$11, x$12).$plus(Doc$.MODULE$.char('.').$div(Doc$.MODULE$.text("Stakeholders:")))).$amp(Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), (Iterable)stakeholders.map((Function1 & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom())).$plus(Doc$.MODULE$.char('.')));
        } else if (sErrorScenario instanceof SError.ScenarioErrorCommitError && (commitError = (scenarioErrorCommitError = (SError.ScenarioErrorCommitError)sErrorScenario).commitError()) instanceof ScenarioLedger.CommitError.UniqueKeyViolation) {
            ScenarioLedger.CommitError.UniqueKeyViolation uniqueKeyViolation = (ScenarioLedger.CommitError.UniqueKeyViolation)commitError;
            ScenarioLedger.UniqueKeyViolation gk = uniqueKeyViolation.error();
            doc = Doc$.MODULE$.text("due to unique key violation for key:").$amp(this.prettyValue(false, (Value<Value.ContractId>)gk.gk().key())).$amp(Doc$.MODULE$.text("for template")).$amp(this.prettyIdentifier(gk.gk().templateId()));
        } else if (sErrorScenario instanceof SError.ScenarioErrorMustFailSucceeded) {
            doc = Doc$.MODULE$.text("due to a mustfailAt that succeeded.");
        } else if (sErrorScenario instanceof SError.ScenarioErrorInvalidPartyName) {
            SError.ScenarioErrorInvalidPartyName scenarioErrorInvalidPartyName = (SError.ScenarioErrorInvalidPartyName)sErrorScenario;
            String msg = scenarioErrorInvalidPartyName.msg();
            doc = Doc$.MODULE$.text(new StringBuilder(15).append("Invalid party: ").append(msg).toString());
        } else if (sErrorScenario instanceof SError.ScenarioErrorPartyAlreadyExists) {
            SError.ScenarioErrorPartyAlreadyExists scenarioErrorPartyAlreadyExists = (SError.ScenarioErrorPartyAlreadyExists)sErrorScenario;
            String party = scenarioErrorPartyAlreadyExists.name();
            doc = Doc$.MODULE$.text(new StringBuilder(47).append("Tried to allocate a party that already exists: ").append(party).toString());
        } else {
            throw new MatchError((Object)sErrorScenario);
        }
        return doc2.$amp(doc);
    }

    private String prettyFailedAuthorization(NodeId id, FailedAuthorization failure) {
        String string;
        FailedAuthorization failedAuthorization = failure;
        if (failedAuthorization instanceof FailedAuthorization.NoControllers) {
            FailedAuthorization.NoControllers noControllers = (FailedAuthorization.NoControllers)failedAuthorization;
            string = new StringBuilder(27).append("node ").append(id).append(" (").append(noControllers.templateId()).append(") has no controllers").toString();
        } else if (failedAuthorization instanceof FailedAuthorization.CreateMissingAuthorization) {
            FailedAuthorization.CreateMissingAuthorization createMissingAuthorization = (FailedAuthorization.CreateMissingAuthorization)failedAuthorization;
            string = new StringBuilder(52).append("node ").append(id).append(" (").append(createMissingAuthorization.templateId()).append(") requires authorizers ").append(createMissingAuthorization.requiredParties().mkString(",")).append(", but only ").append(createMissingAuthorization.authorizingParties().mkString(",")).append(" were given").toString();
        } else if (failedAuthorization instanceof FailedAuthorization.FetchMissingAuthorization) {
            FailedAuthorization.FetchMissingAuthorization fetchMissingAuthorization = (FailedAuthorization.FetchMissingAuthorization)failedAuthorization;
            string = new StringBuilder(106).append("node ").append(id).append(" requires one of the stakeholders ").append(fetchMissingAuthorization.stakeholders()).append(" of the fetched contract to be an authorizer, but authorizers were ").append(fetchMissingAuthorization.authorizingParties()).toString();
        } else if (failedAuthorization instanceof FailedAuthorization.ExerciseMissingAuthorization) {
            FailedAuthorization.ExerciseMissingAuthorization exerciseMissingAuthorization = (FailedAuthorization.ExerciseMissingAuthorization)failedAuthorization;
            string = new StringBuilder(52).append("node ").append(id).append(" (").append(exerciseMissingAuthorization.templateId()).append(") requires authorizers ").append(exerciseMissingAuthorization.requiredParties().mkString(",")).append(", but only ").append(exerciseMissingAuthorization.authorizingParties().mkString(",")).append(" were given").toString();
        } else if (failedAuthorization instanceof FailedAuthorization.NoSignatories) {
            FailedAuthorization.NoSignatories noSignatories = (FailedAuthorization.NoSignatories)failedAuthorization;
            string = new StringBuilder(27).append("node ").append(id).append(" (").append(noSignatories.templateId()).append(") has no signatories").toString();
        } else if (failedAuthorization instanceof FailedAuthorization.LookupByKeyMissingAuthorization) {
            FailedAuthorization.LookupByKeyMissingAuthorization lookupByKeyMissingAuthorization = (FailedAuthorization.LookupByKeyMissingAuthorization)failedAuthorization;
            string = new StringBuilder(66).append("node ").append(id).append(" (").append(lookupByKeyMissingAuthorization.templateId()).append(") requires authorizers ").append(lookupByKeyMissingAuthorization.maintainers()).append(" for lookup by key, but it only has ").append(lookupByKeyMissingAuthorization.authorizingParties()).toString();
        } else if (failedAuthorization instanceof FailedAuthorization.MaintainersNotSubsetOfSignatories) {
            FailedAuthorization.MaintainersNotSubsetOfSignatories maintainersNotSubsetOfSignatories = (FailedAuthorization.MaintainersNotSubsetOfSignatories)failedAuthorization;
            string = new StringBuilder(68).append("node ").append(id).append(" (").append(maintainersNotSubsetOfSignatories.templateId()).append(") has maintainers ").append(maintainersNotSubsetOfSignatories.maintainers()).append(" which are not a subset of the signatories ").append(maintainersNotSubsetOfSignatories.signatories()).toString();
        } else {
            throw new MatchError((Object)failedAuthorization);
        }
        return string;
    }

    public Doc prettyValueRef(Ref.Identifier ref) {
        return Doc$.MODULE$.text(new StringBuilder(1).append(ref.qualifiedName().toString()).append("@").append(ref.packageId()).toString());
    }

    public Doc prettyLedger(ScenarioLedger l) {
        return Doc$.MODULE$.text("transactions:").$div(this.prettyTransactions(l)).$div(Doc$.MODULE$.line()).$plus(Doc$.MODULE$.text("active contracts:").$div(this.prettyActiveContracts(l.ledgerData())).nested(3));
    }

    public Doc prettyTransactions(ScenarioLedger l) {
        return Doc$.MODULE$.intercalate(Doc$.MODULE$.line().$plus(Doc$.MODULE$.line()), (Iterable)l.scenarioSteps().values().map((Function1 & Serializable & scala.Serializable)step -> MODULE$.prettyScenarioStep(l, (ScenarioLedger.ScenarioStep)step), Iterable$.MODULE$.canBuildFrom()));
    }

    public Doc prettyLoc(Option<Ref.Location> optLoc) {
        return (Doc)optLoc.map((Function1 & Serializable & scala.Serializable)l -> Doc$.MODULE$.text(new StringBuilder(2).append("[").append(l.module().toString()).append(":").toString()).$plus(Doc$.MODULE$.str((Object)BoxesRunTime.boxToInteger((int)(l.start()._1$mcI$sp() + 1)))).$plus(Doc$.MODULE$.text("]"))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Doc$.MODULE$.text("[unknown source]"));
    }

    public Doc prettyScenarioStep(ScenarioLedger l, ScenarioLedger.ScenarioStep step) {
        Doc doc;
        ScenarioLedger.ScenarioStep scenarioStep = step;
        if (scenarioStep instanceof ScenarioLedger.Commit) {
            ScenarioLedger.Commit commit = (ScenarioLedger.Commit)scenarioStep;
            ScenarioLedger.TransactionId txId = commit.txId();
            ScenarioLedger.RichTransaction rtx = commit.richTransaction();
            Option<Ref.Location> optLoc = commit.optLocation();
            Doc children = Doc$.MODULE$.intercalate(Doc$.MODULE$.line().$plus(Doc$.MODULE$.line()), (Iterable)rtx.transaction().roots().toList().map((Function1 & Serializable & scala.Serializable)nodeId -> MODULE$.prettyEventInfo(l, txId, (NodeId)nodeId), List$.MODULE$.canBuildFrom()));
            doc = Doc$.MODULE$.text("TX").$amp(Doc$.MODULE$.char('#').$plus(Doc$.MODULE$.str((Object)txId.id()))).$amp(Doc$.MODULE$.str((Object)rtx.effectiveAt())).$amp(this.prettyLoc(optLoc)).$amp(Doc$.MODULE$.text("version:")).$amp(Doc$.MODULE$.str((Object)rtx.transaction().version().protoValue()).$div(children));
        } else if (scenarioStep instanceof ScenarioLedger.PassTime) {
            ScenarioLedger.PassTime passTime = (ScenarioLedger.PassTime)scenarioStep;
            long dt = passTime.dtMicros();
            String string = "pass";
            doc = Doc$.MODULE$.str((Object)BoxesRunTime.boxToLong((long)dt)).$amp$colon(string);
        } else if (scenarioStep instanceof ScenarioLedger.AssertMustFail) {
            ScenarioLedger.AssertMustFail assertMustFail = (ScenarioLedger.AssertMustFail)scenarioStep;
            Doc qual$1 = Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), (Iterable)assertMustFail.actAs().map((Function1 & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom()));
            Doc x$1 = Doc$.MODULE$.char('{');
            Doc x$2 = Doc$.MODULE$.char('}');
            int x$3 = qual$1.tightBracketBy$default$3();
            Doc qual$2 = Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), (Iterable)assertMustFail.readAs().map((Function1 & Serializable & scala.Serializable)p -> MODULE$.prettyParty((String)p), Set$.MODULE$.canBuildFrom()));
            Doc x$4 = Doc$.MODULE$.char('{');
            Doc x$5 = Doc$.MODULE$.char('}');
            int x$6 = qual$2.tightBracketBy$default$3();
            doc = Doc$.MODULE$.text("mustFailAt").$amp(Doc$.MODULE$.text("actAs:")).$amp(qual$1.tightBracketBy(x$1, x$2, x$3)).$amp(Doc$.MODULE$.text("readAs:")).$amp(qual$2.tightBracketBy(x$4, x$5, x$6)).$amp(this.prettyLoc(assertMustFail.optLocation()));
        } else {
            throw new MatchError((Object)scenarioStep);
        }
        return doc;
    }

    public Doc prettyKeyWithMaintainers(Node.KeyWithMaintainers<Value<Value.ContractId>> key) {
        return this.prettyValue(false, (Value<Value.ContractId>)((Value)key.key()));
    }

    public Doc prettyVersionedKeyWithMaintainers(Node.KeyWithMaintainers<Value.VersionedValue<Value.ContractId>> key) {
        return this.prettyValue(false, (Value<Value.ContractId>)((Value.VersionedValue)key.key()).value());
    }

    public Doc prettyEventInfo(ScenarioLedger l, ScenarioLedger.TransactionId txId, NodeId nodeId2) {
        Doc doc;
        Doc doc2;
        EventId eventId = new EventId(txId.id(), nodeId2);
        ScenarioLedger.LedgerNodeInfo ni = (ScenarioLedger.LedgerNodeInfo)l.ledgerData().nodeInfos().apply((Object)eventId);
        Node.GenNode<NodeId, Value.ContractId> genNode = ni.node();
        if (genNode instanceof Node.NodeCreate) {
            Doc doc3;
            Node.NodeCreate nodeCreate = (Node.NodeCreate)genNode;
            String string = "create";
            Doc d = this.prettyVersionedContractInst((Value.ContractInst<Value.VersionedValue<Value.ContractId>>)nodeCreate.versionedCoinst()).$amp$colon(string);
            Option option = nodeCreate.versionedKey();
            if (None$.MODULE$.equals(option)) {
                doc3 = d;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Node.KeyWithMaintainers key = (Node.KeyWithMaintainers)some.value();
                doc3 = d.$div(Doc$.MODULE$.text("key")).$amp(this.prettyVersionedKeyWithMaintainers((Node.KeyWithMaintainers<Value.VersionedValue<Value.ContractId>>)key));
            } else {
                throw new MatchError((Object)option);
            }
            doc2 = doc3;
        } else if (genNode instanceof Node.NodeFetch) {
            Node.NodeFetch nodeFetch = (Node.NodeFetch)genNode;
            String string = "ensure active";
            doc2 = this.prettyContractId((Value.ContractId)nodeFetch.coid()).$amp$colon(string);
        } else if (genNode instanceof Node.NodeExercises) {
            Node.NodeExercises nodeExercises = (Node.NodeExercises)genNode;
            Doc children = nodeExercises.children().nonEmpty() ? Doc$.MODULE$.text("children:").$div(Doc$.MODULE$.stack((Iterable)nodeExercises.children().toList().map((Function1 & Serializable & scala.Serializable)nodeId -> MODULE$.prettyEventInfo(l, txId, (NodeId)nodeId), List$.MODULE$.canBuildFrom()))) : Doc$.MODULE$.text("");
            doc2 = Doc$.MODULE$.intercalate(Doc$.MODULE$.text(", "), (Iterable)nodeExercises.actingParties().map((Function1 & Serializable & scala.Serializable)p -> Doc$.MODULE$.text(p), Set$.MODULE$.canBuildFrom())).$amp(Doc$.MODULE$.text("exercises")).$amp(Doc$.MODULE$.text(nodeExercises.choiceId()).$plus(Doc$.MODULE$.char(':')).$plus(this.prettyIdentifier(nodeExercises.templateId()))).$amp(Doc$.MODULE$.text("on")).$amp(this.prettyContractId((Value.ContractId)nodeExercises.targetCoid()).$div(Doc$.MODULE$.text("    ").$plus(Doc$.MODULE$.text("with")).$amp(this.prettyValue(false, (Value<Value.ContractId>)nodeExercises.chosenValue()).$div(children)).nested(4)));
        } else if (genNode instanceof Node.NodeLookupByKey) {
            Doc doc4;
            Node.NodeLookupByKey nodeLookupByKey = (Node.NodeLookupByKey)genNode;
            Doc doc5 = Doc$.MODULE$.text("lookup by key").$amp(this.prettyIdentifier(nodeLookupByKey.templateId()).$div(Doc$.MODULE$.text("key")));
            Doc doc6 = this.prettyVersionedKeyWithMaintainers((Node.KeyWithMaintainers<Value.VersionedValue<Value.ContractId>>)nodeLookupByKey.versionedKey());
            Option option = nodeLookupByKey.result();
            if (None$.MODULE$.equals(option)) {
                doc4 = Doc$.MODULE$.text("not found");
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Value.ContractId coid = (Value.ContractId)some.value();
                doc4 = Doc$.MODULE$.text("found").$amp(this.prettyContractId(coid));
            } else {
                throw new MatchError((Object)option);
            }
            doc2 = doc5.$amp(doc6.$div(doc4));
        } else {
            throw new MatchError(genNode);
        }
        Doc ppNode = doc2;
        Doc ppDisclosedTo = ni.disclosures().nonEmpty() ? Pretty$.meta$1(Doc$.MODULE$.text("known to (since):").$amp(Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), (Iterable)((TraversableLike)ni.disclosures().toSeq().sortWith((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)Pretty$.$anonfun$prettyEventInfo$3(x0$1, x1$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String p = (String)tuple2._1();
            ScenarioLedger.Disclosure d = (ScenarioLedger.Disclosure)tuple2._2();
            Doc doc = Doc$.MODULE$.text(p).$amp(Doc$.MODULE$.text("(#").$plus(Doc$.MODULE$.str((Object)d.since().id())).$plus(Doc$.MODULE$.char(')')));
            return doc;
        }, Seq$.MODULE$.canBuildFrom())))) : Doc$.MODULE$.text("");
        Doc ppReferencedBy = ni.referencedBy().nonEmpty() ? Pretty$.meta$1(Doc$.MODULE$.text("referenced by").$amp(Doc$.MODULE$.intercalate(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), (Iterable)ni.referencedBy().toSeq().map((Function1 & Serializable & scala.Serializable)n -> MODULE$.prettyEventId((EventId)n), Seq$.MODULE$.canBuildFrom())))) : Doc$.MODULE$.text("");
        Option<EventId> option = ni.consumedBy();
        if (None$.MODULE$.equals(option)) {
            doc = Doc$.MODULE$.text("");
        } else if (option instanceof Some) {
            Some some = (Some)option;
            EventId nid = (EventId)some.value();
            String string = "archived by";
            doc = Pretty$.meta$1(this.prettyEventId(nid).$amp$colon(string));
        } else {
            throw new MatchError(option);
        }
        Doc ppArchivedBy = doc;
        return this.prettyEventId(eventId).$amp(Doc$.MODULE$.text("version:")).$amp(Doc$.MODULE$.str((Object)ni.node().version().protoValue()).$div(Doc$.MODULE$.stack((Iterable)((TraversableLike)new .colon.colon((Object)ppArchivedBy, (List)new .colon.colon((Object)ppReferencedBy, (List)new .colon.colon((Object)ppDisclosedTo, (List)new .colon.colon((Object)Pretty$.arrowRight$1(ppNode), (List)Nil$.MODULE$))))).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.nonEmpty())))));
    }

    public Doc prettyEventId(EventId n) {
        return Doc$.MODULE$.text(n.toLedgerString());
    }

    public Doc prettyContractInst(Value.ContractInst<Value<Value.ContractId>> coinst) {
        return this.prettyIdentifier(coinst.template()).$div(Doc$.MODULE$.text("with:")).$amp(this.prettyValue(false, (Value<Value.ContractId>)((Value)coinst.arg()))).nested(4);
    }

    public Doc prettyVersionedContractInst(Value.ContractInst<Value.VersionedValue<Value.ContractId>> coinst) {
        return this.prettyIdentifier(coinst.template()).$div(Doc$.MODULE$.text("with:")).$amp(this.prettyValue(false, (Value<Value.ContractId>)((Value.VersionedValue)coinst.arg()).value())).nested(4);
    }

    public Doc prettyTypeConName(Ref.Identifier tycon) {
        return Doc$.MODULE$.text(tycon.qualifiedName().toString()).$plus(Doc$.MODULE$.char('@')).$plus(this.prettyPackageId(tycon.packageId()));
    }

    public Doc prettyContractId(Value.ContractId coid) {
        return Doc$.MODULE$.text(coid.coid());
    }

    public Doc prettyActiveContracts(ScenarioLedger.LedgerData c) {
        return Doc$.MODULE$.fill(Doc$.MODULE$.comma().$plus(Doc$.MODULE$.space()), (Iterable)((List)c.activeContracts().toList().sortBy((Function1 & Serializable & scala.Serializable)x$9 -> x$9.toString(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)coid -> MODULE$.prettyContractId((Value.ContractId)coid), List$.MODULE$.canBuildFrom()));
    }

    public Doc prettyPackageId(String pkgId) {
        return Doc$.MODULE$.text((String)new StringOps(Predef$.MODULE$.augmentString(pkgId)).take(8));
    }

    public Doc prettyIdentifier(Ref.Identifier id) {
        return Doc$.MODULE$.text(id.qualifiedName().toString()).$plus(Doc$.MODULE$.char('@')).$plus(this.prettyPackageId(id.packageId()));
    }

    public Doc prettyVersionedValue(boolean verbose, Value.VersionedValue<Value.ContractId> v) {
        return this.prettyValue(verbose, (Value<Value.ContractId>)v.value());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Doc prettyValue(boolean verbose, Value<Value.ContractId> v) {
        Option option;
        boolean bl = false;
        Value.ValueOptional valueOptional = null;
        Value<Value.ContractId> value = v;
        if (value instanceof Value.ValueInt64) {
            Value.ValueInt64 valueInt64 = (Value.ValueInt64)value;
            long i = valueInt64.value();
            return Doc$.MODULE$.str((Object)BoxesRunTime.boxToLong((long)i));
        }
        if (value instanceof Value.ValueNumeric) {
            Value.ValueNumeric valueNumeric = (Value.ValueNumeric)value;
            BigDecimal d = valueNumeric.value();
            return Doc$.MODULE$.str((Object)d);
        }
        if (value instanceof Value.ValueRecord) {
            Doc doc;
            Value.ValueRecord valueRecord = (Value.ValueRecord)value;
            Option mbId = valueRecord.tycon();
            ImmArray fs = valueRecord.fields();
            Option option2 = mbId;
            if (None$.MODULE$.equals(option2)) {
                doc = Doc$.MODULE$.text("");
                return doc.$plus(Doc$.MODULE$.char('{')).$amp(Doc$.MODULE$.fill(Doc$.MODULE$.text(", "), (Iterable)fs.toList().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Option option = (Option)tuple2._1();
                        Value v = (Value)tuple2._2();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            String k = (String)some.value();
                            return Doc$.MODULE$.text(k).$amp(Doc$.MODULE$.char('=')).$amp(MODULE$.prettyValue(true, (Value<Value.ContractId>)v));
                        }
                    }
                    if (tuple2 == null) throw new MatchError((Object)tuple2);
                    Option option = (Option)tuple2._1();
                    Value v = (Value)tuple2._2();
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
                    return Doc$.MODULE$.text("<no-label>").$amp(Doc$.MODULE$.char('=')).$amp(MODULE$.prettyValue(true, (Value<Value.ContractId>)v));
                }, List$.MODULE$.canBuildFrom()))).$amp(Doc$.MODULE$.char('}'));
            } else {
                if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
                Some some = (Some)option2;
                Ref.Identifier id = (Ref.Identifier)some.value();
                doc = verbose ? this.prettyIdentifier(id) : Doc$.MODULE$.text("");
            }
            return doc.$plus(Doc$.MODULE$.char('{')).$amp(Doc$.MODULE$.fill(Doc$.MODULE$.text(", "), (Iterable)fs.toList().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Option option = (Option)tuple2._1();
                    Value v = (Value)tuple2._2();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String k = (String)some.value();
                        return Doc$.MODULE$.text(k).$amp(Doc$.MODULE$.char('=')).$amp(MODULE$.prettyValue(true, (Value<Value.ContractId>)v));
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Option option = (Option)tuple2._1();
                Value v = (Value)tuple2._2();
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
                return Doc$.MODULE$.text("<no-label>").$amp(Doc$.MODULE$.char('=')).$amp(MODULE$.prettyValue(true, (Value<Value.ContractId>)v));
            }, List$.MODULE$.canBuildFrom()))).$amp(Doc$.MODULE$.char('}'));
        }
        if (value instanceof Value.ValueVariant) {
            Doc doc;
            Value.ValueVariant valueVariant = (Value.ValueVariant)value;
            Option mbId = valueVariant.tycon();
            String variant = valueVariant.variant();
            Value value2 = valueVariant.value();
            Option option3 = mbId;
            if (None$.MODULE$.equals(option3)) {
                doc = Doc$.MODULE$.text("");
            } else {
                if (!(option3 instanceof Some)) throw new MatchError((Object)option3);
                Some some = (Some)option3;
                Ref.Identifier id = (Ref.Identifier)some.value();
                doc = verbose ? this.prettyIdentifier(id).$plus(Doc$.MODULE$.char(':')) : Doc$.MODULE$.text("");
            }
            Value value3 = value2;
            Doc doc2 = Value.ValueUnit$.MODULE$.equals(value3) ? Doc$.MODULE$.text(variant) : Doc$.MODULE$.text(variant).$plus(Doc$.MODULE$.char('(')).$plus(this.prettyValue(true, (Value<Value.ContractId>)value2)).$plus(Doc$.MODULE$.char(')'));
            return doc.$plus(doc2);
        }
        if (value instanceof Value.ValueEnum) {
            Doc doc;
            Value.ValueEnum valueEnum = (Value.ValueEnum)value;
            Option mbId = valueEnum.tycon();
            String constructor = valueEnum.value();
            Option option4 = mbId;
            if (None$.MODULE$.equals(option4)) {
                doc = Doc$.MODULE$.text("");
                return doc.$plus(Doc$.MODULE$.text(constructor));
            } else {
                if (!(option4 instanceof Some)) throw new MatchError((Object)option4);
                Some some = (Some)option4;
                Ref.Identifier id = (Ref.Identifier)some.value();
                doc = verbose ? this.prettyIdentifier(id).$plus(Doc$.MODULE$.char(':')) : Doc$.MODULE$.text("");
            }
            return doc.$plus(Doc$.MODULE$.text(constructor));
        }
        if (value instanceof Value.ValueText) {
            Value.ValueText valueText = (Value.ValueText)value;
            String t = valueText.value();
            return Doc$.MODULE$.char('\"').$plus(Doc$.MODULE$.text(t)).$plus(Doc$.MODULE$.char('\"'));
        }
        if (value instanceof Value.ValueContractId) {
            Value.ValueContractId valueContractId = (Value.ValueContractId)value;
            Value.ContractId acoid = (Value.ContractId)valueContractId.value();
            return Doc$.MODULE$.text(acoid.coid());
        }
        if (Value.ValueUnit$.MODULE$.equals(value)) {
            return Doc$.MODULE$.text("<unit>");
        }
        if (value instanceof Value.ValueBool) {
            Value.ValueBool valueBool = (Value.ValueBool)value;
            boolean b = valueBool.value();
            return Doc$.MODULE$.str((Object)BoxesRunTime.boxToBoolean((boolean)b));
        }
        if (value instanceof Value.ValueList) {
            Value.ValueList valueList = (Value.ValueList)value;
            FrontStack lst = valueList.values();
            return Doc$.MODULE$.char('[').$plus(Doc$.MODULE$.intercalate(Doc$.MODULE$.text(", "), (Iterable)lst.map((Function1 & Serializable & scala.Serializable)x$10 -> MODULE$.prettyValue(true, (Value<Value.ContractId>)x$10)).toImmArray().toSeq())).$plus(Doc$.MODULE$.char(']'));
        }
        if (value instanceof Value.ValueTimestamp) {
            Value.ValueTimestamp valueTimestamp = (Value.ValueTimestamp)value;
            Time.Timestamp t = valueTimestamp.value();
            return Doc$.MODULE$.str((Object)t);
        }
        if (value instanceof Value.ValueDate) {
            Value.ValueDate valueDate = (Value.ValueDate)value;
            Time.Date days = valueDate.value();
            return Doc$.MODULE$.str((Object)days);
        }
        if (value instanceof Value.ValueParty) {
            Value.ValueParty valueParty = (Value.ValueParty)value;
            String p = valueParty.value();
            return Doc$.MODULE$.char('\'').$plus(Doc$.MODULE$.str((Object)p)).$plus(Doc$.MODULE$.char('\''));
        }
        if (value instanceof Value.ValueOptional) {
            bl = true;
            valueOptional = (Value.ValueOptional)value;
            Option option5 = valueOptional.value();
            if (option5 instanceof Some) {
                Some some = (Some)option5;
                Value v1 = (Value)some.value();
                return Doc$.MODULE$.text("Option(").$plus(this.prettyValue(verbose, (Value<Value.ContractId>)v1)).$plus(Doc$.MODULE$.char(')'));
            }
        }
        if (bl && None$.MODULE$.equals(option = valueOptional.value())) {
            return Doc$.MODULE$.text("None");
        }
        if (value instanceof Value.ValueTextMap) {
            Value.ValueTextMap valueTextMap = (Value.ValueTextMap)value;
            SortedLookupList map = valueTextMap.value();
            ImmArray list = map.toImmArray().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                Value v = (Value)tuple2._2();
                Doc doc = Doc$.MODULE$.text(k).$plus(Doc$.MODULE$.text(" -> ")).$plus(MODULE$.prettyValue(verbose, (Value<Value.ContractId>)v));
                return doc;
            });
            return Doc$.MODULE$.text("TextMap(").$plus(Doc$.MODULE$.intercalate(Doc$.MODULE$.text(", "), (Iterable)list.toSeq())).$plus(Doc$.MODULE$.text(")"));
        }
        if (!(value instanceof Value.ValueGenMap)) throw new MatchError(value);
        Value.ValueGenMap valueGenMap = (Value.ValueGenMap)value;
        ImmArray entries = valueGenMap.entries();
        ImmArray list = entries.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Value k = (Value)tuple2._1();
            Value v = (Value)tuple2._2();
            Doc doc = MODULE$.prettyValue(verbose, (Value<Value.ContractId>)k).$plus(Doc$.MODULE$.text(" -> ")).$plus(MODULE$.prettyValue(verbose, (Value<Value.ContractId>)v));
            return doc;
        });
        return Doc$.MODULE$.text("GenMap(").$plus(Doc$.MODULE$.intercalate(Doc$.MODULE$.text(", "), (Iterable)list.toSeq())).$plus(Doc$.MODULE$.text(")"));
    }

    private static final Doc arrowRight$1(Doc d) {
        return Doc$.MODULE$.text("\u2514\u2500>").$amp(d);
    }

    private static final Doc meta$1(Doc d) {
        return Doc$.MODULE$.text("\u2502  ").$amp(d);
    }

    public static final /* synthetic */ boolean $anonfun$prettyEventInfo$3(Tuple2 x0$1, Tuple2 x1$1) {
        ScenarioLedger.Disclosure d1;
        String p1;
        Tuple2 tuple2;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = new Tuple2((Object)x0$1, (Object)x1$1);
                if (tuple22 == null) break block2;
                Tuple2 tuple23 = (Tuple2)tuple22._1();
                tuple2 = (Tuple2)tuple22._2();
                if (tuple23 == null) break block2;
                p1 = (String)tuple23._1();
                d1 = (ScenarioLedger.Disclosure)tuple23._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        String p2 = (String)tuple2._1();
        ScenarioLedger.Disclosure d2 = (ScenarioLedger.Disclosure)tuple2._2();
        boolean bl = d1.since().$less$eq(d2.since()) && new StringOps(Predef$.MODULE$.augmentString(p1)).$less((Object)p2);
        return bl;
    }

    private Pretty$() {
        MODULE$ = this;
    }
}

