/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.speedy;

import com.daml.lf.speedy.SBuiltin;
import com.daml.lf.speedy.SBuiltinPure;
import com.daml.lf.speedy.SExpr;
import com.daml.lf.speedy.SValue;
import com.daml.lf.speedy.Speedy;
import java.io.Serializable;
import java.util.ArrayList;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;

public final class PrettyLightweight$ {
    public static PrettyLightweight$ MODULE$;

    static {
        new PrettyLightweight$();
    }

    public String ppMachine(Speedy.Machine m) {
        return new StringBuilder(11).append("[").append(m.envBase()).append("] ").append(this.ppEnv(m.env())).append(" -- ").append(this.ppCtrl(m.ctrl(), m.returnValue())).append(" -- ").append(this.ppKontStack(m.kontStack())).toString();
    }

    public String ppCtrl(SExpr e, SValue v) {
        return v != null ? new StringBuilder(2).append("V-").append(this.pp(v)).toString() : new StringBuilder(2).append("E-").append(this.pp(e)).toString();
    }

    public String ppEnv(ArrayList<SValue> env) {
        return new StringBuilder(4).append("#").append(env.size()).append("={").append(this.commas((Seq<String>)((Seq)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(env).asScala()).map((Function1 & Serializable & scala.Serializable)v -> MODULE$.pp((SValue)v), Buffer$.MODULE$.canBuildFrom())))).append("}").toString();
    }

    public String ppKontStack(ArrayList<Speedy.Kont> ks) {
        return new StringBuilder(7).append("[").append(this.ppKont(ks.get(ks.size() - 1))).append("... #").append(ks.size()).append("]").toString();
    }

    public String ppKont(Speedy.Kont k) {
        return k.getClass().getSimpleName();
    }

    public String pp(SExpr.SELoc v) {
        String string;
        SExpr.SELoc sELoc = v;
        if (sELoc instanceof SExpr.SELocS) {
            SExpr.SELocS sELocS = (SExpr.SELocS)sELoc;
            int n = sELocS.n();
            string = new StringBuilder(2).append("S#").append(n).toString();
        } else if (sELoc instanceof SExpr.SELocA) {
            SExpr.SELocA sELocA = (SExpr.SELocA)sELoc;
            int n = sELocA.n();
            string = new StringBuilder(2).append("A#").append(n).toString();
        } else if (sELoc instanceof SExpr.SELocF) {
            SExpr.SELocF sELocF = (SExpr.SELocF)sELoc;
            int n = sELocF.n();
            string = new StringBuilder(2).append("F#").append(n).toString();
        } else {
            throw new MatchError((Object)sELoc);
        }
        return string;
    }

    public String pp(SExpr.SDefinitionRef x) {
        return String.valueOf(x.ref().qualifiedName().name());
    }

    public String pp(SExpr e2) {
        String string;
        SExpr sExpr = e2;
        if (sExpr instanceof SExpr.SEValue) {
            SExpr.SEValue sEValue = (SExpr.SEValue)sExpr;
            SValue v2 = sEValue.v();
            string = new StringBuilder(7).append("(VALUE)").append(this.pp(v2)).toString();
        } else if (sExpr instanceof SExpr.SEVar) {
            SExpr.SEVar sEVar = (SExpr.SEVar)sExpr;
            int n = sEVar.index();
            string = new StringBuilder(2).append("D#").append(n).toString();
        } else if (sExpr instanceof SExpr.SELoc) {
            SExpr.SELoc sELoc = (SExpr.SELoc)sExpr;
            string = this.pp(sELoc);
        } else if (sExpr instanceof SExpr.SEAppGeneral) {
            SExpr.SEAppGeneral sEAppGeneral = (SExpr.SEAppGeneral)sExpr;
            SExpr func = sEAppGeneral.fun();
            SExpr[] args = sEAppGeneral.args();
            string = new StringBuilder(5).append("@E(").append(this.pp(func)).append(",").append(this.commas((Seq<String>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).map((Function1 & Serializable & scala.Serializable)e -> MODULE$.pp((SExpr)e), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))))).append(")").toString();
        } else if (sExpr instanceof SExpr.SEAppAtomicFun) {
            SExpr.SEAppAtomicFun sEAppAtomicFun = (SExpr.SEAppAtomicFun)sExpr;
            SExpr.SExprAtomic func = sEAppAtomicFun.fun();
            SExpr[] args = sEAppAtomicFun.args();
            string = new StringBuilder(5).append("@N(").append(this.pp(func)).append(",").append(this.commas((Seq<String>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).map((Function1 & Serializable & scala.Serializable)e -> MODULE$.pp((SExpr)e), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))))).append(")").toString();
        } else if (sExpr instanceof SExpr.SEAppAtomicGeneral) {
            SExpr.SEAppAtomicGeneral sEAppAtomicGeneral = (SExpr.SEAppAtomicGeneral)sExpr;
            SExpr.SExprAtomic func = sEAppAtomicGeneral.fun();
            SExpr.SExprAtomic[] args = sEAppAtomicGeneral.args();
            string = new StringBuilder(5).append("@A(").append(this.pp(func)).append(",").append(this.commas((Seq<String>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).map((Function1 & Serializable & scala.Serializable)e -> MODULE$.pp((SExpr)e), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))))).append(")").toString();
        } else if (sExpr instanceof SExpr.SEAppAtomicSaturatedBuiltin) {
            SExpr.SEAppAtomicSaturatedBuiltin sEAppAtomicSaturatedBuiltin = (SExpr.SEAppAtomicSaturatedBuiltin)sExpr;
            SBuiltin b = sEAppAtomicSaturatedBuiltin.builtin();
            SExpr.SExprAtomic[] args = sEAppAtomicSaturatedBuiltin.args();
            string = new StringBuilder(5).append("@B(").append(this.pp(new SExpr.SEBuiltin(b))).append(",").append(this.commas((Seq<String>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).map((Function1 & Serializable & scala.Serializable)e -> MODULE$.pp((SExpr)e), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))))).append(")").toString();
        } else if (sExpr instanceof SExpr.SEMakeClo) {
            SExpr.SEMakeClo sEMakeClo = (SExpr.SEMakeClo)sExpr;
            SExpr.SELoc[] fvs = sEMakeClo.fvs();
            int arity = sEMakeClo.arity();
            SExpr body = sEMakeClo.body();
            string = new StringBuilder(4).append("[").append(this.commas((Seq<String>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fvs)).map((Function1 & Serializable & scala.Serializable)v -> MODULE$.pp((SExpr.SELoc)v), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))))).append("]\\").append(arity).append(".").append(this.pp(body)).toString();
        } else if (sExpr instanceof SExpr.SEBuiltin) {
            SExpr.SEBuiltin sEBuiltin = (SExpr.SEBuiltin)sExpr;
            SBuiltin b = sEBuiltin.b();
            string = new StringBuilder(9).append("(BUILTIN)").append(b).toString();
        } else if (sExpr instanceof SExpr.SEVal) {
            SExpr.SEVal sEVal = (SExpr.SEVal)sExpr;
            SExpr.SDefinitionRef ref = sEVal.ref();
            string = new StringBuilder(5).append("(DEF)").append(this.pp(ref)).toString();
        } else if (sExpr instanceof SExpr.SELocation) {
            SExpr.SELocation sELocation = (SExpr.SELocation)sExpr;
            SExpr exp = sELocation.expr();
            string = new StringBuilder(5).append("LOC(").append(this.pp(exp)).append(")").toString();
        } else if (sExpr instanceof SExpr.SELet) {
            SExpr.SELet sELet = (SExpr.SELet)sExpr;
            List<SExpr> rhss = sELet.bounds();
            SExpr body = sELet.body();
            string = new StringBuilder(11).append("letG (").append(this.commas((Seq<String>)((Seq)rhss.map((Function1 & Serializable & scala.Serializable)e -> MODULE$.pp((SExpr)e), List$.MODULE$.canBuildFrom())))).append(") in ").append(this.pp(body)).toString();
        } else if (sExpr instanceof SExpr.SELet1General) {
            SExpr.SELet1General sELet1General = (SExpr.SELet1General)sExpr;
            SExpr rhs = sELet1General.rhs();
            SExpr body = sELet1General.body();
            string = new StringBuilder(8).append("let ").append(this.pp(rhs)).append(" in ").append(this.pp(body)).toString();
        } else if (sExpr instanceof SExpr.SELet1Builtin) {
            SExpr.SELet1Builtin sELet1Builtin = (SExpr.SELet1Builtin)sExpr;
            SBuiltinPure builtin = sELet1Builtin.builtin();
            SExpr.SExprAtomic[] args = sELet1Builtin.args();
            SExpr body = sELet1Builtin.body();
            string = new StringBuilder(12).append("letB (").append(this.pp(new SExpr.SEBuiltin(builtin))).append(",").append(this.commas((Seq<String>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).map((Function1 & Serializable & scala.Serializable)e -> MODULE$.pp((SExpr)e), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))))).append(") in ").append(this.pp(body)).toString();
        } else if (sExpr instanceof SExpr.SECaseAtomic) {
            SExpr.SECaseAtomic sECaseAtomic = (SExpr.SECaseAtomic)sExpr;
            SExpr.SExprAtomic scrut = sECaseAtomic.scrut();
            string = new StringBuilder(19).append("case(atomic) ").append(this.pp(scrut)).append(" of...").toString();
        } else if (sExpr instanceof SExpr.SECase) {
            SExpr.SECase sECase = (SExpr.SECase)sExpr;
            SExpr scrut = sECase.scrut();
            string = new StringBuilder(11).append("case ").append(this.pp(scrut)).append(" of...").toString();
        } else {
            string = new StringBuilder(5).append("<").append(e2.getClass().getSimpleName()).append("...>").toString();
        }
        return string;
    }

    public String pp(SValue v) {
        String string;
        SValue sValue = v;
        if (sValue instanceof SValue.SInt64) {
            SValue.SInt64 sInt64 = (SValue.SInt64)sValue;
            long n = sInt64.value();
            string = String.valueOf(BoxesRunTime.boxToLong((long)n));
        } else if (sValue instanceof SValue.SBool) {
            SValue.SBool sBool = (SValue.SBool)sValue;
            boolean b = sBool.value();
            string = String.valueOf(BoxesRunTime.boxToBoolean((boolean)b));
        } else if (sValue instanceof SValue.SPAP) {
            SValue.SPAP sPAP = (SValue.SPAP)sValue;
            ArrayList<SValue> args = sPAP.actuals();
            int arity = sPAP.arity();
            string = new StringBuilder(6).append("PAP(").append(args.size()).append("/").append(arity).append(")").toString();
        } else if (sValue instanceof SValue.SText) {
            SValue.SText sText = (SValue.SText)sValue;
            String s = sText.value();
            string = new StringBuilder(2).append("'").append(s).append("'").toString();
        } else {
            string = new StringBuilder(5).append("<").append(v.getClass().getSimpleName()).append("...>").toString();
        }
        return string;
    }

    public String pp(SValue.Prim prim) {
        String string;
        SValue.Prim prim2 = prim;
        if (prim2 instanceof SValue.PBuiltin) {
            SValue.PBuiltin pBuiltin = (SValue.PBuiltin)prim2;
            SBuiltin b = pBuiltin.b();
            string = String.valueOf(b);
        } else if (prim2 instanceof SValue.PClosure) {
            SValue.PClosure pClosure = (SValue.PClosure)prim2;
            SExpr expr = pClosure.expr();
            SValue[] fvs = pClosure.frame();
            string = new StringBuilder(6).append("clo[").append(this.commas((Seq<String>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fvs)).map((Function1 & Serializable & scala.Serializable)v -> MODULE$.pp((SValue)v), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))))).append("]:").append(this.pp(expr)).toString();
        } else {
            throw new MatchError((Object)prim2);
        }
        return string;
    }

    public String commas(Seq<String> xs) {
        return xs.mkString(",");
    }

    private PrettyLightweight$() {
        MODULE$ = this;
    }
}

