/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.speedy;

import com.daml.lf.data.FrontStack;
import com.daml.lf.data.Ref;
import com.daml.lf.data.Ref$;
import com.daml.lf.data.Struct;
import com.daml.lf.data.Struct$;
import com.daml.lf.data.package$;
import com.daml.lf.language.Ast$;
import com.daml.lf.ledger.FailedAuthorization;
import com.daml.lf.speedy.PartialTransaction;
import com.daml.lf.speedy.SError;
import com.daml.lf.speedy.SError$;
import com.daml.lf.speedy.SValue;
import com.daml.lf.speedy.SValue$SToken$;
import com.daml.lf.transaction.Node;
import com.daml.lf.transaction.NodeId;
import com.daml.lf.transaction.Transaction;
import com.daml.lf.value.Value;
import com.daml.lf.value.Value$;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.TreeSet;
import scala.collection.immutable.TreeSet$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.Either;

public final class SBuiltin$ {
    public static SBuiltin$ MODULE$;
    private final Struct<BoxedUnit> keyWithMaintainersStructFields;
    private final int keyIdx;
    private final int maintainerIdx;

    static {
        new SBuiltin$();
    }

    public long com$daml$lf$speedy$SBuiltin$$add(long x, long y) {
        long l;
        try {
            l = Math.addExact(x, y);
        }
        catch (ArithmeticException arithmeticException) {
            throw new SError.DamlEArithmeticError(new StringBuilder(32).append("Int64 overflow when adding ").append(y).append(" to ").append(x).append(".").toString());
        }
        return l;
    }

    public long com$daml$lf$speedy$SBuiltin$$div(long x, long y) {
        if (y == 0L) {
            throw new SError.DamlEArithmeticError(new StringBuilder(24).append("Attempt to divide ").append(x).append(" by 0.").toString());
        }
        if (x == Long.MIN_VALUE && y == -1L) {
            throw new SError.DamlEArithmeticError(new StringBuilder(34).append("Int64 overflow when dividing ").append(x).append(" by ").append(y).append(".").toString());
        }
        return x / y;
    }

    public long com$daml$lf$speedy$SBuiltin$$mult(long x, long y) {
        long l;
        try {
            l = Math.multiplyExact(x, y);
        }
        catch (ArithmeticException arithmeticException) {
            throw new SError.DamlEArithmeticError(new StringBuilder(37).append("Int64 overflow when multiplying ").append(x).append(" by ").append(y).append(".").toString());
        }
        return l;
    }

    public long com$daml$lf$speedy$SBuiltin$$sub(long x, long y) {
        long l;
        try {
            l = Math.subtractExact(x, y);
        }
        catch (ArithmeticException arithmeticException) {
            throw new SError.DamlEArithmeticError(new StringBuilder(39).append("Int64 overflow when subtracting ").append(y).append(" from ").append(x).append(".").toString());
        }
        return l;
    }

    public long com$daml$lf$speedy$SBuiltin$$mod(long x, long y) {
        if (y == 0L) {
            throw new SError.DamlEArithmeticError(new StringBuilder(29).append("Attempt to compute ").append(x).append(" modulo 0.").toString());
        }
        return x % y;
    }

    public long com$daml$lf$speedy$SBuiltin$$exp(long base, long exponent) {
        long l;
        if (exponent < 0L) {
            throw new SError.DamlEArithmeticError(new StringBuilder(44).append("Attempt to raise ").append(base).append(" to the negative exponent ").append(exponent).append(".").toString());
        }
        if (exponent == 0L) {
            l = 1L;
        } else {
            try {
                long x = base;
                long y = 1L;
                for (long n = exponent; n > 1L; n >>= 1) {
                    if (n % 2L == 1L) {
                        y = Math.multiplyExact(y, x);
                    }
                    x = Math.multiplyExact(x, x);
                }
                l = Math.multiplyExact(x, y);
            }
            catch (ArithmeticException arithmeticException) {
                throw new SError.DamlEArithmeticError(new StringBuilder(46).append("Int64 overflow when raising ").append(base).append(" to the exponent ").append(exponent).append(".").toString());
            }
        }
        return l;
    }

    public BigDecimal com$daml$lf$speedy$SBuiltin$$add(BigDecimal x, BigDecimal y) {
        return (BigDecimal)this.com$daml$lf$speedy$SBuiltin$$rightOrArithmeticError(new StringBuilder(37).append("(Numeric ").append(x.scale()).append(") overflow when adding ").append(package$.MODULE$.Numeric().toString(y)).append(" to ").append(package$.MODULE$.Numeric().toString(x)).append(".").toString(), package$.MODULE$.Numeric().add(x, y));
    }

    public BigDecimal com$daml$lf$speedy$SBuiltin$$subtract(BigDecimal x, BigDecimal y) {
        return (BigDecimal)this.com$daml$lf$speedy$SBuiltin$$rightOrArithmeticError(new StringBuilder(44).append("(Numeric ").append(x.scale()).append(") overflow when subtracting ").append(package$.MODULE$.Numeric().toString(y)).append(" from ").append(package$.MODULE$.Numeric().toString(x)).append(".").toString(), package$.MODULE$.Numeric().subtract(x, y));
    }

    public BigDecimal com$daml$lf$speedy$SBuiltin$$multiply(int scale, BigDecimal x, BigDecimal y) {
        return (BigDecimal)this.com$daml$lf$speedy$SBuiltin$$rightOrArithmeticError(new StringBuilder(42).append("(Numeric ").append(scale).append(") overflow when multiplying ").append(package$.MODULE$.Numeric().toString(x)).append(" by ").append(package$.MODULE$.Numeric().toString(y)).append(".").toString(), package$.MODULE$.Numeric().multiply(scale, x, y));
    }

    public BigDecimal com$daml$lf$speedy$SBuiltin$$divide(int scale, BigDecimal x, BigDecimal y) {
        if (y.signum() == 0) {
            throw new SError.DamlEArithmeticError(new StringBuilder(23).append("Attempt to divide ").append(package$.MODULE$.Numeric().toString(x)).append(" by ").append(package$.MODULE$.Numeric().toString(y)).append(".").toString());
        }
        return (BigDecimal)this.com$daml$lf$speedy$SBuiltin$$rightOrArithmeticError(new StringBuilder(39).append("(Numeric ").append(scale).append(") overflow when dividing ").append(package$.MODULE$.Numeric().toString(x)).append(" by ").append(package$.MODULE$.Numeric().toString(y)).append(".").toString(), package$.MODULE$.Numeric().divide(scale, x, y));
    }

    public void com$daml$lf$speedy$SBuiltin$$checkAborted(PartialTransaction ptx) {
        Transaction.TransactionError transactionError;
        Transaction.TransactionError transactionError2;
        boolean bl = false;
        Some some = null;
        Option<Transaction.TransactionError> option = ptx.aborted();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Transaction.TransactionError transactionError3 = (Transaction.TransactionError)some.value();
            if (transactionError3 instanceof Transaction.AuthFailureDuringExecution) {
                Transaction.AuthFailureDuringExecution authFailureDuringExecution = (Transaction.AuthFailureDuringExecution)transactionError3;
                NodeId nid = authFailureDuringExecution.nid();
                FailedAuthorization fa = authFailureDuringExecution.fa();
                throw new SError.DamlEFailedAuthorization(nid, fa);
            }
        }
        if (bl && (transactionError2 = (Transaction.TransactionError)some.value()) instanceof Transaction.ContractNotActive) {
            Transaction.ContractNotActive contractNotActive = (Transaction.ContractNotActive)transactionError2;
            Value.ContractId coid = contractNotActive.coid();
            Ref.Identifier tid = contractNotActive.templateId();
            NodeId consumedBy = contractNotActive.consumedBy();
            throw new SError.DamlELocalContractNotActive(coid, tid, consumedBy);
        }
        if (bl && Transaction.EndExerciseInRootContext$.MODULE$.equals(transactionError = (Transaction.TransactionError)some.value())) {
            BoxedUnit boxedUnit = (BoxedUnit)SError$.MODULE$.crash("internal error: end exercise in root context");
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public void com$daml$lf$speedy$SBuiltin$$checkToken(SValue v) {
        SValue sValue = v;
        if (SValue$SToken$.MODULE$.equals(sValue)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = (BoxedUnit)SError$.MODULE$.crash(new StringBuilder(19).append("value not a token: ").append(v).toString());
        }
    }

    public TreeSet<String> com$daml$lf$speedy$SBuiltin$$extractParties(SValue v) {
        TreeSet treeSet;
        SValue sValue = v;
        if (sValue instanceof SValue.SList) {
            SValue.SList sList = (SValue.SList)sValue;
            FrontStack<SValue> vs = sList.list();
            treeSet = (TreeSet)TreeSet$.MODULE$.empty(Ref$.MODULE$.Party().ordering()).$plus$plus((GenTraversableOnce)vs.iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                String string;
                SValue sValue = x0$1;
                if (sValue instanceof SValue.SParty) {
                    String p;
                    SValue.SParty sParty = (SValue.SParty)sValue;
                    string = p = sParty.value();
                } else {
                    string = (String)SError$.MODULE$.crash(new StringBuilder(25).append("non-party value in list: ").append(sValue).toString());
                }
                return string;
            }));
        } else if (sValue instanceof SValue.SParty) {
            SValue.SParty sParty = (SValue.SParty)sValue;
            String p = sParty.value();
            treeSet = (TreeSet)TreeSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{p}), Ref$.MODULE$.Party().ordering());
        } else {
            treeSet = (TreeSet)SError$.MODULE$.crash(new StringBuilder(38).append("value not a list of parties or party: ").append(v).toString());
        }
        return treeSet;
    }

    public Node.KeyWithMaintainers<Value<Nothing$>> com$daml$lf$speedy$SBuiltin$$extractKeyWithMaintainers(SValue v) {
        Node.KeyWithMaintainers keyWithMaintainers;
        SValue sValue = v;
        if (sValue instanceof SValue.SStruct) {
            SValue.SStruct sStruct = (SValue.SStruct)sValue;
            ArrayList<SValue> vals = sStruct.values();
            keyWithMaintainers = (Node.KeyWithMaintainers)this.rightOrCrash(vals.get(this.keyIdx).toValue().ensureNoCid(Value$.MODULE$.noCidCheckerInstance(Value.ContractId$.MODULE$.noCidMapper())).left().map((Function1 & Serializable & scala.Serializable)coid -> new StringBuilder(49).append("Contract IDs are not supported in contract keys: ").append(coid).toString()).map((Function1 & Serializable & scala.Serializable)keyVal -> new Node.KeyWithMaintainers(keyVal, MODULE$.com$daml$lf$speedy$SBuiltin$$extractParties((SValue)vals.get(SBuiltin$.MODULE$.maintainerIdx)))));
        } else {
            keyWithMaintainers = (Node.KeyWithMaintainers)SError$.MODULE$.crash(new StringBuilder(30).append("Invalid key with maintainers: ").append(v).toString());
        }
        return keyWithMaintainers;
    }

    public Option<Node.KeyWithMaintainers<Value<Nothing$>>> com$daml$lf$speedy$SBuiltin$$extractOptionalKeyWithMaintainers(SValue optKey) {
        Option option;
        SValue sValue = optKey;
        if (sValue instanceof SValue.SOptional) {
            SValue.SOptional sOptional = (SValue.SOptional)sValue;
            Option<SValue> mbKey = sOptional.value();
            option = mbKey.map((Function1 & Serializable & scala.Serializable)v -> MODULE$.com$daml$lf$speedy$SBuiltin$$extractKeyWithMaintainers((SValue)v));
        } else {
            option = (Option)SError$.MODULE$.crash(new StringBuilder(45).append("Expected optional key with maintainers, got: ").append(sValue).toString());
        }
        return option;
    }

    public <A> A com$daml$lf$speedy$SBuiltin$$rightOrArithmeticError(String message, Either<String, A> mb) {
        return (A)mb.fold((Function1 & Serializable & scala.Serializable)x$17 -> {
            throw new SError.DamlEArithmeticError(String.valueOf(message));
        }, (Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x));
    }

    private <A> A rightOrCrash(Either<String, A> either) {
        return (A)either.fold((Function1 & Serializable & scala.Serializable)reason -> (Nothing$)SError$.MODULE$.crash((String)reason), (Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x));
    }

    private SBuiltin$() {
        MODULE$ = this;
        this.keyWithMaintainersStructFields = Struct$.MODULE$.assertFromNameSeq((Seq)new .colon.colon((Object)Ast$.MODULE$.keyFieldName(), (List)new .colon.colon((Object)Ast$.MODULE$.maintainersFieldName(), (List)Nil$.MODULE$)));
        this.keyIdx = this.keyWithMaintainersStructFields.indexOf(Ast$.MODULE$.keyFieldName());
        this.maintainerIdx = this.keyWithMaintainersStructFields.indexOf(Ast$.MODULE$.maintainersFieldName());
    }
}

