/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.transaction.test;

import com.daml.lf.data.ImmArray;
import com.daml.lf.data.ImmArray$;
import com.daml.lf.data.Ref;
import com.daml.lf.data.Ref$;
import com.daml.lf.language.LanguageVersion;
import com.daml.lf.transaction.Node;
import com.daml.lf.transaction.Node$KeyWithMaintainers$;
import com.daml.lf.transaction.Node$NodeCreate$;
import com.daml.lf.transaction.Node$NodeExercises$;
import com.daml.lf.transaction.Node$NodeFetch$;
import com.daml.lf.transaction.Node$NodeLookupByKey$;
import com.daml.lf.transaction.NodeId;
import com.daml.lf.transaction.TransactionVersion;
import com.daml.lf.transaction.TransactionVersions$;
import com.daml.lf.transaction.VersionTimeline;
import com.daml.lf.transaction.VersionTimeline$;
import com.daml.lf.transaction.VersionedTransaction;
import com.daml.lf.transaction.VersionedTransaction$;
import com.daml.lf.transaction.package$;
import com.daml.lf.transaction.test.TransactionBuilder;
import com.daml.lf.value.Value;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.runtime.BoxedUnit;
import scalaz.;

public final class TransactionBuilder$ {
    public static TransactionBuilder$ MODULE$;
    private final Node$NodeCreate$ Create;
    private final Node$NodeExercises$ Exercise;
    private final Node$NodeFetch$ Fetch;
    private final Node$NodeLookupByKey$ LookupByKey;
    private final Node$KeyWithMaintainers$ KeyWithMaintainers;
    private final VersionedTransaction<NodeId, Value.ContractId> Empty;
    private final VersionedTransaction EmptySubmitted;
    private final VersionedTransaction EmptyCommitted;

    static {
        new TransactionBuilder$();
    }

    private Node$NodeCreate$ Create() {
        return this.Create;
    }

    private Node$NodeExercises$ Exercise() {
        return this.Exercise;
    }

    private Node$NodeFetch$ Fetch() {
        return this.Fetch;
    }

    private Node$NodeLookupByKey$ LookupByKey() {
        return this.LookupByKey;
    }

    private Node$KeyWithMaintainers$ KeyWithMaintainers() {
        return this.KeyWithMaintainers;
    }

    public TransactionBuilder apply() {
        return this.apply((TransactionVersion)TransactionVersions$.MODULE$.StableOutputVersions().min());
    }

    public TransactionBuilder apply(TransactionVersion txVersion) {
        return new TransactionBuilder((Function1<String, TransactionVersion>)(Function1 & Serializable & scala.Serializable)x$3 -> txVersion);
    }

    public TransactionBuilder apply(Function1<String, LanguageVersion> pkgLangVersion) {
        return new TransactionBuilder((Function1<String, TransactionVersion>)(Function1 & Serializable & scala.Serializable)pkgId -> TransactionBuilder$.pkgTxVersion$1(pkgId, pkgLangVersion));
    }

    public Value<Value.ContractId> record(Seq<Tuple2<String, String>> fields) {
        return new Value.ValueRecord((Option)None$.MODULE$, ImmArray$.MODULE$.apply((Iterable)fields.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            String value = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)new Some(Ref$.MODULE$.Name().assertFromString(name)), (Object)new Value.ValueText(value));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())));
    }

    public Value<Value.ContractId> tuple(Seq<String> values) {
        return this.record((Seq<Tuple2<String, String>>)((Seq)((TraversableLike)values.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String v = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append("_").append(i).toString()), (Object)v);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())));
    }

    public Node.KeyWithMaintainers<Value<Value.ContractId>> keyWithMaintainers(Seq<String> maintainers, String value) {
        return this.KeyWithMaintainers().apply(this.tuple((Seq<String>)((Seq)maintainers.$colon$plus((Object)value, Seq$.MODULE$.canBuildFrom()))), ((TraversableOnce)maintainers.map((Function1 & Serializable & scala.Serializable)s -> (String)Ref$.MODULE$.Party().assertFromString(s), Seq$.MODULE$.canBuildFrom())).toSet());
    }

    public Node.NodeCreate<Value.ContractId, Value<Value.ContractId>> create(String id, String template, Value<Value.ContractId> argument, Seq<String> signatories, Seq<String> observers, Option<String> key) {
        return this.Create().apply((Object)Value.ContractId$.MODULE$.assertFromString(id), new Value.ContractInst(Ref.Identifier$.MODULE$.assertFromString(template), argument, ""), (Option)None$.MODULE$, ((TraversableOnce)signatories.map((Function1 & Serializable & scala.Serializable)s -> (String)Ref$.MODULE$.Party().assertFromString(s), Seq$.MODULE$.canBuildFrom())).toSet(), ((TraversableOnce)((TraversableLike)signatories.union(observers, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)s -> (String)Ref$.MODULE$.Party().assertFromString(s), Seq$.MODULE$.canBuildFrom())).toSet(), key.map((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.keyWithMaintainers(signatories, (String)x$4)));
    }

    public Node.NodeExercises<NodeId, Value.ContractId, Value<Value.ContractId>> exercise(Node.NodeCreate<Value.ContractId, Value<Value.ContractId>> contract, String choice, boolean consuming, Set<String> actingParties, Value<Value.ContractId> argument, boolean byKey) {
        Set x$1 = Predef$.MODULE$.Set().empty();
        Value.ContractId x$2 = (Value.ContractId)contract.coid();
        Ref.Identifier x$3 = contract.coinst().template();
        String x$4 = (String)Ref$.MODULE$.ChoiceName().assertFromString(choice);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = consuming;
        Set x$7 = (Set)actingParties.map((Function1 & Serializable & scala.Serializable)s -> (String)Ref$.MODULE$.Party().assertFromString(s), Set$.MODULE$.canBuildFrom());
        Value<Value.ContractId> x$8 = argument;
        Set x$9 = contract.stakeholders();
        Set x$10 = contract.signatories();
        ImmArray x$11 = ImmArray$.MODULE$.empty();
        None$ x$12 = None$.MODULE$;
        Option x$13 = contract.key();
        boolean x$14 = byKey;
        return this.Exercise().apply((Object)x$2, x$3, x$4, (Option)x$5, x$6, x$7, x$8, x$9, x$10, x$1, x$11, (Option)x$12, x$13, x$14);
    }

    public boolean exercise$default$6() {
        return true;
    }

    public Node.NodeExercises<NodeId, Value.ContractId, Value<Value.ContractId>> exerciseByKey(Node.NodeCreate<Value.ContractId, Value<Value.ContractId>> contract, String choice, boolean consuming, Set<String> actingParties, Value<Value.ContractId> argument) {
        return this.exercise(contract, choice, consuming, actingParties, argument, true);
    }

    public Node.NodeFetch<Value.ContractId, Value<Value.ContractId>> fetch(Node.NodeCreate<Value.ContractId, Value<Value.ContractId>> contract, boolean byKey) {
        return this.Fetch().apply(contract.coid(), contract.coinst().template(), (Option)None$.MODULE$, (Set)contract.signatories().map((Function1 & Serializable & scala.Serializable)s -> (String)Ref$.MODULE$.Party().assertFromString(s), Set$.MODULE$.canBuildFrom()), contract.signatories(), contract.stakeholders(), contract.key(), byKey);
    }

    public boolean fetch$default$2() {
        return true;
    }

    public Node.NodeFetch<Value.ContractId, Value<Value.ContractId>> fetchByKey(Node.NodeCreate<Value.ContractId, Value<Value.ContractId>> contract) {
        return this.fetch(contract, true);
    }

    public Node.NodeLookupByKey<Value.ContractId, Value<Value.ContractId>> lookupByKey(Node.NodeCreate<Value.ContractId, Value<Value.ContractId>> contract, boolean found) {
        return this.LookupByKey().apply(contract.coinst().template(), (Option)None$.MODULE$, (Node.KeyWithMaintainers)contract.key().get(), (Option)(found ? new Some(contract.coid()) : None$.MODULE$));
    }

    public VersionedTransaction<NodeId, Value.ContractId> just(Node.GenNode<NodeId, Value.ContractId, Value<Value.ContractId>> node2, Seq<Node.GenNode<NodeId, Value.ContractId, Value<Value.ContractId>>> nodes) {
        TransactionBuilder builder = this.apply();
        NodeId _ = builder.add(node2);
        nodes.foreach((Function1 & Serializable & scala.Serializable)node -> {
            nodeId = builder.add((Node.GenNode<NodeId, Value.ContractId, Value<Value.ContractId>>)node);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    public VersionedTransaction justSubmitted(Node.GenNode<NodeId, Value.ContractId, Value<Value.ContractId>> node, Seq<Node.GenNode<NodeId, Value.ContractId, Value<Value.ContractId>>> nodes) {
        return (VersionedTransaction)package$.MODULE$.SubmittedTransaction().apply(this.just(node, nodes));
    }

    public VersionedTransaction justCommitted(Node.GenNode<NodeId, Value.ContractId, Value<Value.ContractId>> node, Seq<Node.GenNode<NodeId, Value.ContractId, Value<Value.ContractId>>> nodes) {
        return (VersionedTransaction)package$.MODULE$.CommittedTransaction().apply(this.just(node, nodes));
    }

    public VersionedTransaction<NodeId, Value.ContractId> Empty() {
        return this.Empty;
    }

    public VersionedTransaction EmptySubmitted() {
        return this.EmptySubmitted;
    }

    public VersionedTransaction EmptyCommitted() {
        return this.EmptyCommitted;
    }

    private static final TransactionVersion pkgTxVersion$1(String pkgId, Function1 pkgLangVersion$1) {
        return (TransactionVersion)VersionTimeline$.MODULE$.latestWhenAllPresent(TransactionVersions$.MODULE$.StableOutputVersions().min(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new .bslash.div[]{VersionTimeline.Implicits$.MODULE$.any$u0020to$u0020SV(pkgLangVersion$1.apply((Object)pkgId), VersionTimeline.SubVersion$.MODULE$.language())}), VersionTimeline.SubVersion$.MODULE$.transaction());
    }

    private TransactionBuilder$() {
        MODULE$ = this;
        this.Create = Node$NodeCreate$.MODULE$;
        this.Exercise = Node$NodeExercises$.MODULE$;
        this.Fetch = Node$NodeFetch$.MODULE$;
        this.LookupByKey = Node$NodeLookupByKey$.MODULE$;
        this.KeyWithMaintainers = Node$KeyWithMaintainers$.MODULE$;
        this.Empty = VersionedTransaction$.MODULE$.apply((TransactionVersion)TransactionVersions$.MODULE$.StableOutputVersions().min(), (Map)HashMap$.MODULE$.empty(), ImmArray$.MODULE$.empty());
        this.EmptySubmitted = (VersionedTransaction)package$.MODULE$.SubmittedTransaction().apply(this.Empty());
        this.EmptyCommitted = (VersionedTransaction)package$.MODULE$.CommittedTransaction().apply(this.Empty());
    }
}

