/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.value.test;

import com.daml.lf.crypto.Hash;
import com.daml.lf.crypto.Hash$;
import com.daml.lf.data.BackStack;
import com.daml.lf.data.BackStack$;
import com.daml.lf.data.Bytes;
import com.daml.lf.data.Bytes$;
import com.daml.lf.data.Decimal$;
import com.daml.lf.data.FrontStack;
import com.daml.lf.data.FrontStack$;
import com.daml.lf.data.ImmArray;
import com.daml.lf.data.ImmArray$;
import com.daml.lf.data.Ref;
import com.daml.lf.data.Ref$;
import com.daml.lf.data.SortedLookupList$;
import com.daml.lf.data.Time;
import com.daml.lf.data.package$;
import com.daml.lf.transaction.Node;
import com.daml.lf.transaction.NodeId;
import com.daml.lf.transaction.Transaction;
import com.daml.lf.transaction.TransactionVersion;
import com.daml.lf.transaction.TransactionVersion$;
import com.daml.lf.transaction.Versioned;
import com.daml.lf.transaction.VersionedTransaction;
import com.daml.lf.transaction.VersionedTransaction$;
import com.daml.lf.transaction.test.TransactionBuilder$;
import com.daml.lf.value.Value;
import com.daml.lf.value.Value$;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.math.BigDecimal;
import org.scalacheck.Arbitrary$;
import org.scalacheck.Gen;
import org.scalacheck.Gen$;
import org.scalacheck.util.Buildable$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Factory$;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.math.BigDecimal$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scalaz.Apply;
import scalaz.scalacheck.ScalaCheckBinding$;

public final class ValueGenerators$ {
    public static final ValueGenerators$ MODULE$ = new ValueGenerators$();
    private static final Gen<String> moduleSegmentGen = Gen$.MODULE$.choose((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)100), Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable)n -> ValueGenerators$.$anonfun$moduleSegmentGen$1(BoxesRunTime.unboxToInt((Object)n)));
    private static final Gen<Ref.DottedName> moduleGen = Gen$.MODULE$.choose((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)10), Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable)n -> ValueGenerators$.$anonfun$moduleGen$1(BoxesRunTime.unboxToInt((Object)n)));
    private static final Gen<String> dottedNameSegmentGen = Gen$.MODULE$.alphaLowerChar().flatMap((Function1 & Serializable)ch -> ValueGenerators$.$anonfun$dottedNameSegmentGen$1(BoxesRunTime.unboxToChar((Object)ch)));
    private static final Gen<Ref.DottedName> dottedNameGen = Gen$.MODULE$.choose((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)10), Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable)n -> ValueGenerators$.$anonfun$dottedNameGen$1(BoxesRunTime.unboxToInt((Object)n)));
    private static final Gen<Ref.Identifier> idGen = Gen$.MODULE$.choose((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)64), Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable)n -> ValueGenerators$.$anonfun$idGen$1(BoxesRunTime.unboxToInt((Object)n)));
    private static final Gen<String> nameGen;
    private static final Time.Date minDate;
    private static final Time.Date maxDate;
    private static final Gen<Time.Date> dateGen;
    private static final Gen<Time.Timestamp> timestampGen;
    private static final Gen<Hash> genHash;
    private static final Gen<Bytes> genSuffixes;
    private static final Gen<Value.ContractId.V0> cidV0Gen;
    private static final Gen<Value.ContractId.V1> cidV1Gen;
    private static final Vector<Object> simpleChars;
    private static final Gen<Set<String>> genMaybeEmptyParties;
    private static final Gen<Set<String>> genNonEmptyParties;
    private static final Gen<Value.ContractInstance> contractInstanceGen;
    private static final Gen<Versioned<Value.ContractInstance>> versionedContractInstanceGen;
    private static final Gen<Node.KeyWithMaintainers> keyWithMaintainersGen;
    private static final Gen<Node.Create> malformedCreateNodeGen;
    private static final Gen<Node.Fetch> fetchNodeGen;
    private static final Gen<Node.Rollback> danglingRefRollbackNodeGen;
    private static final Gen<Node.Exercise> danglingRefExerciseNodeGen;
    private static final Gen<Node.LookupByKey> lookupNodeGen;
    private static final Gen<Transaction> malformedGenTransaction;
    private static final Gen<Transaction> noDanglingRefGenTransaction;
    private static final Gen<VersionedTransaction> noDanglingRefGenVersionedTransaction;

    static {
        Vector firstChars = Predef$.MODULE$.wrapString("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_$").toVector();
        Vector mainChars = (Vector)firstChars.$plus$plus((IterableOnce)Predef$.MODULE$.wrapString("1234567890"));
        nameGen = Gen$.MODULE$.oneOf((Seq)firstChars).flatMap((Function1 & Serializable)h -> ValueGenerators$.$anonfun$nameGen$1(mainChars, BoxesRunTime.unboxToChar((Object)h)));
        minDate = Time.Date$.MODULE$.assertFromString("1900-01-01");
        maxDate = Time.Date$.MODULE$.assertFromString("2100-12-31");
        dateGen = Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)MODULE$.minDate().days()), (Object)BoxesRunTime.boxToInteger((int)MODULE$.maxDate().days()), (Seq)Nil$.MODULE$, (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()).map((Function1 & Serializable)i -> Time.Date$.MODULE$.assertFromDaysSinceEpoch(BoxesRunTime.unboxToInt((Object)i)));
        timestampGen = Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToLong((long)Time.Timestamp$.MODULE$.MinValue().micros()), (Object)BoxesRunTime.boxToLong((long)Time.Timestamp$.MODULE$.MaxValue().micros()), (Seq)Nil$.MODULE$, (Numeric)Numeric.LongIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseLong()).map((Function1 & Serializable)micros -> Time.Timestamp$.MODULE$.assertFromLong(BoxesRunTime.unboxToLong((Object)micros)));
        genHash = Gen$.MODULE$.containerOfN(Hash$.MODULE$.underlyingHashLength(), Arbitrary$.MODULE$.arbitrary(Arbitrary$.MODULE$.arbByte()), Buildable$.MODULE$.buildableFactory(Factory$.MODULE$.arrayFactory((ClassTag)ClassTag$.MODULE$.Byte())), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs)).map((Function1 & Serializable)a -> Hash$.MODULE$.assertFromByteArray(a));
        genSuffixes = Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)Value.ContractId$.V1$.MODULE$.MaxSuffixLength()), (Seq)Nil$.MODULE$, (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable)sz -> ValueGenerators$.$anonfun$genSuffixes$1(BoxesRunTime.unboxToInt((Object)sz)));
        cidV0Gen = Gen$.MODULE$.alphaStr().map((Function1 & Serializable)t -> Value.ContractId$.V0$.MODULE$.assertFromString(StringOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(t), 254)), '#')));
        cidV1Gen = Gen$.MODULE$.zip(MODULE$.genHash(), MODULE$.genSuffixes()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Hash h = (Hash)tuple2._1();
            ByteString b = ((Bytes)tuple2._2()).value();
            Value.ContractId.V1 v1 = Value.ContractId$.V1$.MODULE$.assertBuild(h, b);
            return v1;
        });
        simpleChars = Predef$.MODULE$.wrapString("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_ ").toVector();
        genMaybeEmptyParties = Gen$.MODULE$.listOf((Function0 & Serializable)() -> MODULE$.party()).map((Function1 & Serializable)x$7 -> x$7.toSet());
        genNonEmptyParties = (Gen)scalaz.syntax.package$.MODULE$.apply().$up((Function0 & Serializable)() -> MODULE$.party(), (Function0 & Serializable)() -> MODULE$.genMaybeEmptyParties(), (Function2 & Serializable)(hd, tl) -> (Set)tl.$plus(hd), (Apply)ScalaCheckBinding$.MODULE$.GenMonad());
        contractInstanceGen = MODULE$.idGen().flatMap((Function1 & Serializable)template -> MODULE$.valueGen().flatMap((Function1 & Serializable)arg -> Arbitrary$.MODULE$.arbitrary(Arbitrary$.MODULE$.arbString()).map((Function1 & Serializable)agreement -> new Value.ContractInstance(template, arg, agreement))));
        versionedContractInstanceGen = MODULE$.idGen().flatMap((Function1 & Serializable)template -> MODULE$.versionedValueGen().flatMap((Function1 & Serializable)arg -> Arbitrary$.MODULE$.arbitrary(Arbitrary$.MODULE$.arbString()).map((Function1 & Serializable)agreement -> arg.map((Function1 & Serializable)x$8 -> new Value.ContractInstance(template, x$8, agreement)))));
        keyWithMaintainersGen = MODULE$.valueGen().flatMap((Function1 & Serializable)key -> MODULE$.genNonEmptyParties().map((Function1 & Serializable)maintainers -> new Node.KeyWithMaintainers(key, maintainers)));
        malformedCreateNodeGen = MODULE$.transactionVersionGen(MODULE$.transactionVersionGen$default$1(), MODULE$.transactionVersionGen$default$2()).flatMap((Function1 & Serializable)version -> MODULE$.malformedCreateNodeGenWithVersion((TransactionVersion)version).map((Function1 & Serializable)node -> node));
        fetchNodeGen = MODULE$.transactionVersionGen(MODULE$.transactionVersionGen$default$1(), MODULE$.transactionVersionGen$default$2()).flatMap((Function1 & Serializable)version -> MODULE$.fetchNodeGenWithVersion((TransactionVersion)version).map((Function1 & Serializable)node -> node));
        danglingRefRollbackNodeGen = Gen$.MODULE$.listOf((Function0 & Serializable)() -> Arbitrary$.MODULE$.arbInt().arbitrary()).map((Function1 & Serializable)x$9 -> x$9.map((Function1 & Serializable)x$10 -> ValueGenerators$.$anonfun$danglingRefRollbackNodeGen$3(BoxesRunTime.unboxToInt((Object)x$10)))).map((Function1 & Serializable)x$11 -> (ImmArray)x$11.to(IterableFactory$.MODULE$.toFactory((IterableFactory)ImmArray$.MODULE$))).map((Function1 & Serializable)children -> new Node.Rollback(children));
        danglingRefExerciseNodeGen = MODULE$.transactionVersionGen(MODULE$.transactionVersionGen$default$1(), MODULE$.transactionVersionGen$default$2()).flatMap((Function1 & Serializable)version -> MODULE$.danglingRefExerciseNodeGenWithVersion((TransactionVersion)version).map((Function1 & Serializable)node -> node));
        lookupNodeGen = MODULE$.transactionVersionGen(MODULE$.transactionVersionGen$default$1(), MODULE$.transactionVersionGen$default$2()).flatMap((Function1 & Serializable)version -> MODULE$.coidGen().flatMap((Function1 & Serializable)targetCoid -> MODULE$.idGen().flatMap((Function1 & Serializable)templateId -> MODULE$.keyWithMaintainersGen().flatMap((Function1 & Serializable)key -> Gen$.MODULE$.option(Gen$.MODULE$.const(targetCoid)).map((Function1 & Serializable)result -> new Node.LookupByKey(templateId, key, result, version))))));
        malformedGenTransaction = Gen$.MODULE$.listOf((Function0 & Serializable)() -> MODULE$.danglingRefGenNode()).flatMap((Function1 & Serializable)nodes -> Gen$.MODULE$.listOf((Function0 & Serializable)() -> Arbitrary$.MODULE$.arbInt().arbitrary().map((Function1 & Serializable)x$19 -> ValueGenerators$.$anonfun$malformedGenTransaction$4(BoxesRunTime.unboxToInt((Object)x$19)))).map((Function1 & Serializable)roots -> new Transaction(nodes.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (ImmArray)roots.to(IterableFactory$.MODULE$.toFactory((IterableFactory)ImmArray$.MODULE$)))));
        noDanglingRefGenTransaction = MODULE$.nonDanglingRefNodeGen$1(3, new NodeId(0)).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ImmArray nodeIds = (ImmArray)tuple2._1();
            HashMap nodes = (HashMap)tuple2._2();
            Transaction transaction = new Transaction((Map)nodes, nodeIds);
            return transaction;
        });
        noDanglingRefGenVersionedTransaction = MODULE$.noDanglingRefGenTransaction().flatMap((Function1 & Serializable)tx -> MODULE$.transactionVersionGen(MODULE$.transactionVersionGen$default$1(), MODULE$.transactionVersionGen$default$2()).map((Function1 & Serializable)txVer -> {
            Gen nodeVersionGen = MODULE$.transactionVersionGen(MODULE$.transactionVersionGen$default$1(), MODULE$.transactionVersionGen$default$2()).filterNot((Function1 & Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)ValueGenerators$.$anonfun$noDanglingRefGenVersionedTransaction$3(txVer, x$30)));
            return new Tuple2(txVer, (Object)nodeVersionGen);
        }).flatMap((Function1 & Serializable)x$31 -> {
            Tuple2 tuple2 = x$31;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TransactionVersion txVer = (TransactionVersion)tuple2._1();
            Gen gen = ((Gen)tx.fold((Object)Gen$.MODULE$.const((Object)HashMap$.MODULE$.empty()), (Function2 & Serializable)(x0$3, x1$1) -> {
                Tuple2 tuple2;
                Gen acc;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$3, x1$1);
                        if (tuple22 == null) break block2;
                        acc = (Gen)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                NodeId nodeId = (NodeId)tuple2._1();
                Node node = (Node)tuple2._2();
                Gen gen = acc.map((Function1 & Serializable)hashMap -> hashMap.updated((Object)nodeId, (Object)node));
                return gen;
            })).map((Function1 & Serializable)nodes -> VersionedTransaction$.MODULE$.apply(txVer, (Map)nodes, tx.roots()));
            return gen;
        }));
    }

    public Gen<BigDecimal> numGen(int scale) {
        Gen num = Gen$.MODULE$.listOfN(package$.MODULE$.Numeric().maxPrecision() - scale, Gen$.MODULE$.choose((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)9), Gen.Choose$.MODULE$.chooseInt())).map((Function1 & Serializable)x$1 -> x$1.mkString()).flatMap((Function1 & Serializable)integerPart -> Gen$.MODULE$.listOfN(scale, Gen$.MODULE$.choose((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)9), Gen.Choose$.MODULE$.chooseInt())).map((Function1 & Serializable)x$2 -> x$2.mkString()).map((Function1 & Serializable)decimalPart -> package$.MODULE$.Numeric().assertFromString(new StringBuilder(1).append((String)integerPart).append(".").append((String)decimalPart).toString())));
        return Gen$.MODULE$.frequency((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)Gen$.MODULE$.const((Object)package$.MODULE$.Numeric().assertFromBigDecimal(scale, BigDecimal$.MODULE$.int2bigDecimal(0)))), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)Gen$.MODULE$.const((Object)package$.MODULE$.Numeric().maxValue(scale))), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)Gen$.MODULE$.const((Object)package$.MODULE$.Numeric().minValue(scale))), new Tuple2((Object)BoxesRunTime.boxToInteger((int)5), (Object)num)}));
    }

    public Gen<BigDecimal> unscaledNumGen() {
        return Gen$.MODULE$.oneOf((Seq)package$.MODULE$.Numeric().Scale().values()).flatMap((Function1 & Serializable)scale -> ValueGenerators$.MODULE$.numGen(BoxesRunTime.unboxToInt((Object)scale)));
    }

    public Gen<String> moduleSegmentGen() {
        return moduleSegmentGen;
    }

    public Gen<Ref.DottedName> moduleGen() {
        return moduleGen;
    }

    public Gen<String> dottedNameSegmentGen() {
        return dottedNameSegmentGen;
    }

    public Gen<Ref.DottedName> dottedNameGen() {
        return dottedNameGen;
    }

    public Gen<Ref.Identifier> idGen() {
        return idGen;
    }

    public Gen<String> nameGen() {
        return nameGen;
    }

    private Time.Date minDate() {
        return minDate;
    }

    private Time.Date maxDate() {
        return maxDate;
    }

    public Gen<Time.Date> dateGen() {
        return dateGen;
    }

    public Gen<Time.Timestamp> timestampGen() {
        return timestampGen;
    }

    private Gen<Value.ValueVariant> variantGen(int nesting) {
        return this.idGen().flatMap((Function1 & Serializable)id -> MODULE$.nameGen().flatMap((Function1 & Serializable)variantName -> Gen$.MODULE$.oneOf((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Seq)Nil$.MODULE$).map((Function1 & Serializable)withoutLabels -> ValueGenerators$.$anonfun$variantGen$3(BoxesRunTime.unboxToBoolean((Object)withoutLabels))).flatMap((Function1 & Serializable)toOption -> Gen$.MODULE$.lzy((Function0 & Serializable)() -> MODULE$.valueGen(nesting)).map((Function1 & Serializable)value -> new Value.ValueVariant((Option)toOption.apply(id), variantName, value)))));
    }

    public Gen<Value.ValueVariant> variantGen() {
        return this.variantGen(0);
    }

    private Gen<Value.ValueRecord> recordGen(int nesting) {
        return this.idGen().flatMap((Function1 & Serializable)id -> Gen$.MODULE$.oneOf((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Seq)Nil$.MODULE$).map((Function1 & Serializable)a -> ValueGenerators$.$anonfun$recordGen$2(BoxesRunTime.unboxToBoolean((Object)a))).flatMap((Function1 & Serializable)toOption -> Gen$.MODULE$.listOf((Function0 & Serializable)() -> MODULE$.nameGen().flatMap((Function1 & Serializable)label -> Gen$.MODULE$.lzy((Function0 & Serializable)() -> MODULE$.valueGen(nesting)).map((Function1 & Serializable)x -> label.isEmpty() ? new Tuple2((Object)None$.MODULE$, x) : new Tuple2((Object)new Some(label), x)))).map((Function1 & Serializable)labelledValues -> new Value.ValueRecord((Option)toOption.apply(id), (ImmArray)labelledValues.to(IterableFactory$.MODULE$.toFactory((IterableFactory)ImmArray$.MODULE$))))));
    }

    public Gen<Value.ValueRecord> recordGen() {
        return this.recordGen(0);
    }

    private Gen<Value.ValueOptional> valueOptionalGen(int nesting) {
        return Gen$.MODULE$.option(this.valueGen(nesting)).map((Function1 & Serializable)v -> new Value.ValueOptional(v));
    }

    public Gen<Value.ValueOptional> valueOptionalGen() {
        return this.valueOptionalGen(0);
    }

    private Gen<Value.ValueList> valueListGen(int nesting) {
        return Gen$.MODULE$.listOf((Function0 & Serializable)() -> Gen$.MODULE$.lzy((Function0 & Serializable)() -> MODULE$.valueGen(nesting))).map((Function1 & Serializable)values -> new Value.ValueList((FrontStack)values.to(IterableFactory$.MODULE$.toFactory((IterableFactory)FrontStack$.MODULE$))));
    }

    public Gen<Value.ValueList> valueListGen() {
        return this.valueListGen(0);
    }

    private Gen<Value.ValueTextMap> valueMapGen(int nesting) {
        return Gen$.MODULE$.listOf((Function0 & Serializable)() -> Gen$.MODULE$.asciiPrintableStr().flatMap((Function1 & Serializable)k -> Gen$.MODULE$.lzy((Function0 & Serializable)() -> MODULE$.valueGen(nesting)).map((Function1 & Serializable)v -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(k), v)))).map((Function1 & Serializable)list -> new Value.ValueTextMap(SortedLookupList$.MODULE$.apply((Map)Predef$.MODULE$.Map().apply((Seq)list))));
    }

    public Gen<Value.ValueTextMap> valueMapGen() {
        return this.valueMapGen(0);
    }

    private Gen<Value.ValueGenMap> valueGenMapGen(int nesting) {
        return Gen$.MODULE$.listOf((Function0 & Serializable)() -> Gen$.MODULE$.zip(Gen$.MODULE$.lzy((Function0 & Serializable)() -> MODULE$.valueGen(nesting)), Gen$.MODULE$.lzy((Function0 & Serializable)() -> MODULE$.valueGen(nesting)))).map((Function1 & Serializable)list -> new Value.ValueGenMap((ImmArray)list.to(IterableFactory$.MODULE$.toFactory((IterableFactory)ImmArray$.MODULE$))));
    }

    public Gen<Value.ValueGenMap> valueGenMapGen() {
        return this.valueGenMapGen(0);
    }

    private Gen<Hash> genHash() {
        return genHash;
    }

    private Gen<Bytes> genSuffixes() {
        return genSuffixes;
    }

    public Gen<Value.ContractId.V0> cidV0Gen() {
        return cidV0Gen;
    }

    private Gen<Value.ContractId.V1> cidV1Gen() {
        return cidV1Gen;
    }

    public Seq<Gen<Value.ContractId>> comparableCoidsGen() {
        return (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gen[]{Gen$.MODULE$.oneOf(this.cidV0Gen(), Gen$.MODULE$.zip(this.cidV1Gen(), Arbitrary$.MODULE$.arbitrary(Arbitrary$.MODULE$.arbByte())).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Value.ContractId.V1 b1 = (Value.ContractId.V1)tuple2._1();
            byte b = BoxesRunTime.unboxToByte((Object)tuple2._2());
            Value.ContractId.V1 v1 = Value.ContractId$.V1$.MODULE$.assertBuild(b1.discriminator(), Bytes$.MODULE$.nonEmpty$extension(b1.suffix()) ? b1.suffix() : Bytes$.MODULE$.fromByteArray(new byte[]{b}));
            return v1;
        }), (Seq)Nil$.MODULE$), Gen$.MODULE$.oneOf(this.cidV0Gen(), this.cidV1Gen().map((Function1 & Serializable)cid -> Value.ContractId$.V1$.MODULE$.apply(cid.discriminator())), (Seq)Nil$.MODULE$)}));
    }

    public Gen<Value.ContractId> coidGen() {
        return Gen$.MODULE$.oneOf(this.cidV0Gen(), this.cidV1Gen(), (Seq)Nil$.MODULE$);
    }

    public Gen<Value.ValueContractId> coidValueGen() {
        return this.coidGen().map((Function1 & Serializable)x$5 -> new Value.ValueContractId(x$5));
    }

    private Gen<Value> valueGen(int nesting) {
        return Gen$.MODULE$.sized((Function1 & Serializable)sz -> ValueGenerators$.$anonfun$valueGen$1(nesting, BoxesRunTime.unboxToInt((Object)sz)));
    }

    private Vector<Object> simpleChars() {
        return simpleChars;
    }

    public Gen<String> simpleStr() {
        return Gen$.MODULE$.nonEmptyListOf((Function0 & Serializable)() -> Gen$.MODULE$.oneOf(MODULE$.simpleChars())).map((Function1 & Serializable)s -> (String)Ref$.MODULE$.PackageId().assertFromString(s.mkString()));
    }

    public Gen<String> party() {
        return Gen$.MODULE$.nonEmptyListOf((Function0 & Serializable)() -> Gen$.MODULE$.oneOf(MODULE$.simpleChars())).map((Function1 & Serializable)s -> (String)Ref$.MODULE$.Party().assertFromString(s.take(255).mkString()));
    }

    public Gen<Value> valueGen() {
        return this.valueGen(0);
    }

    public Gen<Versioned<Value>> versionedValueGen() {
        return this.valueGen().map((Function1 & Serializable)value -> {
            TransactionVersion minVersion = TransactionBuilder$.MODULE$.assertAssignVersion((Value)value, TransactionBuilder$.MODULE$.assertAssignVersion$default$2());
            return new Tuple2(value, (Object)minVersion);
        }).flatMap((Function1 & Serializable)x$6 -> {
            Tuple2 tuple2 = x$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Value value = (Value)tuple2._1();
            TransactionVersion minVersion = (TransactionVersion)tuple2._2();
            Gen gen = MODULE$.transactionVersionGen(minVersion, MODULE$.transactionVersionGen$default$2()).map((Function1 & Serializable)version -> new Versioned(version, (Object)value));
            return gen;
        });
    }

    public Gen<Set<String>> genMaybeEmptyParties() {
        return genMaybeEmptyParties;
    }

    public Gen<Set<String>> genNonEmptyParties() {
        return genNonEmptyParties;
    }

    public Gen<Value.ContractInstance> contractInstanceGen() {
        return contractInstanceGen;
    }

    public Gen<Versioned<Value.ContractInstance>> versionedContractInstanceGen() {
        return versionedContractInstanceGen;
    }

    public Gen<Node.KeyWithMaintainers> keyWithMaintainersGen() {
        return keyWithMaintainersGen;
    }

    public Gen<Node.Create> malformedCreateNodeGen() {
        return malformedCreateNodeGen;
    }

    public Gen<Node.Create> malformedCreateNodeGenWithVersion(TransactionVersion version) {
        return this.coidGen().flatMap((Function1 & Serializable)coid -> MODULE$.idGen().flatMap((Function1 & Serializable)templateId -> MODULE$.valueGen().flatMap((Function1 & Serializable)arg -> Arbitrary$.MODULE$.arbitrary(Arbitrary$.MODULE$.arbString()).flatMap((Function1 & Serializable)agreement -> MODULE$.genNonEmptyParties().flatMap((Function1 & Serializable)signatories -> MODULE$.genNonEmptyParties().flatMap((Function1 & Serializable)stakeholders -> Gen$.MODULE$.option(MODULE$.keyWithMaintainersGen()).map((Function1 & Serializable)key -> new Node.Create(coid, templateId, arg, agreement, signatories, stakeholders, key, (Option)None$.MODULE$, version))))))));
    }

    public Gen<Node.Fetch> fetchNodeGen() {
        return fetchNodeGen;
    }

    public Gen<Node.Fetch> fetchNodeGenWithVersion(TransactionVersion version) {
        return this.coidGen().flatMap((Function1 & Serializable)coid -> MODULE$.idGen().flatMap((Function1 & Serializable)templateId -> MODULE$.genNonEmptyParties().flatMap((Function1 & Serializable)actingParties -> MODULE$.genNonEmptyParties().flatMap((Function1 & Serializable)signatories -> MODULE$.genNonEmptyParties().flatMap((Function1 & Serializable)stakeholders -> Gen$.MODULE$.option(MODULE$.keyWithMaintainersGen()).flatMap((Function1 & Serializable)key -> Gen$.MODULE$.oneOf((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Seq)Nil$.MODULE$).map((Function1 & Serializable)byKey -> ValueGenerators$.$anonfun$fetchNodeGenWithVersion$7(coid, templateId, actingParties, signatories, stakeholders, key, version, BoxesRunTime.unboxToBoolean((Object)byKey)))))))));
    }

    public Gen<Node.Rollback> danglingRefRollbackNodeGen() {
        return danglingRefRollbackNodeGen;
    }

    public Gen<Node.Exercise> danglingRefExerciseNodeGen() {
        return danglingRefExerciseNodeGen;
    }

    public Gen<Node.Exercise> danglingRefExerciseNodeGenWithVersion(TransactionVersion version) {
        return this.coidGen().flatMap((Function1 & Serializable)targetCoid -> MODULE$.idGen().flatMap((Function1 & Serializable)templateId -> MODULE$.nameGen().flatMap((Function1 & Serializable)choiceId -> Gen$.MODULE$.oneOf((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Seq)Nil$.MODULE$).flatMap((Function1 & Serializable)consume -> ValueGenerators$.$anonfun$danglingRefExerciseNodeGenWithVersion$4(version, targetCoid, templateId, choiceId, BoxesRunTime.unboxToBoolean((Object)consume))))));
    }

    public Gen<Node.LookupByKey> lookupNodeGen() {
        return lookupNodeGen;
    }

    public Gen<Tuple2<NodeId, Node.Action>> danglingRefGenActionNode() {
        return Arbitrary$.MODULE$.arbInt().arbitrary().map((Function1 & Serializable)x$16 -> ValueGenerators$.$anonfun$danglingRefGenActionNode$1(BoxesRunTime.unboxToInt((Object)x$16))).flatMap((Function1 & Serializable)id -> MODULE$.transactionVersionGen(MODULE$.transactionVersionGen$default$1(), MODULE$.transactionVersionGen$default$2()).map((Function1 & Serializable)version -> {
            Gen<Node.Create> create = MODULE$.malformedCreateNodeGenWithVersion((TransactionVersion)version);
            Gen<Node.Exercise> exe = MODULE$.danglingRefExerciseNodeGenWithVersion((TransactionVersion)version);
            Gen<Node.Fetch> fetch = MODULE$.fetchNodeGenWithVersion((TransactionVersion)version);
            return new Tuple4(version, create, exe, fetch);
        }).flatMap((Function1 & Serializable)x$17 -> {
            Tuple4 tuple4 = x$17;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            Gen create = (Gen)tuple4._2();
            Gen exe = (Gen)tuple4._3();
            Gen fetch = (Gen)tuple4._4();
            Gen gen = Gen$.MODULE$.oneOf(create, exe, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gen[]{fetch})).map((Function1 & Serializable)node -> new Tuple2(id, node));
            return gen;
        }));
    }

    public Gen<Tuple2<NodeId, Node>> danglingRefGenNode() {
        return this.transactionVersionGen(this.transactionVersionGen$default$1(), this.transactionVersionGen$default$2()).flatMap((Function1 & Serializable)version -> MODULE$.danglingRefGenNodeWithVersion((TransactionVersion)version).map((Function1 & Serializable)node -> node));
    }

    private Gen<Tuple2<NodeId, Node>> refGenNode(Gen<Node> g) {
        return Arbitrary$.MODULE$.arbInt().arbitrary().map((Function1 & Serializable)x$18 -> ValueGenerators$.$anonfun$refGenNode$1(BoxesRunTime.unboxToInt((Object)x$18))).flatMap((Function1 & Serializable)id -> g.map((Function1 & Serializable)node -> new Tuple2(id, node)));
    }

    public Gen<Tuple2<NodeId, Node>> danglingRefGenActionNodeWithVersion(TransactionVersion version) {
        return this.refGenNode((Gen<Node>)Gen$.MODULE$.oneOf(this.malformedCreateNodeGenWithVersion(version), this.danglingRefExerciseNodeGenWithVersion(version), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gen[]{this.fetchNodeGenWithVersion(version)})));
    }

    public Gen<Tuple2<NodeId, Node>> danglingRefGenNodeWithVersion(TransactionVersion version) {
        return Ordering.Implicits$.MODULE$.infixOrderingOps((Object)version, TransactionVersion$.MODULE$.Ordering()).$less((Object)TransactionVersion$.MODULE$.minExceptions()) ? this.danglingRefGenActionNodeWithVersion(version) : Gen$.MODULE$.frequency((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), this.danglingRefGenActionNodeWithVersion(version)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), this.refGenNode(this.danglingRefRollbackNodeGen()))}));
    }

    public Gen<Transaction> malformedGenTransaction() {
        return malformedGenTransaction;
    }

    public Gen<Transaction> noDanglingRefGenTransaction() {
        return noDanglingRefGenTransaction;
    }

    public Gen<VersionedTransaction> noDanglingRefGenVersionedTransaction() {
        return noDanglingRefGenVersionedTransaction;
    }

    public Gen<String> stringVersionGen() {
        Gen g = Gen$.MODULE$.posNum((Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable)major -> ValueGenerators$.$anonfun$stringVersionGen$1(BoxesRunTime.unboxToInt((Object)major)));
        return Gen$.MODULE$.frequency((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)Gen$.MODULE$.const((Object)"")), new Tuple2((Object)BoxesRunTime.boxToInteger((int)10), (Object)g)}));
    }

    public Gen<TransactionVersion> transactionVersionGen(TransactionVersion minVersion, Option<TransactionVersion> maxVersion) {
        return Gen$.MODULE$.oneOf((Seq)TransactionVersion$.MODULE$.All().filter((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)ValueGenerators$.$anonfun$transactionVersionGen$1(minVersion, maxVersion, v))));
    }

    public TransactionVersion transactionVersionGen$default$1() {
        return TransactionVersion$.MODULE$.minVersion();
    }

    public Option<TransactionVersion> transactionVersionGen$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ Gen $anonfun$moduleSegmentGen$1(int n) {
        return Gen$.MODULE$.listOfN(n, Gen$.MODULE$.alphaChar()).map((Function1 & Serializable)name -> StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(name.mkString())));
    }

    public static final /* synthetic */ Gen $anonfun$moduleGen$1(int n) {
        return Gen$.MODULE$.listOfN(n, MODULE$.moduleSegmentGen()).map((Function1 & Serializable)segments -> Ref$.MODULE$.ModuleName().assertFromSegments((Iterable)segments));
    }

    public static final /* synthetic */ Gen $anonfun$dottedNameSegmentGen$2(char ch$1, int n) {
        return Gen$.MODULE$.listOfN(n, Gen$.MODULE$.alphaChar()).map((Function1 & Serializable)name -> {
            char c = ch$1;
            return name.$colon$colon((Object)BoxesRunTime.boxToCharacter((char)c)).mkString();
        });
    }

    public static final /* synthetic */ Gen $anonfun$dottedNameSegmentGen$1(char ch) {
        return Gen$.MODULE$.choose((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)99), Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable)n -> ValueGenerators$.$anonfun$dottedNameSegmentGen$2(ch, BoxesRunTime.unboxToInt((Object)n)));
    }

    public static final /* synthetic */ Gen $anonfun$dottedNameGen$1(int n) {
        return Gen$.MODULE$.listOfN(n, MODULE$.dottedNameSegmentGen()).map((Function1 & Serializable)segments -> Ref.DottedName$.MODULE$.assertFromSegments((Iterable)segments));
    }

    public static final /* synthetic */ Gen $anonfun$idGen$1(int n) {
        return Gen$.MODULE$.listOfN(n, Gen$.MODULE$.alphaNumChar()).map((Function1 & Serializable)s -> (String)Ref$.MODULE$.PackageId().assertFromString(s.mkString())).flatMap((Function1 & Serializable)packageId -> MODULE$.moduleGen().flatMap((Function1 & Serializable)module -> MODULE$.dottedNameGen().map((Function1 & Serializable)name -> new Ref.Identifier(packageId, Ref.QualifiedName$.MODULE$.apply(module, name)))));
    }

    public static final /* synthetic */ Gen $anonfun$nameGen$1(Vector mainChars$1, char h) {
        return Gen$.MODULE$.listOf((Function0 & Serializable)() -> Gen$.MODULE$.oneOf((Seq)mainChars$1)).map((Function1 & Serializable)t -> {
            char c = h;
            return (String)Ref$.MODULE$.Name().assertFromString(t.$colon$colon((Object)BoxesRunTime.boxToCharacter((char)c)).mkString());
        });
    }

    public static final /* synthetic */ Function1 $anonfun$variantGen$3(boolean withoutLabels) {
        return withoutLabels ? (Function1 & Serializable)x$3 -> None$.MODULE$ : (Function1 & Serializable)variantId -> new Some(variantId);
    }

    public static final /* synthetic */ Function1 $anonfun$recordGen$2(boolean a) {
        return a ? (Function1 & Serializable)x$4 -> None$.MODULE$ : (Function1 & Serializable)x -> new Some(x);
    }

    public static final /* synthetic */ Gen $anonfun$genSuffixes$1(int sz) {
        return Gen$.MODULE$.containerOfN(sz, Arbitrary$.MODULE$.arbitrary(Arbitrary$.MODULE$.arbByte()), Buildable$.MODULE$.buildableFactory(Factory$.MODULE$.arrayFactory((ClassTag)ClassTag$.MODULE$.Byte())), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs)).map((Function1 & Serializable)ab -> new Bytes(Bytes$.MODULE$.fromByteArray(ab)));
    }

    public static final /* synthetic */ Gen $anonfun$valueGen$1(int nesting$6, int sz) {
        int newNesting = nesting$6 + 1;
        List nested = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)(sz / 2 + 1)), (Object)Gen$.MODULE$.resize(sz / 5, MODULE$.valueListGen(newNesting))), new Tuple2((Object)BoxesRunTime.boxToInteger((int)(sz / 2 + 1)), (Object)Gen$.MODULE$.resize(sz / 5, MODULE$.variantGen(newNesting))), new Tuple2((Object)BoxesRunTime.boxToInteger((int)(sz / 2 + 1)), (Object)Gen$.MODULE$.resize(sz / 5, MODULE$.recordGen(newNesting))), new Tuple2((Object)BoxesRunTime.boxToInteger((int)(sz / 2 + 1)), (Object)Gen$.MODULE$.resize(sz / 5, MODULE$.valueOptionalGen(newNesting))), new Tuple2((Object)BoxesRunTime.boxToInteger((int)(sz / 2 + 1)), (Object)Gen$.MODULE$.resize(sz / 5, MODULE$.valueMapGen(newNesting)))}));
        List flat = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)(sz + 1)), (Object)MODULE$.dateGen().map((Function1)Value.ValueDate$.MODULE$)), new Tuple2((Object)BoxesRunTime.boxToInteger((int)(sz + 1)), (Object)Gen$.MODULE$.alphaStr().map((Function1)Value.ValueText$.MODULE$)), new Tuple2((Object)BoxesRunTime.boxToInteger((int)(sz + 1)), (Object)MODULE$.unscaledNumGen().map((Function1)Value.ValueNumeric$.MODULE$)), new Tuple2((Object)BoxesRunTime.boxToInteger((int)(sz + 1)), (Object)MODULE$.numGen(Decimal$.MODULE$.scale()).map((Function1)Value.ValueNumeric$.MODULE$)), new Tuple2((Object)BoxesRunTime.boxToInteger((int)(sz + 1)), (Object)Arbitrary$.MODULE$.arbLong().arbitrary().map((Function1)Value.ValueInt64$.MODULE$)), new Tuple2((Object)BoxesRunTime.boxToInteger((int)(sz + 1)), (Object)Gen$.MODULE$.alphaStr().map((Function1)Value.ValueText$.MODULE$)), new Tuple2((Object)BoxesRunTime.boxToInteger((int)(sz + 1)), (Object)MODULE$.timestampGen().map((Function1)Value.ValueTimestamp$.MODULE$)), new Tuple2((Object)BoxesRunTime.boxToInteger((int)(sz + 1)), MODULE$.coidValueGen()), new Tuple2((Object)BoxesRunTime.boxToInteger((int)(sz + 1)), (Object)MODULE$.party().map((Function1)Value.ValueParty$.MODULE$)), new Tuple2((Object)BoxesRunTime.boxToInteger((int)(sz + 1)), (Object)Gen$.MODULE$.oneOf((Object)Value$.MODULE$.ValueTrue(), (Object)Value$.MODULE$.ValueFalse(), (Seq)Nil$.MODULE$))}));
        List all = nesting$6 >= Value$.MODULE$.MAXIMUM_NESTING() ? (List)scala.package$.MODULE$.List().apply((Seq)Nil$.MODULE$) : (List)nested.$plus$plus((IterableOnce)flat);
        return Gen$.MODULE$.frequency((Seq)all);
    }

    public static final /* synthetic */ Node.Fetch $anonfun$fetchNodeGenWithVersion$7(Value.ContractId coid$2, Ref.Identifier templateId$2, Set actingParties$1, Set signatories$2, Set stakeholders$2, Option key$2, TransactionVersion version$2, boolean byKey) {
        return new Node.Fetch(coid$2, templateId$2, actingParties$1, signatories$2, stakeholders$2, key$2, byKey, (Option)None$.MODULE$, version$2);
    }

    public static final /* synthetic */ NodeId $anonfun$danglingRefRollbackNodeGen$3(int x$10) {
        return new NodeId(x$10);
    }

    public static final /* synthetic */ NodeId $anonfun$danglingRefExerciseNodeGenWithVersion$12(int x$13) {
        return new NodeId(x$13);
    }

    public static final /* synthetic */ Node.Exercise $anonfun$danglingRefExerciseNodeGenWithVersion$18(Value.ContractId targetCoid$1, Ref.Identifier templateId$3, String choiceId$1, boolean consume$1, Set actingParties$2, Value chosenValue$1, Set stakeholders$3, Set signatories$3, Set choiceObservers$1, ImmArray children$1, Option exerciseResult$1, Option key$3, TransactionVersion version$3, boolean byKey) {
        return new Node.Exercise(targetCoid$1, templateId$3, choiceId$1, consume$1, actingParties$2, chosenValue$1, stakeholders$3, signatories$3, choiceObservers$1, children$1, exerciseResult$1, key$3, byKey, (Option)None$.MODULE$, version$3);
    }

    public static final /* synthetic */ Gen $anonfun$danglingRefExerciseNodeGenWithVersion$4(TransactionVersion version$3, Value.ContractId targetCoid$1, Ref.Identifier templateId$3, String choiceId$1, boolean consume) {
        return MODULE$.genNonEmptyParties().flatMap((Function1 & Serializable)actingParties -> MODULE$.valueGen().flatMap((Function1 & Serializable)chosenValue -> MODULE$.genNonEmptyParties().flatMap((Function1 & Serializable)stakeholders -> MODULE$.genNonEmptyParties().flatMap((Function1 & Serializable)signatories -> MODULE$.genMaybeEmptyParties().flatMap((Function1 & Serializable)choiceObservers -> Gen$.MODULE$.listOf((Function0 & Serializable)() -> Arbitrary$.MODULE$.arbInt().arbitrary()).map((Function1 & Serializable)x$12 -> x$12.map((Function1 & Serializable)x$13 -> ValueGenerators$.$anonfun$danglingRefExerciseNodeGenWithVersion$12(BoxesRunTime.unboxToInt((Object)x$13)))).map((Function1 & Serializable)x$14 -> (ImmArray)x$14.to(IterableFactory$.MODULE$.toFactory((IterableFactory)ImmArray$.MODULE$))).flatMap((Function1 & Serializable)children -> (Ordering.Implicits$.MODULE$.infixOrderingOps((Object)version$3, TransactionVersion$.MODULE$.Ordering()).$less((Object)TransactionVersion$.MODULE$.minExceptions()) ? MODULE$.valueGen().map((Function1 & Serializable)x$15 -> new Some(x$15)) : Gen$.MODULE$.option(MODULE$.valueGen())).flatMap((Function1 & Serializable)exerciseResult -> Gen$.MODULE$.option(MODULE$.keyWithMaintainersGen()).flatMap((Function1 & Serializable)key -> Gen$.MODULE$.oneOf((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Seq)Nil$.MODULE$).map((Function1 & Serializable)byKey -> ValueGenerators$.$anonfun$danglingRefExerciseNodeGenWithVersion$18(targetCoid$1, templateId$3, choiceId$1, consume, actingParties, chosenValue, stakeholders, signatories, choiceObservers, children, exerciseResult, key, version$3, BoxesRunTime.unboxToBoolean((Object)byKey)))))))))));
    }

    public static final /* synthetic */ NodeId $anonfun$danglingRefGenActionNode$1(int x$16) {
        return new NodeId(x$16);
    }

    public static final /* synthetic */ NodeId $anonfun$refGenNode$1(int x$18) {
        return new NodeId(x$18);
    }

    public static final /* synthetic */ NodeId $anonfun$malformedGenTransaction$4(int x$19) {
        return new NodeId(x$19);
    }

    public static final /* synthetic */ Gen $anonfun$noDanglingRefGenTransaction$2(ValueGenerators$ $this, NodeId nodeId$1, Node.Exercise x2$1, int depth) {
        return $this.nonDanglingRefNodeGen$1(depth, nodeId$1).map((Function1 & Serializable)nodeWithChildren -> {
            Tuple2 tuple2 = nodeWithChildren;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ImmArray children = (ImmArray)tuple2._1();
            HashMap nodes = (HashMap)tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)tuple2, (Object)children, (Object)nodes);
            Tuple3 tuple32 = tuple3;
            Tuple2 x$20 = (Tuple2)tuple32._1();
            ImmArray children2 = (ImmArray)tuple32._2();
            HashMap nodes2 = (HashMap)tuple32._3();
            return new Tuple2(nodeWithChildren, (Object)x$20);
        }).map((Function1 & Serializable)x$22 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$22;
            if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
                throw new MatchError((Object)tuple22);
            }
            ImmArray children = (ImmArray)tuple2._1();
            HashMap nodes = (HashMap)tuple2._2();
            ImmArray x$1 = children;
            Value.ContractId x$2 = x2$1.copy$default$1();
            Ref.Identifier x$3 = x2$1.copy$default$2();
            String x$4 = x2$1.copy$default$3();
            boolean x$5 = x2$1.copy$default$4();
            Set x$6 = x2$1.copy$default$5();
            Value x$7 = x2$1.copy$default$6();
            Set x$8 = x2$1.copy$default$7();
            Set x$9 = x2$1.copy$default$8();
            Set x$10 = x2$1.copy$default$9();
            Option x$11 = x2$1.copy$default$11();
            Option x$12 = x2$1.copy$default$12();
            boolean x$13 = x2$1.copy$default$13();
            Option x$14 = x2$1.copy$default$14();
            TransactionVersion x$15 = x2$1.copy$default$15();
            Tuple2 tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x2$1.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$1, x$11, x$12, x$13, x$14, x$15)), (Object)nodes);
            return tuple23;
        });
    }

    public static final /* synthetic */ Gen $anonfun$noDanglingRefGenTransaction$5(ValueGenerators$ $this, NodeId nodeId$1, Node.Rollback x3$1, int depth) {
        return $this.nonDanglingRefNodeGen$1(depth, nodeId$1).map((Function1 & Serializable)nodeWithChildren -> {
            Tuple2 tuple2 = nodeWithChildren;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ImmArray children = (ImmArray)tuple2._1();
            HashMap nodes = (HashMap)tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)tuple2, (Object)children, (Object)nodes);
            Tuple3 tuple32 = tuple3;
            Tuple2 x$23 = (Tuple2)tuple32._1();
            ImmArray children2 = (ImmArray)tuple32._2();
            HashMap nodes2 = (HashMap)tuple32._3();
            return new Tuple2(nodeWithChildren, (Object)x$23);
        }).map((Function1 & Serializable)x$25 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$25;
            if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
                throw new MatchError((Object)tuple22);
            }
            ImmArray children = (ImmArray)tuple2._1();
            HashMap nodes = (HashMap)tuple2._2();
            Tuple2 tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x3$1.copy(children)), (Object)nodes);
            return tuple23;
        });
    }

    private final Gen nodeGen$1(NodeId nodeId, int exerciseFreq$1, int rollbackFreq$1, int maxDepth$1) {
        return Gen$.MODULE$.frequency((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)exerciseFreq$1)), this.danglingRefExerciseNodeGen()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)rollbackFreq$1)), this.danglingRefRollbackNodeGen()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), this.malformedCreateNodeGen()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), this.fetchNodeGen())})).flatMap((Function1 & Serializable)node -> {
            Gen gen;
            Node node2 = node;
            if (node2 instanceof Node.Exercise) {
                Node.Exercise exercise = (Node.Exercise)node2;
                gen = Gen$.MODULE$.choose((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)(maxDepth$1 - 1)), Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable)depth -> ValueGenerators$.$anonfun$noDanglingRefGenTransaction$2(this, nodeId, exercise, BoxesRunTime.unboxToInt((Object)depth)));
            } else if (node2 instanceof Node.Rollback) {
                Node.Rollback rollback = (Node.Rollback)node2;
                gen = Gen$.MODULE$.choose((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)(maxDepth$1 - 1)), Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable)depth -> ValueGenerators$.$anonfun$noDanglingRefGenTransaction$5(this, nodeId, rollback, BoxesRunTime.unboxToInt((Object)depth)));
            } else {
                gen = Gen$.MODULE$.const((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)node2), (Object)HashMap$.MODULE$.empty()));
            }
            return gen.map((Function1 & Serializable)nodeWithChildren -> {
                Tuple2 tuple2 = nodeWithChildren;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Node node = (Node)tuple2._1();
                HashMap nodes = (HashMap)tuple2._2();
                Tuple3 tuple3 = new Tuple3((Object)tuple2, (Object)node, (Object)nodes);
                Tuple3 tuple32 = tuple3;
                Tuple2 x$26 = (Tuple2)tuple32._1();
                Node node2 = (Node)tuple32._2();
                HashMap nodes2 = (HashMap)tuple32._3();
                return new Tuple2(nodeWithChildren, (Object)x$26);
            }).map((Function1 & Serializable)x$28 -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = x$28;
                if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
                    throw new MatchError((Object)tuple22);
                }
                Node node = (Node)tuple2._1();
                HashMap nodes = (HashMap)tuple2._2();
                Tuple2 tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nodeId), (Object)nodes.updated((Object)nodeId, (Object)node));
                return tuple23;
            });
        });
    }

    private final Gen nodesGen$1(NodeId parentNodeId, int size, BackStack nodeIds, HashMap nodes, int exerciseFreq$1, int rollbackFreq$1, int maxDepth$1) {
        return size <= 0 ? Gen$.MODULE$.const((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nodeIds.toImmArray()), (Object)nodes)) : this.nodeGen$1(new NodeId(parentNodeId.index() * 10 + size), exerciseFreq$1, rollbackFreq$1, maxDepth$1).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            NodeId nodeId = (NodeId)tuple2._1();
            HashMap children = (HashMap)tuple2._2();
            Gen gen = this.nodesGen$1(parentNodeId, size - 1, nodeIds.$colon$plus((Object)nodeId), (HashMap)nodes.$plus$plus((IterableOnce)children), exerciseFreq$1, rollbackFreq$1, maxDepth$1);
            return gen;
        });
    }

    private static final BackStack nodesGen$default$3$1() {
        return BackStack$.MODULE$.empty();
    }

    private static final HashMap nodesGen$default$4$1() {
        return HashMap$.MODULE$.empty();
    }

    private final Gen nonDanglingRefNodeGen$1(int maxDepth, NodeId nodeId) {
        int exerciseFreq = maxDepth <= 0 ? 0 : 1;
        int rollbackFreq = maxDepth <= 0 ? 0 : 1;
        return Gen$.MODULE$.choose((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)6), Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable)x$29 -> this.nodesGen$1(nodeId, BoxesRunTime.unboxToInt((Object)x$29), ValueGenerators$.nodesGen$default$3$1(), ValueGenerators$.nodesGen$default$4$1(), exerciseFreq, rollbackFreq, maxDepth));
    }

    public static final /* synthetic */ boolean $anonfun$noDanglingRefGenVersionedTransaction$3(TransactionVersion txVer$1, TransactionVersion x$30) {
        return Ordering.Implicits$.MODULE$.infixOrderingOps((Object)x$30, TransactionVersion$.MODULE$.Ordering()).$less((Object)txVer$1);
    }

    public static final /* synthetic */ String $anonfun$stringVersionGen$4(int major$1, int x) {
        return new StringBuilder(1).append(major$1).append(".").append(x).toString();
    }

    public static final /* synthetic */ Gen $anonfun$stringVersionGen$1(int major) {
        return Gen$.MODULE$.option(Gen$.MODULE$.posNum((Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt())).map((Function1 & Serializable)minorO -> {
            String raw = (String)minorO.fold((Function0 & Serializable)() -> Integer.toString(major), (Function1 & Serializable)x -> ValueGenerators$.$anonfun$stringVersionGen$4(major, BoxesRunTime.unboxToInt((Object)x)));
            return new Tuple2(minorO, (Object)raw);
        }).map((Function1 & Serializable)x$32 -> {
            String raw;
            Tuple2 tuple2 = x$32;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String string = raw = (String)tuple2._2();
            return string;
        });
    }

    public static final /* synthetic */ boolean $anonfun$transactionVersionGen$2(TransactionVersion v$1, TransactionVersion x$33) {
        return Ordering.Implicits$.MODULE$.infixOrderingOps((Object)v$1, TransactionVersion$.MODULE$.Ordering()).$less((Object)x$33);
    }

    public static final /* synthetic */ boolean $anonfun$transactionVersionGen$1(TransactionVersion minVersion$1, Option maxVersion$1, TransactionVersion v) {
        return Ordering.Implicits$.MODULE$.infixOrderingOps((Object)minVersion$1, TransactionVersion$.MODULE$.Ordering()).$less$eq((Object)v) && maxVersion$1.forall((Function1 & Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)ValueGenerators$.$anonfun$transactionVersionGen$2(v, x$33)));
    }

    private ValueGenerators$() {
    }
}

