/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.crypto;

import com.daml.crypto.MacPrototype;
import com.daml.crypto.MacPrototype$;
import com.daml.crypto.MessageDigestPrototype$;
import com.daml.lf.crypto.Hash;
import com.daml.lf.crypto.Hash$Purpose$;
import com.daml.lf.data.Bytes;
import com.daml.lf.data.Bytes$;
import com.daml.lf.data.Ref;
import com.daml.lf.data.Ref$;
import com.daml.lf.data.Time;
import com.daml.lf.value.Value;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.concurrent.atomic.AtomicLong;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scalaz.Order;
import scalaz.Order$;

public final class Hash$ {
    public static final Hash$ MODULE$ = new Hash$();
    private static final byte version = (byte)0;
    private static final int underlyingHashLength = 32;
    private static final Ordering<Hash> ordering = package$.MODULE$.Ordering().by((Function1 & Serializable)x$1 -> new Bytes(x$1.bytes()), Bytes$.MODULE$.ordering());
    private static final Order<Hash> order = Order$.MODULE$.fromScalaOrdering(MODULE$.ordering());
    private static final Function1<Value.ContractId, Bytes> aCid2Bytes = (Function1 & Serializable)x0$1 -> new Bytes(Hash$.$anonfun$aCid2Bytes$1(x0$1));
    private static final Function1<Value.ContractId, Nothing$> noCid2String = (Function1 & Serializable)x$2 -> MODULE$.error("Contract IDs are not supported in contract keys.");

    public byte version() {
        return version;
    }

    public int underlyingHashLength() {
        return underlyingHashLength;
    }

    private Nothing$ error(String msg) {
        throw new Hash.HashingError(msg);
    }

    private <X> Either<String, X> handleError(Function0<X> x) {
        Right right;
        try {
            right = package$.MODULE$.Right().apply(x.apply());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof Hash.HashingError)) {
                throw throwable;
            }
            Hash.HashingError hashingError = (Hash.HashingError)throwable2;
            String msg = hashingError.msg();
            Left left = package$.MODULE$.Left().apply((Object)msg);
            right = left;
        }
        return right;
    }

    public Either<String, Hash> fromBytes(ByteString bs) {
        return package$.MODULE$.Either().cond(Bytes$.MODULE$.length$extension(bs) == this.underlyingHashLength(), (Function0 & Serializable)() -> new Hash(bs), (Function0 & Serializable)() -> new StringBuilder(29).append("hash should have ").append(MODULE$.underlyingHashLength()).append(" bytes, got ").append(Bytes$.MODULE$.length$extension(bs)).toString());
    }

    public Hash assertFromBytes(ByteString bs) {
        return (Hash)com.daml.lf.data.package$.MODULE$.assertRight(this.fromBytes(bs));
    }

    public Either<String, Hash> fromByteArray(byte[] a) {
        return this.fromBytes(Bytes$.MODULE$.fromByteArray(a));
    }

    public Hash assertFromByteArray(byte[] a) {
        return (Hash)com.daml.lf.data.package$.MODULE$.assertRight(this.fromByteArray(a));
    }

    public Function0<Hash> secureRandom(Hash seed) {
        AtomicLong counter = new AtomicLong();
        return (Function0 & Serializable)() -> MODULE$.hMacBuilder(seed).add(counter.getAndIncrement()).build();
    }

    public Ordering<Hash> ordering() {
        return ordering;
    }

    public Order<Hash> order() {
        return order;
    }

    public Function1<Value.ContractId, Bytes> aCid2Bytes() {
        return aCid2Bytes;
    }

    public Function1<Value.ContractId, Nothing$> noCid2String() {
        return noCid2String;
    }

    public Hash.Builder builder(Hash.Purpose purpose, Function1<Value.ContractId, Bytes> cid2Bytes) {
        return new Hash.Builder(cid2Bytes, purpose){
            private final MessageDigest md;

            private MessageDigest md() {
                return this.md;
            }

            public void update(ByteBuffer a) {
                this.md().update(a);
            }

            public void update(byte[] a) {
                this.md().update(a);
            }

            public void doFinal(byte[] buf) {
                Predef$.MODULE$.assert(this.md().digest(buf, 0, Hash$.MODULE$.underlyingHashLength()) == Hash$.MODULE$.underlyingHashLength());
            }
            {
                this.md = MessageDigestPrototype$.MODULE$.Sha256().newDigest();
                this.md().update(Hash$.MODULE$.version());
                this.md().update(purpose$1.id());
            }
        };
    }

    public Hash.Builder hMacBuilder(Hash key) {
        return new Hash.Builder(key){
            private final MacPrototype macPrototype;
            private final Mac mac;

            private MacPrototype macPrototype() {
                return this.macPrototype;
            }

            private Mac mac() {
                return this.mac;
            }

            public void update(ByteBuffer a) {
                this.mac().update(a);
            }

            public void update(byte[] a) {
                this.mac().update(a);
            }

            public void doFinal(byte[] buf) {
                this.mac().doFinal(buf, 0);
            }
            {
                this.macPrototype = MacPrototype$.MODULE$.HmacSha256();
                this.mac = this.macPrototype().newMac();
                this.mac().init(new SecretKeySpec(Bytes$.MODULE$.toByteArray$extension(key$1.bytes()), this.macPrototype().algorithm()));
            }
        };
    }

    public Either<String, Hash> fromHexString(String s) {
        ByteString bytes = Ref$.MODULE$.HexString().decode(s);
        return package$.MODULE$.Either().cond(Bytes$.MODULE$.length$extension(bytes) == this.underlyingHashLength(), (Function0 & Serializable)() -> new Hash(bytes), (Function0 & Serializable)() -> new StringBuilder(18).append("Cannot parse hash ").append(s).toString());
    }

    public Either<String, Hash> fromString(String s) {
        return Ref$.MODULE$.HexString().fromString(s).flatMap((Function1 & Serializable)hexaString -> MODULE$.fromHexString((String)hexaString).map((Function1 & Serializable)hash -> hash));
    }

    public Hash assertFromString(String s) {
        return (Hash)com.daml.lf.data.package$.MODULE$.assertRight(this.fromString(s));
    }

    public Hash hashPrivateKey(String s) {
        return this.builder(Hash$Purpose$.MODULE$.PrivateKey(), this.noCid2String()).add(s).build();
    }

    public Hash assertHashContractKey(Ref.Identifier templateId, Value key) throws Hash.HashingError {
        return this.builder(Hash$Purpose$.MODULE$.ContractKey(), this.noCid2String()).addIdentifier(templateId).addTypedValue(key).build();
    }

    public Hash safeHashContractKey(Ref.Identifier templateId, Value key) {
        return this.assertHashContractKey(templateId, key);
    }

    public Either<String, Hash> hashContractKey(Ref.Identifier templateId, Value key) {
        return this.handleError((Function0 & Serializable)() -> MODULE$.assertHashContractKey(templateId, key));
    }

    public Hash assertHashContractInstance(Ref.Identifier templateId, Value arg) throws Hash.HashingError {
        return this.builder(Hash$Purpose$.MODULE$.ContractInstance(), this.aCid2Bytes()).addIdentifier(templateId).addTypedValue(arg).build();
    }

    public Either<String, Hash> hashContractInstnce(Ref.Identifier templateId, Value arg) {
        return this.handleError((Function0 & Serializable)() -> MODULE$.assertHashContractInstance(templateId, arg));
    }

    public Hash hashChangeId(String applicationId, String commandId, Set<String> actAs) {
        return this.builder(Hash$Purpose$.MODULE$.ChangeId(), this.noCid2String()).add(applicationId).add(commandId).addStringSet(actAs).build();
    }

    public Hash deriveSubmissionSeed(Hash nonce, String applicationId, String commandId, String submitter) {
        return this.hMacBuilder(nonce).add(applicationId).add(commandId).add(submitter).build();
    }

    public Hash deriveTransactionSeed(Hash submissionSeed, String participantId, Time.Timestamp submitTime) {
        return this.hMacBuilder(submissionSeed).add(participantId).add(submitTime.micros()).build();
    }

    public Hash deriveNodeSeed(Hash parentDiscriminator, int childIdx) {
        return this.hMacBuilder(parentDiscriminator).add(childIdx).build();
    }

    public Hash deriveContractDiscriminator(Hash nodeSeed, Time.Timestamp submitTime, Set<String> parties) {
        return this.hMacBuilder(nodeSeed).add(submitTime.micros()).addStringSet(parties).build();
    }

    public Hash deriveMaintainerContractKeyUUID(Hash keyHash, String maintainer) {
        return this.builder(Hash$Purpose$.MODULE$.MaintainerContractKeyUUID(), this.noCid2String()).add(keyHash).add(maintainer).build();
    }

    public static final /* synthetic */ ByteString $anonfun$aCid2Bytes$1(Value.ContractId x0$1) {
        Value.ContractId contractId = x0$1;
        if (!(contractId instanceof Value.ContractId.V1)) {
            throw new MatchError((Object)contractId);
        }
        Value.ContractId.V1 v1 = (Value.ContractId.V1)contractId;
        ByteString byteString = v1.toBytes();
        return byteString;
    }

    private Hash$() {
    }
}

