/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.transaction;

import com.daml.lf.data.BackStack;
import com.daml.lf.data.BackStack$;
import com.daml.lf.data.ImmArray;
import com.daml.lf.data.Ref;
import com.daml.lf.data.Ref$;
import com.daml.lf.ledger.EventId;
import com.daml.lf.ledger.EventId$;
import com.daml.lf.transaction.ActionNodeInfo;
import com.daml.lf.transaction.GlobalKey;
import com.daml.lf.transaction.GlobalKey$;
import com.daml.lf.transaction.Node;
import com.daml.lf.transaction.NodeId;
import com.daml.lf.transaction.TransactionCoder;
import com.daml.lf.transaction.TransactionCoder$;
import com.daml.lf.transaction.TransactionOuterClass;
import com.daml.lf.transaction.TransactionVersion;
import com.daml.lf.transaction.TransactionVersion$;
import com.daml.lf.transaction.Versioned;
import com.daml.lf.transaction.VersionedTransaction;
import com.daml.lf.transaction.VersionedTransaction$;
import com.daml.lf.transaction.package$;
import com.daml.lf.value.Value;
import com.daml.lf.value.ValueCoder;
import com.daml.lf.value.ValueCoder$;
import com.daml.lf.value.ValueCoder$DecodeError$;
import com.daml.lf.value.ValueCoder$EncodeError$;
import com.daml.lf.value.ValueOuterClass;
import com.daml.scalautil.Statement$;
import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.ProtocolStringList;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.Set;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scalaz.std.string$;

public final class TransactionCoder$ {
    public static final TransactionCoder$ MODULE$ = new TransactionCoder$();
    private static final TransactionCoder.EncodeNid NidEncoder = new TransactionCoder.EncodeNid(){

        public String asString(NodeId id) {
            return Integer.toString(id.index());
        }
    };
    private static final TransactionCoder.DecodeNid NidDecoder = new TransactionCoder.DecodeNid(){

        public Either<ValueCoder.DecodeError, NodeId> fromString(String s) {
            return (Either)string$.MODULE$.parseInt(s).fold((Function1 & Serializable)x$1 -> scala.package$.MODULE$.Left().apply((Object)new ValueCoder.DecodeError(new StringBuilder(21).append("cannot parse node Id ").append(s).toString())), (Function1 & Serializable)idx -> anon.2.$anonfun$fromString$2(BoxesRunTime.unboxToInt((Object)idx)));
        }

        public static final /* synthetic */ Right $anonfun$fromString$2(int idx) {
            return scala.package$.MODULE$.Right().apply((Object)new NodeId(idx));
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$fromString$1(java.lang.String java.lang.NumberFormatException ), $anonfun$fromString$2$adapted(java.lang.Object )}, serializedLambda);
        }
    };
    private static final Right<Nothing$, None$> RightNone = scala.package$.MODULE$.Right().apply((Object)None$.MODULE$);

    public TransactionCoder.EncodeNid NidEncoder() {
        return NidEncoder;
    }

    public TransactionCoder.DecodeNid NidDecoder() {
        return NidDecoder;
    }

    public TransactionCoder.EncodeNid EventIdEncoder(String trId) {
        return new TransactionCoder.EncodeNid(trId){
            private final String trId$1;

            public String asString(NodeId id) {
                return new EventId(this.trId$1, id).toLedgerString();
            }
            {
                this.trId$1 = trId$1;
            }
        };
    }

    public TransactionCoder.DecodeNid EventIdDecoder(String trId) {
        return new TransactionCoder.DecodeNid(trId){
            private final String trId$2;

            public Either<ValueCoder.DecodeError, NodeId> fromString(String s) {
                return (Either)EventId$.MODULE$.fromString(s).fold((Function1 & Serializable)x$2 -> scala.package$.MODULE$.Left().apply((Object)new ValueCoder.DecodeError(new StringBuilder(20).append("cannot decode noid: ").append(s).toString())), (Function1 & Serializable)eventId -> {
                    String string = eventId.transactionId();
                    String string2 = $this.trId$2;
                    return scala.package$.MODULE$.Either().cond(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable)() -> eventId.nodeId(), (Function0 & Serializable)() -> new ValueCoder.DecodeError(new StringBuilder(60).append("eventId with unexpected transaction ID, expected ").append($this.trId$2).append(" but found ").append(eventId.transactionId()).toString()));
                });
            }
            {
                this.trId$2 = trId$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$fromString$3(java.lang.String java.lang.String ), $anonfun$fromString$4(com.daml.lf.transaction.TransactionCoder$$anon$4 com.daml.lf.ledger.EventId ), $anonfun$fromString$5(com.daml.lf.ledger.EventId ), $anonfun$fromString$6(com.daml.lf.transaction.TransactionCoder$$anon$4 com.daml.lf.ledger.EventId )}, serializedLambda);
            }
        };
    }

    public Either<ValueCoder.EncodeError, ValueOuterClass.VersionedValue> encodeVersionedValue(ValueCoder.EncodeCid cidEncoder, TransactionVersion enclosingVersion, Versioned<Value> value) {
        TransactionVersion transactionVersion = enclosingVersion;
        TransactionVersion transactionVersion2 = value.version();
        return !(transactionVersion != null ? !transactionVersion.equals(transactionVersion2) : transactionVersion2 != null) ? ValueCoder$.MODULE$.encodeVersionedValue(cidEncoder, value) : scala.package$.MODULE$.Left().apply((Object)new ValueCoder.EncodeError(new StringBuilder(69).append("A node of version ").append(enclosingVersion).append(" cannot contain value of different version version ").append(value.version()).toString()));
    }

    private Either<ValueCoder.EncodeError, ByteString> encodeValue(ValueCoder.EncodeCid cidEncoder, TransactionVersion nodeVersion, Value value) {
        return ValueCoder$.MODULE$.encodeValue(cidEncoder, nodeVersion, value);
    }

    private Either<ValueCoder.EncodeError, ValueOuterClass.VersionedValue> encodeVersionedValue(ValueCoder.EncodeCid cidEncoder, TransactionVersion nodeVersion, Value value) {
        return ValueCoder$.MODULE$.encodeVersionedValue(cidEncoder, nodeVersion, value);
    }

    private Either<ValueCoder.DecodeError, Value> decodeValue(ValueCoder.DecodeCid cidDecoder, TransactionVersion nodeVersion, ValueOuterClass.VersionedValue value) {
        return ValueCoder$.MODULE$.decodeVersionedValue(cidDecoder, value).flatMap((Function1 & Serializable)x0$1 -> {
            Versioned versioned = x0$1;
            if (versioned != null) {
                TransactionVersion transactionVersion = versioned.version();
                Value value = (Value)versioned.unversioned();
                TransactionVersion transactionVersion2 = nodeVersion;
                TransactionVersion transactionVersion3 = transactionVersion;
                if (transactionVersion2 == null) {
                    if (transactionVersion3 == null) return scala.package$.MODULE$.Right().apply((Object)value);
                } else if (transactionVersion2.equals(transactionVersion3)) {
                    return scala.package$.MODULE$.Right().apply((Object)value);
                }
            }
            if (versioned == null) throw new MatchError((Object)versioned);
            TransactionVersion version = versioned.version();
            return scala.package$.MODULE$.Left().apply((Object)new ValueCoder.DecodeError(new StringBuilder(64).append("A node of version ").append(nodeVersion).append(" cannot contain values of different version (").append(version).append(")").toString()));
        });
    }

    public Either<ValueCoder.EncodeError, TransactionOuterClass.ContractInstance> encodeContractInstance(ValueCoder.EncodeCid encodeCid, Versioned<Value.ContractInstance> coinst) {
        return ValueCoder$.MODULE$.encodeVersionedValue(encodeCid, coinst.version(), coinst.unversioned().arg()).map((Function1 & Serializable)x$3 -> TransactionOuterClass.ContractInstance.newBuilder().setTemplateId(ValueCoder$.MODULE$.encodeIdentifier(((Value.ContractInstance)coinst.unversioned()).template())).setArgVersioned(x$3).setAgreement(((Value.ContractInstance)coinst.unversioned()).agreementText()).build());
    }

    private Either<ValueCoder.EncodeError, TransactionOuterClass.ContractInstance> encodeContractInstance(ValueCoder.EncodeCid encodeCid, TransactionVersion version, Ref.Identifier templateId, Value arg, String agreementText) {
        return this.encodeVersionedValue(encodeCid, version, arg).map((Function1 & Serializable)x$4 -> TransactionOuterClass.ContractInstance.newBuilder().setTemplateId(ValueCoder$.MODULE$.encodeIdentifier(templateId)).setArgVersioned(x$4).setAgreement(agreementText).build());
    }

    public Either<ValueCoder.DecodeError, Value.ContractInstance> decodeContractInstance(ValueCoder.DecodeCid decodeCid, TransactionOuterClass.ContractInstance protoCoinst) {
        return ValueCoder$.MODULE$.decodeIdentifier(protoCoinst.getTemplateId()).flatMap((Function1 & Serializable)id -> ValueCoder$.MODULE$.decodeValue(decodeCid, protoCoinst.getArgVersioned()).map((Function1 & Serializable)value -> new Value.ContractInstance((Ref.Identifier)id, (Value)value, protoCoinst.getAgreement())));
    }

    private Either<ValueCoder.DecodeError, Value.ContractInstance> decodeContractInstance(ValueCoder.DecodeCid decodeCid, TransactionVersion nodeVersion, TransactionOuterClass.ContractInstance protoCoinst) {
        return ValueCoder$.MODULE$.decodeIdentifier(protoCoinst.getTemplateId()).flatMap((Function1 & Serializable)id -> MODULE$.decodeValue(decodeCid, nodeVersion, protoCoinst.getArgVersioned()).map((Function1 & Serializable)value -> new Value.ContractInstance((Ref.Identifier)id, (Value)value, protoCoinst.getAgreement())));
    }

    public Either<ValueCoder.DecodeError, Versioned<Value.ContractInstance>> decodeVersionedContractInstance(ValueCoder.DecodeCid decodeCid, TransactionOuterClass.ContractInstance protoCoinst) {
        return ValueCoder$.MODULE$.decodeIdentifier(protoCoinst.getTemplateId()).flatMap((Function1 & Serializable)id -> ValueCoder$.MODULE$.decodeVersionedValue(decodeCid, protoCoinst.getArgVersioned()).map((Function1 & Serializable)value -> value.map((Function1 & Serializable)x$5 -> new Value.ContractInstance((Ref.Identifier)id, (Value)x$5, protoCoinst.getAgreement()))));
    }

    private Either<ValueCoder.EncodeError, TransactionOuterClass.KeyWithMaintainers> encodeKeyWithMaintainers(ValueCoder.EncodeCid encodeCid, TransactionVersion version, Node.KeyWithMaintainers key) {
        TransactionOuterClass.KeyWithMaintainers.Builder builder = TransactionOuterClass.KeyWithMaintainers.newBuilder().addAllMaintainers((Iterable)CollectionConverters$.MODULE$.SetHasAsJava((Set)key.maintainers().toSet()).asJava());
        return Ordering.Implicits$.MODULE$.infixOrderingOps((Object)version, TransactionVersion$.MODULE$.Ordering()).$less((Object)TransactionVersion$.MODULE$.minNoVersionValue()) ? ValueCoder$.MODULE$.encodeVersionedValue(encodeCid, version, key.key()).map((Function1 & Serializable)x$6 -> builder.setKeyVersioned(x$6).build()) : ValueCoder$.MODULE$.encodeValue(encodeCid, version, key.key()).map((Function1 & Serializable)x$7 -> builder.setKeyUnversioned(x$7).build());
    }

    private Either<ValueCoder.EncodeError, BoxedUnit> encodeAndSetContractKey(ValueCoder.EncodeCid encodeCid, TransactionVersion version, Option<Node.KeyWithMaintainers> key, Function1<TransactionOuterClass.KeyWithMaintainers, GeneratedMessageV3.Builder<?>> setKey) {
        Right right;
        Option<Node.KeyWithMaintainers> option = key;
        if (option instanceof Some) {
            Some some = (Some)option;
            Node.KeyWithMaintainers key2 = (Node.KeyWithMaintainers)some.value();
            right = this.encodeKeyWithMaintainers(encodeCid, version, key2).map((Function1 & Serializable)k -> {
                Statement$.MODULE$.discard(setKey.apply((Object)k));
                return BoxedUnit.UNIT;
            });
        } else if (None$.MODULE$.equals(option)) {
            right = scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else {
            throw new MatchError(option);
        }
        return right;
    }

    private Either<ValueCoder.EncodeError, BoxedUnit> encodeAndSetValue(ValueCoder.EncodeCid encodeCid, TransactionVersion version, Value value, Function1<ValueOuterClass.VersionedValue, GeneratedMessageV3.Builder<?>> setVersioned, Function1<ByteString, GeneratedMessageV3.Builder<?>> setUnversioned) {
        return Ordering.Implicits$.MODULE$.infixOrderingOps((Object)version, TransactionVersion$.MODULE$.Ordering()).$less((Object)TransactionVersion$.MODULE$.minNoVersionValue()) ? this.encodeVersionedValue(encodeCid, version, value).map((Function1 & Serializable)v -> {
            Statement$.MODULE$.discard(setVersioned.apply((Object)v));
            return BoxedUnit.UNIT;
        }) : this.encodeValue(encodeCid, version, value).map((Function1 & Serializable)v -> {
            Statement$.MODULE$.discard(setUnversioned.apply((Object)v));
            return BoxedUnit.UNIT;
        });
    }

    public Either<ValueCoder.EncodeError, TransactionOuterClass.Node> encodeNode(TransactionCoder.EncodeNid encodeNid, ValueCoder.EncodeCid encodeCid, TransactionVersion enclosingVersion, NodeId nodeId, Node node, boolean disableVersionCheck) {
        Either either;
        TransactionOuterClass.Node.Builder nodeBuilder = TransactionOuterClass.Node.newBuilder().setNodeId(encodeNid.asString(nodeId));
        Node node2 = node;
        if (node2 instanceof Node.Rollback) {
            Node.Rollback rollback = (Node.Rollback)node2;
            ImmArray<NodeId> children = rollback.children();
            TransactionOuterClass.NodeRollback.Builder builder = TransactionOuterClass.NodeRollback.newBuilder();
            children.foreach((Function1 & Serializable)id -> {
                Statement$.MODULE$.discard((Object)builder.addChildren(encodeNid.asString(id)));
                return BoxedUnit.UNIT;
            });
            either = scala.package$.MODULE$.Either().cond(Ordering.Implicits$.MODULE$.infixOrderingOps((Object)enclosingVersion, TransactionVersion$.MODULE$.Ordering()).$greater$eq((Object)TransactionVersion$.MODULE$.minExceptions()) || disableVersionCheck, (Function0)(JFunction0.mcV.sp & Serializable)() -> {}, (Function0 & Serializable)() -> ValueCoder$EncodeError$.MODULE$.apply(enclosingVersion, "rollback nodes")).map((Function1 & Serializable)x$8 -> {
                BoxedUnit boxedUnit = x$8;
                TransactionOuterClass.Node node = nodeBuilder.setRollback(builder).build();
                return node;
            });
        } else if (node2 instanceof Node.Action) {
            Left left;
            Node.Action action = (Node.Action)node2;
            TransactionVersion nodeVersion = action.version();
            if (Ordering.Implicits$.MODULE$.infixOrderingOps((Object)enclosingVersion, TransactionVersion$.MODULE$.Ordering()).$less((Object)nodeVersion)) {
                left = scala.package$.MODULE$.Left().apply((Object)new ValueCoder.EncodeError(new StringBuilder(66).append("A transaction of version ").append(enclosingVersion).append(" cannot contain nodes of newer version (").append(nodeVersion).append(")").toString()));
            } else {
                Either either2;
                Node.Action action2;
                if (Ordering.Implicits$.MODULE$.infixOrderingOps((Object)enclosingVersion, TransactionVersion$.MODULE$.Ordering()).$greater$eq((Object)TransactionVersion$.MODULE$.minNodeVersion())) {
                    Statement$.MODULE$.discard((Object)nodeBuilder.setVersion(nodeVersion.protoValue()));
                }
                if ((action2 = action) instanceof Node.Create) {
                    Node.Create create = (Node.Create)action2;
                    TransactionOuterClass.NodeCreate.Builder builder = TransactionOuterClass.NodeCreate.newBuilder();
                    create.stakeholders().foreach((Function1 & Serializable)value -> builder.addStakeholders(value));
                    create.signatories().foreach((Function1 & Serializable)value -> builder.addSignatories(value));
                    Statement$.MODULE$.discard((Object)builder.setContractIdStruct(encodeCid.encode(create.coid())));
                    either2 = (Ordering.Implicits$.MODULE$.infixOrderingOps((Object)nodeVersion, TransactionVersion$.MODULE$.Ordering()).$less((Object)TransactionVersion$.MODULE$.minNoVersionValue()) ? this.encodeContractInstance(encodeCid, create.version(), create.templateId(), create.arg(), create.agreementText()).map((Function1 & Serializable)value -> builder.setContractInstance(value)) : this.encodeValue(encodeCid, nodeVersion, create.arg()).map((Function1 & Serializable)arg -> builder.setTemplateId(ValueCoder$.MODULE$.encodeIdentifier(create.templateId())).setArgUnversioned(arg).setAgreement(create.agreementText()))).flatMap((Function1 & Serializable)x$10 -> {
                        TransactionOuterClass.NodeCreate.Builder builder = x$10;
                        Either either = MODULE$.encodeAndSetContractKey(encodeCid, nodeVersion, create.key(), (Function1 & Serializable)value -> builder.setKeyWithMaintainers(value)).map((Function1 & Serializable)x$9 -> {
                            BoxedUnit boxedUnit = x$9;
                            TransactionOuterClass.Node node = nodeBuilder.setCreate(builder).build();
                            return node;
                        });
                        return either;
                    });
                } else if (action2 instanceof Node.Fetch) {
                    Node.Fetch fetch = (Node.Fetch)action2;
                    TransactionOuterClass.NodeFetch.Builder builder = TransactionOuterClass.NodeFetch.newBuilder();
                    Statement$.MODULE$.discard((Object)builder.setTemplateId(ValueCoder$.MODULE$.encodeIdentifier(fetch.templateId())));
                    fetch.stakeholders().foreach((Function1 & Serializable)value -> builder.addStakeholders(value));
                    fetch.signatories().foreach((Function1 & Serializable)value -> builder.addSignatories(value));
                    Statement$.MODULE$.discard((Object)builder.setContractIdStruct(encodeCid.encode(fetch.coid())));
                    if (Ordering.Implicits$.MODULE$.infixOrderingOps((Object)nodeVersion, TransactionVersion$.MODULE$.Ordering()).$greater$eq((Object)TransactionVersion$.MODULE$.minByKey())) {
                        Statement$.MODULE$.discard((Object)builder.setByKey(fetch.byKey()));
                    }
                    fetch.actingParties().foreach((Function1 & Serializable)value -> builder.addActors(value));
                    either2 = this.encodeAndSetContractKey(encodeCid, nodeVersion, fetch.key(), (Function1 & Serializable)value -> builder.setKeyWithMaintainers(value)).map((Function1 & Serializable)x$11 -> {
                        BoxedUnit boxedUnit = x$11;
                        TransactionOuterClass.Node node = nodeBuilder.setFetch(builder).build();
                        return node;
                    });
                } else if (action2 instanceof Node.Exercise) {
                    Node.Exercise exercise = (Node.Exercise)action2;
                    TransactionOuterClass.NodeExercise.Builder builder = TransactionOuterClass.NodeExercise.newBuilder();
                    Statement$.MODULE$.discard((Object)builder.setContractIdStruct(encodeCid.encode(exercise.targetCoid())).setChoice(exercise.choiceId()).setTemplateId(ValueCoder$.MODULE$.encodeIdentifier(exercise.templateId())).setConsuming(exercise.consuming()));
                    exercise.actingParties().foreach((Function1 & Serializable)value -> builder.addActors(value));
                    exercise.children().foreach((Function1 & Serializable)id -> {
                        Statement$.MODULE$.discard((Object)builder.addChildren(encodeNid.asString(id)));
                        return BoxedUnit.UNIT;
                    });
                    exercise.signatories().foreach((Function1 & Serializable)value -> builder.addSignatories(value));
                    exercise.stakeholders().foreach((Function1 & Serializable)value -> builder.addStakeholders(value));
                    exercise.choiceObservers().foreach((Function1 & Serializable)value -> builder.addObservers(value));
                    if (Ordering.Implicits$.MODULE$.infixOrderingOps((Object)nodeVersion, TransactionVersion$.MODULE$.Ordering()).$greater$eq((Object)TransactionVersion$.MODULE$.minByKey())) {
                        Statement$.MODULE$.discard((Object)builder.setByKey(exercise.byKey()));
                    }
                    if (Ordering.Implicits$.MODULE$.infixOrderingOps((Object)nodeVersion, TransactionVersion$.MODULE$.Ordering()).$greater$eq((Object)TransactionVersion$.MODULE$.minInterfaces())) {
                        exercise.interfaceId().foreach((Function1 & Serializable)iface -> builder.setInterfaceId(ValueCoder$.MODULE$.encodeIdentifier((Ref.Identifier)iface)));
                    }
                    either2 = scala.package$.MODULE$.Either().cond(Ordering.Implicits$.MODULE$.infixOrderingOps((Object)exercise.version(), TransactionVersion$.MODULE$.Ordering()).$greater$eq((Object)TransactionVersion$.MODULE$.minChoiceObservers()) || exercise.choiceObservers().isEmpty(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {}, (Function0 & Serializable)() -> ValueCoder$EncodeError$.MODULE$.apply(nodeVersion, "non-empty choice-observers")).flatMap((Function1 & Serializable)x$15 -> {
                        BoxedUnit boxedUnit = x$15;
                        Either either = MODULE$.encodeAndSetValue(encodeCid, nodeVersion, exercise.chosenValue(), (Function1 & Serializable)value -> builder.setArgVersioned(value), (Function1 & Serializable)value -> builder.setArgUnversioned(value)).flatMap((Function1 & Serializable)x$14 -> {
                            Either either;
                            BoxedUnit boxedUnit = x$14;
                            Option<Value> option = exercise.exerciseResult();
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                Value value2 = (Value)some.value();
                                either = MODULE$.encodeAndSetValue(encodeCid, nodeVersion, value2, (Function1 & Serializable)value -> builder.setResultVersioned(value), (Function1 & Serializable)value -> builder.setResultUnversioned(value));
                            } else if (None$.MODULE$.equals(option)) {
                                either = scala.package$.MODULE$.Either().cond(Ordering.Implicits$.MODULE$.infixOrderingOps((Object)exercise.version(), TransactionVersion$.MODULE$.Ordering()).$greater$eq((Object)TransactionVersion$.MODULE$.minExceptions()) || disableVersionCheck, (Function0)(JFunction0.mcV.sp & Serializable)() -> {}, (Function0 & Serializable)() -> ValueCoder$EncodeError$.MODULE$.apply(nodeVersion, "NodeExercises without result"));
                            } else {
                                throw new MatchError(option);
                            }
                            Either either2 = either.flatMap((Function1 & Serializable)x$13 -> {
                                BoxedUnit boxedUnit = x$13;
                                Either either = MODULE$.encodeAndSetContractKey(encodeCid, nodeVersion, exercise.key(), (Function1 & Serializable)value -> builder.setKeyWithMaintainers(value)).map((Function1 & Serializable)x$12 -> {
                                    BoxedUnit boxedUnit = x$12;
                                    TransactionOuterClass.Node node = nodeBuilder.setExercise(builder).build();
                                    return node;
                                });
                                return either;
                            });
                            return either2;
                        });
                        return either;
                    });
                } else if (action2 instanceof Node.LookupByKey) {
                    Node.LookupByKey lookupByKey = (Node.LookupByKey)action2;
                    TransactionOuterClass.NodeLookupByKey.Builder builder = TransactionOuterClass.NodeLookupByKey.newBuilder();
                    Statement$.MODULE$.discard((Object)builder.setTemplateId(ValueCoder$.MODULE$.encodeIdentifier(lookupByKey.templateId())));
                    lookupByKey.result().foreach((Function1 & Serializable)cid -> {
                        Statement$.MODULE$.discard((Object)builder.setContractIdStruct(encodeCid.encode(cid)));
                        return BoxedUnit.UNIT;
                    });
                    either2 = this.encodeKeyWithMaintainers(encodeCid, lookupByKey.version(), lookupByKey.key()).map((Function1 & Serializable)encodedKey -> {
                        Statement$.MODULE$.discard((Object)builder.setKeyWithMaintainers(encodedKey));
                        return nodeBuilder.setLookupByKey(builder).build();
                    });
                } else {
                    throw new MatchError((Object)action2);
                }
                left = either2;
            }
            either = left;
        } else {
            throw new MatchError((Object)node2);
        }
        return either;
    }

    public boolean encodeNode$default$6() {
        return false;
    }

    private Either<ValueCoder.DecodeError, Node.KeyWithMaintainers> decodeKeyWithMaintainers(ValueCoder.DecodeCid decodeCid, TransactionVersion version, TransactionOuterClass.KeyWithMaintainers keyWithMaintainers) {
        return this.toPartySet(keyWithMaintainers.getMaintainersList()).flatMap((Function1 & Serializable)maintainers -> MODULE$.decodeValue(decodeCid, version, (Function0<ValueOuterClass.VersionedValue>)(Function0 & Serializable)() -> keyWithMaintainers.getKeyVersioned(), (Function0<ByteString>)(Function0 & Serializable)() -> keyWithMaintainers.getKeyUnversioned()).map((Function1 & Serializable)key -> new Node.KeyWithMaintainers((Value)key, (scala.collection.immutable.Set<String>)maintainers)));
    }

    private Right<Nothing$, None$> RightNone() {
        return RightNone;
    }

    private Either<ValueCoder.DecodeError, Option<Node.KeyWithMaintainers>> decodeOptionalKeyWithMaintainers(ValueCoder.DecodeCid decodeCid, TransactionVersion version, TransactionOuterClass.KeyWithMaintainers keyWithMaintainers) {
        TransactionOuterClass.KeyWithMaintainers keyWithMaintainers2 = keyWithMaintainers;
        TransactionOuterClass.KeyWithMaintainers keyWithMaintainers3 = TransactionOuterClass.KeyWithMaintainers.getDefaultInstance();
        return !(keyWithMaintainers2 != null ? !keyWithMaintainers2.equals(keyWithMaintainers3) : keyWithMaintainers3 != null) ? this.RightNone() : this.toPartySet(keyWithMaintainers.getMaintainersList()).flatMap((Function1 & Serializable)maintainers -> MODULE$.decodeValue(decodeCid, version, (Function0<ValueOuterClass.VersionedValue>)(Function0 & Serializable)() -> keyWithMaintainers.getKeyVersioned(), (Function0<ByteString>)(Function0 & Serializable)() -> keyWithMaintainers.getKeyUnversioned()).map((Function1 & Serializable)key -> new Some((Object)new Node.KeyWithMaintainers((Value)key, (scala.collection.immutable.Set<String>)maintainers))));
    }

    public Either<ValueCoder.DecodeError, Value> decodeValue(ValueCoder.DecodeCid decodeCid, TransactionVersion version, Function0<ValueOuterClass.VersionedValue> versionedProto, Function0<ByteString> unversionedProto) {
        return Ordering.Implicits$.MODULE$.infixOrderingOps((Object)version, TransactionVersion$.MODULE$.Ordering()).$less((Object)TransactionVersion$.MODULE$.minNoVersionValue()) ? this.decodeValue(decodeCid, version, (ValueOuterClass.VersionedValue)versionedProto.apply()) : ValueCoder$.MODULE$.decodeValue(decodeCid, version, (ByteString)unversionedProto.apply());
    }

    public Either<ValueCoder.DecodeError, Tuple2<NodeId, Node>> decodeVersionedNode(TransactionCoder.DecodeNid decodeNid, ValueCoder.DecodeCid decodeCid, TransactionVersion transactionVersion, TransactionOuterClass.Node protoNode) {
        return this.decodeNodeVersion(transactionVersion, protoNode).flatMap((Function1 & Serializable)nodeVersion -> MODULE$.decodeNode(decodeNid, decodeCid, (TransactionVersion)nodeVersion, protoNode).map((Function1 & Serializable)node -> node));
    }

    private Either<ValueCoder.DecodeError, Tuple2<NodeId, Node>> decodeNode(TransactionCoder.DecodeNid decodeNid, ValueCoder.DecodeCid decodeCid, TransactionVersion nodeVersion, TransactionOuterClass.Node protoNode) {
        Either either;
        Either<ValueCoder.DecodeError, NodeId> nodeId = decodeNid.fromString(protoNode.getNodeId());
        TransactionOuterClass.Node.NodeTypeCase nodeTypeCase = protoNode.getNodeTypeCase();
        if (TransactionOuterClass.Node.NodeTypeCase.ROLLBACK.equals(nodeTypeCase)) {
            TransactionOuterClass.NodeRollback protoRollback = protoNode.getRollback();
            either = scala.package$.MODULE$.Either().cond(Ordering.Implicits$.MODULE$.infixOrderingOps((Object)nodeVersion, TransactionVersion$.MODULE$.Ordering()).$greater$eq((Object)TransactionVersion$.MODULE$.minExceptions()), (Function0)(JFunction0.mcV.sp & Serializable)() -> {}, (Function0 & Serializable)() -> new ValueCoder.DecodeError(new StringBuilder(70).append("rollback node (supported since ").append(TransactionVersion$.MODULE$.minExceptions()).append(") unexpected in transaction of version ").append(nodeVersion).toString())).flatMap((Function1 & Serializable)x$16 -> {
                BoxedUnit boxedUnit = x$16;
                Either either = nodeId.flatMap((Function1 & Serializable)ni -> MODULE$.decodeChildren(decodeNid, protoRollback.getChildrenList()).map((Function1 & Serializable)children -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ni), (Object)new Node.Rollback((ImmArray<NodeId>)children))));
                return either;
            });
        } else if (TransactionOuterClass.Node.NodeTypeCase.CREATE.equals(nodeTypeCase)) {
            TransactionOuterClass.NodeCreate protoCreate = protoNode.getCreate();
            either = nodeId.flatMap((Function1 & Serializable)ni -> decodeCid.decode(protoCreate.getContractIdStruct()).flatMap((Function1 & Serializable)c -> (Ordering.Implicits$.MODULE$.infixOrderingOps((Object)nodeVersion, TransactionVersion$.MODULE$.Ordering()).$less((Object)TransactionVersion$.MODULE$.minNoVersionValue()) ? MODULE$.decodeContractInstance(decodeCid, nodeVersion, protoCreate.getContractInstance()) : ValueCoder$.MODULE$.decodeIdentifier(protoCreate.getTemplateId()).flatMap((Function1 & Serializable)tmplId -> ValueCoder$.MODULE$.decodeValue(decodeCid, nodeVersion, protoCreate.getArgUnversioned()).map((Function1 & Serializable)arg -> new Value.ContractInstance((Ref.Identifier)tmplId, (Value)arg, protoCreate.getAgreement())))).flatMap((Function1 & Serializable)ci -> MODULE$.toPartySet(protoCreate.getStakeholdersList()).flatMap((Function1 & Serializable)stakeholders -> MODULE$.toPartySet(protoCreate.getSignatoriesList()).flatMap((Function1 & Serializable)signatories -> MODULE$.decodeOptionalKeyWithMaintainers(decodeCid, nodeVersion, protoCreate.getKeyWithMaintainers()).map((Function1 & Serializable)key -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ni), (Object)new Node.Create((Value.ContractId)c, ci.template(), ci.arg(), ci.agreementText(), (scala.collection.immutable.Set<String>)signatories, (scala.collection.immutable.Set<String>)stakeholders, (Option<Node.KeyWithMaintainers>)key, nodeVersion))))))));
        } else if (TransactionOuterClass.Node.NodeTypeCase.FETCH.equals(nodeTypeCase)) {
            TransactionOuterClass.NodeFetch protoFetch = protoNode.getFetch();
            either = nodeId.flatMap((Function1 & Serializable)ni -> ValueCoder$.MODULE$.decodeIdentifier(protoFetch.getTemplateId()).flatMap((Function1 & Serializable)templateId -> decodeCid.decode(protoFetch.getContractIdStruct()).flatMap((Function1 & Serializable)c -> MODULE$.toPartySet(protoFetch.getActorsList()).flatMap((Function1 & Serializable)actingParties -> MODULE$.toPartySet(protoFetch.getStakeholdersList()).flatMap((Function1 & Serializable)stakeholders -> MODULE$.toPartySet(protoFetch.getSignatoriesList()).flatMap((Function1 & Serializable)signatories -> MODULE$.decodeOptionalKeyWithMaintainers(decodeCid, nodeVersion, protoFetch.getKeyWithMaintainers()).map((Function1 & Serializable)key -> {
                boolean byKey = Ordering.Implicits$.MODULE$.infixOrderingOps((Object)nodeVersion, TransactionVersion$.MODULE$.Ordering()).$greater$eq((Object)TransactionVersion$.MODULE$.minByKey()) ? protoFetch.getByKey() : false;
                return new Tuple2(key, (Object)BoxesRunTime.boxToBoolean((boolean)byKey));
            }).map((Function1 & Serializable)x$17 -> {
                Tuple2 tuple2 = x$17;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Option key = (Option)tuple2._1();
                boolean byKey = tuple2._2$mcZ$sp();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ni), (Object)new Node.Fetch((Value.ContractId)c, (Ref.Identifier)templateId, (scala.collection.immutable.Set<String>)actingParties, (scala.collection.immutable.Set<String>)signatories, (scala.collection.immutable.Set<String>)stakeholders, (Option<Node.KeyWithMaintainers>)key, byKey, nodeVersion));
                return tuple22;
            })))))));
        } else if (TransactionOuterClass.Node.NodeTypeCase.EXERCISE.equals(nodeTypeCase)) {
            TransactionOuterClass.NodeExercise protoExe = protoNode.getExercise();
            either = (!protoExe.hasResultVersioned() && protoExe.getResultUnversioned().isEmpty() ? scala.package$.MODULE$.Either().cond(Ordering.Implicits$.MODULE$.infixOrderingOps((Object)nodeVersion, TransactionVersion$.MODULE$.Ordering()).$greater$eq((Object)TransactionVersion$.MODULE$.minExceptions()), (Function0 & Serializable)() -> None$.MODULE$, (Function0 & Serializable)() -> new ValueCoder.DecodeError(new StringBuilder(85).append("NodeExercises without result (supported since ").append(TransactionVersion$.MODULE$.minExceptions()).append(") unexpected in transaction of version ").append(nodeVersion).toString())) : this.decodeValue(decodeCid, nodeVersion, (Function0<ValueOuterClass.VersionedValue>)(Function0 & Serializable)() -> protoExe.getResultVersioned(), (Function0<ByteString>)(Function0 & Serializable)() -> protoExe.getResultUnversioned()).map((Function1 & Serializable)v -> new Some(v))).flatMap((Function1 & Serializable)rvOpt -> MODULE$.decodeOptionalKeyWithMaintainers(decodeCid, nodeVersion, protoExe.getKeyWithMaintainers()).flatMap((Function1 & Serializable)keyWithMaintainers -> nodeId.flatMap((Function1 & Serializable)ni -> decodeCid.decode(protoExe.getContractIdStruct()).flatMap((Function1 & Serializable)targetCoid -> MODULE$.decodeChildren(decodeNid, protoExe.getChildrenList()).flatMap((Function1 & Serializable)children -> MODULE$.decodeValue(decodeCid, nodeVersion, (Function0<ValueOuterClass.VersionedValue>)(Function0 & Serializable)() -> protoExe.getArgVersioned(), (Function0<ByteString>)(Function0 & Serializable)() -> protoExe.getArgUnversioned()).flatMap((Function1 & Serializable)cv -> ValueCoder$.MODULE$.decodeIdentifier(protoExe.getTemplateId()).flatMap((Function1 & Serializable)templateId -> MODULE$.toPartySet(protoExe.getActorsList()).flatMap((Function1 & Serializable)actingParties -> MODULE$.toPartySet(protoExe.getSignatoriesList()).flatMap((Function1 & Serializable)signatories -> MODULE$.toPartySet(protoExe.getStakeholdersList()).flatMap((Function1 & Serializable)stakeholders -> (Ordering.Implicits$.MODULE$.infixOrderingOps((Object)nodeVersion, TransactionVersion$.MODULE$.Ordering()).$less((Object)TransactionVersion$.MODULE$.minChoiceObservers()) ? scala.package$.MODULE$.Right().apply((Object)Predef$.MODULE$.Set().empty()) : MODULE$.toPartySet(protoExe.getObserversList())).flatMap((Function1 & Serializable)choiceObservers -> MODULE$.toIdentifier(protoExe.getChoice()).map((Function1 & Serializable)choiceName -> {
                boolean byKey = Ordering.Implicits$.MODULE$.infixOrderingOps((Object)nodeVersion, TransactionVersion$.MODULE$.Ordering()).$greater$eq((Object)TransactionVersion$.MODULE$.minByKey()) ? protoExe.getByKey() : false;
                return new Tuple2(choiceName, (Object)BoxesRunTime.boxToBoolean((boolean)byKey));
            }).flatMap((Function1 & Serializable)x$19 -> {
                Tuple2 tuple2 = x$19;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String choiceName = (String)tuple2._1();
                boolean byKey = tuple2._2$mcZ$sp();
                Either either = (Ordering.Implicits$.MODULE$.infixOrderingOps((Object)nodeVersion, TransactionVersion$.MODULE$.Ordering()).$greater$eq((Object)TransactionVersion$.MODULE$.minInterfaces()) && protoExe.hasInterfaceId() ? ValueCoder$.MODULE$.decodeIdentifier(protoExe.getInterfaceId()).map((Function1 & Serializable)x$18 -> new Some(x$18)) : scala.package$.MODULE$.Right().apply((Object)None$.MODULE$)).map((Function1 & Serializable)interfaceId -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ni), (Object)new Node.Exercise((Value.ContractId)targetCoid, (Ref.Identifier)templateId, (Option<Ref.Identifier>)interfaceId, choiceName, protoExe.getConsuming(), (scala.collection.immutable.Set<String>)actingParties, (Value)cv, (scala.collection.immutable.Set<String>)stakeholders, (scala.collection.immutable.Set<String>)signatories, (scala.collection.immutable.Set<String>)choiceObservers, (ImmArray<NodeId>)children, (Option<Value>)rvOpt, (Option<Node.KeyWithMaintainers>)keyWithMaintainers, byKey, nodeVersion)));
                return either;
            }))))))))))));
        } else if (TransactionOuterClass.Node.NodeTypeCase.LOOKUP_BY_KEY.equals(nodeTypeCase)) {
            TransactionOuterClass.NodeLookupByKey protoLookupByKey = protoNode.getLookupByKey();
            either = nodeId.flatMap((Function1 & Serializable)ni -> ValueCoder$.MODULE$.decodeIdentifier(protoLookupByKey.getTemplateId()).flatMap((Function1 & Serializable)templateId -> MODULE$.decodeKeyWithMaintainers(decodeCid, nodeVersion, protoLookupByKey.getKeyWithMaintainers()).flatMap((Function1 & Serializable)key -> decodeCid.decodeOptional(protoLookupByKey.getContractIdStruct()).map((Function1 & Serializable)cid -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ni), (Object)new Node.LookupByKey((Ref.Identifier)templateId, (Node.KeyWithMaintainers)key, (Option<Value.ContractId>)cid, nodeVersion))))));
        } else if (TransactionOuterClass.Node.NodeTypeCase.NODETYPE_NOT_SET.equals(nodeTypeCase)) {
            either = scala.package$.MODULE$.Left().apply((Object)new ValueCoder.DecodeError("Unset Node type"));
        } else {
            throw new MatchError((Object)nodeTypeCase);
        }
        return either;
    }

    private Either<ValueCoder.DecodeError, ImmArray<NodeId>> decodeChildren(TransactionCoder.DecodeNid decodeNid, ProtocolStringList strList) {
        return ((Either)CollectionConverters$.MODULE$.ListHasAsScala((List)strList).asScala().foldLeft((Object)scala.package$.MODULE$.Right().apply((Object)BackStack$.MODULE$.empty()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Either either;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null && (either = (Either)tuple2._1()) instanceof Left) {
                Left left = (Left)either;
                ValueCoder.DecodeError e = (ValueCoder.DecodeError)left.value();
                return scala.package$.MODULE$.Left().apply((Object)e);
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Either either2 = (Either)tuple2._1();
            String s = (String)tuple2._2();
            if (!(either2 instanceof Right)) throw new MatchError((Object)tuple2);
            Right right = (Right)either2;
            BackStack ids = (BackStack)right.value();
            return decodeNid.fromString(s).map((Function1 & Serializable)x$20 -> ids.$colon$plus(x$20));
        })).map((Function1 & Serializable)x$21 -> x$21.toImmArray());
    }

    public Either<ValueCoder.EncodeError, TransactionOuterClass.Transaction> encodeTransaction(TransactionCoder.EncodeNid encodeNid, ValueCoder.EncodeCid encodeCid, VersionedTransaction tx) {
        return this.encodeTransactionWithCustomVersion(encodeNid, encodeCid, tx);
    }

    public Either<ValueCoder.EncodeError, TransactionOuterClass.Transaction> encodeTransactionWithCustomVersion(TransactionCoder.EncodeNid encodeNid, ValueCoder.EncodeCid encodeCid, VersionedTransaction transaction) {
        TransactionOuterClass.Transaction.Builder builder = TransactionOuterClass.Transaction.newBuilder().setVersion(transaction.version().protoValue());
        transaction.roots().foreach((Function1 & Serializable)nid -> {
            Statement$.MODULE$.discard((Object)builder.addRoots(encodeNid.asString(nid)));
            return BoxedUnit.UNIT;
        });
        return ((Either)transaction.fold(scala.package$.MODULE$.Right().apply((Object)builder), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Either builderOrError;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    builderOrError = (Either)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            NodeId nid = (NodeId)tuple2._1();
            Either either = builderOrError.flatMap((Function1 & Serializable)builder -> MODULE$.encodeNode(encodeNid, encodeCid, transaction.version(), nid, (Node)transaction.nodes().apply((Object)nid), MODULE$.encodeNode$default$6()).map((Function1 & Serializable)encodedNode -> builder.addNodes(encodedNode)));
            return either;
        })).map((Function1 & Serializable)x$22 -> x$22.build());
    }

    /*
     * Unable to fully structure code
     */
    public Either<ValueCoder.DecodeError, TransactionVersion> decodeNodeVersion(TransactionVersion txVersion, TransactionOuterClass.Node protoNode) {
        block3: {
            block5: {
                block4: {
                    block2: {
                        if (!Ordering.Implicits$.MODULE$.infixOrderingOps((Object)txVersion, TransactionVersion$.MODULE$.Ordering()).$less((Object)TransactionVersion$.MODULE$.minNodeVersion())) break block2;
                        v0 = scala.package$.MODULE$.Right().apply((Object)txVersion);
                        break block3;
                    }
                    var5_3 = protoNode.getNodeTypeCase();
                    if (!TransactionOuterClass.Node.NodeTypeCase.ROLLBACK.equals(var5_3)) break block4;
                    var3_4 = scala.package$.MODULE$.Right().apply((Object)txVersion);
                    break block5;
                }
                var6_5 = this.decodeVersion(protoNode.getVersion());
                if (!(var6_5 instanceof Right)) ** GOTO lbl-1000
                var7_6 = (Right)var6_5;
                nodeVersion = (TransactionVersion)var7_6.value();
                if (Ordering.Implicits$.MODULE$.infixOrderingOps((Object)txVersion, TransactionVersion$.MODULE$.Ordering()).$less((Object)nodeVersion)) {
                    var4_8 = scala.package$.MODULE$.Left().apply((Object)new ValueCoder.DecodeError(new StringBuilder(65).append("A transaction of version ").append(txVersion).append(" cannot contain node of newer version (").append(protoNode.getVersion()).append(")").toString()));
                } else lbl-1000:
                // 2 sources

                {
                    var4_8 = var6_5;
                }
                var3_4 = var4_8;
            }
            v0 = var3_4;
        }
        return v0;
    }

    public Either<ValueCoder.DecodeError, TransactionVersion> decodeVersion(String vs) {
        return TransactionVersion$.MODULE$.fromString(vs).left().map((Function1)ValueCoder$DecodeError$.MODULE$);
    }

    public Either<ValueCoder.DecodeError, VersionedTransaction> decodeTransaction(TransactionCoder.DecodeNid decodeNid, ValueCoder.DecodeCid decodeCid, TransactionOuterClass.Transaction protoTx) {
        return this.decodeVersion(protoTx.getVersion()).flatMap((Function1 & Serializable)version -> MODULE$.decodeTransaction(decodeNid, decodeCid, (TransactionVersion)version, protoTx).map((Function1 & Serializable)tx -> tx));
    }

    private Either<ValueCoder.DecodeError, VersionedTransaction> decodeTransaction(TransactionCoder.DecodeNid decodeNid, ValueCoder.DecodeCid decodeCid, TransactionVersion txVersion, TransactionOuterClass.Transaction protoTx) {
        Either roots = ((Either)CollectionConverters$.MODULE$.ListHasAsScala((List)protoTx.getRootsList()).asScala().foldLeft((Object)scala.package$.MODULE$.Right().apply((Object)BackStack$.MODULE$.empty()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Either either = (Either)tuple2._1();
                String s = (String)tuple2._2();
                if (either instanceof Right) {
                    Right right = (Right)either;
                    BackStack acc = (BackStack)right.value();
                    return decodeNid.fromString(s).map((Function1 & Serializable)x$23 -> acc.$colon$plus(x$23));
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Either either = (Either)tuple2._1();
            if (!(either instanceof Left)) throw new MatchError((Object)tuple2);
            Left left = (Left)either;
            ValueCoder.DecodeError e = (ValueCoder.DecodeError)left.value();
            return scala.package$.MODULE$.Left().apply((Object)e);
        })).map((Function1 & Serializable)x$24 -> x$24.toImmArray());
        Either nodes = (Either)CollectionConverters$.MODULE$.ListHasAsScala(protoTx.getNodesList()).asScala().foldLeft((Object)scala.package$.MODULE$.Right().apply((Object)HashMap$.MODULE$.empty()), (Function2 & Serializable)(x0$2, x1$2) -> {
            Either either;
            Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
            if (tuple2 != null && (either = (Either)tuple2._1()) instanceof Left) {
                Left left = (Left)either;
                ValueCoder.DecodeError e = (ValueCoder.DecodeError)left.value();
                return scala.package$.MODULE$.Left().apply((Object)e);
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Either either2 = (Either)tuple2._1();
            TransactionOuterClass.Node s = (TransactionOuterClass.Node)tuple2._2();
            if (!(either2 instanceof Right)) throw new MatchError((Object)tuple2);
            Right right = (Right)either2;
            HashMap acc = (HashMap)right.value();
            return MODULE$.decodeVersionedNode(decodeNid, decodeCid, txVersion, s).map((Function1 & Serializable)x$25 -> (HashMap)acc.$plus(x$25));
        });
        return roots.flatMap((Function1 & Serializable)rs -> nodes.map((Function1 & Serializable)ns -> VersionedTransaction$.MODULE$.apply(txVersion, (Map<NodeId, Node>)ns, (ImmArray<NodeId>)rs)));
    }

    public Either<ValueCoder.DecodeError, scala.collection.immutable.Set<String>> toPartySet(ProtocolStringList strList) {
        Right right;
        Buffer parties = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(strList.asByteStringList()).asScala().map((Function1 & Serializable)bs -> Ref$.MODULE$.Party().fromString(bs.toStringUtf8()));
        Either either = package$.MODULE$.sequence(parties, BuildFrom$.MODULE$.buildFromIterableOps());
        if (either instanceof Left) {
            Left left = (Left)either;
            String err = (String)left.value();
            right = scala.package$.MODULE$.Left().apply((Object)new ValueCoder.DecodeError(new StringBuilder(21).append("Cannot decode party: ").append(err).toString()));
        } else if (either instanceof Right) {
            Right right2 = (Right)either;
            Buffer ps = (Buffer)right2.value();
            right = scala.package$.MODULE$.Right().apply((Object)ps.toSet());
        } else {
            throw new MatchError(either);
        }
        return right;
    }

    private Either<ValueCoder.DecodeError, String> toIdentifier(String s) {
        return Ref$.MODULE$.Name().fromString(s).left().map((Function1)ValueCoder$DecodeError$.MODULE$);
    }

    public Either<ValueCoder.DecodeError, TransactionVersion> decodeVersion(TransactionOuterClass.Node node) {
        return node.getVersion().isEmpty() ? scala.package$.MODULE$.Right().apply((Object)TransactionVersion$.MODULE$.minVersion()) : this.decodeVersion(node.getVersion());
    }

    public Either<ValueCoder.DecodeError, ActionNodeInfo> protoActionNodeInfo(TransactionVersion txVersion, TransactionOuterClass.Node protoNode) {
        Left left;
        TransactionOuterClass.Node.NodeTypeCase nodeTypeCase = protoNode.getNodeTypeCase();
        if (TransactionOuterClass.Node.NodeTypeCase.ROLLBACK.equals(nodeTypeCase)) {
            left = scala.package$.MODULE$.Left().apply((Object)new ValueCoder.DecodeError("protoActionNodeInfo only supports action nodes but was applied to a rollback node"));
        } else if (TransactionOuterClass.Node.NodeTypeCase.CREATE.equals(nodeTypeCase)) {
            TransactionOuterClass.NodeCreate protoCreate = protoNode.getCreate();
            left = this.toPartySet(protoCreate.getSignatoriesList()).flatMap((Function1 & Serializable)signatories_ -> MODULE$.toPartySet(protoCreate.getStakeholdersList()).map((Function1 & Serializable)stakeholders_ -> new ActionNodeInfo.Create((scala.collection.immutable.Set)signatories_, (scala.collection.immutable.Set)stakeholders_){
                private final scala.collection.immutable.Set signatories_$1;
                private final scala.collection.immutable.Set stakeholders_$1;

                public final scala.collection.immutable.Set<String> requiredAuthorizers() {
                    return ActionNodeInfo.Create.requiredAuthorizers$(this);
                }

                public final scala.collection.immutable.Set<String> informeesOfNode() {
                    return ActionNodeInfo.Create.informeesOfNode$(this);
                }

                public scala.collection.immutable.Set<String> signatories() {
                    return this.signatories_$1;
                }

                public scala.collection.immutable.Set<String> stakeholders() {
                    return this.stakeholders_$1;
                }
                {
                    this.signatories_$1 = signatories_$1;
                    this.stakeholders_$1 = stakeholders_$1;
                    ActionNodeInfo.Create.$init$(this);
                }
            }));
        } else if (TransactionOuterClass.Node.NodeTypeCase.FETCH.equals(nodeTypeCase)) {
            TransactionOuterClass.NodeFetch protoFetch = protoNode.getFetch();
            left = this.toPartySet(protoFetch.getActorsList()).flatMap((Function1 & Serializable)actingParties_ -> MODULE$.toPartySet(protoFetch.getStakeholdersList()).flatMap((Function1 & Serializable)stakeholders_ -> MODULE$.toPartySet(protoFetch.getSignatoriesList()).map((Function1 & Serializable)signatories_ -> new ActionNodeInfo.Fetch((scala.collection.immutable.Set)signatories_, (scala.collection.immutable.Set)stakeholders_, (scala.collection.immutable.Set)actingParties_){
                private final scala.collection.immutable.Set signatories_$2;
                private final scala.collection.immutable.Set stakeholders_$2;
                private final scala.collection.immutable.Set actingParties_$1;

                public final scala.collection.immutable.Set<String> requiredAuthorizers() {
                    return ActionNodeInfo.Fetch.requiredAuthorizers$(this);
                }

                public final scala.collection.immutable.Set<String> informeesOfNode() {
                    return ActionNodeInfo.Fetch.informeesOfNode$(this);
                }

                public scala.collection.immutable.Set<String> signatories() {
                    return this.signatories_$2;
                }

                public scala.collection.immutable.Set<String> stakeholders() {
                    return this.stakeholders_$2;
                }

                public scala.collection.immutable.Set<String> actingParties() {
                    return this.actingParties_$1;
                }
                {
                    this.signatories_$2 = signatories_$2;
                    this.stakeholders_$2 = stakeholders_$2;
                    this.actingParties_$1 = actingParties_$1;
                    ActionNodeInfo.Fetch.$init$(this);
                }
            })));
        } else if (TransactionOuterClass.Node.NodeTypeCase.EXERCISE.equals(nodeTypeCase)) {
            TransactionOuterClass.NodeExercise protoExe = protoNode.getExercise();
            left = this.toPartySet(protoExe.getActorsList()).flatMap((Function1 & Serializable)actingParties_ -> MODULE$.toPartySet(protoExe.getSignatoriesList()).flatMap((Function1 & Serializable)signatories_ -> MODULE$.toPartySet(protoExe.getStakeholdersList()).flatMap((Function1 & Serializable)stakeholders_ -> (Ordering.Implicits$.MODULE$.infixOrderingOps((Object)txVersion, TransactionVersion$.MODULE$.Ordering()).$less((Object)TransactionVersion$.MODULE$.minChoiceObservers()) ? scala.package$.MODULE$.Right().apply((Object)Predef$.MODULE$.Set().empty()) : MODULE$.toPartySet(protoExe.getObserversList())).map((Function1 & Serializable)choiceObservers_ -> new ActionNodeInfo.Exercise((scala.collection.immutable.Set)signatories_, (scala.collection.immutable.Set)stakeholders_, (scala.collection.immutable.Set)actingParties_, (scala.collection.immutable.Set)choiceObservers_, protoExe){
                private final scala.collection.immutable.Set signatories_$3;
                private final scala.collection.immutable.Set stakeholders_$3;
                private final scala.collection.immutable.Set actingParties_$2;
                private final scala.collection.immutable.Set choiceObservers_$1;
                private final TransactionOuterClass.NodeExercise protoExe$2;

                public final scala.collection.immutable.Set<String> requiredAuthorizers() {
                    return ActionNodeInfo.Exercise.requiredAuthorizers$(this);
                }

                public final scala.collection.immutable.Set<String> informeesOfNode() {
                    return ActionNodeInfo.Exercise.informeesOfNode$(this);
                }

                public scala.collection.immutable.Set<String> signatories() {
                    return this.signatories_$3;
                }

                public scala.collection.immutable.Set<String> stakeholders() {
                    return this.stakeholders_$3;
                }

                public scala.collection.immutable.Set<String> actingParties() {
                    return this.actingParties_$2;
                }

                public scala.collection.immutable.Set<String> choiceObservers() {
                    return this.choiceObservers_$1;
                }

                public boolean consuming() {
                    return this.protoExe$2.getConsuming();
                }
                {
                    this.signatories_$3 = signatories_$3;
                    this.stakeholders_$3 = stakeholders_$3;
                    this.actingParties_$2 = actingParties_$2;
                    this.choiceObservers_$1 = choiceObservers_$1;
                    this.protoExe$2 = protoExe$2;
                    ActionNodeInfo.Exercise.$init$(this);
                }
            }))));
        } else if (TransactionOuterClass.Node.NodeTypeCase.LOOKUP_BY_KEY.equals(nodeTypeCase)) {
            TransactionOuterClass.NodeLookupByKey protoLookupByKey = protoNode.getLookupByKey();
            left = this.toPartySet(protoLookupByKey.getKeyWithMaintainers().getMaintainersList()).map((Function1 & Serializable)maintainers -> new ActionNodeInfo.LookupByKey(protoLookupByKey, (scala.collection.immutable.Set)maintainers){
                private final TransactionOuterClass.NodeLookupByKey protoLookupByKey$2;
                private final scala.collection.immutable.Set maintainers$3;

                public final scala.collection.immutable.Set<String> requiredAuthorizers() {
                    return ActionNodeInfo.LookupByKey.requiredAuthorizers$(this);
                }

                public final scala.collection.immutable.Set<String> informeesOfNode() {
                    return ActionNodeInfo.LookupByKey.informeesOfNode$(this);
                }

                public boolean hasResult() {
                    return this.protoLookupByKey$2.hasContractIdStruct();
                }

                public scala.collection.immutable.Set<String> keyMaintainers() {
                    return this.maintainers$3;
                }
                {
                    this.protoLookupByKey$2 = protoLookupByKey$2;
                    this.maintainers$3 = maintainers$3;
                    ActionNodeInfo.LookupByKey.$init$(this);
                }
            });
        } else if (TransactionOuterClass.Node.NodeTypeCase.NODETYPE_NOT_SET.equals(nodeTypeCase)) {
            left = scala.package$.MODULE$.Left().apply((Object)new ValueCoder.DecodeError("Unset Node type"));
        } else {
            throw new MatchError((Object)nodeTypeCase);
        }
        return left;
    }

    private Either<ValueCoder.DecodeError, GlobalKey> keyHash(TransactionVersion nodeVersion, ValueOuterClass.Identifier rawTmplId, ByteString rawKey) {
        return ValueCoder$.MODULE$.decodeIdentifier(rawTmplId).flatMap((Function1 & Serializable)tmplId -> ValueCoder$.MODULE$.decodeValue(ValueCoder$.MODULE$.NoCidDecoder(), nodeVersion, rawKey).flatMap((Function1 & Serializable)value -> GlobalKey$.MODULE$.build((Ref.Identifier)tmplId, (Value)value).left().map((Function1)ValueCoder$DecodeError$.MODULE$).map((Function1 & Serializable)key -> key)));
    }

    public Either<ValueCoder.DecodeError, Option<GlobalKey>> nodeKey(TransactionVersion nodeVersion, TransactionOuterClass.NodeCreate protoCreate) {
        Right right;
        if (protoCreate.hasKeyWithMaintainers()) {
            Tuple2 tuple2;
            Tuple2 tuple22 = tuple2 = Ordering.Implicits$.MODULE$.infixOrderingOps((Object)nodeVersion, TransactionVersion$.MODULE$.Ordering()).$less((Object)TransactionVersion$.MODULE$.minNoVersionValue()) ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)protoCreate.getContractInstance().getTemplateId()), (Object)protoCreate.getKeyWithMaintainers().getKeyVersioned().getValue()) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)protoCreate.getTemplateId()), (Object)protoCreate.getKeyWithMaintainers().getKeyUnversioned());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ValueOuterClass.Identifier rawTmplId = (ValueOuterClass.Identifier)tuple2._1();
            ByteString rawKey = (ByteString)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)rawTmplId, (Object)rawKey);
            Tuple2 tuple24 = tuple23;
            ValueOuterClass.Identifier rawTmplId2 = (ValueOuterClass.Identifier)tuple24._1();
            ByteString rawKey2 = (ByteString)tuple24._2();
            right = this.keyHash(nodeVersion, rawTmplId2, rawKey2).map((Function1 & Serializable)x$27 -> new Some(x$27));
        } else {
            right = scala.package$.MODULE$.Right().apply((Object)None$.MODULE$);
        }
        return right;
    }

    public Either<ValueCoder.DecodeError, Option<GlobalKey>> nodeKey(TransactionVersion nodeVersion, TransactionOuterClass.NodeExercise protoExercise) {
        Right right;
        if (protoExercise.hasKeyWithMaintainers()) {
            ByteString rawKey = Ordering.Implicits$.MODULE$.infixOrderingOps((Object)nodeVersion, TransactionVersion$.MODULE$.Ordering()).$less((Object)TransactionVersion$.MODULE$.minNoVersionValue()) ? protoExercise.getKeyWithMaintainers().getKeyVersioned().getValue() : protoExercise.getKeyWithMaintainers().getKeyUnversioned();
            right = this.keyHash(nodeVersion, protoExercise.getTemplateId(), rawKey).map((Function1 & Serializable)x$28 -> new Some(x$28));
        } else {
            right = scala.package$.MODULE$.Right().apply((Object)None$.MODULE$);
        }
        return right;
    }

    private TransactionCoder$() {
    }
}

