/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.transaction;

import com.daml.lf.VersionRange;
import com.daml.lf.language.LanguageVersion;
import com.daml.lf.language.LanguageVersion$;
import com.daml.lf.transaction.Node;
import com.daml.lf.transaction.Transaction;
import com.daml.lf.transaction.TransactionVersion;
import com.daml.lf.transaction.TransactionVersion$V10$;
import com.daml.lf.transaction.TransactionVersion$V11$;
import com.daml.lf.transaction.TransactionVersion$V12$;
import com.daml.lf.transaction.TransactionVersion$V13$;
import com.daml.lf.transaction.TransactionVersion$V14$;
import com.daml.lf.transaction.TransactionVersion$VDev$;
import com.daml.lf.transaction.VersionedTransaction;
import com.daml.lf.transaction.VersionedTransaction$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Right;

public final class TransactionVersion$
implements Serializable {
    public static final TransactionVersion$ MODULE$ = new TransactionVersion$();
    private static final List<TransactionVersion> All = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TransactionVersion[]{TransactionVersion$V10$.MODULE$, TransactionVersion$V11$.MODULE$, TransactionVersion$V12$.MODULE$, TransactionVersion$V13$.MODULE$, TransactionVersion$V14$.MODULE$, TransactionVersion$VDev$.MODULE$}));
    private static final Ordering<TransactionVersion> Ordering = package$.MODULE$.Ordering().by((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.com$daml$lf$transaction$TransactionVersion$$index()), (Ordering)Ordering.Int$.MODULE$);
    private static final Map<String, TransactionVersion> stringMapping = MODULE$.All().iterator().map((Function1 & Serializable)v -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)v.protoValue()), v)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    private static final TransactionVersion minVersion = (TransactionVersion)MODULE$.All().min(MODULE$.Ordering());
    private static final TransactionVersion$V11$ minGenMap = TransactionVersion$V11$.MODULE$;
    private static final TransactionVersion$V11$ minChoiceObservers = TransactionVersion$V11$.MODULE$;
    private static final TransactionVersion$V11$ minNodeVersion = TransactionVersion$V11$.MODULE$;
    private static final TransactionVersion$V12$ minNoVersionValue = TransactionVersion$V12$.MODULE$;
    private static final TransactionVersion$V12$ minTypeErasure = TransactionVersion$V12$.MODULE$;
    private static final TransactionVersion$V14$ minExceptions = TransactionVersion$V14$.MODULE$;
    private static final TransactionVersion$V14$ minByKey = TransactionVersion$V14$.MODULE$;
    private static final TransactionVersion$VDev$ minInterfaces = TransactionVersion$VDev$.MODULE$;
    private static final Function1<LanguageVersion, TransactionVersion> assignNodeVersion = (Function1)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LanguageVersion$.MODULE$.v1_6()), (Object)TransactionVersion$V10$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LanguageVersion$.MODULE$.v1_7()), (Object)TransactionVersion$V10$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LanguageVersion$.MODULE$.v1_8()), (Object)TransactionVersion$V10$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LanguageVersion$.MODULE$.v1_11()), (Object)TransactionVersion$V11$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LanguageVersion$.MODULE$.v1_12()), (Object)TransactionVersion$V12$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LanguageVersion$.MODULE$.v1_13()), (Object)TransactionVersion$V13$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LanguageVersion$.MODULE$.v1_14()), (Object)TransactionVersion$V14$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LanguageVersion$.MODULE$.v1_dev()), (Object)TransactionVersion$VDev$.MODULE$)}));
    private static final VersionRange<TransactionVersion> StableVersions = LanguageVersion$.MODULE$.StableVersions().map(MODULE$.assignNodeVersion(), MODULE$.Ordering());
    private static final VersionRange<TransactionVersion> EarlyAccessVersions = LanguageVersion$.MODULE$.EarlyAccessVersions().map(MODULE$.assignNodeVersion(), MODULE$.Ordering());
    private static final VersionRange<TransactionVersion> DevVersions = LanguageVersion$.MODULE$.DevVersions().map(MODULE$.assignNodeVersion(), MODULE$.Ordering());

    public List<TransactionVersion> All() {
        return All;
    }

    public Ordering<TransactionVersion> Ordering() {
        return Ordering;
    }

    public Either<String, TransactionVersion> fromString(String vs) {
        Right right;
        Option option = stringMapping.get((Object)vs);
        if (option instanceof Some) {
            Some some = (Some)option;
            TransactionVersion value = (TransactionVersion)some.value();
            right = package$.MODULE$.Right().apply((Object)value);
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Left().apply((Object)new StringBuilder(34).append("Unsupported transaction version '").append(vs).append("'").toString());
        } else {
            throw new MatchError((Object)option);
        }
        return right;
    }

    public TransactionVersion assertFromString(String vs) {
        return (TransactionVersion)com.daml.lf.data.package$.MODULE$.assertRight(this.fromString(vs));
    }

    public TransactionVersion minVersion() {
        return minVersion;
    }

    public TransactionVersion maxVersion() {
        return TransactionVersion$VDev$.MODULE$;
    }

    public TransactionVersion$V11$ minGenMap() {
        return minGenMap;
    }

    public TransactionVersion$V11$ minChoiceObservers() {
        return minChoiceObservers;
    }

    public TransactionVersion$V11$ minNodeVersion() {
        return minNodeVersion;
    }

    public TransactionVersion$V12$ minNoVersionValue() {
        return minNoVersionValue;
    }

    public TransactionVersion$V12$ minTypeErasure() {
        return minTypeErasure;
    }

    public TransactionVersion$V14$ minExceptions() {
        return minExceptions;
    }

    public TransactionVersion$V14$ minByKey() {
        return minByKey;
    }

    public TransactionVersion$VDev$ minInterfaces() {
        return minInterfaces;
    }

    public Function1<LanguageVersion, TransactionVersion> assignNodeVersion() {
        return assignNodeVersion;
    }

    public VersionedTransaction asVersionedTransaction(Transaction tx) {
        TransactionVersion txVersion = (TransactionVersion)tx.nodes().valuesIterator().foldLeft((Object)this.minVersion(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                TransactionVersion acc = (TransactionVersion)tuple2._1();
                Node action = (Node)tuple2._2();
                if (action instanceof Node.Action) {
                    Node.Action action2 = (Node.Action)action;
                    return (TransactionVersion)Ordering.Implicits$.MODULE$.infixOrderingOps((Object)acc, MODULE$.Ordering()).max((Object)action2.version());
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            TransactionVersion acc = (TransactionVersion)tuple2._1();
            if (!(tuple2._2() instanceof Node.Rollback)) throw new MatchError((Object)tuple2);
            return (TransactionVersion)Ordering.Implicits$.MODULE$.infixOrderingOps((Object)acc, MODULE$.Ordering()).max((Object)MODULE$.minExceptions());
        });
        return VersionedTransaction$.MODULE$.apply(txVersion, tx.nodes(), tx.roots());
    }

    public VersionRange<TransactionVersion> StableVersions() {
        return StableVersions;
    }

    public VersionRange<TransactionVersion> EarlyAccessVersions() {
        return EarlyAccessVersions;
    }

    public VersionRange<TransactionVersion> DevVersions() {
        return DevVersions;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TransactionVersion$.class);
    }

    private TransactionVersion$() {
    }
}

