/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.transaction;

import com.daml.lf.InternalError$;
import com.daml.lf.data.FrontStack;
import com.daml.lf.data.ImmArray;
import com.daml.lf.data.Ref;
import com.daml.lf.data.SortedLookupList;
import com.daml.lf.transaction.Node;
import com.daml.lf.transaction.TransactionVersion;
import com.daml.lf.transaction.TransactionVersion$;
import com.daml.lf.transaction.Versioned;
import com.daml.lf.value.Value;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.math.Ordering;
import scala.package$;
import scala.util.Either;
import scala.util.Right;

public final class Util$ {
    public static final Util$ MODULE$ = new Util$();

    public Either<String, Value> normalizeValue(Value value0, TransactionVersion version) {
        Right right;
        try {
            right = package$.MODULE$.Right().apply((Object)this.assertNormalizeValue(value0, version));
        }
        catch (IllegalArgumentException e) {
            right = package$.MODULE$.Left().apply((Object)e.getMessage());
        }
        return right;
    }

    public Value assertNormalizeValue(Value value0, TransactionVersion version) throws IllegalArgumentException {
        boolean allowGenMap = Ordering.Implicits$.MODULE$.infixOrderingOps((Object)version, TransactionVersion$.MODULE$.Ordering()).$greater$eq((Object)TransactionVersion$.MODULE$.minGenMap());
        boolean eraseType = Ordering.Implicits$.MODULE$.infixOrderingOps((Object)version, TransactionVersion$.MODULE$.Ordering()).$greater$eq((Object)TransactionVersion$.MODULE$.minTypeErasure());
        return Util$.go$1(value0, allowGenMap, version, eraseType);
    }

    public Either<String, Versioned<Value>> normalizeVersionedValue(Versioned<Value> value) {
        return this.normalizeValue(value.unversioned(), value.version()).map((Function1 & Serializable)normalized -> value.map((Function1 & Serializable)x$1 -> normalized));
    }

    public Either<String, Versioned<Value.ContractInstance>> normalizeContract(Versioned<Value.ContractInstance> contract) {
        return this.normalizeValue(contract.unversioned().arg(), contract.version()).map((Function1 & Serializable)normalized -> contract.map((Function1 & Serializable)x$2 -> {
            Value x$1 = normalized;
            Ref.Identifier x$22 = x$2.copy$default$1();
            String x$3 = x$2.copy$default$3();
            return x$2.copy(x$22, x$1, x$3);
        }));
    }

    public Either<String, Node.KeyWithMaintainers> normalizeKey(Node.KeyWithMaintainers key, TransactionVersion version) {
        return this.normalizeValue(key.key(), version).map((Function1 & Serializable)normalized -> key.copy((Value)normalized, key.copy$default$2()));
    }

    public Either<String, Option<Node.KeyWithMaintainers>> normalizeOptKey(Option<Node.KeyWithMaintainers> key, TransactionVersion version) {
        Right right;
        Option<Node.KeyWithMaintainers> option = key;
        if (option instanceof Some) {
            Some some = (Some)option;
            Node.KeyWithMaintainers value = (Node.KeyWithMaintainers)some.value();
            right = this.normalizeKey(value, version).map((Function1 & Serializable)x$3 -> new Some(x$3));
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Right().apply((Object)None$.MODULE$);
        } else {
            throw new MatchError(option);
        }
        return right;
    }

    private static final Option handleTypeInfo$1(Option x, boolean eraseType$1) {
        return eraseType$1 ? None$.MODULE$ : x;
    }

    private static final Value go$1(Value value2, boolean allowGenMap$1, TransactionVersion version$1, boolean eraseType$1) {
        Value value3;
        Value value4 = value2;
        if (value4 instanceof Value.ValueEnum) {
            Value.ValueEnum valueEnum = (Value.ValueEnum)value4;
            Option<Ref.Identifier> tyCon = valueEnum.tycon();
            String cons = valueEnum.value();
            value3 = new Value.ValueEnum((Option<Ref.Identifier>)Util$.handleTypeInfo$1(tyCon, eraseType$1), cons);
        } else if (value4 instanceof Value.ValueRecord) {
            Value.ValueRecord valueRecord = (Value.ValueRecord)value4;
            Option<Ref.Identifier> tyCon = valueRecord.tycon();
            ImmArray<Tuple2<Option<String>, Value>> fields = valueRecord.fields();
            value3 = new Value.ValueRecord((Option<Ref.Identifier>)Util$.handleTypeInfo$1(tyCon, eraseType$1), (ImmArray<Tuple2<Option<String>, Value>>)fields.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Option fieldName = (Option)tuple2._1();
                Value value = (Value)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Util$.handleTypeInfo$1(fieldName, eraseType$1)), (Object)Util$.go$1(value, allowGenMap$1, version$1, eraseType$1));
                return tuple22;
            }));
        } else if (value4 instanceof Value.ValueVariant) {
            Value.ValueVariant valueVariant = (Value.ValueVariant)value4;
            Option<Ref.Identifier> tyCon = valueVariant.tycon();
            String variant = valueVariant.variant();
            Value value5 = valueVariant.value();
            value3 = new Value.ValueVariant((Option<Ref.Identifier>)Util$.handleTypeInfo$1(tyCon, eraseType$1), variant, Util$.go$1(value5, allowGenMap$1, version$1, eraseType$1));
        } else {
            boolean bl = value4 instanceof Value.ValueCidlessLeaf ? true : value4 instanceof Value.ValueContractId;
            if (bl) {
                value3 = value2;
            } else if (value4 instanceof Value.ValueList) {
                Value.ValueList valueList = (Value.ValueList)value4;
                FrontStack<Value> values = valueList.values();
                value3 = new Value.ValueList((FrontStack<Value>)values.map((Function1 & Serializable)value -> Util$.go$1(value, allowGenMap$1, version$1, eraseType$1)));
            } else if (value4 instanceof Value.ValueOptional) {
                Value.ValueOptional valueOptional = (Value.ValueOptional)value4;
                Option<Value> value6 = valueOptional.value();
                value3 = new Value.ValueOptional((Option<Value>)value6.map((Function1 & Serializable)value -> Util$.go$1(value, allowGenMap$1, version$1, eraseType$1)));
            } else if (value4 instanceof Value.ValueTextMap) {
                Value.ValueTextMap valueTextMap = (Value.ValueTextMap)value4;
                SortedLookupList<Value> value7 = valueTextMap.value();
                value3 = new Value.ValueTextMap((SortedLookupList<Value>)value7.mapValue((Function1 & Serializable)value -> Util$.go$1(value, allowGenMap$1, version$1, eraseType$1)));
            } else if (value4 instanceof Value.ValueGenMap) {
                Value.ValueGenMap valueGenMap = (Value.ValueGenMap)value4;
                ImmArray<Tuple2<Value, Value>> entries = valueGenMap.entries();
                if (!allowGenMap$1) {
                    throw InternalError$.MODULE$.illegalArgumentException("com.daml.lf.transaction.Util.go", new StringBuilder(46).append("GenMap are not allowed in transaction version ").append(version$1).toString());
                }
                value3 = new Value.ValueGenMap((ImmArray<Tuple2<Value, Value>>)entries.map((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Value k = (Value)tuple2._1();
                    Value v = (Value)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Util$.go$1(k, allowGenMap$1, version$1, eraseType$1)), (Object)Util$.go$1(v, allowGenMap$1, version$1, eraseType$1));
                    return tuple22;
                }));
            } else {
                throw new MatchError((Object)value4);
            }
        }
        return value3;
    }

    private Util$() {
    }
}

