/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.value;

import com.daml.SafeProto$;
import com.daml.lf.data.FrontStack;
import com.daml.lf.data.FrontStack$;
import com.daml.lf.data.ImmArray;
import com.daml.lf.data.ImmArray$;
import com.daml.lf.data.Ref;
import com.daml.lf.data.Ref$;
import com.daml.lf.data.SortedLookupList;
import com.daml.lf.data.SortedLookupList$;
import com.daml.lf.data.Time;
import com.daml.lf.data.package$;
import com.daml.lf.transaction.TransactionVersion;
import com.daml.lf.transaction.TransactionVersion$;
import com.daml.lf.transaction.TransactionVersion$V10$;
import com.daml.lf.transaction.Versioned;
import com.daml.lf.value.Value;
import com.daml.lf.value.Value$;
import com.daml.lf.value.Value$ContractId$;
import com.daml.lf.value.Value$ValueBool$;
import com.daml.lf.value.Value$ValueDate$;
import com.daml.lf.value.Value$ValueNumeric$;
import com.daml.lf.value.Value$ValueParty$;
import com.daml.lf.value.Value$ValueTimestamp$;
import com.daml.lf.value.Value$ValueUnit$;
import com.daml.lf.value.ValueCoder;
import com.daml.lf.value.ValueCoder$DecodeError$;
import com.daml.lf.value.ValueCoder$EncodeError$;
import com.daml.lf.value.ValueCoder$Err$2$;
import com.daml.lf.value.ValueCoder$Err$5$;
import com.daml.lf.value.ValueOuterClass;
import com.daml.scalautil.Statement$;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Empty;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class ValueCoder$ {
    public static final ValueCoder$ MODULE$ = new ValueCoder$();
    private static final ValueCoder.DecodeCid CidDecoder = new ValueCoder.DecodeCid(){

        private Either<ValueCoder.DecodeError, Value.ContractId> stringToCidString(String s) {
            return Value$ContractId$.MODULE$.fromString(s).left().map((Function1 & Serializable)x$1 -> new ValueCoder.DecodeError(new StringBuilder(26).append("cannot parse contractId \"").append(s).append("\"").toString()));
        }

        public Either<ValueCoder.DecodeError, Option<Value.ContractId>> decodeOptional(ValueOuterClass.ContractId structForm) {
            return structForm.getContractId().isEmpty() ? scala.package$.MODULE$.Right().apply((Object)None$.MODULE$) : this.stringToCidString(structForm.getContractId()).map((Function1 & Serializable)x$2 -> new Some(x$2));
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$decodeOptional$1(com.daml.lf.value.Value$ContractId ), $anonfun$stringToCidString$1(java.lang.String java.lang.String )}, serializedLambda);
        }
    };
    private static final ValueCoder.DecodeCid NoCidDecoder = new ValueCoder.DecodeCid(){

        public Right<Nothing$, None$> decodeOptional(ValueOuterClass.ContractId structForm) {
            return scala.package$.MODULE$.Right().apply((Object)None$.MODULE$);
        }
    };
    private static final int MAXIMUM_PROTO_RECURSION_LIMIT = 3 * Value$.MODULE$.MAXIMUM_NESTING() + 1;

    public ValueCoder.DecodeCid CidDecoder() {
        return CidDecoder;
    }

    public ValueCoder.DecodeCid NoCidDecoder() {
        return NoCidDecoder;
    }

    public ValueOuterClass.Identifier encodeIdentifier(Ref.Identifier id) {
        return ValueOuterClass.Identifier.newBuilder().setPackageId(id.packageId()).addAllModuleName((java.lang.Iterable)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)id.qualifiedName().module().segments().toSeq()).asJava()).addAllName((java.lang.Iterable)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)id.qualifiedName().name().segments().toSeq()).asJava()).build();
    }

    public Either<ValueCoder.DecodeError, Ref.Identifier> decodeIdentifier(ValueOuterClass.Identifier id) {
        return Ref$.MODULE$.PackageId().fromString(id.getPackageId()).left().map((Function1 & Serializable)err -> new ValueCoder.DecodeError(new StringBuilder(23).append("Invalid package id '").append(id.getPackageId()).append("': ").append((String)err).toString())).map((Function1 & Serializable)pkgId -> {
            Buffer moduleSegments = CollectionConverters$.MODULE$.ListHasAsScala((List)id.getModuleNameList()).asScala();
            return new Tuple2(pkgId, (Object)moduleSegments);
        }).flatMap((Function1 & Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String pkgId = (String)tuple2._1();
            Buffer moduleSegments = (Buffer)tuple2._2();
            Either either = Ref$.MODULE$.ModuleName().fromSegments((Iterable)CollectionConverters$.MODULE$.ListHasAsScala((List)id.getModuleNameList()).asScala()).left().map((Function1 & Serializable)err -> new ValueCoder.DecodeError(new StringBuilder(26).append("Invalid module segments ").append(moduleSegments).append(": ").append((String)err).toString())).map((Function1 & Serializable)module -> {
                Buffer nameSegments = CollectionConverters$.MODULE$.ListHasAsScala((List)id.getNameList()).asScala();
                return new Tuple2(module, (Object)nameSegments);
            }).flatMap((Function1 & Serializable)x$3 -> {
                Tuple2 tuple2 = x$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Ref.DottedName module = (Ref.DottedName)tuple2._1();
                Buffer nameSegments = (Buffer)tuple2._2();
                Either either = Ref.DottedName$.MODULE$.fromSegments((Iterable)nameSegments).left().map((Function1 & Serializable)err -> new ValueCoder.DecodeError(new StringBuilder(24).append("Invalid name segments ").append(nameSegments).append(": ").append((String)err).toString())).map((Function1 & Serializable)name -> new Ref.Identifier(pkgId, Ref.QualifiedName$.MODULE$.apply(module, name)));
                return either;
            });
            return either;
        });
    }

    public String encodeValueVersion(TransactionVersion version) {
        TransactionVersion transactionVersion = version;
        TransactionVersion$V10$ transactionVersion$V10$ = TransactionVersion$V10$.MODULE$;
        return !(transactionVersion != null ? !transactionVersion.equals(transactionVersion$V10$) : transactionVersion$V10$ != null) ? "6" : version.protoValue();
    }

    private Either<ValueCoder.DecodeError, TransactionVersion> decodeValueVersion(String vs) {
        Object object;
        String string = vs;
        if ("6".equals(string)) {
            object = scala.package$.MODULE$.Right().apply((Object)TransactionVersion$V10$.MODULE$);
        } else {
            String string2 = TransactionVersion$V10$.MODULE$.protoValue();
            String string3 = string;
            object = !(string2 != null ? !string2.equals(string3) : string3 != null) ? scala.package$.MODULE$.Left().apply((Object)new ValueCoder.DecodeError("Unsupported value version 10")) : TransactionVersion$.MODULE$.fromString(vs).left().map((Function1)ValueCoder$DecodeError$.MODULE$);
        }
        return object;
    }

    public Either<ValueCoder.DecodeError, Versioned<Value>> decodeVersionedValue(ValueCoder.DecodeCid decodeCid, ValueOuterClass.VersionedValue protoValue0) {
        return this.decodeValueVersion(protoValue0.getVersion()).flatMap((Function1 & Serializable)version -> MODULE$.decodeValue(decodeCid, (TransactionVersion)version, protoValue0.getValue()).map((Function1 & Serializable)value -> new Versioned<Value>((TransactionVersion)version, (Value)value)));
    }

    public Either<ValueCoder.DecodeError, Value> decodeValue(ValueCoder.DecodeCid decodeCid, ValueOuterClass.VersionedValue protoValue0) {
        return this.decodeVersionedValue(decodeCid, protoValue0).map((Function1 & Serializable)x$5 -> (Value)x$5.unversioned());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Either<ValueCoder.DecodeError, ValueOuterClass.Value> parseValue(ByteString bytes) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            CodedInputStream cis = CodedInputStream.newInstance((ByteBuffer)bytes.asReadOnlyByteBuffer());
            Statement$.MODULE$.discard((Object)BoxesRunTime.boxToInteger((int)cis.setRecursionLimit(MAXIMUM_PROTO_RECURSION_LIMIT)));
            return ValueOuterClass.Value.parseFrom((CodedInputStream)cis);
        });
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable exception = failure.exception();
            if (exception instanceof Error) {
                Error error = (Error)exception;
                return scala.package$.MODULE$.Left().apply((Object)new ValueCoder.DecodeError(new StringBuilder(26).append("cannot parse proto Value: ").append(error.getMessage()).toString()));
            }
        }
        if (bl) {
            Throwable throwable = failure.exception();
            throw throwable;
        }
        if (!(try_ instanceof Success)) throw new MatchError((Object)try_);
        Success success = (Success)try_;
        ValueOuterClass.Value value = (ValueOuterClass.Value)success.value();
        return scala.package$.MODULE$.Right().apply((Object)value);
    }

    public Either<ValueCoder.DecodeError, Value> decodeValue(ValueCoder.DecodeCid decodeCid, TransactionVersion version, ByteString bytes) {
        return this.parseValue(bytes).flatMap((Function1 & Serializable)x$6 -> MODULE$.decodeValue(decodeCid, version, (ValueOuterClass.Value)x$6));
    }

    private Either<ValueCoder.DecodeError, Value> decodeValue(ValueCoder.DecodeCid decodeCid, TransactionVersion version, ValueOuterClass.Value protoValue0) {
        Right right;
        LazyRef Err$module = new LazyRef();
        try {
            right = scala.package$.MODULE$.Right().apply((Object)this.go$1(0, protoValue0, decodeCid, Err$module, version));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            public class Com_daml_lf_value_ValueCoder$Err$1
            extends Throwable
            implements Product {
                private final String msg;

                public Iterator<String> productElementNames() {
                    return Product.productElementNames$((Product)this);
                }

                public String msg() {
                    return this.msg;
                }

                public Com_daml_lf_value_ValueCoder$Err$1 copy(String msg) {
                    return new Com_daml_lf_value_ValueCoder$Err$1(msg);
                }

                public String copy$default$1() {
                    return this.msg();
                }

                public String productPrefix() {
                    return "Err";
                }

                public int productArity() {
                    return 1;
                }

                public Object productElement(int x$1) {
                    Object object;
                    int n = x$1;
                    switch (n) {
                        case 0: {
                            object = this.msg();
                            break;
                        }
                        default: {
                            object = Statics.ioobe((int)x$1);
                            break;
                        }
                    }
                    return object;
                }

                public Iterator<Object> productIterator() {
                    return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
                }

                public boolean canEqual(Object x$1) {
                    return x$1 instanceof Com_daml_lf_value_ValueCoder$Err$1;
                }

                public String productElementName(int x$1) {
                    String string;
                    int n = x$1;
                    switch (n) {
                        case 0: {
                            string = "msg";
                            break;
                        }
                        default: {
                            string = (String)Statics.ioobe((int)x$1);
                            break;
                        }
                    }
                    return string;
                }

                public int hashCode() {
                    return ScalaRunTime$.MODULE$._hashCode((Product)this);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean equals(Object x$1) {
                    if (this == x$1) return true;
                    Object object = x$1;
                    if (!(object instanceof Com_daml_lf_value_ValueCoder$Err$1)) return false;
                    boolean bl = true;
                    if (!bl) return false;
                    Com_daml_lf_value_ValueCoder$Err$1 var4_4 = (Com_daml_lf_value_ValueCoder$Err$1)x$1;
                    String string = this.msg();
                    String string2 = var4_4.msg();
                    if (string == null) {
                        if (string2 != null) {
                            return false;
                        }
                    } else if (!string.equals(string2)) return false;
                    if (!var4_4.canEqual(this)) return false;
                    return true;
                }

                public Com_daml_lf_value_ValueCoder$Err$1(String msg) {
                    this.msg = msg;
                    super(null, null, true, false);
                    Product.$init$((Product)this);
                }
            }
            if (!(throwable2 instanceof Com_daml_lf_value_ValueCoder$Err$1)) {
                throw throwable;
            }
            Com_daml_lf_value_ValueCoder$Err$1 var8_7 = (Com_daml_lf_value_ValueCoder$Err$1)throwable2;
            String msg = var8_7.msg();
            Left left = scala.package$.MODULE$.Left().apply((Object)new ValueCoder.DecodeError(msg));
            right = left;
        }
        return right;
    }

    public Either<ValueCoder.EncodeError, ValueOuterClass.VersionedValue> encodeVersionedValue(ValueCoder.EncodeCid encodeCid, Versioned<Value> versionedValue) {
        return this.encodeVersionedValue(encodeCid, versionedValue.version(), versionedValue.unversioned());
    }

    public Either<ValueCoder.EncodeError, ValueOuterClass.VersionedValue> encodeVersionedValue(ValueCoder.EncodeCid encodeCid, TransactionVersion version, Value value) {
        return this.encodeValue(encodeCid, version, value).map((Function1 & Serializable)bytes -> {
            ValueOuterClass.VersionedValue.Builder builder = ValueOuterClass.VersionedValue.newBuilder();
            return builder.setVersion(MODULE$.encodeValueVersion(version)).setValue(bytes).build();
        });
    }

    public Either<ValueCoder.EncodeError, ByteString> encodeValue(ValueCoder.EncodeCid encodeCid, TransactionVersion valueVersion, Value v0) {
        Either either;
        LazyRef Err$module = new LazyRef();
        try {
            either = SafeProto$.MODULE$.toByteString((AbstractMessageLite)this.go$2(0, v0, encodeCid, valueVersion, Err$module)).left().map((Function1)ValueCoder$EncodeError$.MODULE$);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            public class Com_daml_lf_value_ValueCoder$Err$4
            extends Throwable
            implements Product {
                private final String msg;

                public Iterator<String> productElementNames() {
                    return Product.productElementNames$((Product)this);
                }

                public String msg() {
                    return this.msg;
                }

                public Com_daml_lf_value_ValueCoder$Err$4 copy(String msg) {
                    return new Com_daml_lf_value_ValueCoder$Err$4(msg);
                }

                public String copy$default$1() {
                    return this.msg();
                }

                public String productPrefix() {
                    return "Err";
                }

                public int productArity() {
                    return 1;
                }

                public Object productElement(int x$1) {
                    Object object;
                    int n = x$1;
                    switch (n) {
                        case 0: {
                            object = this.msg();
                            break;
                        }
                        default: {
                            object = Statics.ioobe((int)x$1);
                            break;
                        }
                    }
                    return object;
                }

                public Iterator<Object> productIterator() {
                    return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
                }

                public boolean canEqual(Object x$1) {
                    return x$1 instanceof Com_daml_lf_value_ValueCoder$Err$4;
                }

                public String productElementName(int x$1) {
                    String string;
                    int n = x$1;
                    switch (n) {
                        case 0: {
                            string = "msg";
                            break;
                        }
                        default: {
                            string = (String)Statics.ioobe((int)x$1);
                            break;
                        }
                    }
                    return string;
                }

                public int hashCode() {
                    return ScalaRunTime$.MODULE$._hashCode((Product)this);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean equals(Object x$1) {
                    if (this == x$1) return true;
                    Object object = x$1;
                    if (!(object instanceof Com_daml_lf_value_ValueCoder$Err$4)) return false;
                    boolean bl = true;
                    if (!bl) return false;
                    Com_daml_lf_value_ValueCoder$Err$4 var4_4 = (Com_daml_lf_value_ValueCoder$Err$4)x$1;
                    String string = this.msg();
                    String string2 = var4_4.msg();
                    if (string == null) {
                        if (string2 != null) {
                            return false;
                        }
                    } else if (!string.equals(string2)) return false;
                    if (!var4_4.canEqual(this)) return false;
                    return true;
                }

                public Com_daml_lf_value_ValueCoder$Err$4(String msg) {
                    this.msg = msg;
                    super(null, null, true, false);
                    Product.$init$((Product)this);
                }
            }
            if (!(throwable2 instanceof Com_daml_lf_value_ValueCoder$Err$4)) {
                throw throwable;
            }
            Com_daml_lf_value_ValueCoder$Err$4 var8_7 = (Com_daml_lf_value_ValueCoder$Err$4)throwable2;
            String msg = var8_7.msg();
            Left left = scala.package$.MODULE$.Left().apply((Object)new ValueCoder.EncodeError(msg));
            either = left;
        }
        return either;
    }

    public Either<ValueCoder.DecodeError, Value> valueFromBytes(ValueCoder.DecodeCid decodeCid, byte[] bytes) {
        return this.decodeValue(decodeCid, ValueOuterClass.VersionedValue.parseFrom((byte[])bytes));
    }

    private static final /* synthetic */ ValueCoder$Err$2$ Err$lzycompute$1(LazyRef Err$module$1) {
        ValueCoder$Err$2$ valueCoder$Err$2$;
        LazyRef lazyRef = Err$module$1;
        synchronized (lazyRef) {
            valueCoder$Err$2$ = Err$module$1.initialized() ? (ValueCoder$Err$2$)Err$module$1.value() : (ValueCoder$Err$2$)Err$module$1.initialize((Object)new ValueCoder$Err$2$());
        }
        return valueCoder$Err$2$;
    }

    private final ValueCoder$Err$2$ Err$3(LazyRef Err$module$1) {
        return Err$module$1.initialized() ? (ValueCoder$Err$2$)Err$module$1.value() : ValueCoder$.Err$lzycompute$1(Err$module$1);
    }

    private final String identifier$1(String s, LazyRef Err$module$1) {
        return (String)Ref$.MODULE$.Name().fromString(s).fold((Function1 & Serializable)err -> {
            throw this.Err$3(Err$module$1).apply(new StringBuilder(36).append("error decoding variant constructor: ").append((String)err).toString());
        }, (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x));
    }

    private final void assertSince$1(TransactionVersion minVersion, Function0 description, TransactionVersion version$3, LazyRef Err$module$1) {
        if (Ordering.Implicits$.MODULE$.infixOrderingOps((Object)version$3, TransactionVersion$.MODULE$.Ordering()).$less((Object)minVersion)) {
            throw this.Err$3(Err$module$1).apply(new StringBuilder(41).append(description.apply()).append(" is not supported by transaction version ").append(version$3).toString());
        }
    }

    private final void assertUntil$1(TransactionVersion minVersion, Function0 description, TransactionVersion version$3, LazyRef Err$module$1) {
        if (Ordering.Implicits$.MODULE$.infixOrderingOps((Object)version$3, TransactionVersion$.MODULE$.Ordering()).$greater$eq((Object)minVersion)) {
            throw this.Err$3(Err$module$1).apply(new StringBuilder(41).append(description.apply()).append(" is not supported by transaction version ").append(version$3).toString());
        }
    }

    private final Value go$1(int nesting, ValueOuterClass.Value protoValue, ValueCoder.DecodeCid decodeCid$3, LazyRef Err$module$1, TransactionVersion version$3) {
        Value value;
        if (nesting > Value$.MODULE$.MAXIMUM_NESTING()) {
            throw this.Err$3(Err$module$1).apply(new StringBuilder(64).append("Provided proto value to decode exceeds maximum nesting level of ").append(Value$.MODULE$.MAXIMUM_NESTING()).toString());
        }
        int newNesting = nesting + 1;
        ValueOuterClass.Value.SumCase sumCase = protoValue.getSumCase();
        if (ValueOuterClass.Value.SumCase.BOOL.equals(sumCase)) {
            value = Value$ValueBool$.MODULE$.apply(protoValue.getBool());
        } else if (ValueOuterClass.Value.SumCase.UNIT.equals(sumCase)) {
            value = Value$ValueUnit$.MODULE$;
        } else if (ValueOuterClass.Value.SumCase.NUMERIC.equals(sumCase)) {
            value = (Value)package$.MODULE$.Numeric().fromString(protoValue.getNumeric()).fold((Function1 & Serializable)e -> {
                throw this.Err$3(Err$module$1).apply(new StringBuilder(24).append("error decoding decimal: ").append((String)e).toString());
            }, (Function1)Value$ValueNumeric$.MODULE$);
        } else if (ValueOuterClass.Value.SumCase.INT64.equals(sumCase)) {
            value = new Value.ValueInt64(protoValue.getInt64());
        } else if (ValueOuterClass.Value.SumCase.TEXT.equals(sumCase)) {
            value = new Value.ValueText(protoValue.getText());
        } else if (ValueOuterClass.Value.SumCase.DATE.equals(sumCase)) {
            Either d = Time.Date$.MODULE$.fromDaysSinceEpoch(protoValue.getDate());
            value = (Value)d.fold((Function1 & Serializable)e -> {
                throw this.Err$3(Err$module$1).apply(new StringBuilder(21).append("error decoding date: ").append((String)e).toString());
            }, (Function1)Value$ValueDate$.MODULE$);
        } else if (ValueOuterClass.Value.SumCase.TIMESTAMP.equals(sumCase)) {
            Either t = Time.Timestamp$.MODULE$.fromLong(protoValue.getTimestamp());
            value = (Value)t.fold((Function1 & Serializable)e -> {
                throw this.Err$3(Err$module$1).apply(new StringBuilder(26).append("error decoding timestamp: ").append((String)e).toString());
            }, (Function1)Value$ValueTimestamp$.MODULE$);
        } else if (ValueOuterClass.Value.SumCase.PARTY.equals(sumCase)) {
            Either party = Ref$.MODULE$.Party().fromString(protoValue.getParty());
            value = (Value)party.fold((Function1 & Serializable)e -> {
                throw this.Err$3(Err$module$1).apply(new StringBuilder(22).append("error decoding party: ").append((String)e).toString());
            }, (Function1)Value$ValueParty$.MODULE$);
        } else if (ValueOuterClass.Value.SumCase.CONTRACT_ID_STRUCT.equals(sumCase)) {
            Either<ValueCoder.DecodeError, Value.ContractId> cid = decodeCid$3.decode(protoValue.getContractIdStruct());
            value = (Value)cid.fold((Function1 & Serializable)e -> {
                throw this.Err$3(Err$module$1).apply(new StringBuilder(27).append("error decoding contractId: ").append(e.errorMessage()).toString());
            }, (Function1 & Serializable)x$7 -> new Value.ValueContractId((Value.ContractId)x$7));
        } else if (ValueOuterClass.Value.SumCase.LIST.equals(sumCase)) {
            value = new Value.ValueList((FrontStack<Value>)((FrontStack)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(protoValue.getList().getElementsList()).asScala().map((Function1 & Serializable)x$8 -> this.go$1(newNesting, (ValueOuterClass.Value)x$8, decodeCid$3, Err$module$1, version$3))).to(IterableFactory$.MODULE$.toFactory((IterableFactory)FrontStack$.MODULE$))));
        } else if (ValueOuterClass.Value.SumCase.VARIANT.equals(sumCase)) {
            None$ none$;
            ValueOuterClass.Variant variant = protoValue.getVariant();
            ValueOuterClass.Identifier identifier = variant.getVariantId();
            ValueOuterClass.Identifier identifier2 = ValueOuterClass.Identifier.getDefaultInstance();
            if (!(identifier != null ? !identifier.equals(identifier2) : identifier2 != null)) {
                none$ = None$.MODULE$;
            } else {
                this.assertUntil$1(TransactionVersion$.MODULE$.minTypeErasure(), (Function0 & Serializable)() -> "variant_id field in message Variant", version$3, Err$module$1);
                none$ = (Option)this.decodeIdentifier(variant.getVariantId()).fold((Function1 & Serializable)err -> {
                    throw this.Err$3(Err$module$1).apply(err.errorMessage());
                }, (Function1 & Serializable)x$9 -> new Some(x$9));
            }
            None$ id2 = none$;
            value = new Value.ValueVariant((Option<Ref.Identifier>)id2, this.identifier$1(variant.getConstructor(), Err$module$1), this.go$1(newNesting, variant.getValue(), decodeCid$3, Err$module$1, version$3));
        } else if (ValueOuterClass.Value.SumCase.ENUM.equals(sumCase)) {
            None$ none$;
            ValueOuterClass.Enum enumeration = protoValue.getEnum();
            ValueOuterClass.Identifier identifier = enumeration.getEnumId();
            ValueOuterClass.Identifier identifier3 = ValueOuterClass.Identifier.getDefaultInstance();
            if (!(identifier != null ? !identifier.equals(identifier3) : identifier3 != null)) {
                none$ = None$.MODULE$;
            } else {
                this.assertUntil$1(TransactionVersion$.MODULE$.minTypeErasure(), (Function0 & Serializable)() -> "enum_id field in message Enum", version$3, Err$module$1);
                none$ = (Option)this.decodeIdentifier(enumeration.getEnumId()).fold((Function1 & Serializable)err -> {
                    throw this.Err$3(Err$module$1).apply(err.errorMessage());
                }, (Function1 & Serializable)id -> new Some(id));
            }
            None$ id3 = none$;
            value = new Value.ValueEnum((Option<Ref.Identifier>)id3, this.identifier$1(enumeration.getValue(), Err$module$1));
        } else if (ValueOuterClass.Value.SumCase.RECORD.equals(sumCase)) {
            None$ none$;
            ValueOuterClass.Record record = protoValue.getRecord();
            ValueOuterClass.Identifier identifier = record.getRecordId();
            ValueOuterClass.Identifier identifier4 = ValueOuterClass.Identifier.getDefaultInstance();
            if (!(identifier != null ? !identifier.equals(identifier4) : identifier4 != null)) {
                none$ = None$.MODULE$;
            } else {
                this.assertUntil$1(TransactionVersion$.MODULE$.minTypeErasure(), (Function0 & Serializable)() -> "record_id field in message Record", version$3, Err$module$1);
                none$ = (Option)this.decodeIdentifier(record.getRecordId()).fold((Function1 & Serializable)err -> {
                    throw this.Err$3(Err$module$1).apply(err.errorMessage());
                }, (Function1 & Serializable)x$10 -> new Some(x$10));
            }
            None$ id4 = none$;
            value = new Value.ValueRecord((Option<Ref.Identifier>)id4, (ImmArray<Tuple2<Option<String>, Value>>)((ImmArray)CollectionConverters$.MODULE$.ListHasAsScala(protoValue.getRecord().getFieldsList()).asScala().view().map((Function1 & Serializable)fld -> {
                None$ none$;
                if (fld.getLabel().isEmpty()) {
                    none$ = None$.MODULE$;
                } else {
                    this.assertUntil$1(TransactionVersion$.MODULE$.minTypeErasure(), (Function0 & Serializable)() -> "label field in message RecordField", version$3, Err$module$1);
                    none$ = Option$.MODULE$.apply((Object)this.identifier$1(fld.getLabel(), Err$module$1));
                }
                None$ lbl = none$;
                return new Tuple2((Object)lbl, (Object)this.go$1(newNesting, fld.getValue(), decodeCid$3, Err$module$1, version$3));
            }).to(IterableFactory$.MODULE$.toFactory((IterableFactory)ImmArray$.MODULE$))));
        } else if (ValueOuterClass.Value.SumCase.OPTIONAL.equals(sumCase)) {
            ValueOuterClass.Optional option = protoValue.getOptional();
            ValueOuterClass.Value value2 = option.getValue();
            ValueOuterClass.Value value3 = ValueOuterClass.Value.getDefaultInstance();
            None$ mbV = !(value2 != null ? !value2.equals(value3) : value3 != null) ? None$.MODULE$ : new Some((Object)this.go$1(newNesting, option.getValue(), decodeCid$3, Err$module$1, version$3));
            value = new Value.ValueOptional((Option<Value>)mbV);
        } else if (ValueOuterClass.Value.SumCase.MAP.equals(sumCase)) {
            ImmArray entries = (ImmArray)CollectionConverters$.MODULE$.ListHasAsScala(protoValue.getMap().getEntriesList()).asScala().view().map((Function1 & Serializable)entry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entry.getKey()), (Object)this.go$1(newNesting, entry.getValue(), decodeCid$3, Err$module$1, version$3))).to(IterableFactory$.MODULE$.toFactory((IterableFactory)ImmArray$.MODULE$));
            SortedLookupList map = (SortedLookupList)SortedLookupList$.MODULE$.fromImmArray(entries).fold((Function1 & Serializable)err -> {
                throw this.Err$3(Err$module$1).apply((String)err);
            }, (Function1 & Serializable)x -> (SortedLookupList)Predef$.MODULE$.identity(x));
            value = new Value.ValueTextMap((SortedLookupList<Value>)map);
        } else if (ValueOuterClass.Value.SumCase.GEN_MAP.equals(sumCase)) {
            this.assertSince$1(TransactionVersion$.MODULE$.minGenMap(), (Function0 & Serializable)() -> "Value.SumCase.MAP", version$3, Err$module$1);
            ImmArray genMap = (ImmArray)CollectionConverters$.MODULE$.ListHasAsScala(protoValue.getGenMap().getEntriesList()).asScala().view().map((Function1 & Serializable)entry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.go$1(newNesting, entry.getKey(), decodeCid$3, Err$module$1, version$3)), (Object)this.go$1(newNesting, entry.getValue(), decodeCid$3, Err$module$1, version$3))).to(IterableFactory$.MODULE$.toFactory((IterableFactory)ImmArray$.MODULE$));
            value = new Value.ValueGenMap((ImmArray<Tuple2<Value, Value>>)genMap);
        } else {
            if (ValueOuterClass.Value.SumCase.SUM_NOT_SET.equals(sumCase)) {
                throw this.Err$3(Err$module$1).apply("Value not set");
            }
            throw new MatchError((Object)sumCase);
        }
        return value;
    }

    private static final /* synthetic */ ValueCoder$Err$5$ Err$lzycompute$2(LazyRef Err$module$2) {
        ValueCoder$Err$5$ valueCoder$Err$5$;
        LazyRef lazyRef = Err$module$2;
        synchronized (lazyRef) {
            valueCoder$Err$5$ = Err$module$2.initialized() ? (ValueCoder$Err$5$)Err$module$2.value() : (ValueCoder$Err$5$)Err$module$2.initialize((Object)new ValueCoder$Err$5$());
        }
        return valueCoder$Err$5$;
    }

    private final ValueCoder$Err$5$ Err$6(LazyRef Err$module$2) {
        return Err$module$2.initialized() ? (ValueCoder$Err$5$)Err$module$2.value() : ValueCoder$.Err$lzycompute$2(Err$module$2);
    }

    private final void assertSince$2(TransactionVersion minVersion, Function0 description, TransactionVersion valueVersion$1, LazyRef Err$module$2) {
        if (Ordering.Implicits$.MODULE$.infixOrderingOps((Object)valueVersion$1, TransactionVersion$.MODULE$.Ordering()).$less((Object)minVersion)) {
            throw this.Err$6(Err$module$2).apply(new StringBuilder(35).append(description.apply()).append(" is not supported by value version ").append(valueVersion$1).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$encodeValue$2(ValueCoder$ $this, TransactionVersion valueVersion$1, int newNesting$2, ValueOuterClass.Record.Builder recordBuilder$1, ValueCoder.EncodeCid encodeCid$1, LazyRef Err$module$2, Tuple2 x0$1) {
        ValueOuterClass.RecordField.Builder b;
        Value field;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Option fieldName = (Option)tuple2._1();
            field = (Value)tuple2._2();
            b = ValueOuterClass.RecordField.newBuilder();
            if (Ordering.Implicits$.MODULE$.infixOrderingOps((Object)valueVersion$1, TransactionVersion$.MODULE$.Ordering()).$less((Object)TransactionVersion$.MODULE$.minTypeErasure())) {
                Statement$.MODULE$.discard((Object)fieldName.map((Function1 & Serializable)value -> b.setLabel(value)));
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        Statement$.MODULE$.discard((Object)b.setValue($this.go$2(newNesting$2, field, encodeCid$1, valueVersion$1, Err$module$2)));
        Statement$.MODULE$.discard((Object)recordBuilder$1.addFields(b));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$encodeValue$8(ValueCoder$ $this, ValueOuterClass.Map.Builder protoMap$1, int newNesting$2, ValueCoder.EncodeCid encodeCid$1, TransactionVersion valueVersion$1, LazyRef Err$module$2, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        Value value = (Value)tuple2._2();
        Statement$.MODULE$.discard((Object)protoMap$1.addEntries(ValueOuterClass.Map.Entry.newBuilder().setKey(key).setValue($this.go$2(newNesting$2, value, encodeCid$1, valueVersion$1, Err$module$2))));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$encodeValue$10(ValueCoder$ $this, ValueOuterClass.GenMap.Builder protoMap$2, int newNesting$2, ValueCoder.EncodeCid encodeCid$1, TransactionVersion valueVersion$1, LazyRef Err$module$2, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Value key = (Value)tuple2._1();
        Value value = (Value)tuple2._2();
        Statement$.MODULE$.discard((Object)protoMap$2.addEntries(ValueOuterClass.GenMap.Entry.newBuilder().setKey($this.go$2(newNesting$2, key, encodeCid$1, valueVersion$1, Err$module$2)).setValue($this.go$2(newNesting$2, value, encodeCid$1, valueVersion$1, Err$module$2))));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final ValueOuterClass.Value go$2(int nesting, Value v2, ValueCoder.EncodeCid encodeCid$1, TransactionVersion valueVersion$1, LazyRef Err$module$2) {
        ValueOuterClass.Value value;
        if (nesting > Value$.MODULE$.MAXIMUM_NESTING()) {
            throw this.Err$6(Err$module$2).apply(new StringBuilder(66).append("Provided Daml-LF value to encode exceeds maximum nesting level of ").append(Value$.MODULE$.MAXIMUM_NESTING()).toString());
        }
        int newNesting = nesting + 1;
        ValueOuterClass.Value.Builder builder = ValueOuterClass.Value.newBuilder();
        Value value2 = v2;
        if (Value$ValueUnit$.MODULE$.equals(value2)) {
            value = builder.setUnit(Empty.newBuilder()).build();
        } else if (value2 instanceof Value.ValueBool) {
            Value.ValueBool valueBool = (Value.ValueBool)value2;
            boolean b = valueBool.value();
            value = builder.setBool(b).build();
        } else if (value2 instanceof Value.ValueInt64) {
            Value.ValueInt64 valueInt64 = (Value.ValueInt64)value2;
            long i2 = valueInt64.value();
            value = builder.setInt64(i2).build();
        } else if (value2 instanceof Value.ValueNumeric) {
            Value.ValueNumeric valueNumeric = (Value.ValueNumeric)value2;
            BigDecimal d = valueNumeric.value();
            value = builder.setNumeric(package$.MODULE$.Numeric().toString(d)).build();
        } else if (value2 instanceof Value.ValueText) {
            Value.ValueText valueText = (Value.ValueText)value2;
            String t = valueText.value();
            value = builder.setText(t).build();
        } else if (value2 instanceof Value.ValueParty) {
            Value.ValueParty valueParty = (Value.ValueParty)value2;
            String p = valueParty.value();
            value = builder.setParty(p).build();
        } else if (value2 instanceof Value.ValueDate) {
            Value.ValueDate valueDate = (Value.ValueDate)value2;
            Time.Date d = valueDate.value();
            value = builder.setDate(d.days()).build();
        } else if (value2 instanceof Value.ValueTimestamp) {
            Value.ValueTimestamp valueTimestamp = (Value.ValueTimestamp)value2;
            Time.Timestamp t = valueTimestamp.value();
            value = builder.setTimestamp(t.micros()).build();
        } else if (value2 instanceof Value.ValueContractId) {
            Value.ValueContractId valueContractId = (Value.ValueContractId)value2;
            Value.ContractId coid = valueContractId.value();
            value = builder.setContractIdStruct(encodeCid$1.encode(coid)).build();
        } else if (value2 instanceof Value.ValueList) {
            Value.ValueList valueList = (Value.ValueList)value2;
            FrontStack<Value> elems = valueList.values();
            ValueOuterClass.List.Builder listBuilder = ValueOuterClass.List.newBuilder();
            elems.foreach((Function1 & Serializable)elem -> {
                Statement$.MODULE$.discard((Object)listBuilder.addElements(this.go$2(newNesting, elem, encodeCid$1, valueVersion$1, Err$module$2)));
                return BoxedUnit.UNIT;
            });
            value = builder.setList(listBuilder).build();
        } else if (value2 instanceof Value.ValueRecord) {
            Value.ValueRecord valueRecord = (Value.ValueRecord)value2;
            Option<Ref.Identifier> id = valueRecord.tycon();
            ImmArray<Tuple2<Option<String>, Value>> fields = valueRecord.fields();
            ValueOuterClass.Record.Builder recordBuilder = ValueOuterClass.Record.newBuilder();
            fields.foreach((Function1 & Serializable)x0$1 -> {
                ValueCoder$.$anonfun$encodeValue$2(this, valueVersion$1, newNesting, recordBuilder, encodeCid$1, Err$module$2, x0$1);
                return BoxedUnit.UNIT;
            });
            if (Ordering.Implicits$.MODULE$.infixOrderingOps((Object)valueVersion$1, TransactionVersion$.MODULE$.Ordering()).$less((Object)TransactionVersion$.MODULE$.minTypeErasure())) {
                id.foreach((Function1 & Serializable)i -> recordBuilder.setRecordId(MODULE$.encodeIdentifier((Ref.Identifier)i)));
            }
            value = builder.setRecord(recordBuilder).build();
        } else if (value2 instanceof Value.ValueVariant) {
            Value.ValueVariant valueVariant = (Value.ValueVariant)value2;
            Option<Ref.Identifier> id = valueVariant.tycon();
            String con = valueVariant.variant();
            Value arg = valueVariant.value();
            ValueOuterClass.Variant.Builder protoVar = ValueOuterClass.Variant.newBuilder().setConstructor(con).setValue(this.go$2(newNesting, arg, encodeCid$1, valueVersion$1, Err$module$2));
            if (Ordering.Implicits$.MODULE$.infixOrderingOps((Object)valueVersion$1, TransactionVersion$.MODULE$.Ordering()).$less((Object)TransactionVersion$.MODULE$.minTypeErasure())) {
                id.foreach((Function1 & Serializable)i -> protoVar.setVariantId(MODULE$.encodeIdentifier((Ref.Identifier)i)));
            }
            value = builder.setVariant(protoVar).build();
        } else if (value2 instanceof Value.ValueEnum) {
            Value.ValueEnum valueEnum = (Value.ValueEnum)value2;
            Option<Ref.Identifier> id = valueEnum.tycon();
            String value3 = valueEnum.value();
            ValueOuterClass.Enum.Builder protoEnum = ValueOuterClass.Enum.newBuilder().setValue(value3);
            if (Ordering.Implicits$.MODULE$.infixOrderingOps((Object)valueVersion$1, TransactionVersion$.MODULE$.Ordering()).$less((Object)TransactionVersion$.MODULE$.minTypeErasure())) {
                id.foreach((Function1 & Serializable)i -> protoEnum.setEnumId(MODULE$.encodeIdentifier((Ref.Identifier)i)));
            }
            value = builder.setEnum(protoEnum).build();
        } else if (value2 instanceof Value.ValueOptional) {
            Value.ValueOptional valueOptional = (Value.ValueOptional)value2;
            Option<Value> mbV = valueOptional.value();
            ValueOuterClass.Optional.Builder protoOption = ValueOuterClass.Optional.newBuilder();
            mbV.foreach((Function1 & Serializable)v -> protoOption.setValue(this.go$2(newNesting, (Value)v, encodeCid$1, valueVersion$1, Err$module$2)));
            value = builder.setOptional(protoOption).build();
        } else if (value2 instanceof Value.ValueTextMap) {
            Value.ValueTextMap valueTextMap = (Value.ValueTextMap)value2;
            SortedLookupList<Value> map = valueTextMap.value();
            ValueOuterClass.Map.Builder protoMap = ValueOuterClass.Map.newBuilder();
            map.toImmArray().foreach((Function1 & Serializable)x0$2 -> {
                ValueCoder$.$anonfun$encodeValue$8(this, protoMap, newNesting, encodeCid$1, valueVersion$1, Err$module$2, x0$2);
                return BoxedUnit.UNIT;
            });
            value = builder.setMap(protoMap).build();
        } else if (value2 instanceof Value.ValueGenMap) {
            Value.ValueGenMap valueGenMap = (Value.ValueGenMap)value2;
            ImmArray<Tuple2<Value, Value>> entries = valueGenMap.entries();
            this.assertSince$2(TransactionVersion$.MODULE$.minGenMap(), (Function0 & Serializable)() -> "Value.SumCase.MAP", valueVersion$1, Err$module$2);
            ValueOuterClass.GenMap.Builder protoMap = ValueOuterClass.GenMap.newBuilder();
            entries.foreach((Function1 & Serializable)x0$3 -> {
                ValueCoder$.$anonfun$encodeValue$10(this, protoMap, newNesting, encodeCid$1, valueVersion$1, Err$module$2, x0$3);
                return BoxedUnit.UNIT;
            });
            value = builder.setGenMap(protoMap).build();
        } else {
            throw new MatchError((Object)value2);
        }
        return value;
    }

    private ValueCoder$() {
    }
}

