/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.validation;

import com.daml.lf.language.Ast;
import com.daml.lf.language.PackageInterface;
import com.daml.lf.language.PackageInterface$;
import com.daml.lf.validation.Collision$;
import com.daml.lf.validation.DependencyVersion$;
import com.daml.lf.validation.Recursion$;
import com.daml.lf.validation.Serializability$;
import com.daml.lf.validation.Typing$;
import com.daml.lf.validation.ValidationError;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Right;

public final class Validation$ {
    public static final Validation$ MODULE$ = new Validation$();

    private <X> Either<ValidationError, X> runSafely(Function0<X> x) {
        Right right;
        try {
            right = package$.MODULE$.Right().apply(x.apply());
        }
        catch (ValidationError e) {
            right = package$.MODULE$.Left().apply((Object)e);
        }
        return right;
    }

    public Either<ValidationError, BoxedUnit> checkPackages(Map<String, Ast.GenPackage<Ast.Expr>> pkgs) {
        return this.runSafely((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.unsafeCheckPackages(PackageInterface$.MODULE$.apply(pkgs), pkgs));
    }

    public Either<ValidationError, BoxedUnit> checkPackages(PackageInterface pkgInterface, Map<String, Ast.GenPackage<Ast.Expr>> pkgs) {
        return this.runSafely((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.unsafeCheckPackages(pkgInterface, pkgs));
    }

    public void unsafeCheckPackages(PackageInterface pkgInterface, Map<String, Ast.GenPackage<Ast.Expr>> pkgs) {
        pkgs.foreach((Function1 & Serializable)x0$1 -> {
            Validation$.$anonfun$unsafeCheckPackages$1(pkgInterface, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public Either<ValidationError, BoxedUnit> checkPackage(PackageInterface pkgInterface, String pkgId, Ast.GenPackage<Ast.Expr> pkg) {
        return this.runSafely((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.unsafeCheckPackage(pkgInterface, pkgId, pkg));
    }

    private void unsafeCheckPackage(PackageInterface pkgInterface, String pkgId, Ast.GenPackage<Ast.Expr> pkg) {
        Collision$.MODULE$.checkPackage(pkgId, pkg);
        Recursion$.MODULE$.checkPackage(pkgId, pkg);
        DependencyVersion$.MODULE$.checkPackage(pkgInterface, pkgId, pkg);
        pkg.modules().values().foreach((Function1 & Serializable)x$1 -> {
            Validation$.MODULE$.unsafeCheckModule(pkgInterface, pkgId, (Ast.GenModule<Ast.Expr>)x$1);
            return BoxedUnit.UNIT;
        });
    }

    public Either<ValidationError, BoxedUnit> checkModule(PackageInterface pkgInterface, String pkgId, Ast.GenModule<Ast.Expr> module) {
        return this.runSafely((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.unsafeCheckModule(pkgInterface, pkgId, module));
    }

    private void unsafeCheckModule(PackageInterface pkgInterface, String pkgId, Ast.GenModule<Ast.Expr> mod) {
        Typing$.MODULE$.checkModule(pkgInterface, pkgId, mod);
        Serializability$.MODULE$.checkModule(pkgInterface, pkgId, mod);
    }

    public static final /* synthetic */ void $anonfun$unsafeCheckPackages$1(PackageInterface pkgInterface$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String pkgId = (String)tuple2._1();
        Ast.GenPackage pkg = (Ast.GenPackage)tuple2._2();
        MODULE$.unsafeCheckPackage(pkgInterface$2, pkgId, (Ast.GenPackage<Ast.Expr>)pkg);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private Validation$() {
    }
}

